/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveUnitPolicy;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.EqTypeListCellRenderer;
import cerent.cms.ui.Pane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PassiveCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create Passive Card";
    private JButton okButton;
    private JButton cancelButton;
    private PassiveCreatePane createPane;

    public static PassiveCreationDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new PassiveCreationDialog(frame, pane);
    }

    private PassiveCreationDialog(Frame frame, Object object) {
        super(frame, TITLE, true, (Object)((Pane)object));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.getCreatePanel((Pane)object), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        if (this.createPane != null) {
            this.createPane.destroy();
            this.createPane = null;
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.toString());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.createPane.apply();
    }

    private JPanel getCreatePanel(Pane pane) {
        this.createPane = new PassiveCreatePane(pane);
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    class PassiveCreatePane
    extends JPanel
    implements ActionListener {
        protected JComboBox passiveNumCB;
        protected JComboBox passiveTypeCB;
        protected NodeModelDelegate nmd;
        eEqType pmType;

        public PassiveCreatePane(Pane pane) {
            this.add(this.createAttrsPanel(pane));
        }

        public void destroy() {
        }

        private Component createAttrsPanel(Pane pane) {
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.fillHorizontal();
            this.nmd = (NodeModelDelegate)pane.getUiModel().getNodeModel();
            this.passiveTypeCB = new JComboBox();
            this.passiveTypeCB.setRenderer(new EqTypeListCellRenderer(this.nmd));
            this.passiveTypeCB.setModel(new DefaultComboBoxModel<eEqType>(PassiveUnitPolicy.getManageablePassiveUnits()));
            UComboBox.setPreferredWidth((JComboBox)this.passiveTypeCB, (int)(this.passiveTypeCB.getPreferredSize().width + 10));
            gridBagPanel.add("Card Type ", 0, 0);
            gridBagPanel.add((Component)this.passiveTypeCB, 1, 1);
            return gridBagPanel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.passiveNumCB) {
                this.passiveTypeCB.setModel(new DefaultComboBoxModel<eEqType>(PassiveUnitPolicy.getManageablePassiveUnits()));
            }
        }

        public void apply() {
            this.applyChangesToModel();
        }

        public void applyChangesToModel() {
            this.pmType = (eEqType)this.passiveTypeCB.getSelectedItem();
            this.createPassiveModule();
        }

        private void createPassiveModule() {
            new Thread("Passive Provisioner"){

                @Override
                public void run() {
                    try {
                        ((EntityTableModel)PassiveCreatePane.this.nmd.getEntityTable()).provisionPassiveModule(PassiveCreatePane.this.pmType);
                    }
                    catch (ResourceInUse resourceInUse) {
                        ErrorMsg.displayError((Component)PassiveCreationDialog.this.createPane, (EID)EMC.EID_CARD_SLOT_IN_USE);
                    }
                    catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
                        SDebug.printStackTrace((Throwable)cmsNodeUpgradingException);
                        ErrorMsg.displayError((Component)PassiveCreationDialog.this.createPane, (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
                    }
                    catch (EMCProvisionError eMCProvisionError) {
                        ErrorMsg.displayDetailed((Component)PassiveCreationDialog.this.createPane, EMC.EID_CARD_PROV_ERROR_PARAM_1, "add", eMCProvisionError.getEID().getComposedMessage());
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        ErrorMsg.displayError((Component)PassiveCreationDialog.this.createPane, (EID)EMC.EID_FAIL_CARD_ADD);
                    }
                }
            }.start();
        }
    }
}

