/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongParameterValue;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.ANSResultController;
import cerent.cms.ui.ans.ANSTreeCellRenderer;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.cms.ui.ans.AnsPathTableModel;
import cerent.cms.ui.ans.IANSTreeViewPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeSelectionModel;

public class ProvSpPathPane
extends AbstractPane
implements IANSTreeViewPane,
TreeSelectionListener,
ActionListener,
Runnable {
    private static final String LAUNCH = "Launch ANS";
    private static final String REFRESH = "Refresh";
    private static final String NODE = "node";
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_DIVIDER = "divider";
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("MMMMM d,yyyy H:mm:ss a,z");
    private final JButton launchButton = new JButton("Launch ANS");
    private final JButton refreshButton = new JButton("Refresh");
    private final JLabel label = new JLabel(" ");
    private String labelText = "";
    private AnsPathDataSource dataSource;
    private final EventUtilities eventutilities;
    private final TabbedView parent;
    private final NodeModelDelegate nodeModel;
    private final DwdmOpticalSetupModel opticalSetupModel;
    private boolean initialized = false;
    private static final SDebug db = new SDebug("ProvSpPathPane");
    private ANSResultController dfc;
    private TreeSelectionModel tsm;
    private JSplitPane split;

    public ProvSpPathPane(String string, TabbedView tabbedView, DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        super(string, tabbedView);
        this.parent = tabbedView;
        this.eventutilities = EventUtilities.getInstance((NodeModelDelegate)this.getUiModel().getNodeModel());
        this.opticalSetupModel = dwdmOpticalSetupModel;
        this.nodeModel = (NodeModelDelegate)dwdmOpticalSetupModel.getNodeModel();
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    private void init() {
        if (db.on()) {
            db.println("Initialization has begun.");
        }
        this.setLayout(new BorderLayout());
        this.dfc = new ANSResultController(this, this.opticalSetupModel, this.nodeModel, db);
        this.dataSource = this.dfc.getDataSource();
        this.add(this.makeFilterPanel(), "North");
        this.add(this.makeControlPanel(), "South");
        this.add(this.makeDataPanel(), "Center");
        if (db.on()) {
            db.println("Initialization has ended.");
        }
    }

    private JSplitPane makeDataPanel() {
        this.split = new JSplitPane(1);
        JTree jTree = new JTree(this.dfc.getTreeModel());
        jTree.setCellRenderer(new ANSTreeCellRenderer());
        jTree.setShowsRootHandles(true);
        jTree.setScrollsOnExpand(true);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.tsm = jTree.getSelectionModel();
        this.tsm.setSelectionMode(1);
        this.tsm.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Selector"));
        this.split.setLeftComponent(jScrollPane);
        this.table = new UTable((TableModel)this.dfc.getTableModel());
        ((AnsPathTableModel)((Object)this.table.getModel())).initTable(this.table);
        jScrollPane = new JScrollPane(this.table);
        this.split.setRightComponent(jScrollPane);
        this.split.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = Preferences.instance().getInt(ProvSpPathPane.PROP_PREF, ProvSpPathPane.PROP_DIVIDER, 0);
                if (n == 0) {
                    ProvSpPathPane.this.split.setDividerLocation(-1);
                } else {
                    ProvSpPathPane.this.split.setDividerLocation((double)n / 100.0);
                }
                ProvSpPathPane.this.split.removeComponentListener(this);
            }
        });
        return this.split;
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        this.launchButton.addActionListener(this);
        this.launchButton.setEnabled(false);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        jPanel2.add(this.launchButton);
        jPanel2.add(this.refreshButton);
        jPanel3.add(this.label);
        jPanel3.add(new CSHelpButton(CSHelpConst.ProvSpPathPane));
        this.enableComponent(this.launchButton, this.nodeModel, SecurityLevel.SUPERUSER);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JPanel makeFilterPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.launchButton) {
            if (!CerentDialog.yesNoDialog((Component)this.parent, (String)"If there are circuits the operation could be traffic affecting.\nDo you want to continue?", (String)"Apply Launch ANS")) {
                return;
            }
            try {
                this.dataSource.startONS();
                CerentDialog.infoDialog((Component)((Object)this), (String)"ANS Completed", (String)LAUNCH);
            }
            catch (MissingEquipment missingEquipment) {
                SDebug.printStackTrace((Throwable)missingEquipment);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_EQPT_NOT_PLUG);
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_PERFORM);
            }
            catch (Busy busy) {
                SDebug.printStackTrace((Throwable)busy);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_BUSY);
            }
            catch (CannotPerform cannotPerform) {
                SDebug.printStackTrace((Throwable)cannotPerform);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_CANT_PERF);
            }
            catch (WrongParameterValue wrongParameterValue) {
                SDebug.printStackTrace((Throwable)((Object)wrongParameterValue));
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_WRONG_PARAM, (Object)wrongParameterValue.getParamName());
            }
            finally {
                this.refresh();
                this.updateLabel(NODE);
            }
        } else if (object == this.refreshButton) {
            try {
                this.refresh();
                this.updateLabel(NODE);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("Entering into page.");
        }
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                if (db.on()) {
                    db.println("Data source needs to be initialized!");
                }
                this.init();
            }
            if (!this.initialized) {
                if (db.on()) {
                    db.println("This seems to be the very first time!");
                }
                this.updateLabel(NODE);
                this.initialized = true;
            }
            this.refresh();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public TreeSelectionModel getTreeSelectionModel() {
        return this.tsm;
    }

    @Override
    public AbstractPane getParentComponent() {
        return this;
    }

    @Override
    public void updateLabel(String string) {
        long l = this.eventutilities.convertSecondsToMilliSeconds(this.opticalSetupModel.getAnsLastTimeStamp());
        String string2 = "Launched: Not Available from " + string;
        if (l != 0L) {
            timeFmt.setTimeZone(this.nodeModel.getCtcTimeZone());
            string2 = "Launched: " + timeFmt.format(new Date(l)) + " from " + string;
        }
        this.setLabel(string2);
    }

    @Override
    public void clearLabel() {
        this.setLabel(" ");
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void setDirty() {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
            this.stopTableCellEditing();
            this.dfc.setTableContent(treeSelectionEvent.getNewLeadSelectionPath());
        }
    }

    @Override
    public void run() {
        this.label.setText(this.labelText);
    }

    @Override
    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("Leaving the page.");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = false;
    }

    @Override
    public void refresh() {
        block4: {
            if (db.on()) {
                db.println("A refresh has been invoked.");
            }
            try {
                this.dfc.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("A refresh has been done.");
        }
    }

    @Override
    public void destroy() {
        if (db.on()) {
            db.println("The pane has been required to be destroyed.");
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dfc != null) {
            this.dfc.disposeDataSource();
            this.dfc = null;
        }
    }
}

