/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpConfigError;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.shelf.ScdIpAddrPane;
import cerent.cms.ui.shelf.SecurityConfigDialog;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ScdIpSelectionPane
extends WizardPane
implements ActionListener {
    private SecurityConfigDialog parent;
    private JPanel mainPanel;
    private JPanel ipSelectionPanel;
    String selectLabel = "Select an address for the node";
    String newIpLabel = " New Node Address";
    JRadioButton secureIpRB = new JRadioButton();
    JRadioButton nodeIpRB = new JRadioButton();
    JRadioButton newIpRB = new JRadioButton(this.newIpLabel);
    ButtonGroup ipGroup = new ButtonGroup();
    protected IIpAddr ipAddr;
    protected IIpAddr defRouterAddr;
    protected IIpAddr nodeIpAddr;
    protected IIpAddr secureIpAddr;
    protected String secureIpLabel;
    protected String nodeIpLabel;
    private static final String NODE_DESC_STR = " (TCC Ethernet Port)";
    private String SECURE_DESC_STR = "(Backplane Ethernet Port)";
    protected IIpConfig nodeIpConfig;
    protected ISecureIpConfig secureIpConfig;
    protected short netMask;
    private static SDebug db = new SDebug("ScdpSelectionPane");
    private ScdIpAddrPane ipPane;
    private boolean newIpSelected = false;
    private boolean nodeIpSelected = false;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();

    public ScdIpSelectionPane(String string, SecurityConfigDialog securityConfigDialog, JLabel jLabel, TDMTerminology tDMTerminology) {
        super(string, securityConfigDialog);
        this.parent = securityConfigDialog;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints((Component)((Object)this), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        this.nodeIpConfig = securityConfigDialog.getIpConfig();
        this.secureIpConfig = securityConfigDialog.getSecureIpConfig();
        this.nodeIpAddr = this.nodeIpConfig.getIpAddress();
        this.secureIpAddr = this.secureIpConfig.getIpAddress();
        this.nodeIpLabel = InetUtil.makeDottedString(this.nodeIpAddr);
        this.secureIpLabel = InetUtil.makeDottedString(this.secureIpAddr);
        String string2 = tDMTerminology.getBackplaneTerm(true);
        this.SECURE_DESC_STR = "( " + string2 + " Ethernet Port)";
        String string3 = this.nodeIpLabel + NODE_DESC_STR;
        this.nodeIpRB.setText(string3);
        string3 = this.secureIpLabel + this.SECURE_DESC_STR;
        this.secureIpRB.setText(string3);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        this.ipGroup.add(this.secureIpRB);
        this.ipGroup.add(this.nodeIpRB);
        this.ipGroup.add(this.newIpRB);
        this.secureIpRB.setSelected(true);
        this.newIpRB.setActionCommand(this.selectLabel);
        this.secureIpRB.setActionCommand(this.secureIpLabel);
        this.nodeIpRB.setActionCommand(this.nodeIpLabel);
        this.nodeIpRB.addActionListener(this);
        this.newIpRB.addActionListener(this);
        this.secureIpRB.addActionListener(this);
        gridBagConstraints.gridx = 1;
        this.mainPanel.add((Component)this.secureIpRB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        this.mainPanel.add((Component)this.nodeIpRB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        this.mainPanel.add((Component)this.newIpRB, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.ipPane = new ScdIpAddrPane("", securityConfigDialog, false, null);
        this.mainPanel.add((Component)((Object)this.ipPane), gridBagConstraints);
        this.ipPane.setComponentsEnabled(false);
        this.add(this.mainPanel);
    }

    private JComboBox addIpSelectionCB(JPanel jPanel, JLabel jLabel, int n, String[] stringArray) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(jLabel);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jComboBox.addActionListener(this);
        jPanel2.add(jComboBox);
        jPanel.add(jPanel2);
        return jComboBox;
    }

    @Override
    public void validatePage() throws Exception {
        IIpAddr iIpAddr;
        if (this.newIpRB.isSelected() || this.nodeIpRB.isSelected()) {
            this.ipPane.validatePage();
            iIpAddr = this.ipPane.getIpAddr();
            IIpAddr iIpAddr2 = this.ipPane.getDefaultRouterAddr();
            this.setDefaultRouterAddr(iIpAddr2);
            this.netMask = this.ipPane.getMask();
        } else {
            iIpAddr = this.secureIpAddr;
            this.netMask = this.secureIpConfig.getNetMaskPrefixLength();
            IIpAddr iIpAddr3 = this.nodeIpConfig.getDefaultRouter();
            this.setDefaultRouterAddr(iIpAddr3);
        }
        this.setIpAddr(iIpAddr);
        try {
            this.parent.validateConfig(this.getName());
        }
        catch (IpConfigError ipConfigError) {
            throw new Exception(ipConfigError.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.newIpSelected = object == this.newIpRB;
        boolean bl = this.nodeIpSelected = object == this.nodeIpRB;
        if (object == this.newIpRB) {
            this.ipPane.setComponentsEnabled(true);
            this.ipPane.setIp(this.newIpSelected, this.nodeIpSelected);
        } else if (object == this.nodeIpRB) {
            this.ipPane.setComponentsEnabled(true);
            this.ipPane.setIp(this.newIpSelected, this.nodeIpSelected);
        } else if (object == this.secureIpRB) {
            this.ipPane.setIp(this.newIpSelected, this.nodeIpSelected);
            this.ipPane.setComponentsEnabled(false);
        }
    }

    private void setIpAddr(IIpAddr iIpAddr) {
        this.ipAddr = iIpAddr;
    }

    private void setDefaultRouterAddr(IIpAddr iIpAddr) {
        this.defRouterAddr = iIpAddr;
    }

    public IIpAddr getIpAddr() {
        return this.ipAddr;
    }

    public IIpAddr getDefRouterAddr() {
        return this.defRouterAddr;
    }

    public short getMask() {
        return this.netMask;
    }

    @Override
    public String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = InetUtil.makeDottedString(this.getIpAddr());
        String string2 = InetUtil.makeDottedString(this.getDefRouterAddr());
        String string3 = Short.toString(this.netMask);
        int n = InetUtil.makeNetMask(this.netMask);
        String string4 = InetUtil.makeDottedString(n);
        stringBuffer.append("Node Address: \n" + string);
        stringBuffer.append("\nNet/Subnet Mask Length: " + string3);
        stringBuffer.append("\nMask : " + string4);
        stringBuffer.append("\nDefault Router : " + string2);
        return stringBuffer.toString();
    }

    @Override
    public void refresh() {
        this.secureIpRB.setSelected(true);
        this.ipPane.setIp(this.newIpSelected, this.nodeIpSelected);
        this.newIpRB.setActionCommand(this.selectLabel);
        this.secureIpRB.setActionCommand(this.secureIpLabel);
        this.nodeIpRB.setActionCommand(this.nodeIpLabel);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.ScdIpSelectionPane;
    }
}

