/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AdminState;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceState;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.util.SDebug;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.util.ArrayList;

public class ShelfInventoryModel
extends SortableRowTableModel {
    private NodeModelDelegate nmd;
    private static final SDebug db = new SDebug("ShelfInventoryModel");

    public ShelfInventoryModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz, NodeModelDelegate nodeModelDelegate) {
        super(rowDataSource, columnRendererArray, clazz);
        this.nmd = nodeModelDelegate;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 9 && n2 != 2) {
            return false;
        }
        if (n2 == 9 && !this.nmd.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 2 && !this.nmd.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            return false;
        }
        ShelfInventoryRowObject shelfInventoryRowObject = null;
        if (this.sortedObjects.size() != 0) {
            if (n < 0 || n > this.sortedObjects.size()) {
                return false;
            }
            if (this.sortedObjects.get(n) instanceof ShelfInventoryRowObject) {
                shelfInventoryRowObject = (ShelfInventoryRowObject)this.sortedObjects.get(n);
            }
        } else {
            if (n < 0 || n > this.source.getRowCount()) {
                return false;
            }
            if (this.source.getObjectAtRow(n) instanceof ShelfInventoryRowObject) {
                shelfInventoryRowObject = (ShelfInventoryRowObject)this.source.getObjectAtRow(n);
            }
        }
        if (shelfInventoryRowObject == null) {
            return false;
        }
        return this.isEquipmentProvisionable(shelfInventoryRowObject, n2);
    }

    private boolean isEquipmentProvisionable(ShelfInventoryRowObject shelfInventoryRowObject, int n) {
        eEqType eEqType2 = shelfInventoryRowObject.entity.getEqTypeEnum();
        if (eEqType2 == null) {
            return false;
        }
        if (n == 9 && (eEqType2 == eEqType.FILLER_CARD || eEqType2 == eEqType.PIM_4_PPM || eEqType2 == eEqType.PIM_1_PPM || eEqType2 == eEqType.PPM_1_PORT || eEqType2 == eEqType.UNKNOWN_CARD)) {
            return false;
        }
        if (n == 2 && eEqType2 == eEqType.FILLER_CARD || eEqType2 == eEqType.UNKNOWN_CARD) {
            return false;
        }
        if (n == 2) {
            if (this.isFmecCard(shelfInventoryRowObject.entity)) {
                return false;
            }
            if (!ServiceState.isEquipmentAdminStateChangeAllowed(shelfInventoryRowObject.entity.getServiceSt())) {
                return false;
            }
        }
        eEqState eEqState2 = shelfInventoryRowObject.entity.getState();
        if (n == 9 && eEqState2.value() == 1) {
            return false;
        }
        return shelfInventoryRowObject.entity.getGenericClass() == 6;
    }

    private boolean isFmecCard(EntityModel entityModel) {
        return (entityModel.getNodeModelDelegate().getPlatform().is455() || entityModel.getChassis().isUTSChassis()) && entityModel.getSlot() > 17;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)this.getValueAt(n, n2);
        if (shelfInventoryRowObject == null) {
            db.println("setValueAt: rowObj == null row = " + n + " col = " + n2);
            return;
        }
        try {
            switch (n2) {
                case 2: {
                    shelfInventoryRowObject.setAdminState((AdminState)object);
                    break;
                }
                case 9: {
                    shelfInventoryRowObject.setUserCode(object.toString());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in setValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        super.rowsUpdated(n, n);
    }

    public ArrayList getSortedArrayList() {
        return this.sortedObjects;
    }

    public RowDataSource getDataSource() {
        return this.source;
    }
}

