/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.AdminState;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

class ShelfInventoryRowObject {
    final MfgEntityModel entity;
    final String eqType;
    final sMfgData_2_01 mfgData;
    final TDMTerminology terms;
    AdminState adminState;
    IServiceState serviceState;
    String location;
    protected boolean[] isDirty;
    private boolean isModule = false;
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryRowObject");
    public static final int USER_CODE_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    private static final int NUM_DIRTY_FIELDS = 2;

    public ShelfInventoryRowObject(MfgEntityModel mfgEntityModel) {
        Object object;
        if (db.on()) {
            db.println("<init>");
        }
        this.entity = mfgEntityModel;
        INodeModel iNodeModel = mfgEntityModel.getNodeModel();
        this.location = iNodeModel.isMultishelf() ? ((object = (IChassisModel)mfgEntityModel.getNodeModel().getIChassisModelsInstance().getEntityByShelfId(mfgEntityModel.getShelfId())) != null && object.isM6Chassis() ? (mfgEntityModel.getSlot() > mfgEntityModel.getChassis().getMaxPhysicalSlots() ? mfgEntityModel.getShelfId() + "-" + "Chassis " + object.getRackLocation() : mfgEntityModel.getLocation()) : mfgEntityModel.getLocation()) : (mfgEntityModel.getChassis() != null && (mfgEntityModel.getChassis().isM6Chassis() || mfgEntityModel.getChassis().isM2Chassis()) ? (mfgEntityModel.getSlot() > mfgEntityModel.getChassis().getMaxPhysicalSlots() ? "Chassis" : mfgEntityModel.getLocation()) : mfgEntityModel.getLocation());
        if (mfgEntityModel.getChassis().isM6Chassis()) {
            if (mfgEntityModel.getSlot() == 30) {
                object = mfgEntityModel.getEqTypeName();
                this.eqType = (String)object + "_A";
            } else if (mfgEntityModel.getSlot() == 32) {
                object = mfgEntityModel.getEqTypeName();
                this.eqType = (String)object + "_B";
            } else {
                this.eqType = mfgEntityModel.getSlot() == 22 || mfgEntityModel.getSlot() == 28 ? (mfgEntityModel.getSlot() == 22 ? "USBP_A_" + mfgEntityModel.getPositionInParent() : "USBP_B_" + mfgEntityModel.getPositionInParent()) : mfgEntityModel.getEqTypeName();
            }
        } else {
            this.eqType = mfgEntityModel.getChassis().isM2Chassis() && mfgEntityModel.getSlot() == 22 ? "USBP_A_" + mfgEntityModel.getPositionInParent() : mfgEntityModel.getEqTypeName();
        }
        this.terms = iNodeModel.getTDMTerminology();
        this.mfgData = mfgEntityModel.getMfgData();
        this.determineIsModule(this.entity);
        this.adminState = this.getAdminStateFromModel();
        this.serviceState = this.getServiceStateFromModel();
        this.isDirty = new boolean[2];
        this.resetDirtyBits();
    }

    private void determineIsModule(MfgEntityModel mfgEntityModel) {
        this.isModule = mfgEntityModel.getGenericClass() == 6;
    }

    boolean isModule() {
        return this.isModule;
    }

    public void setDirty(int n, boolean bl) {
        if (n >= 0 && n < 2) {
            this.isDirty[n] = bl;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < 2; ++i) {
            if (!this.isDirty[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(int n) {
        return n >= 0 && n < 2 && this.isDirty[n];
    }

    public String getUserCode() {
        return this.mfgData.userCode;
    }

    public void setUserCode(String string) {
        if (!this.getUserCode().equals(string)) {
            this.mfgData.userCode = string;
            this.setDirty(0, true);
        }
    }

    public AdminState getAdminState() {
        return this.adminState;
    }

    public boolean adminStateChanged() {
        return this.getAdminState() != this.getAdminStateFromModel();
    }

    public String getAdminStateString() {
        return this.getAdminState().toString(this.terms);
    }

    public void setAdminState(AdminState adminState) {
        if (!this.getAdminState().equals(adminState)) {
            this.adminState = adminState;
            this.setDirty(1, true);
        }
    }

    public IServiceState getServiceState() {
        return this.serviceState;
    }

    public String getServiceStateString() {
        return this.getServiceState().toString(this.terms);
    }

    private boolean isMultiShelfChassis() {
        return this.entity.getGenericClass() == 0 && this.entity.getChassis().isMultishelf();
    }

    public AdminState getAdminStateFromModel() {
        if ((this.entity.getChassis().isM6Chassis() || this.entity.getChassis().isM2Chassis()) && this.entity.getSlot() >= 30 && this.entity.getSlot() <= 32) {
            return AdminState.NULL_STATE;
        }
        if (!this.isModule() && !this.isMultiShelfChassis()) {
            return AdminState.NULL_STATE;
        }
        eAdminState eAdminState2 = this.entity.getAdminStateEnum();
        return AdminState.enumToAdminState(eAdminState2);
    }

    private IServiceState getServiceStateFromModel() {
        if ((this.entity.getChassis().isM6Chassis() || this.entity.getChassis().isM2Chassis()) && this.entity.getSlot() >= 30 && this.entity.getSlot() <= 32) {
            return ServiceStateFactory.getServiceState(null);
        }
        if (!this.isModule() && !this.isMultiShelfChassis()) {
            return ServiceStateFactory.getServiceState(null);
        }
        sServiceState sServiceState2 = this.entity.getServiceState();
        if (db.on()) {
            db.println("primary service state = " + sServiceState2.pst.value());
        }
        return ServiceStateFactory.getServiceState(sServiceState2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < 2; ++i) {
            this.isDirty[i] = false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShelfInventoryRowObject)) {
            return false;
        }
        ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)object;
        return this.location.equals(shelfInventoryRowObject.location) && this.eqType.equals(shelfInventoryRowObject.eqType) && this.entity.equals(shelfInventoryRowObject.entity) && this.mfgData.equals(this.mfgData);
    }

    public String toString() {
        return this.entity != null ? this.entity.toString() : "null";
    }
}

