/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.NoSuchParameter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.ANSController;
import cerent.cms.ui.ans.ANSTableModel;
import cerent.cms.ui.ans.ANSTreeCellRenderer;
import cerent.cms.ui.ans.AnsAddParamDialog;
import cerent.cms.ui.ans.IANSTreeViewPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.PluralisationUtil;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SystemTime;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeSelectionModel;

public class SppAnsNeUpdatePane
extends ObserverProvPane
implements IANSTreeViewPane,
TreeSelectionListener,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_DIVIDER = "divider";
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("MMMMM d,yyyy H:mm:ss a,z");
    private boolean inited = false;
    private ANSController dfc;
    private TreeSelectionModel tsm;
    private JSplitPane split;
    private JLabel label;
    private String labelText;
    private static final String ADD = "Add...";
    private static final String REMOVE = "Remove...";
    private JButton addButton;
    private JButton removeButton;
    private final NodeModelDelegate nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    private static final SDebug dbg = new SDebug("SppAnsNeUpdatePane");

    public SppAnsNeUpdatePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    @Override
    public void enteringPage() throws Exception {
        if (!this.inited) {
            try {
                this.init();
                this.inited = true;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        int n = this.split.getDividerLocation() * 100 / (this.split.getWidth() - this.split.getDividerSize()) + 1;
        Preferences.instance().setInt(PROP_PREF, PROP_DIVIDER, n);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private void init() {
        this.dfc = new ANSController(this, this.nodeModel, dbg);
        this.setDataSourceControl(this.dfc);
        this.split = new JSplitPane(1);
        JTree jTree = new JTree(this.dfc.getTreeModel());
        jTree.setCellRenderer(new ANSTreeCellRenderer());
        jTree.setShowsRootHandles(true);
        jTree.setScrollsOnExpand(true);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.tsm = jTree.getSelectionModel();
        this.tsm.setSelectionMode(1);
        this.tsm.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Selector"));
        this.split.setLeftComponent(jScrollPane);
        this.table = new UTable((TableModel)this.dfc.getTableModel());
        jScrollPane = new JScrollPane(this.table);
        this.split.setRightComponent(jScrollPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.split);
        this.label = new JLabel(" ");
        this.label.setHorizontalAlignment(4);
        jPanel.add((Component)this.label, "South");
        this.add(jPanel);
        ((ANSTableModel)this.dfc.getTableModel()).initTable(this.table, this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SppAnsNeUpdatePane.this.removeButton.setEnabled(SppAnsNeUpdatePane.this.table.getSelectedRows().length > 0);
            }
        });
        this.split.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = Preferences.instance().getInt(SppAnsNeUpdatePane.PROP_PREF, SppAnsNeUpdatePane.PROP_DIVIDER, 0);
                if (n == 0) {
                    SppAnsNeUpdatePane.this.split.setDividerLocation(-1);
                } else {
                    SppAnsNeUpdatePane.this.split.setDividerLocation((double)n / 100.0);
                }
                SppAnsNeUpdatePane.this.split.removeComponentListener(this);
            }
        });
    }

    @Override
    protected AbstractButton[] getExtraButtons() {
        Dimension dimension = new Dimension(75, 25);
        this.addButton = new JButton(ADD);
        this.addButton.setMaximumSize(dimension);
        this.addButton.setMinimumSize(dimension);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SppAnsNeUpdatePane.this.add();
            }
        });
        this.addButton.setEnabled(true);
        this.removeButton = new JButton(REMOVE);
        this.removeButton.setMaximumSize(dimension);
        this.removeButton.setMinimumSize(dimension);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SppAnsNeUpdatePane.this.remove();
            }
        });
        this.removeButton.setEnabled(false);
        return new JButton[]{this.addButton, this.removeButton};
    }

    @Override
    public TreeSelectionModel getTreeSelectionModel() {
        return this.tsm;
    }

    @Override
    public AbstractPane getParentComponent() {
        return this;
    }

    @Override
    public void updateLabel(String string) {
        SystemTime systemTime = this.nodeModel.getSystemTime();
        timeFmt.setTimeZone(this.nodeModel.getCtcTimeZone());
        Date date = systemTime.getSystemCalendar().getTime();
        String string2 = "Retrieved: " + timeFmt.format(date) + " from " + string;
        this.setLabel(string2);
    }

    @Override
    public void clearLabel() {
        this.setLabel(" ");
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    private boolean checkEditAndSave() {
        if (this.dfc.isDirty()) {
            int n = this.getLeavingPageOption();
            switch (n) {
                case 0: {
                    this.apply();
                    break;
                }
                case 1: {
                    this.reset();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void add() {
        if (this.checkEditAndSave()) {
            AnsAddParamDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this)), this.parentTV.getUiModel());
        }
    }

    private void remove() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        Object[] objectArray = new ANSElement[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n >= this.dfc.getTableModel().getRowCount()) continue;
            objectArray[i] = (ANSElement)this.dfc.getTableModel().getValueAt(n, 0);
        }
        if (!this.checkEditAndSave()) {
            return;
        }
        AnsParamDeletionConfirmDialog ansParamDeletionConfirmDialog = new AnsParamDeletionConfirmDialog(objectArray);
        ansParamDeletionConfirmDialog.show();
        if (ansParamDeletionConfirmDialog.isOk()) {
            n = 0;
            for (Object object : objectArray) {
                n |= this.deleteParam((ANSElement)object);
            }
            if (n != 0) {
                CerentDialog.infoDialog((Component)((Object)this), (String)"Note: After removing parameters,\nyou must run automatic node setup (ANS).", (String)"Apply NE Update to Node");
            }
        }
    }

    private boolean deleteParam(ANSElement aNSElement) {
        try {
            this.nodeModel.getANSManager().getNeANSModel().removeParameter(aNSElement.getKey());
            return true;
        }
        catch (NoSuchParameter noSuchParameter) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WDMANS_CANNOT_REMOVE);
            return false;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
            this.stopTableCellEditing();
            this.dfc.setTableContent(treeSelectionEvent.getNewLeadSelectionPath());
        }
    }

    @Override
    public void run() {
        this.label.setText(this.labelText);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SppAnsNeUpdatePane;
    }

    protected class AnsParamDeletionConfirmDialog {
        protected boolean ok = false;
        protected Object[] paramsToDelete;

        public AnsParamDeletionConfirmDialog(Object[] objectArray) {
            this.paramsToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public void show() {
            String string = "Do you really want to delete the selected " + PluralisationUtil.s("ANS Parameter", this.paramsToDelete.length) + "?";
            Object[] objectArray = new Object[]{new JLabel(string)};
            JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, CerentDialog.QUESTION_ICON);
            JDialog jDialog = jOptionPane.createDialog((Component)((Object)SppAnsNeUpdatePane.this), "Delete " + PluralisationUtil.s("ANS Parameter", this.paramsToDelete.length));
            jDialog.setVisible(true);
            if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
                this.ok = true;
            }
        }
    }
}

