/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sRouter;
import cerent.cms.model.Attribute;
import cerent.cms.model.DuplicateAreaAddress;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.LapdTermModel;
import cerent.cms.model.NoSuchRouter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OsiModel;
import cerent.cms.model.RouterModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SubnetModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.OsiAreaAddressDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SppOsiMainPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
IOsiConstants {
    private JLabel nsapAddrLB;
    private JButton changeAddrJB;
    private JCheckBox partitionRepairCB;
    private JRadioButton esRB;
    private JRadioButton l1RB;
    private JRadioButton l1l2RB;
    private SpinPropertyEditor l1LspBufferSizeS;
    private SpinPropertyEditor l2LspBufferSizeS;
    private LapdTermModel lapdModel;
    private OsiModel osiModel;
    private SubnetModel subnetModel;
    private RouterModel routerModel;

    public SppOsiMainPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JLabel(this.getNSAPTerm()), "West");
        this.nsapAddrLB = new JLabel("");
        this.nsapAddrLB.setFont(OsiHelper.FIXED_WIDTH_FONT);
        jPanel3.add((Component)this.nsapAddrLB, "Center");
        this.changeAddrJB = new JButton("Change Primary Area Address...");
        this.changeAddrJB.addActionListener(this);
        jPanel3.add((Component)this.changeAddrJB, "East");
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(Box.createVerticalStrut(5));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.esRB = new JRadioButton("End System");
        this.esRB.setEnabled(this.isUserAuthorized());
        this.l1RB = new JRadioButton("Intermediate System Level 1");
        this.l1RB.setEnabled(this.isUserAuthorized());
        this.l1l2RB = new JRadioButton("Intermediate System Level 1/Level 2");
        this.l1l2RB.setEnabled(this.isUserAuthorized());
        this.l1LspBufferSizeS = new SpinPropertyEditor("L1 LSP Buffer Size", 1, 512, 1500);
        this.l1LspBufferSizeS.setEnabled(this.isUserAuthorized());
        this.l2LspBufferSizeS = new SpinPropertyEditor("L2 LSP Buffer Size", 1, 512, 1500);
        this.l2LspBufferSizeS.setEnabled(this.isUserAuthorized());
        int[] nArray = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform().getOsiModes();
        JComponent[] jComponentArray = new JComponent[2 * nArray.length];
        JPanel jPanel4 = new JPanel(new GridLayout(nArray.length, 2));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Node Routing Mode"));
        for (int i = 0; i < nArray.length; ++i) {
            JRadioButton jRadioButton = null;
            SpinPropertyEditor spinPropertyEditor = null;
            switch (nArray[i]) {
                case 0: {
                    jRadioButton = this.esRB;
                    break;
                }
                case 1: {
                    jRadioButton = this.l1RB;
                    spinPropertyEditor = this.l1LspBufferSizeS;
                    break;
                }
                case 2: {
                    jRadioButton = this.l1l2RB;
                    spinPropertyEditor = this.l2LspBufferSizeS;
                    break;
                }
                default: {
                    db.severe("Unknown routing mode:" + nArray[i]);
                }
            }
            if (jRadioButton == null) continue;
            jRadioButton.addActionListener(this);
            buttonGroup.add(jRadioButton);
            jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel3.add(jRadioButton);
            jPanel4.add(jPanel3);
            jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
            if (spinPropertyEditor == null) {
                jPanel3.add(new JLabel(" "));
            } else {
                spinPropertyEditor.addPropertyChangeListener(this);
                jPanel3.add(spinPropertyEditor);
            }
            jPanel4.add(jPanel3);
        }
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(Box.createVerticalStrut(5));
        this.partitionRepairCB = new JCheckBox();
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JPanel(), "Center");
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
    }

    private String getNSAPTerm() {
        String string = "Network Entity Title:";
        String[] stringArray = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getRouterModel().getOsiRouters();
        if (stringArray.length > 1) {
            string = "Main " + string;
        }
        return string;
    }

    protected void changePAA(String string) {
        try {
            this.routerModel.changePAA(1, OsiHelper.getAreaAddressBytes((String)string));
        }
        catch (DuplicateAreaAddress duplicateAreaAddress) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAA_DUPLICATED_AREA_ADDR);
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.l1l2RB || object == this.l1RB || object == this.esRB) {
            this.l1LspBufferSizeS.setEnabled((this.l1RB.isSelected() || this.l1l2RB.isSelected()) && this.isUserAuthorized());
            this.l2LspBufferSizeS.setEnabled(this.l1l2RB.isSelected() && this.isUserAuthorized());
            this.setDirty();
        } else if (object == this.changeAddrJB) {
            OsiAreaAddressDialog osiAreaAddressDialog = new OsiAreaAddressDialog((JPanel)((Object)this), false);
            osiAreaAddressDialog.setAreaAddress(OsiHelper.getAreaAddressString((byte[])this.routerModel.getRouter((int)1).addrList[0]));
            osiAreaAddressDialog.show();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        int n;
        db.fine("refreshFromModel()");
        this.changeAddrJB.setEnabled(this.isUserAuthorized() && this.routerModel.getEnabled(1));
        byte[] byArray = this.osiModel.getSystemNSAP();
        byArray[byArray.length - 1] = 0;
        this.nsapAddrLB.setText(OsiHelper.getNsapString((byte[])byArray) + "      ");
        this.partitionRepairCB.setEnabled(this.isUserAuthorized() && this.osiModel.getRoutingMode() == 2);
        sRouter[] sRouterArray = this.routerModel.getRouterList();
        boolean bl = true;
        boolean bl2 = true;
        for (n = 1; n < sRouterArray.length; ++n) {
            if (sRouterArray[n].enabled) {
                bl = false;
                break;
            }
            if (this.subnetModel.getSubnetList((short)(n + 1)).length == 0) continue;
            bl2 = false;
            break;
        }
        n = this.subnetModel.getSubnetList((short)1).length > 1 ? 1 : 0;
        this.esRB.setEnabled(this.isUserAuthorized() && bl && bl2 && n == 0);
        JRadioButton jRadioButton = this.esRB;
        switch (this.osiModel.getRoutingMode()) {
            case 0: {
                this.l1LspBufferSizeS.setEnabled(false);
                this.l2LspBufferSizeS.setEnabled(false);
                break;
            }
            case 1: {
                jRadioButton = this.l1RB;
                this.l1LspBufferSizeS.setEnabled(this.isUserAuthorized());
                this.l2LspBufferSizeS.setEnabled(false);
                break;
            }
            case 2: {
                jRadioButton = this.l1l2RB;
                this.l1LspBufferSizeS.setEnabled(this.isUserAuthorized());
                this.l2LspBufferSizeS.setEnabled(this.isUserAuthorized());
            }
        }
        jRadioButton.setSelected(true);
        this.l1LspBufferSizeS.setValue(new Short(this.osiModel.getL1LspBufferSize()));
        this.l2LspBufferSizeS.setValue(new Short(this.osiModel.getL2LspBufferSize()));
        this.partitionRepairCB.setSelected(this.osiModel.getPartitionRepair());
    }

    private short spinnerToShort(SpinPropertyEditor spinPropertyEditor) {
        String string = spinPropertyEditor.getValue().toString();
        short s = new Short(string);
        return s;
    }

    @Override
    public boolean onValidate() {
        boolean bl = true;
        short s = this.lapdModel.getMinMTU();
        if (this.l1RB.isSelected() && this.spinnerToShort(this.l1LspBufferSizeS) > s) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_LSP_EXCEED_MTU_PARAM_3, "L1", this.l1LspBufferSizeS.getValue(), new Short(s).toString());
            return false;
        }
        if (this.l1l2RB.isSelected() && (this.spinnerToShort(this.l1LspBufferSizeS) > s || this.spinnerToShort(this.l2LspBufferSizeS) > s)) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_LSP_EXCEED_MTU_PARAM_3, "Max", this.l1LspBufferSizeS.getValue(), new Short(s).toString());
            return false;
        }
        if (this.l1RB.isSelected() && this.osiModel.getRoutingMode() == 2) {
            sRouter[] sRouterArray = this.routerModel.getRouterList();
            for (int i = 0; i < sRouterArray.length; ++i) {
                if (sRouterArray[i].routerNumber == 1 || !sRouterArray[i].enabled) continue;
                try {
                    if (this.routerModel.routersHaveSameAreaAddress(1, sRouterArray[i].routerNumber)) continue;
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSI_AREA_NOT_SAME);
                    bl = false;
                    break;
                }
                catch (NoSuchRouter noSuchRouter) {
                    db.severe("ERROR: enclosing loop is broken, attempted to access router #" + sRouterArray[i].routerNumber + " which does not exist.");
                }
            }
        }
        return bl;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        int n = 0;
        if (this.l1RB.isSelected()) {
            n = 1;
        } else if (this.l1l2RB.isSelected()) {
            n = 2;
        }
        if (this.osiModel.getRoutingMode() != n) {
            this.osiModel.setRoutingMode(n);
        }
        short s = this.spinnerToShort(this.l1LspBufferSizeS);
        if (this.osiModel.getL1LspBufferSize() != s) {
            this.osiModel.setL1LspBufferSize(s);
        }
        if (this.l1l2RB.isSelected()) {
            s = this.spinnerToShort(this.l2LspBufferSizeS);
            if (this.osiModel.getL2LspBufferSize() != s) {
                this.osiModel.setL2LspBufferSize(s);
            }
        }
        if (this.partitionRepairCB.isSelected() != this.osiModel.getPartitionRepair()) {
            this.osiModel.setPartitionRepair(this.partitionRepairCB.isSelected());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        db.fine("update: start");
        this.requestRefresh(this, null);
    }

    @Override
    public void enteringPage() throws Exception {
        this.osiModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getOsiModel();
        this.subnetModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getSubnetModel();
        this.routerModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getRouterModel();
        this.lapdModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getLapdModel();
        if (this.osiModel != null) {
            this.osiModel.addObserver((Observer)((Object)this));
        }
        if (this.subnetModel != null) {
            this.subnetModel.addObserver((Observer)((Object)this));
        }
        if (this.routerModel != null) {
            this.routerModel.addObserver((Observer)((Object)this));
        }
        if (this.lapdModel != null) {
            this.lapdModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.osiModel != null) {
            this.osiModel.deleteObserver((Observer)((Object)this));
        }
        if (this.subnetModel != null) {
            this.subnetModel.deleteObserver((Observer)((Object)this));
        }
        if (this.routerModel != null) {
            this.routerModel.deleteObserver((Observer)((Object)this));
        }
        if (this.lapdModel != null) {
            this.lapdModel.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        if (this.osiModel != null) {
            this.osiModel.deleteObserver((Observer)((Object)this));
            this.osiModel = null;
        }
        if (this.subnetModel != null) {
            this.subnetModel.deleteObserver((Observer)((Object)this));
            this.subnetModel = null;
        }
        if (this.routerModel != null) {
            this.routerModel.deleteObserver((Observer)((Object)this));
            this.routerModel = null;
        }
        if (this.lapdModel != null) {
            this.lapdModel.deleteObserver((Observer)((Object)this));
            this.lapdModel = null;
        }
        super.destroy();
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap((IModel)this.getUiModel().getNodeModel()).getAttributeArray(string);
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JCheckBox jCheckBox = new JCheckBox(string);
        jPanel2.add(jCheckBox);
        jCheckBox.addActionListener(this);
        jPanel.add(jPanel2);
        return jCheckBox;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OsiMainPane;
    }
}

