/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.CardView;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class TncCardView
extends CardView {
    private static final int MAX_NUM_GFP = 10;
    protected static final SDebug db = new SDebug("TncCardView");
    protected PpmSlotView[] ppmSlotViews;
    protected ObservableManager _obsMgr;
    protected PluggableCarrierModel moduleM;
    protected GridBagConstraints gbc;

    public TncCardView(EntityModel entityModel, AbstractCardViewPanel abstractCardViewPanel) {
        super((ModuleModel)entityModel, abstractCardViewPanel);
        this.moduleM = (PluggableCarrierModel)entityModel;
        this._obsMgr = new ObservableManager(this, false);
        this.registerForLocalUpdates();
        this.numPorts = 2;
    }

    @Override
    protected void addPorts(boolean bl) {
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(2, 3, 2, 2);
        this.addPortsToCard();
        this.invalidate();
    }

    private void addPortsToCard() {
        this.moduleM = (PluggableCarrierModel)this.model;
        PluggableSlotModel[] pluggableSlotModelArray = this.moduleM.getPpmSlots();
        this.ppmSlotViews = new PpmSlotView[pluggableSlotModelArray.length];
        for (int i = 0; i < 2; ++i) {
            this.ppmSlotViews[i] = new PpmSlotView(pluggableSlotModelArray[i]);
            this.ppmSlotViews[i].addCardViewPaneToPort(this.cardViewPanel);
            ++this.gbc.gridy;
            this.add((Component)this.ppmSlotViews[i], this.gbc);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (db.on()) {
                db.println("update(): DwdmCardView, From=" + observable + ", arg=" + n);
            }
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port DELETED");
                }
            } else if (n.equals(ModelUpdateType.CHANGED) && db.on()) {
                db.println("Port CHANGED");
            }
        }
    }

    @Override
    public void dispose() {
        this.localDispose();
        super.dispose();
    }

    protected void localDispose() {
        int n;
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        if (this.ppmSlotViews != null) {
            for (n = 0; n < this.ppmSlotViews.length; ++n) {
                this.ppmSlotViews[n].dispose();
            }
        }
        if (this.ports != null) {
            for (n = 0; n < this.ports.length; ++n) {
                if (this.ports[n] == null) continue;
                this.ports[n].dispose();
                this.ports[n] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    protected void registerForLocalUpdates() {
        this._obsMgr.reset();
        this._obsMgr.addObservable((Observable)((Object)this.moduleM));
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    TncCardView.this.localDispose();
                    if (TncCardView.this.model != null) {
                        TncCardView.this.portModels = TncCardView.this.getPorts();
                        TncCardView.this.numPorts = TncCardView.this.portModels.size();
                        TncCardView.this.ports = new AbstractPortGraphic[TncCardView.this.numPorts];
                        TncCardView.this.addPorts(TncCardView.this.pci.positionPortsVertically());
                        TncCardView.this.refreshAlarmInfo();
                        TncCardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            TncCardView.this.validate();
            TncCardView.this.repaint();
        }
    }
}

