/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticsPortGraphic;
import cerent.cms.ui.shelf.Wxc80CardView;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;

public class Wxc80Card
extends CardGraphic {
    protected OpticsPortGraphic[] portGraphics = null;

    public Wxc80Card(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
        this.addPortGraphics(entityModel);
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    protected void addPortGraphics(EntityModel entityModel) {
        if (entityModel instanceof ModuleModel) {
            int n;
            List list = entityModel.getChildren();
            int n2 = list.size();
            this.portGraphics = new OpticsPortGraphic[n2];
            int n3 = this.cardPainter.getMiniPortHeight();
            int n4 = this.cardPainter.getMiniPortWidth();
            int n5 = this.cardPainter.getMultiPortOpticonXOffset();
            int n6 = this.cardPainter.getMiniOpticonYSpacing();
            int n7 = this.cardPainter.getMiniOpticonYOffset();
            int n8 = this.cardPainter.getOpticonXSpacing();
            int n9 = 7;
            for (n = 0; n < 3; ++n) {
                this.portGraphics[n] = new OpticsPortGraphic((CardGraphic)this, n5 + n8 * n, n7 - n3 / 3 + (n6 - 7) * n9, n4, n3, (OpticsPortModel)list.get(Wxc80CardView.PORT_MODEL_ARRAY[n]));
                n9 += 2;
            }
            this.portGraphics[3] = new OpticsPortGraphic((CardGraphic)this, n5 + n8 + n5 * 2, n7 - n3 / 3 + (n6 - 7), n4, n3, (OpticsPortModel)list.get(Wxc80CardView.PORT_MODEL_ARRAY[3]));
            this.portGraphics[4] = new OpticsPortGraphic((CardGraphic)this, n5 + n8 + n5 * 2, n7 - n3 / 3 + (n6 - 7) * 3, n4, n3, (OpticsPortModel)list.get(Wxc80CardView.PORT_MODEL_ARRAY[4]));
            n = 5;
            n9 = 5;
            for (int i = 5; i < n2; ++i) {
                if (i % 2 == 0) {
                    this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n5 + n8 + n5 * 4, n7 - n3 / 3 + (n6 - 7) * n, n4, n3, (OpticsPortModel)list.get(Wxc80CardView.PORT_MODEL_ARRAY[i]));
                    n += 2;
                    continue;
                }
                this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n5 + n8 + n5 * 2, n7 - n3 / 3 + (n6 - 7) * n9, n4, n3, (OpticsPortModel)list.get(Wxc80CardView.PORT_MODEL_ARRAY[i]));
                n9 += 2;
            }
        }
    }

    @Override
    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            return null;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
            this.portGraphics = null;
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
        }
        this.addRoleLabel(graphics);
    }

    private void addRoleLabel(Graphics graphics) {
        float f = 0.76363635f;
        eCardOperMode eCardOperMode2 = ((ModuleModel)this.entityM).getCardOperMode();
        int n = this.cardPainter.getCardWidth();
        int n2 = this.cardPainter.getCardHeight();
        Font font = graphics.getFont();
        graphics.setFont(font.deriveFont((float)(font.getSize() - 1)));
        graphics.setColor(Color.black);
        String string = null;
        if (eCardOperMode2 == eCardOperMode.OPER_MODE_WXC80_BIDI) {
            string = "BIDI";
        } else if (eCardOperMode2 == eCardOperMode.OPER_MODE_WXC80_MUX) {
            string = "MUX";
        } else if (eCardOperMode2 == eCardOperMode.OPER_MODE_WXC80_DMX) {
            string = "DMX";
        }
        int n3 = Math.round((float)n2 * f);
        if (this.entityM.getChassis().getShelfType() != 71) {
            n3 += 4;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n - fontMetrics.stringWidth(string);
        graphics.drawString(string, n4, n3);
        graphics.setFont(font);
    }

    protected int initWidth() {
        return this.cardPainter.getCardWidth() * this.getSlotsOccupied();
    }

    protected Dimension getSlotDim(int n) {
        return new Dimension(this.initWidth(), this.cardPainter.getCardHeight());
    }
}

