/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Lmp.eDataLinkOperationalState;
import cerent.cms.idl.Lmp.eDataLinkType;
import cerent.cms.idl.Lmp.eLmpError;
import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpDataLinkModel;
import cerent.cms.model.LmpDataLinkModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.lmp.PortWrapper;
import cerent.cms.ui.shelf.lmp.TeLinkDataSource;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import com.cisco.crs.model.PlimPortId;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;

class DataLinkDataSource
extends AbstractRowDataSource
implements LmpConstants {
    static final EntityCellRenderer _renderer = new EntityCellRenderer("", true);
    private LmpDataLinkModels _model;
    private ArrayList _data;
    private Observer _observer;
    private SortableRowTableModel _tm;
    private Column[] _columns;
    private HashMap _columnMap;
    private TeLinkDataSource _teLinkDsc;
    private static final SDebug db = new SDebug("DataLinkDataSource");
    private ArrayList _candidates = new ArrayList();
    private ArrayList _teLinks = new ArrayList();

    DataLinkDataSource(LmpDataLinkModels lmpDataLinkModels) {
        this._model = lmpDataLinkModels;
        this._data = new ArrayList();
        this._observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EventQueue.invokeLater(new Refresher(observable, object));
            }
        };
        this._tm = null;
        this._columns = this.newColumns();
        this._columnMap = new HashMap();
        for (int i = 0; i < this._columns.length; ++i) {
            this._columnMap.put(this._columns[i].getName(), this._columns[i]);
        }
        this._teLinkDsc = new TeLinkDataSource(this.getTeLinkModels());
        this.trace("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            Iterator iterator = this._data.iterator();
            while (iterator.hasNext()) {
                ((Info)iterator.next()).dispose(this._observer);
            }
            this._data.clear();
        }
        this._teLinkDsc.dispose();
        this.trace("dispose");
    }

    private Column[] newColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Operational State";
            }

            @Override
            Class getColumnClass() {
                return String.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return info._operationalState;
            }

            @Override
            void setColumnValue(Info info, Object object) {
                info.setOperationalState(DataLinkDataSource.this.getOperationalStateChoice((Attribute)object));
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vOperationalState.value(), (int)info2._vOperationalState.value());
            }
        });
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Local Port";
            }

            @Override
            Class getColumnClass() {
                return String.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return DataLinkDataSource.this.buildPortString(info);
            }

            @Override
            void setColumnValue(Info info, Object object) throws Exception {
                PortWrapper portWrapper = (PortWrapper)object;
                if (portWrapper == null || portWrapper.getPortId() == 0) {
                    throw new Exception("No local port chosen.");
                }
                info.setLocalPortId(portWrapper.getPortId());
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalPortId, (int)info2._vLocalPortId);
            }
        });
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Local Port Id";
            }

            @Override
            Class getColumnClass() {
                return Integer.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return info._localPortId;
            }

            @Override
            void setColumnValue(Info info, Object object) throws Exception {
                PortWrapper portWrapper = (PortWrapper)object;
                if (portWrapper == null || portWrapper.getPortId() == 0) {
                    throw new Exception("No local port was chosen.");
                }
                info.setLocalPortId(portWrapper.getPortId());
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalPortId, (int)info2._vLocalPortId);
            }
        });
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Data Link Type";
            }

            @Override
            String getDefaultsPath() {
                return "NODE.lmp.dataLink.Type";
            }

            @Override
            String getDefaultValue() {
                return LmpConstants.DATA_LINK_TYPE_DEFAULT;
            }

            @Override
            Class getColumnClass() {
                return String.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return info._type;
            }

            @Override
            void setColumnValue(Info info, Object object) {
                info.setType(DataLinkDataSource.this.getTypeChoice((Attribute)object));
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vType.value(), (int)info2._vType.value());
            }
        });
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Local TE Link Id";
            }

            @Override
            Class getColumnClass() {
                return Integer.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return info._localTeLinkId;
            }

            @Override
            void setColumnValue(Info info, Object object) throws Exception {
                if (object == null) {
                    throw new Exception("No local TE link chosen.");
                }
                info.setLocalTeLinkId(((TeLinkDataSource.Info)object).getLocalTeLinkId());
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vLocalTeLinkId, (int)info2._vLocalTeLinkId);
            }
        });
        arrayList.add(new Column(){

            @Override
            public String getName() {
                return "Remote Port Id";
            }

            @Override
            Class getColumnClass() {
                return Integer.class;
            }

            @Override
            Object getColumnValue(Info info) {
                return info._remoteDataLinkId;
            }

            @Override
            void setColumnValue(Info info, Object object) throws Exception {
                info.setRemoteDataLinkId(this.getLong((String)object));
            }

            @Override
            int cmpValue(Info info, Info info2) {
                return ComparisonUtil.compare((int)info._vRemoteDataLinkId, (int)info2._vRemoteDataLinkId);
            }
        });
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    void setTableModel(SortableRowTableModel sortableRowTableModel) {
        this._tm = sortableRowTableModel;
    }

    String asString(int n, char c, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = (long)n & 0xFFFFFFFFL;
        stringBuffer.append(Long.toHexString(l));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, c);
        }
        stringBuffer.insert(0, "0x");
        return stringBuffer.toString();
    }

    private String getDescription(int n) {
        if (n == 0) {
            return "";
        }
        try {
            INodeModel iNodeModel = this._model.getNodeModel();
            return _renderer.getString(iNodeModel.getEntityTable().getEntityModelByIndex(n), iNodeModel.isMultishelf() ? "shelf " : "slot ");
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return this.asString(n, '0', 8);
        }
    }

    public List<PortModel> getPortList() {
        INodeModel iNodeModel = this._model.getNodeModel();
        return ((EntityTableModel)iNodeModel.getEntityTable()).getEntityModelsByClass(eClass.PORT);
    }

    public PortModel getPortByIndex(int n) throws AbstractCmsNoSuchEntityException {
        INodeModel iNodeModel = this._model.getNodeModel();
        return (PortModel)((EntityTableModel)iNodeModel.getEntityTable()).getEntityModelByIndex(n);
    }

    private String buildPortString(Info info) {
        block10: {
            if (info._localPort == null || info._vLocalPortId == 0) {
                return null;
            }
            INodeModel iNodeModel = this._model.getNodeModel();
            try {
                EntityTableModel entityTableModel = (EntityTableModel)iNodeModel.getEntityTable();
                PortModel portModel = (PortModel)entityTableModel.getEntityModelByIndex(info._vLocalPortId);
                if (LmpDataLinkModels.isChanRx(portModel)) {
                    int n = info.getLocalTXPortId();
                    if (n != 0) {
                        return "RX: " + info._localPort + " -- TX: " + this.getDescription(n);
                    }
                    break block10;
                }
                return info._localPort;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("buildPortString: AbstractCmsNoSuchEntityException");
                }
                return null;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("buildPortString: NoSuchInterface");
                }
                return null;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db.on()) {
                    db.println("buildPortString: WrongInterfaceType");
                }
                return null;
            }
        }
        return null;
    }

    Attribute[] getOperationalStateChoices() {
        return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-Data-Link-Operational-State");
    }

    Attribute getOperationalStateChoice(eDataLinkOperationalState eDataLinkOperationalState2) {
        Attribute[] attributeArray = this.getOperationalStateChoices();
        int n = eDataLinkOperationalState2.value();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return attributeArray[i];
        }
        return null;
    }

    Attribute getOperationalStateChoice(Info info) {
        return this.getOperationalStateChoice(info.getOperationalState());
    }

    eDataLinkOperationalState getOperationalStateChoice(Attribute attribute) {
        return eDataLinkOperationalState.from_int(attribute.getIntValue());
    }

    PortWrapper[] getLocalPortChoices(Info info) throws LmpException {
        int n;
        this._candidates.clear();
        int[] nArray = this._model.getCandidates();
        for (int i = 0; i < nArray.length; ++i) {
            this._candidates.add(new PortWrapper(nArray[i], this.getDescription(nArray[i])));
        }
        PortWrapper portWrapper = this.getLocalPortChoice(info);
        if (portWrapper == null && (n = info.getLocalPortId()) != 0) {
            portWrapper = new PortWrapper(n, info._localPort);
            this._candidates.add(portWrapper);
        }
        Collections.sort(this._candidates);
        return this._candidates.toArray(new PortWrapper[this._candidates.size()]);
    }

    PortWrapper getLocalPortChoice(Info info) {
        int n = info.getLocalPortId();
        for (PortWrapper portWrapper : this._candidates) {
            if (portWrapper.getPortId() != n) continue;
            return portWrapper;
        }
        return null;
    }

    private LmpTeLinkModels getTeLinkModels() {
        return LmpTeLinkModels.getInstance((NodeModelDelegate)this._model.getNodeModel());
    }

    TeLinkDataSource.Info[] getTeLinkChoices() throws LmpException {
        this._teLinks.clear();
        LmpTeLinkModel[] lmpTeLinkModelArray = this.getTeLinkModels().getTeLinks();
        for (int i = 0; i < lmpTeLinkModelArray.length; ++i) {
            TeLinkDataSource teLinkDataSource = this._teLinkDsc;
            teLinkDataSource.getClass();
            this._teLinks.add(new TeLinkDataSource.Info(teLinkDataSource, lmpTeLinkModelArray[i]));
        }
        Collections.sort(this._teLinks);
        return this._teLinks.toArray(new TeLinkDataSource.Info[this._teLinks.size()]);
    }

    TeLinkDataSource.Info getTeLinkChoice(int n) {
        for (TeLinkDataSource.Info info : this._teLinks) {
            if (info.getLocalTeLinkId() != n) continue;
            return info;
        }
        return null;
    }

    TeLinkDataSource.Info getTeLinkChoice(Info info) {
        return this.getTeLinkChoice(info.getLocalTeLinkId());
    }

    Attribute[] getTypeChoices() {
        return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-Data-Link-Type");
    }

    TeLinkDataSource.Info[] getFilteredTeLinkChoices() throws LmpException {
        this.getTeLinkChoices();
        ArrayList<TeLinkDataSource.Info> arrayList = new ArrayList<TeLinkDataSource.Info>();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this._model.getNodeModel();
        for (Object e : this._teLinks) {
            TeLinkDataSource.Info info = (TeLinkDataSource.Info)e;
            LmpCtrlChannelModel lmpCtrlChannelModel = info.getModel().findControlChannel();
            if (lmpCtrlChannelModel != null && lmpCtrlChannelModel.isRemoteCrs() && nodeModelDelegate.getLmpDataLinkModels().getDataLinksForTeLink(info.getModel()).length > 0) continue;
            TeLinkDataSource teLinkDataSource = this._teLinkDsc;
            teLinkDataSource.getClass();
            arrayList.add(new TeLinkDataSource.Info(teLinkDataSource, info));
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new TeLinkDataSource.Info[arrayList.size()]);
    }

    Attribute getTypeChoice(int n) {
        Attribute[] attributeArray = this.getTypeChoices();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getIntValue() != n) continue;
            return attributeArray[i];
        }
        return null;
    }

    Attribute getTypeChoice(eDataLinkType eDataLinkType2) {
        return this.getTypeChoice(eDataLinkType2.value());
    }

    Attribute getTypeChoice(Info info) {
        return this.getTypeChoice(info.getType());
    }

    Attribute getTypeChoice(String string) {
        return this.getTypeChoice(Integer.parseInt(string));
    }

    eDataLinkType getTypeChoice(Attribute attribute) {
        return eDataLinkType.from_int(attribute.getIntValue());
    }

    String getDefaultValue(String string) {
        Column column = this.getColumn(string);
        String string2 = column.getDefaultValue();
        try {
            String string3 = column.getDefaultsPath();
            String string4 = null;
            if (string3 != null) {
                string4 = this._model.getNodeModel().getDefaultValue(string3);
            }
            if (string4 != null && !string4.equals("UNKNOWN")) {
                string2 = string4;
            }
        }
        catch (NoSuchDefault noSuchDefault) {
            db.println("Cannot find default for " + string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info find(ArrayList arrayList, int n) {
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            for (Info info : arrayList) {
                if (info.getLocalDataLinkId() != n) continue;
                return info;
            }
        }
        return null;
    }

    private static boolean isInvalidIndex(LmpException lmpException) {
        return eLmpError.INVALID_DATA_LINK_INDEX.equals(lmpException.getLmpError());
    }

    void refreshFromModel() {
        block7: {
            this.trace("refreshFromModel");
            try {
                ArrayList<LmpException> arrayList = new ArrayList<LmpException>();
                LmpDataLinkModel[] lmpDataLinkModelArray = this._model.getDataLinks();
                ArrayList<Info> arrayList2 = new ArrayList<Info>(lmpDataLinkModelArray.length);
                for (int i = 0; i < lmpDataLinkModelArray.length; ++i) {
                    try {
                        Info info = this.find(this._data, lmpDataLinkModelArray[i].getIndex());
                        if (info == null) {
                            info = new Info(lmpDataLinkModelArray[i]);
                        }
                        arrayList2.add(info);
                        continue;
                    }
                    catch (LmpException lmpException) {
                        if (DataLinkDataSource.isInvalidIndex(lmpException)) continue;
                        arrayList.add(lmpException);
                    }
                }
                this.updateTXPorts(arrayList2);
                EventQueue.invokeLater(new Refresher(arrayList2));
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ErrorMsg.displayError(null, (EID)((LmpException)((Object)iterator.next())).getEid());
                }
            }
            catch (Exception exception) {
                db.println("exception: " + exception);
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void updateTXPorts(ArrayList<Info> arrayList) {
        if (db.on()) {
            db.println("Refreshing RX/TX ports association for datalinks tab");
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Info info : arrayList) {
            hashMap.put(info.getLocalPortId(), 0);
        }
        this._model.getTxPortByRxBulk(hashMap);
        for (Info info : arrayList) {
            int n = info.getLocalPortId();
            if (!hashMap.containsKey(n)) continue;
            info.setLocalTXPortId(hashMap.get(n));
        }
    }

    ColumnRenderer[] getRenderers() {
        return this._columns;
    }

    Column getColumn(String string) {
        return (Column)this._columnMap.get(string);
    }

    String getColumnName(int n) {
        return this._columns[n].getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        ArrayList arrayList = this._data;
        synchronized (arrayList) {
            return this._data.size();
        }
    }

    public List<PlimPortId> getUsedCrsPorts(String string) throws LmpException {
        ArrayList<PlimPortId> arrayList = new ArrayList<PlimPortId>();
        LmpDataLinkModel[] lmpDataLinkModelArray = this._model.getDataLinks();
        for (int i = 0; i < lmpDataLinkModelArray.length; ++i) {
            if (!lmpDataLinkModelArray[i].isRemoteCrs()) continue;
            int n = lmpDataLinkModelArray[i].getLocalTeLinkId();
            IIpAddr iIpAddr = null;
            String string2 = null;
            try {
                iIpAddr = this._model.getNodeModel().getILmpTeLinkModels().getITeLink(n).getIRemoteNodeId();
                string2 = InetUtil.makeDottedString(iIpAddr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!string.equals(string2)) continue;
            arrayList.add(new PlimPortId(lmpDataLinkModelArray[i].getRemoteCrsPortId()));
        }
        return arrayList;
    }

    public Class getRowObjectClass() {
        return Info.class;
    }

    void println(String string) {
        db.println(string);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println(string + "(" + this._model.getNodeModel().getHostName() + ")");
        }
    }

    abstract class Column
    implements ColumnRenderer {
        Column() {
        }

        public abstract String getName();

        String getDefaultsPath() {
            return null;
        }

        String getDefaultValue() {
            return null;
        }

        abstract Class getColumnClass();

        abstract Object getColumnValue(Info var1);

        abstract void setColumnValue(Info var1, Object var2) throws Exception;

        abstract int cmpValue(Info var1, Info var2);

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(this.getColumnClass()).getTableCellRendererComponent(jTable, this.getColumnValue((Info)object), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof Info) {
                if (object2 instanceof Info) {
                    return this.cmpValue((Info)object, (Info)object2);
                }
                return -1;
            }
            return 1;
        }

        int rangeCheck(long l, long l2, long l3) throws Exception {
            if (l2 <= l3 && (l < l2 || l > l3)) {
                throw new Exception("The value (" + l + ") must be between " + l2 + " and " + l3 + ".");
            }
            return (int)l;
        }

        int getLong(String string) throws Exception {
            return this.rangeCheck(Long.decode(string.trim()), 0L, 0xFFFFFFFFL);
        }
    }

    class Info
    extends Observable
    implements Comparable,
    Observer {
        LmpDataLinkModel _vModel;
        eDataLinkOperationalState _vOperationalState;
        int _vLocalPortId;
        int _vLocalDataLinkId;
        eDataLinkType _vType;
        int _vLocalTeLinkId;
        int _vRemoteDataLinkId;
        boolean _vIsCrs;
        int _vRemoteCrsPortId;
        int localTXPortId;
        String _operationalState;
        String _localPort;
        String _localPortId;
        String _localDataLinkId;
        String _type;
        String _localTeLinkId;
        String _remoteDataLinkId;

        Info() {
        }

        Info(Info info) {
            this._vModel = info._vModel;
            this._vOperationalState = info._vOperationalState;
            this._vLocalPortId = info._vLocalPortId;
            this.localTXPortId = 0;
            this._vLocalDataLinkId = info._vLocalDataLinkId;
            this._vType = info._vType;
            this._vLocalTeLinkId = info._vLocalTeLinkId;
            this._vRemoteDataLinkId = info._vRemoteDataLinkId;
            this._vIsCrs = info._vIsCrs;
            this._vRemoteCrsPortId = info._vRemoteCrsPortId;
            this._operationalState = info._operationalState;
            this._localPort = info._localPort;
            this._localPortId = info._localPortId;
            this._localDataLinkId = info._localDataLinkId;
            this._type = info._type;
            this._localTeLinkId = info._localTeLinkId;
            this._remoteDataLinkId = info._remoteDataLinkId;
        }

        Info(LmpDataLinkModel lmpDataLinkModel) throws LmpException {
            this._vModel = lmpDataLinkModel;
            this.refresh();
        }

        private void refresh() throws LmpException {
            this.setLocalPortId(this._vModel.getLocalPortId());
            DataLinkDataSource.this.trace("refresh-" + this);
            this.setOperationalState(this._vModel.getOperationalState());
            this.setLocalDataLinkId(this._vModel.getLocalDataLinkId());
            this.setType(this._vModel.getType());
            this.setLocalTeLinkId(this._vModel.getLocalTeLinkId());
            this.setRemoteDataLinkId(this._vModel.getRemoteDataLinkId());
            this.setRemoteCrsPortId(this._vModel.getRemoteCrsPortId());
            this.setIsCrs(this._vModel.isRemoteCrs());
        }

        @Override
        public void update(Observable observable, Object object) {
            if (ModelUpdateType.CHANGED.equals(object)) {
                DataLinkDataSource.this.trace("changed-" + this);
                try {
                    this.refresh();
                    this.setChanged();
                    this.notifyObservers(object);
                }
                catch (LmpException lmpException) {
                    if (!DataLinkDataSource.isInvalidIndex(lmpException)) {
                        ErrorMsg.displayError(null, (EID)lmpException.getEid());
                    }
                }
            } else if (ModelUpdateType.DELETED.equals(object)) {
                DataLinkDataSource.this.trace("deleted-" + this);
                this.setChanged();
                this.notifyObservers(object);
            } else {
                DataLinkDataSource.this.trace("update-" + object + "-" + this);
            }
        }

        void init(Observer observer) {
            DataLinkDataSource.this.trace("init-" + this);
            if (this._vModel != null) {
                this._vModel.addObserver(this);
            }
            this.addObserver(observer);
        }

        void dispose(Observer observer) {
            DataLinkDataSource.this.trace("dispose-" + this);
            this.deleteObserver(observer);
            if (this._vModel != null) {
                this._vModel.deleteObserver(this);
            }
        }

        LmpDataLinkModel getModel() {
            return this._vModel;
        }

        void setOperationalState(eDataLinkOperationalState eDataLinkOperationalState2) {
            this._vOperationalState = eDataLinkOperationalState2;
            this._operationalState = DataLinkDataSource.this.getOperationalStateChoice(this._vOperationalState).toString();
        }

        eDataLinkOperationalState getOperationalState() {
            return this._vOperationalState;
        }

        void setLocalPortId(int n) {
            this._vLocalPortId = n;
            this._localPortId = this._vLocalPortId == 0 ? "" : DataLinkDataSource.this.asString(this._vLocalPortId, '0', 8);
            this._localPort = DataLinkDataSource.this.getDescription(this._vLocalPortId);
        }

        int getLocalPortId() {
            return this._vLocalPortId;
        }

        void setLocalTXPortId(int n) {
            this.localTXPortId = n;
        }

        int getLocalTXPortId() {
            return this.localTXPortId;
        }

        void setLocalDataLinkId(int n) {
            this._vLocalDataLinkId = n;
            this._localDataLinkId = DataLinkDataSource.this.asString(this._vLocalDataLinkId, '0', 8);
        }

        int getLocalDataLinkId() {
            return this._vLocalDataLinkId;
        }

        void setType(eDataLinkType eDataLinkType2) {
            this._vType = eDataLinkType2;
            this._type = DataLinkDataSource.this.getTypeChoice(this._vType).toString();
        }

        eDataLinkType getType() {
            return this._vType;
        }

        void setLocalTeLinkId(int n) {
            this._vLocalTeLinkId = n;
            this._localTeLinkId = this._vLocalTeLinkId == 0 ? "None" : DataLinkDataSource.this.asString(this._vLocalTeLinkId, '0', 8);
        }

        int getLocalTeLinkId() {
            return this._vLocalTeLinkId;
        }

        void setRemoteDataLinkId(int n) {
            this._vRemoteDataLinkId = n;
            this._remoteDataLinkId = DataLinkDataSource.this.asString(this._vRemoteDataLinkId, '0', 8);
        }

        int getRemoteDataLinkId() {
            return this._vRemoteDataLinkId;
        }

        public String toString() {
            return this._localPortId;
        }

        public sDataLinkAttrsEx toAttrs() {
            sDataLinkAttrsEx sDataLinkAttrsEx2 = new sDataLinkAttrsEx();
            sDataLinkAttrsEx2.type = this.getType();
            sDataLinkAttrsEx2.tIndex = this.getLocalPortId();
            sDataLinkAttrsEx2.te_link_id = this.getLocalTeLinkId();
            sDataLinkAttrsEx2.remote_id = this.getRemoteDataLinkId();
            sDataLinkAttrsEx2.remote_crsPort = this.getRemoteCrsPortId();
            sDataLinkAttrsEx2.isRemoteCrs = this.getIsCrs();
            return sDataLinkAttrsEx2;
        }

        public int compareTo(Object object) {
            return DataLinkDataSource.this.getColumn("Local Port Id").cmpValue(this, (Info)object);
        }

        public int hashCode() {
            return this._vLocalDataLinkId;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Info) {
                bl = this._vLocalDataLinkId == ((Info)object)._vLocalDataLinkId;
            }
            return bl;
        }

        public int getRemoteCrsPortId() {
            return this._vRemoteCrsPortId;
        }

        public void setRemoteCrsPortId(int n) {
            this._vRemoteCrsPortId = n;
        }

        public boolean getIsCrs() {
            return this._vIsCrs;
        }

        public void setIsCrs(boolean bl) {
            this._vIsCrs = bl;
        }
    }

    private class Refresher
    implements Runnable {
        private ArrayList _newModels;
        private ArrayList _oldModels;
        private ArrayList _updModels;

        Refresher(ArrayList arrayList) {
            this._newModels = arrayList;
            this._oldModels = null;
            this._updModels = null;
        }

        Refresher(Object object, Object object2) {
            this._newModels = null;
            if (ModelUpdateType.DELETED.equals(object2)) {
                this._oldModels = new ArrayList();
                this._oldModels.add(object);
                this._updModels = null;
            } else {
                this._oldModels = null;
                this._updModels = new ArrayList();
                this._updModels.add(object);
                DataLinkDataSource.this.updateTXPorts(this._updModels);
            }
        }

        private int findAndRemove(ArrayList arrayList, Info info) {
            int n = arrayList.indexOf(info);
            if (n != -1) {
                arrayList.remove(n);
            }
            return n;
        }

        private void removeOldModels(ArrayList arrayList, ArrayList arrayList2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = DataLinkDataSource.this._data.indexOf((Info)iterator.next());
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
            for (Info info : arrayList) {
                int n = this.findAndRemove(DataLinkDataSource.this._data, info);
                if (n == -1) continue;
                info.dispose(DataLinkDataSource.this._observer);
            }
        }

        private void notifyDeletedRows(ArrayList arrayList) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Integer)object2).compareTo((Integer)object);
                }
            });
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n2 == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n - 1) {
                    n = n3;
                    continue;
                }
                DataLinkDataSource.this._tm.rowsDeleted(n, n2);
                n = n2 = n3;
            }
            if (n2 != -1) {
                DataLinkDataSource.this._tm.rowsDeleted(n, n2);
            }
        }

        private void findUpdModels(ArrayList arrayList, ArrayList arrayList2) {
            for (Info info : arrayList) {
                int n = DataLinkDataSource.this._data.indexOf(info);
                if (n == -1) continue;
                arrayList2.add(new Integer(n));
            }
        }

        private void notifyUpdatedRows(ArrayList arrayList) {
            int n = -1;
            int n2 = -1;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (n == -1) {
                    n = n2 = ((Integer)iterator.next()).intValue();
                    continue;
                }
                int n3 = (Integer)iterator.next();
                if (n3 == n2 + 1) {
                    n2 = n3;
                    continue;
                }
                DataLinkDataSource.this._tm.rowsUpdated(n, n2);
                n = n2 = n3;
            }
            if (n != -1) {
                DataLinkDataSource.this._tm.rowsUpdated(n, n2);
            }
        }

        private void addNewModels(ArrayList arrayList) {
            for (Info info : arrayList) {
                info.init(DataLinkDataSource.this._observer);
                DataLinkDataSource.this._data.add(info);
            }
        }

        private void notifyAddedRows(int n, int n2) {
            if (n2 >= n) {
                DataLinkDataSource.this._tm.rowsAdded(n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList = DataLinkDataSource.this._data;
            synchronized (arrayList) {
                ArrayList arrayList2;
                ArrayList<Info> arrayList3 = new ArrayList<Info>();
                ArrayList arrayList4 = new ArrayList();
                if (this._newModels != null && !this._newModels.isEmpty()) {
                    arrayList4.addAll(DataLinkDataSource.this._data);
                    for (Info info : this._newModels) {
                        if (this.findAndRemove(arrayList4, info) != -1) continue;
                        arrayList3.add(info);
                    }
                }
                if (this._oldModels != null) {
                    this._oldModels.addAll(arrayList4);
                } else {
                    this._oldModels = arrayList4;
                }
                if (this._oldModels != null && !this._oldModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.removeOldModels(this._oldModels, arrayList2);
                    this.notifyDeletedRows(arrayList2);
                }
                if (this._updModels != null && !this._updModels.isEmpty()) {
                    arrayList2 = new ArrayList();
                    this.findUpdModels(this._updModels, arrayList2);
                    this.notifyUpdatedRows(arrayList2);
                }
                if (arrayList3 != null && !arrayList3.isEmpty()) {
                    int n = DataLinkDataSource.this._data.size();
                    this.addNewModels(arrayList3);
                    this.notifyAddedRows(n, DataLinkDataSource.this._data.size() - 1);
                }
            }
            this._updModels = null;
            this._oldModels = null;
            this._newModels = null;
        }
    }
}

