/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.ui.shelf.lmp.crs.CcCommand;
import cerent.cms.ui.shelf.lmp.crs.CrsControlChannelManager;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.RouterUtil;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIShowVersionAction;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYSessionFactory;
import com.cisco.crs.model.PlatformNodeModel;
import java.awt.Component;
import java.io.IOException;

class CcVersionCheckCmd
extends CcCommand {
    private String crsIpAddr;

    public CcVersionCheckCmd(CrsControlChannelManager crsControlChannelManager, String string) {
        super(crsControlChannelManager);
        this.crsIpAddr = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        try {
            String string;
            String string2;
            this.mgr.nodeHelper.initTtyLogFactory();
            ITTYSession iTTYSession = null;
            try {
                Preferences preferences = Preferences.instance();
                if (preferences.getBoolean("ctc.router", "useRouterLogin", false)) {
                    string2 = preferences.getProperty("ctc.router", "username", "");
                    string = RouterUtil.decrypt(preferences.getProperty("ctc.router", "password", ""), string2);
                } else {
                    string2 = this.mgr.node.getUserName();
                    string = this.mgr.node.getUserPassword();
                }
                iTTYSession = TTYSessionFactory.instance().getSession(this.crsIpAddr, string2, string, TTYSessionFactory.SessionType.XML);
            }
            finally {
                if (iTTYSession != null) {
                    iTTYSession.releaseMe();
                }
            }
            string2 = new CLIShowVersionAction(this.crsIpAddr, (KDebug)this.mgr.db);
            string = string2.get();
            if (string == null) {
                this.showCliError((CLIAction)string2);
                return false;
            }
            if (!string.getNeType().equals("crs")) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_NE_ERROR);
                return false;
            }
            if (!PlatformNodeModel.checkSwVersionCompatibility(this.crsIpAddr, string.getVersion())) {
                return false;
            }
        }
        catch (IOException iOException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_IO_ERROR);
            return false;
        }
        return true;
    }

    @Override
    public boolean undo() {
        return true;
    }
}

