/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SnmpGeneralPane
extends NodeProvPane
implements ActionListener {
    public static final String USE_GENERIC_MIB = "Use Generic Mib";
    private JTextField engineIdTF;
    private JCheckBox useGenericMibCB;
    private boolean nameDirty;
    private boolean genereicMibDirty;
    private boolean hasProvPrivilege = false;
    private boolean isSecure = false;

    public SnmpGeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.SnmpGeneralPane;
    }

    private void init() {
        db.info("init: start");
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getPlatform().isSecureModeSupported()) {
            this.isSecure = nodeModelDelegate.isSecureMode();
        }
        this.hasProvPrivilege = nodeModelDelegate.isSecureMode() ? this.isUserAuthorized(SecurityLevel.SUPERUSER) : this.isUserAuthorized(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createGeneralPanel());
        this.registerWithModel();
        db.info("init: finish");
    }

    private JPanel createGeneralPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Common"));
        this.useGenericMibCB = new JCheckBox(USE_GENERIC_MIB);
        this.useGenericMibCB.addActionListener(this);
        if (this.pci.is454() || this.pci.is455()) {
            jPanel.add(this.useGenericMibCB);
            if (!this.canEdit()) {
                this.useGenericMibCB.setEnabled(false);
            }
        } else {
            jPanel.add(this.useGenericMibCB);
            this.useGenericMibCB.setSelected(false);
            this.useGenericMibCB.setEnabled(false);
        }
        return jPanel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(100, 20));
        return jLabel;
    }

    private JPanel createAttributePanel(String string, JComponent jComponent) {
        Dimension dimension = new Dimension(140, 40);
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = this.createLabel(string);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(2));
        jPanel.add(jPanel2);
        jPanel.add(jComponent);
        return jPanel;
    }

    private boolean canEdit() {
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (this.isSecure) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING);
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, boolean bl) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setPreferredSize(new Dimension(n, 20));
        jTextField.setMaximumSize(new Dimension(n, 20));
        jTextField.setMinimumSize(new Dimension(n, 20));
        jPanel.add(jTextField);
        jTextField.setEditable(false);
        return jTextField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source!");
            return;
        }
        if (object == this.useGenericMibCB) {
            this.genereicMibDirty = true;
        }
        this.setDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        db.info("applyChangesToModel: start");
        SnmpModel snmpModel = (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
        boolean bl = false;
        if (this.genereicMibDirty) {
            db.fine("applyChangesToModel: setting Generic mib");
            snmpModel.setGenericMib(this.useGenericMibCB.isSelected());
            this.genereicMibDirty = false;
        }
        if (!bl) {
            db.info("applyChangesToModel: set nothing!");
            this.refresh();
        }
        db.info("applyChangesToModel: finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
    }

    @Override
    public void refreshFromModel() throws Exception {
        db.info("refreshFromModel: start");
        try {
            SnmpModel snmpModel = (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
            if (snmpModel == null) {
                db.severe("Snmp Model is null in SnmpGeneralPane::refresh()");
                return;
            }
            if (this.pci.is454() || this.pci.is455()) {
                this.useGenericMibCB.setSelected(snmpModel.getGenericMib());
            }
        }
        catch (CmsCommFailException cmsCommFailException) {
            db.info("refreshFromModel: commfail exception");
            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
        }
        db.info("refreshFromModel: finish");
    }
}

