/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.SnmpV3SecurityLevel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.model.SnmpV3TrapDestination;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.snmp.SnmpV3TargetCreateDialog;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class SnmpV3TargetPane
extends AbstractShelfEditTablePane {
    public static final int TARGET_IP_IDX = 0;
    public static final int UDP_SCOKET_IDX = 1;
    public static final int SECURITY_NAME_IDX = 2;
    public static final int SECURITY_LEVEL_IDX = 3;
    public static final int PROFILE_NAME_IDX = 4;
    public static final int ONLY_PROXY_TRAP_CHECK_IDX = 5;
    public static final int PROXY_TAG_IDX = 6;
    SnmpModel snmpModel = this.getSnmpModel();

    public SnmpV3TargetPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    @Override
    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    @Override
    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new TargetIPColumnRenderer(), new UdpColumnRenderer(), new SecurityNameColumnRenderer(), new SecurityLevelColumnRenderer(), new ProfileNameColumnRenderer(), new ProxyTrapColumnRenderer(), new TagNameColumnRenderer()};
        UserTableRowSource userTableRowSource = new UserTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)userTableRowSource, columnRendererArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        } else if (this.getTable().getSelectedRowCount() == 1) {
            SnmpV3TrapDestination snmpV3TrapDestination = (SnmpV3TrapDestination)this.model.getValueAt(this.getTable().getSelectedRow(), 0);
            if (InetUtil.isIPv6Address(IpAddrFactory.getIIpAddr(snmpV3TrapDestination.targetAddress)) && !this.getUiModel().getNodeModel().getIpConfig().getNodeMode()) {
                WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateTableData() {
        if (this.canDisplay()) {
            List list = this.tableData;
            synchronized (list) {
                this.tableData = new ArrayList();
                try {
                    SnmpV3TrapDestination[] snmpV3TrapDestinationArray = this.snmpModel.getSnmpV3TrapDestination();
                    if (snmpV3TrapDestinationArray != null) {
                        for (int i = 0; i < snmpV3TrapDestinationArray.length; ++i) {
                            this.tableData.add(snmpV3TrapDestinationArray[i]);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    db.println("Error in getting SnmpV3 Trap Params: " + exception);
                }
            }
        }
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    public boolean isTargetExists(sIpAddr sIpAddr2, String string, SnmpV3SecurityLevel snmpV3SecurityLevel) {
        boolean bl = false;
        for (int i = 0; i < this.tableData.size(); ++i) {
            String string2;
            SnmpV3TrapDestination snmpV3TrapDestination = (SnmpV3TrapDestination)this.tableData.get(i);
            String string3 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(snmpV3TrapDestination.targetAddress));
            if (!string3.equals(string2 = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2))) || !snmpV3TrapDestination.userName.equals(string) || snmpV3TrapDestination.securityLevel != snmpV3SecurityLevel) continue;
            bl = true;
            return bl;
        }
        return bl;
    }

    @Override
    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    @Override
    protected void createTableEntry() {
        SnmpV3TargetCreateDialog snmpV3TargetCreateDialog = SnmpV3TargetCreateDialog.instance(this, this.getSnmpModel());
        snmpV3TargetCreateDialog.show();
        snmpV3TargetCreateDialog.dispose();
    }

    @Override
    protected void editSelectedTableEntry(int n) {
        SnmpV3TrapDestination snmpV3TrapDestination = (SnmpV3TrapDestination)this.model.getValueAt(n, 0);
        if (InetUtil.isIPv6Address(IpAddrFactory.getIIpAddr(snmpV3TrapDestination.targetAddress)) && !this.getUiModel().getNodeModel().getIpConfig().getNodeMode()) {
            return;
        }
        SnmpV3TargetCreateDialog snmpV3TargetCreateDialog = SnmpV3TargetCreateDialog.instance(this, this.getSnmpModel());
        if (snmpV3TrapDestination != null) {
            snmpV3TargetCreateDialog.setSelectedTrap(snmpV3TrapDestination);
        }
        snmpV3TargetCreateDialog.show();
        snmpV3TargetCreateDialog.dispose();
    }

    @Override
    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Do you really want to delete the selected Target" + (nArray.length > 1 ? "s?" : "?")), (String)"Delete Target")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        SnmpV3TrapDestination[] snmpV3TrapDestinationArray = new SnmpV3TrapDestination[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                snmpV3TrapDestinationArray[n2] = (SnmpV3TrapDestination)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            snmpV3TrapDestinationArray[n2] = null;
        }
        for (n2 = 0; n2 < snmpV3TrapDestinationArray.length; ++n2) {
            if (snmpV3TrapDestinationArray[n2] == null) continue;
            try {
                this.getSnmpModel().deleteSnmpV3TrapDestination(snmpV3TrapDestinationArray[n2].userName, snmpV3TrapDestinationArray[n2].securityLevel, snmpV3TrapDestinationArray[n2].targetAddress);
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SNMPV3_TARGET_ERROR);
            }
        }
    }

    @Override
    protected void registerWithModels() {
        if (this.snmpModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.snmpModel));
        }
    }

    @Override
    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public boolean canDisplay() {
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        boolean bl = false;
        if (nodeModelDelegate.getPlatform().isSecureModeSupported()) {
            bl = nodeModelDelegate.isSecureMode();
        }
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (bl) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING) || this.isUserAuthorized(SecurityLevel.MAINTENANCE) || this.isUserAuthorized(SecurityLevel.RETRIEVE);
    }

    public NodeModelDelegate getNMD() {
        return (NodeModelDelegate)this.getUiModel().getNodeModel();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.TargetFiltersConfigurationPane;
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 100;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(SnmpV3TrapDestination snmpV3TrapDestination, int n) {
            String string = "";
            switch (n) {
                case 0: {
                    IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(snmpV3TrapDestination.targetAddress);
                    string = InetUtil.makeDottedString(iIpAddr);
                    break;
                }
                case 1: {
                    int n2 = snmpV3TrapDestination.udpPort & 0xFFFF;
                    string = Integer.toString(n2);
                    break;
                }
                case 2: {
                    string = snmpV3TrapDestination.userName;
                    break;
                }
                case 3: {
                    string = SnmpV3Util.getSecurityLevel(snmpV3TrapDestination.securityLevel.value());
                    break;
                }
                case 4: {
                    string = snmpV3TrapDestination.filterProfile;
                    break;
                }
                case 6: {
                    String string2;
                    string = string2 = snmpV3TrapDestination.proxyTags;
                }
            }
            return " " + string;
        }

        protected String getMPMModel(int n) {
            switch (n) {
                case 1: {
                    return "V1";
                }
                case 2: {
                    return "V2";
                }
                case 3: {
                    return "V3";
                }
            }
            return "??";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SnmpV3TrapDestination snmpV3TrapDestination = (SnmpV3TrapDestination)jTable.getValueAt(n, 0);
            String string = this.getStringValue(snmpV3TrapDestination, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((SnmpV3TrapDestination)object, n);
            String string2 = this.getStringValue((SnmpV3TrapDestination)object2, n);
            return string.compareTo(string2);
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            SnmpV3TargetPane.this.resetObservableManager();
            SnmpV3TargetPane.this.registerWithModels();
            SnmpV3TargetPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            SnmpV3TargetPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SnmpV3TargetPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class ProfileNameColumnRenderer
    extends BaseColumnRenderer {
        ProfileNameColumnRenderer() {
        }

        public String getName() {
            return "Filter Profile Name";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    class ProxyTrapColumnRenderer
    extends BaseColumnRenderer {
        ProxyTrapColumnRenderer() {
        }

        public String getName() {
            return "Proxy Traps Only";
        }

        @Override
        public int getWidth() {
            return 200;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SnmpV3TrapDestination snmpV3TrapDestination = (SnmpV3TrapDestination)jTable.getValueAt(n, 0);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            if (snmpV3TrapDestination.proxyTrapsOnly.booleanValue()) {
                jCheckBox.setSelected(true);
            } else {
                jCheckBox.setSelected(false);
            }
            if (bl) {
                jCheckBox.setBackground(jTable.getSelectionBackground());
                jCheckBox.setForeground(jTable.getSelectionForeground());
            } else {
                jCheckBox.setBackground(jTable.getBackground());
                jCheckBox.setForeground(jTable.getForeground());
            }
            return jCheckBox;
        }
    }

    class SecurityLevelColumnRenderer
    extends BaseColumnRenderer {
        SecurityLevelColumnRenderer() {
        }

        public String getName() {
            return "Security Level";
        }

        @Override
        public int getWidth() {
            return 130;
        }
    }

    class SecurityNameColumnRenderer
    extends BaseColumnRenderer {
        SecurityNameColumnRenderer() {
        }

        public String getName() {
            return "User Name";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    class TagNameColumnRenderer
    extends BaseColumnRenderer {
        TagNameColumnRenderer() {
        }

        public String getName() {
            return "Proxy Tags";
        }

        @Override
        public int getWidth() {
            return 200;
        }
    }

    class TargetIPColumnRenderer
    extends BaseColumnRenderer {
        TargetIPColumnRenderer() {
        }

        public String getName() {
            return "Target Address";
        }
    }

    class UdpColumnRenderer
    extends BaseColumnRenderer {
        UdpColumnRenderer() {
        }

        public String getName() {
            return "UDP Port";
        }
    }

    class UserTableRowSource
    extends AbstractRowDataSource {
        UserTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = SnmpV3TargetPane.this.tableData;
            synchronized (list) {
                var2_2 = SnmpV3TargetPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = SnmpV3TargetPane.this.tableData;
            synchronized (list) {
                n = SnmpV3TargetPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = SnmpV3TargetPane.this.tableData;
            synchronized (list) {
                return SnmpV3TargetPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return SnmpV3TrapDestination.class;
        }
    }
}

