/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.SonetMedia.eBlsrExtensionByte;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmLineModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InService;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.InvalidSoakTime;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RollsOnPort;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.cms.model.vf.Version;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.AbstractHoNum;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;

public class TdmLineTableModel
extends TdmTableModel
implements IAdminTableAccess {
    protected static final int MEDIUM_TYPE_SONET = 0;
    protected static final int MEDIUM_TYPE_SDH = 1;
    protected static final Attribute[] sdhSonetAttrs = new Attribute[]{new Attribute("SONET", 1), new Attribute("SDH", 0)};
    static final Attribute[] blsrAttrs = new Attribute[]{new Attribute("K3", 0), new Attribute("Z2", 1), new Attribute("E2", 2), new Attribute("F1", 3)};
    public String[] columnNames;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] blsrExtByte;
    private sLineSyncConfig[] syncConfig;
    private Attribute[] qualityAttrs;
    private Integer[] stsMonitor;
    private Attribute[] lineBuildout;
    private Boolean[] receiveEqualization;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    private String sdString;
    private String sfString;
    protected Attribute[] mediaType;
    protected boolean[][] isDirty;
    protected int[] soakTime;
    protected Attribute[] alsMode;
    protected Attribute[] band;
    protected Attribute[] reach;
    protected Attribute[] wavelength;
    protected Attribute[] termmode;
    protected boolean isSonet;
    protected IOpticsProvExtModel[] opticModels;
    private boolean sonetTiming;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int PORTRATE_INDEX = 2;
    public static final int ADMIN_STATE_INDEX = 3;
    public static final int SERVICE_STATE_INDEX = 4;
    public static final int SFBERLEVEL_INDEX = 5;
    public static final int SDBERLEVEL_INDEX = 6;
    public static final int BLSREXT_INDEX = 7;
    public static final int USEDFORSYNC_INDEX = 8;
    public static final int PROVIDESSYNC_INDEX = 9;
    public static final int SYNCMESSAGEIN_INDEX = 10;
    public static final int ADMIN_SSM_INDEX = 11;
    public static final int SENDFFDONOTUSE_INDEX = 12;
    public static final int SENDDONOTUSE_INDEX = 13;
    public static final int STSMONITOR_INDEX = 14;
    public static final int LINEBUILDOUT_INDEX = 15;
    public static final int RXEQ_INDEX = 16;
    public static final int SOAK_TIME_INDEX = 17;
    public static final int SDH_INDEX = 18;
    public static final int SYNCSTATUSMSG_INDEX = 19;
    public static final int ALS_MODE_INDEX = 20;
    public static final int BAND_INDEX = 21;
    public static final int REACH_INDEX = 22;
    public static final int WAVELENGTH_INDEX = 23;
    public static final int TERMMODE_INDEX = 24;
    protected static final int TDM_COLUMN_NEXT_INDEX = 25;
    protected String[] portNums;
    protected String[] portNames;
    protected String[] portRates;
    private boolean FlgDlgAlreadyShowed = false;
    private static final SDebug db = new SDebug("TdmLineTableModel");

    public TdmLineTableModel(NodeModelDelegate nodeModelDelegate, TdmLineModel[] tdmLineModelArray) {
        super(nodeModelDelegate);
        this.model = tdmLineModelArray;
        String[] stringArray = new String[]{"Port", "Port Name", "Port Rate", "Admin State", "Service State", "SF BER", "SD BER", this.getTerms().getRingTerms(1) + " Ext. Byte", "UsedForSync", "ProvidesSync", "SyncMsgIn", "Admin SSM In", "Send <FF> DoNotUse", "Send DoNotUse", "PJ" + this.getTerms().getGeneralTerms(0) + "Mon#", "Line Length", "Rx Equalization", "AINS Soak", "Type", "SyncStatusMsg", "ALS Mode", "Band", "Reach", "Wavelength", "Termination mode"};
        this.columnNames = stringArray;
        this.init();
    }

    protected void init() {
        this.numLines = this.model.length;
        this.opticModels = OpticsProvExtModel.getModels(this.model);
        this.portNums = new String[this.numLines];
        this.portNames = new String[this.numLines];
        this.portRates = new String[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.blsrExtByte = new Attribute[this.numLines];
        this.syncConfig = new sLineSyncConfig[this.numLines];
        this.stsMonitor = new Integer[this.numLines];
        this.lineBuildout = new Attribute[this.numLines];
        this.receiveEqualization = new Boolean[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.mediaType = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        this.alsMode = new Attribute[this.numLines];
        this.reach = new Attribute[this.numLines];
        this.wavelength = new Attribute[this.numLines];
        this.termmode = new Attribute[this.numLines];
        this.band = new Attribute[this.numLines];
        this.soakTime = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
        }
        this.resetDirtyBits();
        this.isSonet = this.node.getTdmProtocolTypeObj().isSonet();
        this.sonetTiming = this.isSonetTiming();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return 25;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private Attribute getBand(int n) {
        if (this.band[n] == null) {
            Attribute attribute = null;
            try {
                this.band[n] = attribute = this.getAttributeMap().getAttributeForVal("Band", 0);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("TdmLineTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.band[n];
    }

    private Attribute getReach(int n) {
        if (this.reach[n] == null) {
            eReach eReach2 = null;
            Attribute attribute = null;
            try {
                eReach2 = this.opticModels[n].getLineReach();
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", eReach2.value());
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.reach[n] = attribute = this.getAttributeMap().getAttributeForVal("declDwdmReach", 0);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("TdmLineTableModel: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.reach[n];
    }

    protected Attribute getWavelength(int n) {
        if (this.wavelength[n] == null) {
            int n2;
            eWavelength eWavelength2;
            block8: {
                eWavelength2 = eWavelength.WV_UNKNOWN;
                try {
                    eWavelength2 = this.opticModels[n].getLineWavelength();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    if (db.on()) {
                        db.println("TdmLineTableModel: " + (Object)((Object)unsupportedOperation));
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("TdmLineTableModel: " + exception);
                    }
                    SDebug.printStackTrace((Throwable)exception);
                }
                n2 = 359;
                try {
                    n2 = this.model[n].getModuleModel().getEqType();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("TdmLineTableModel: " + (Object)((Object)abstractCmsNoSuchEntityException));
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.wavelength[n] = n2 == 251 ? this.getAttributeMap().getAttributeForVal("declDwdmCWl", eWavelength2.value()) : this.getAttributeMap().getAttributeForVal("declAllWavelength", eWavelength2.value());
        }
        return this.wavelength[n];
    }

    protected Attribute getTermMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.termmode[n] == null) {
            InterfaceModel interfaceModel = this.model[n].getHighestParent();
            int n2 = 0;
            n2 = ((AbstractDwdmLineModel)interfaceModel).getTermMode();
            this.termmode[n] = this.getAttributeMap().getAttributeForVal("declTermModeFullSet", n2);
        }
        return this.termmode[n];
    }

    private sLineSyncConfig getSyncConfig(int n) throws NoSuchInterface, UnsupportedOperation {
        if (this.syncConfig[n] == null) {
            this.syncConfig[n] = this.model[n].getSonetConfig();
        }
        return this.syncConfig[n];
    }

    private Boolean getProvidesSyncFromCard(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).providesSyncFromCard);
    }

    private Boolean getSyncMessageIn(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).syncMessageIn);
    }

    private Attribute getAdminSsm(int n) throws NoSuchInterface, UnsupportedOperation, AbstractCmsNoSuchEntityException {
        int n2 = this.getSyncConfig((int)n).adminSSM.value();
        if (db.on()) {
            db.println("TdmLineTableModel: getAdminSsm: val=" + n2);
        }
        if (this.sonetTiming) {
            SynchronizationModel synchronizationModel = ((PortModel)this.model[0].getPortModel()).getChassis().getSyncModel();
            if (synchronizationModel.isG1SsmGeneration()) {
                return this.getAttributeFor("timingSonetSsmQuality", n2);
            }
            return this.getAttributeFor("timingSonetG2SsmQuality", n2);
        }
        return this.getAttributeFor("timingSdhSsmQuality", n2);
    }

    private Boolean getSendDoNotUseFF(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUseFF);
    }

    private Attribute getLineBuildout(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineBuildout[n] == null) {
            int n2 = this.getRangeFor(Math.abs(this.model[n].getLineBuildout()));
            this.lineBuildout[n] = this.getLineBuildoutAttributeFor(n2);
        }
        return this.lineBuildout[n];
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.node.getTdmProtocolType(), this.getTerms());
    }

    private Attribute getLineBuildoutAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("EC1.SonetLineBuildout", n);
    }

    protected int getRangeFor(int n) {
        if (Ds123LineTableModel.between(225, 450, n)) {
            return 450;
        }
        return 225;
    }

    protected eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    private Boolean getSendDoNotUse(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUse);
    }

    private Integer getStsMonitor(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.stsMonitor[n] == null) {
            if (!this.isSonet) {
                short s = this.model[n].getPointerMonitorStsNumber();
                this.stsMonitor[n] = new Integer(AbstractHoNum.StsNum2Vc4((int)s));
            } else {
                this.stsMonitor[n] = new Integer(this.unsignedShortToInt(this.model[n].getPointerMonitorStsNumber()));
            }
        }
        return this.stsMonitor[n];
    }

    private int getSfBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSfBerLevelIndex(n).getIntValue();
    }

    private int getSdBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSdBerLevelIndex(n).getIntValue();
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this.model != null && this.numLines > 0 && n2 != 4) {
            if (n2 == 19) {
                bl = true;
            } else {
                ModuleModel moduleModel;
                block28: {
                    moduleModel = null;
                    try {
                        moduleModel = this.model[0].getModuleModel();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.println("Caught exception in isCellEditable");
                        if (!db.on()) break block28;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && moduleModel != null && !moduleModel.isProtectModule()) {
                    switch (n2) {
                        case 16: {
                            bl = moduleModel.supportsRxEqualization();
                            break;
                        }
                        case 18: {
                            boolean bl2 = false;
                            try {
                                bl2 = moduleModel.getEqType() == 273 && this.model[n].getPortModel().getEqType() == 61;
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                // empty catch block
                            }
                            bl = this.isSonet && moduleModel.allowsMediumTypeProvisioning() && !bl2;
                            break;
                        }
                        case 13: {
                            bl = (!this.isSonet || this.getValueAt(n, 18) == sdhSonetAttrs[0]) && !this.isProtectedInOnePlusOneProtectionGroup(this.model[n]);
                            break;
                        }
                        case 12: {
                            bl = !this.isSonet || this.getValueAt(n, 18) == sdhSonetAttrs[0];
                            break;
                        }
                        case 10: {
                            if (this.isProtectedInOnePlusOneProtectionGroup(this.model[n])) {
                                bl = false;
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 11: {
                            bl = (Boolean)this.getValueAt(n, 10) == false;
                            break;
                        }
                        case 7: {
                            try {
                                int n3 = this.model[n].getPortModel().getEqType();
                                return n3 == 30 || n3 == 61;
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                db.println("Caught exc. in isCellEditable!");
                                if (!db.on()) break;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                                break;
                            }
                        }
                        case 23: {
                            if (moduleModel.getEqType() == 251) {
                                try {
                                    bl = !AdminState.isFormOfIS(this.getAdminState(n).getAdminStateEnum());
                                }
                                catch (NoSuchInterface noSuchInterface) {
                                    db.println("Caught NoSuchInterface in isCellEditable");
                                    if (!db.on()) break;
                                    SDebug.printStackTrace((Throwable)noSuchInterface);
                                }
                                break;
                            }
                            bl = true;
                            break;
                        }
                        case 24: {
                            try {
                                IPortModel iPortModel;
                                InterfaceModel interfaceModel;
                                if (this.model[n] instanceof TdmLineModel && (interfaceModel = this.model[n].getHighestParent()) instanceof IDwdmLineModel && (iPortModel = interfaceModel.getPortModel()) instanceof IDwdmPortModel && ((IDwdmPortModel)iPortModel).isClientPort()) {
                                    int n4 = this.model[n].getPortModel().getEqType();
                                    return n4 == 61 || n4 == 302;
                                }
                                return false;
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                db.println("Caught exc. in isCellEditable!");
                                if (!db.on()) break;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                                break;
                            }
                        }
                        default: {
                            bl = n2 > 0 && n2 != 9;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public boolean isAdminStateDirty(int n) {
        return this.isDirty[n][3];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount()) {
            if (db.on()) {
                db.println("Array index out of bounds in getValueAt");
            }
            return null;
        }
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getPortRate(n);
                }
                case 3: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 4: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 5: {
                    return this.getSfBerLevelIndex(n);
                }
                case 6: {
                    return this.getSdBerLevelIndex(n);
                }
                case 7: {
                    Object object = "N/A";
                    if (this.model[n].getPortModel().getEqType() != 28) {
                        object = this.getBlsrExtByte(n);
                    }
                    return object;
                }
                case 9: {
                    return this.getProvidesSyncFromCard(n);
                }
                case 10: {
                    return this.getSyncMessageIn(n);
                }
                case 11: {
                    return this.getAdminSsm(n);
                }
                case 12: {
                    return this.getSendDoNotUseFF(n);
                }
                case 13: {
                    return this.getSendDoNotUse(n);
                }
                case 14: {
                    return this.getStsMonitor(n);
                }
                case 15: {
                    return this.getLineBuildout(n);
                }
                case 16: {
                    return this.getRxEq(n);
                }
                case 17: {
                    return this.getSoakTimeAsHHMM(n);
                }
                case 18: {
                    return this.getMediaType(n);
                }
                case 19: {
                    return this.model[n].getCurrentQuality();
                }
                case 20: {
                    return this.getAlsMode(n);
                }
                case 21: {
                    return this.getBand(n);
                }
                case 22: {
                    return this.getReach(n);
                }
                case 23: {
                    return this.getWavelength(n);
                }
                case 24: {
                    return this.getTermMode(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    protected String getPortNum(int n) {
        block3: {
            if (this.portNums[n] == null) {
                try {
                    this.portNums[n] = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)false, (boolean)true);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught NoSuchEntity in getPortNum!");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return this.portNums[n];
    }

    protected String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    protected String getPortRate(int n) {
        block3: {
            if (this.portRates[n] == null) {
                try {
                    this.portRates[n] = PortHelper.getPortTypeString((IEntityModel)this.model[n].getPortModel());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught NoSuchEntity in getPortRate");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return this.portRates[n];
    }

    private Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, this.model[n].getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    private Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, this.model[n].getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    public Boolean getRxEq(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.receiveEqualization[n] == null) {
            int n2 = this.model[n].getLineBuildout();
            if (db.on()) {
                db.println("model[" + n + "].lineBuildout = " + n2);
            }
            this.receiveEqualization[n] = new Boolean(n2 >= 0);
        }
        return this.receiveEqualization[n];
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        return this.model[n].getAdminStateEnum();
    }

    protected sServiceState getServiceStateFromModel(int n) throws NoSuchInterface {
        return this.model[n].getServiceState();
    }

    @Override
    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.getAdminStateFromModel(n);
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.getServiceStateFromModel(n);
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private String getSoakTimeAsHHMM(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    private void refreshMediaType(int n) throws WrongInterfaceType, NoSuchInterface {
        this.mediaType[n] = null;
        this.getMediaType(n);
        this.isDirty[n][18] = false;
        this.fireTableCellUpdated(n, 18);
    }

    public Attribute getMediaType(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.mediaType[n] == null) {
            int n2 = this.model[n].getLineInfoMediumType();
            this.mediaType[n] = !this.isSonet ? sdhSonetAttrs[1] : (sdhSonetAttrs[1].getIntValue() == n2 ? sdhSonetAttrs[1] : sdhSonetAttrs[0]);
        }
        return this.mediaType[n];
    }

    public Attribute getBlsrExtByte(int n) {
        if (this.blsrExtByte[n] == null) {
            try {
                int n2 = this.model[n].getBlsrByte();
                this.blsrExtByte[n] = blsrAttrs[n2];
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in getBlsrExtByte");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                return blsrAttrs[0];
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Caught WrongInterfaceType in getBlsrExtByte");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                return blsrAttrs[0];
            }
            catch (UnsupportedOperation unsupportedOperation) {
                db.println("Caught UnsupportedOperation in getBlsrExtByte");
                if (db.on()) {
                    db.println("getBlsrByte() was called on a card that does not support BLSR.");
                    SDebug.printStackTrace((Throwable)unsupportedOperation);
                }
                this.blsrExtByte[n] = blsrAttrs[0];
            }
        }
        return this.blsrExtByte[n];
    }

    protected Attribute getAlsMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.alsMode[n] == null) {
            this.alsMode[n] = this.getAttributeFor("AlsMode", this.model[n].getALSMode());
        }
        return this.alsMode[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 3: {
                    if (((AdminState)object).equals(this.adminState[n])) {
                        return;
                    }
                    this.adminState[n] = (AdminState)object;
                    break;
                }
                case 5: {
                    if (!this.sdSfBerLevelPJHoMonSanityCheck(n)) {
                        return;
                    }
                    this.sfBerLevel[n] = (Attribute)object;
                    break;
                }
                case 6: {
                    if (!this.sdSfBerLevelPJHoMonSanityCheck(n)) {
                        return;
                    }
                    this.sdBerLevel[n] = (Attribute)object;
                    break;
                }
                case 7: {
                    if (!this.blsrTypeSanityCheck(n, (Attribute)object)) {
                        return;
                    }
                    this.blsrExtByte[n] = (Attribute)object;
                    break;
                }
                case 16: {
                    Boolean bl = (Boolean)object;
                    if (bl.equals(this.receiveEqualization[n])) {
                        return;
                    }
                    db.fine("setting RxEq to " + bl);
                    this.receiveEqualization[n] = bl;
                    break;
                }
                case 17: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                case 18: {
                    Attribute attribute = (Attribute)object;
                    if (attribute.equals(this.mediaType[n])) {
                        return;
                    }
                    this.mediaType[n] = attribute;
                    if (this.isSonet && attribute == sdhSonetAttrs[1]) {
                        this.setValueAt(Boolean.FALSE, n, 10);
                    }
                    break;
                }
                case 10: {
                    Boolean bl = (Boolean)object;
                    if (bl == this.syncConfig[n].syncMessageIn) {
                        return;
                    }
                    if (!this.syncMsgInSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].syncMessageIn = bl;
                    break;
                }
                case 11: {
                    int n4 = 0;
                    try {
                        n4 = ((Attribute)object).getIntValue();
                    }
                    catch (NullPointerException nullPointerException) {
                        db.println("Null value in TdmLineTableModel");
                        return;
                    }
                    if (n4 == this.syncConfig[n].adminSSM.value()) {
                        return;
                    }
                    if (!this.syncMsgInSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].adminSSM = eQualityLevel.from_int(n4);
                    break;
                }
                case 12: {
                    Boolean bl = (Boolean)object;
                    if (bl == this.syncConfig[n].sendDoNotUseFF) {
                        return;
                    }
                    if (!this.syncMsgInSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].sendDoNotUseFF = bl;
                    if (bl.booleanValue()) {
                        this.setValueAt(Boolean.FALSE, n, 13);
                    }
                    break;
                }
                case 13: {
                    Boolean bl = (Boolean)object;
                    if (bl == this.syncConfig[n].sendDoNotUse) {
                        return;
                    }
                    if (!this.sendDoNotUseSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].sendDoNotUse = bl;
                    if (bl.booleanValue()) {
                        this.setValueAt(Boolean.FALSE, n, 12);
                    }
                    break;
                }
                case 14: {
                    if (!this.sdSfBerLevelPJHoMonSanityCheck(n)) {
                        return;
                    }
                    this.stsMonitor[n] = (Integer)object;
                    break;
                }
                case 15: {
                    this.lineBuildout[n] = (Attribute)object;
                    break;
                }
                case 20: {
                    Attribute attribute = (Attribute)object;
                    if (!this.model[n].supportsAutoALS() && eALSMode.from_int(attribute.getIntValue()) == eALSMode.AUTO) {
                        ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_AUTO_RESTART_NOT_SUPPORTED);
                        return;
                    }
                    if (attribute == this.alsMode[n]) {
                        return;
                    }
                    this.alsMode[n] = attribute;
                    break;
                }
                case 21: {
                    this.band[n] = (Attribute)object;
                    break;
                }
                case 22: {
                    if (this.reach[n] == (Attribute)object) {
                        return;
                    }
                    this.reach[n] = (Attribute)object;
                    break;
                }
                case 23: {
                    if (this.wavelength[n] == (Attribute)object) {
                        return;
                    }
                    this.wavelength[n] = (Attribute)object;
                    break;
                }
                case 24: {
                    if (this.termmode[n] == (Attribute)object) {
                        return;
                    }
                    this.termmode[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in setValueAt");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private boolean sendDoNotUseSanityCheck(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer();
            InterfaceModel interfaceModel = this.model[n].getHighestParent();
            ElementModel elementModel = null;
            bl3 = false;
            bl2 = false;
            try {
                elementModel = interfaceModel.getElementModel();
                bl3 = elementModel instanceof OnePlusOneModel && elementModel.getProtectEntityIndex() == interfaceModel.getIndex();
                bl2 = elementModel instanceof YCableModel && elementModel.getProtectEntityIndex() == interfaceModel.getIndex();
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                db.println("Caught NoSuchElement in sendDoNotUseSanityCheck");
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (bl3) {
            stringBuffer.append("- The port is the protect port in a 1+1 protection group.\n");
        } else if (bl2) {
            stringBuffer.append("- The port is the protect port in a Y-cable protection group.\n");
        }
        boolean bl4 = this.model[n].isBlsrProtectLine();
        if (bl4) {
            stringBuffer.append("- The port is the protect port of a four-fiber " + this.getTerms().getRingTerms(1) + ".");
        }
        boolean bl5 = bl = !bl3 && !bl2 && !bl4;
        if (!bl) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_SEND_DO_NOT_USE_REQ, stringBuffer.toString());
        }
        return bl;
    }

    private boolean syncMsgInSanityCheck(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer();
            stringBuffer.append("The SyncMsg attribute cannot be modified because:\n");
            InterfaceModel interfaceModel = this.model[n].getHighestParent();
            ElementModel elementModel = null;
            bl3 = false;
            bl2 = false;
            try {
                elementModel = interfaceModel.getElementModel();
                bl3 = elementModel instanceof OnePlusOneModel && elementModel.getProtectEntityIndex() == interfaceModel.getIndex();
                bl2 = elementModel instanceof YCableModel && elementModel.getProtectEntityIndex() == interfaceModel.getIndex();
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                db.println("Caught NoSuchElement in syncMsgInSanityCheck");
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (bl3) {
            stringBuffer.append("- The port is the protect port in a 1+1 protection group.\n");
        } else if (bl2) {
            stringBuffer.append("- The port is the protect port in a Y-cable protection group.\n");
        }
        boolean bl4 = this.model[n].isBlsrProtectLine();
        if (bl4) {
            stringBuffer.append("- The port is the protect port of a four-fiber " + this.getTerms().getRingTerms(1) + ".");
        }
        boolean bl5 = bl = !bl3 && !bl2 && !bl4;
        if (!bl) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_ENABLE_SYNC_MSG_REQ, stringBuffer.toString());
        }
        return bl;
    }

    private boolean sdSfBerLevelPJHoMonSanityCheck(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer();
            bl3 = this.model[n].isProtectLine();
            InterfaceModel interfaceModel = this.model[n].getHighestParent();
            ElementModel elementModel = null;
            bl2 = false;
            bl = true;
            try {
                elementModel = interfaceModel.getElementModel();
                if (elementModel instanceof OnePlusOneModel && ((OnePlusOneModel)elementModel).getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_OPTIMIZED) {
                    bl2 = true;
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                db.println("Caught NoSuchElement in sdSfBerLevelPJHoMonSanityCheck");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (bl3) {
            stringBuffer.append("The SD/SF BER level or PJHOMON# cannot be modified because:\n");
            if (bl2) {
                stringBuffer.append("- The port is the protect port in an optimized 1+1 protection group.\n");
            } else {
                stringBuffer.append("- The port is the protect port in a 1+1 protection group.\n");
            }
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_BER_NOT_APPLICABLE_ON_PROTECT_LINE, stringBuffer.toString());
            return !bl;
        }
        return bl;
    }

    private boolean portIsIS(int n) throws AnnotatedException, WrongInterfaceType {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.model[n].getAdminState() == 0 || this.model[n].getAdminState() == 3) {
                    bl = true;
                    this.refreshMediaType(n);
                    throw new AnnotatedException("The port is in service.", new Exception());
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in portIsIS");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return bl;
    }

    private void portTypeSanityCheck(int n) throws AnnotatedException, NoSuchInterface, WrongInterfaceType {
        StringBuffer stringBuffer;
        boolean bl;
        block14: {
            bl = true;
            stringBuffer = new StringBuffer();
            try {
                if (!this.isSdh(n) && this.getSendDoNotUse(n).booleanValue()) {
                    bl = false;
                    stringBuffer.append("- Send DoNotUse is checked\n");
                }
                if (!this.isSdh(n) && this.getSendDoNotUseFF(n).booleanValue()) {
                    bl = false;
                    stringBuffer.append("- Send <FF> DoNotUse is checked\n");
                }
                if (!this.isSdh(n) && this.getSyncMessageIn(n).booleanValue()) {
                    bl = false;
                    stringBuffer.append("- SyncMsgIn is checked\n");
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in portTypeSanityCheck");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            catch (UnsupportedOperation unsupportedOperation) {
                db.println("Caught UnsupportedOperation in portTypeSanityCheck");
                if (!db.on()) break block14;
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        if (this.isCircuitPresent(this.model[n])) {
            bl = false;
            stringBuffer.append("- There are circuits using this port.\n");
        }
        if (this.isOhCircuitPresent(this.model[n])) {
            bl = false;
            stringBuffer.append("- There are overhead circuits on this port.\n");
        }
        if (this.isInOnePlusOneProtectionGroup(this.model[n])) {
            bl = false;
            stringBuffer.append("- The port is part of a 1+1 protection group.\n");
        }
        if (this.isInBlsr(this.model[n])) {
            bl = false;
            stringBuffer.append("- The port is part of a(n) " + this.getTerms().getRingTerms(1) + ".\n");
        }
        if (!this.isSdh(n) && this.isSdccPresent(this.model[n])) {
            bl = false;
            String string = this.getTerms().getGeneralTerms(8);
            stringBuffer.append("- A(n)" + string + " termination exists on this port\n");
        }
        if (!this.isSdh(n) && this.getBlsrExtByte(n) != blsrAttrs[0]) {
            bl = false;
            stringBuffer.append("- " + this.getTerms().getRingTerms(1) + " is not using the K3 (default) byte.\n");
        }
        if (!bl) {
            this.refreshMediaType(n);
            throw new AnnotatedException(stringBuffer.toString(), new Exception());
        }
    }

    private boolean blsrTypeSanityCheck(int n, Attribute attribute) {
        StringBuffer stringBuffer;
        boolean bl;
        block10: {
            bl = true;
            stringBuffer = new StringBuffer();
            stringBuffer.append("The " + this.getTerms().getRingTerms(1) + " extension byte cannot be modified because:\n");
            try {
                if (this.isSonet && this.getMediaType(n) == sdhSonetAttrs[1]) {
                    stringBuffer.append("- The port type is SDH.\n");
                    bl = false;
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Caught WrongInterfaceType in blsrTypeSanityCheck");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in blsrTypeSanityCheck");
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        int n2 = attribute.getValue();
        OhChannelType ohChannelType = OhChannelType.getOhChannelTypeForBlsrExtByte((int)n2);
        if (ohChannelType != null) {
            if (this.isOhCircuitPresent(this.model[n], ohChannelType)) {
                stringBuffer.append("- An overhead channel is using the " + blsrAttrs[n2].getKey() + " byte.\n");
                bl = false;
            } else {
                TdmLineModel tdmLineModel = this.getPeerLineModel(this.model[n]);
                if (tdmLineModel != null && this.isOhCircuitPresent(tdmLineModel, ohChannelType)) {
                    stringBuffer.append("- An overhead channel is using the " + blsrAttrs[n2].getKey() + " byte " + "on the working port.\n");
                    bl = false;
                }
            }
        }
        if (!bl) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_EXTENSION_BYTE_MOD_PARAM_1, this.getTerms().getRingTerms(1), stringBuffer.toString());
        }
        return bl;
    }

    private TdmLineModel getPeerLineModel(TdmLineModel tdmLineModel) {
        IEntityModel iEntityModel;
        block16: {
            ElementModel elementModel = null;
            try {
                elementModel = tdmLineModel.getElementModel();
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                return null;
            }
            TdmPortModel tdmPortModel = null;
            try {
                tdmPortModel = (TdmPortModel)tdmLineModel.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in getPeerLineModel");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return null;
            }
            iEntityModel = null;
            try {
                switch (elementModel.getType()) {
                    case 1: {
                        OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                        if (tdmPortModel.equals(onePlusOneModel.getMainEntityModel())) {
                            iEntityModel = onePlusOneModel.getProtectEntityModel();
                            break;
                        }
                        iEntityModel = onePlusOneModel.getMainEntityModel();
                        break;
                    }
                    case 3: {
                        BlsrModel blsrModel = (BlsrModel)elementModel;
                        if (tdmPortModel.equals(blsrModel.getEastEntityModel())) {
                            iEntityModel = blsrModel.getEastProtectEntityModel();
                            break;
                        }
                        if (tdmPortModel.equals(blsrModel.getEastProtectEntityModel())) {
                            iEntityModel = blsrModel.getEastEntityModel();
                            break;
                        }
                        if (tdmPortModel.equals(blsrModel.getWestEntityModel())) {
                            iEntityModel = blsrModel.getWestProtectEntityModel();
                            break;
                        }
                        if (!tdmPortModel.equals(blsrModel.getWestProtectEntityModel())) break;
                        iEntityModel = blsrModel.getWestEntityModel();
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in getPeerLineModel");
                if (!db.on()) break block16;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (iEntityModel == null) {
            return null;
        }
        return ((TdmPortModel)iEntityModel).getTdmLineModel();
    }

    private boolean isCircuitPresent(TdmLineModel tdmLineModel) {
        return !tdmLineModel.getConnectionsList().isEmpty();
    }

    private boolean isOhCircuitPresent(TdmLineModel tdmLineModel) {
        return tdmLineModel.getOhConnectionsList().size() > 0;
    }

    private boolean isOhCircuitPresent(TdmLineModel tdmLineModel, OhChannelType ohChannelType) {
        return tdmLineModel.isOhCircuitPresent(ohChannelType);
    }

    private boolean isSdccPresent(TdmLineModel tdmLineModel) {
        boolean bl;
        block5: {
            bl = false;
            try {
                IPortModel iPortModel = tdmLineModel.getPortModel();
                if (iPortModel instanceof TdmPortModel) {
                    bl = ((TdmPortModel)iPortModel).isSonetDccTermination();
                } else if (iPortModel instanceof DwdmPortModel) {
                    bl = ((DwdmPortModel)iPortModel).isSonetDccTermination();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught NoSuchEntity in isSdccPresent");
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return bl;
    }

    private boolean isInBlsr(TdmLineModel tdmLineModel) {
        boolean bl;
        block2: {
            bl = false;
            try {
                ElementModel elementModel = tdmLineModel.getElementModel();
                bl = elementModel instanceof BlsrModel;
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                db.println("Caught NoSuchElement in isInBlsr");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return bl;
    }

    private boolean isInOnePlusOneProtectionGroup(TdmLineModel tdmLineModel) {
        ElementModel elementModel;
        boolean bl = tdmLineModel.isProtectLine();
        try {
            elementModel = tdmLineModel.getElementModel();
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            db.println("Caught NoSuchElement in isInOnePlusOne...");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return false;
        }
        boolean bl2 = false;
        bl2 = elementModel instanceof OnePlusOneModel;
        return bl || bl2;
    }

    private boolean isProtectedInOnePlusOneProtectionGroup(TdmLineModel tdmLineModel) {
        ElementModel elementModel;
        boolean bl = tdmLineModel.isProtectLine();
        try {
            elementModel = tdmLineModel.getElementModel();
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            db.println("Caught NoSuchElement in isInOnePlusOne...");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return false;
        }
        boolean bl2 = false;
        bl2 = elementModel instanceof OnePlusOneModel;
        return bl && bl2;
    }

    protected boolean isSdh(int n) {
        boolean bl;
        block4: {
            bl = false;
            try {
                bl = this.getMediaType(n) == sdhSonetAttrs[1];
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Caught WrongInterfaceType in isSdh");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Caught NoSuchInterface in isSdh");
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return bl;
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal(string, n);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.FlgDlgAlreadyShowed = false;
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNums[n] = null;
        this.portNames[n] = null;
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        this.blsrExtByte[n] = null;
        this.syncConfig[n] = null;
        this.receiveEqualization[n] = null;
        this.stsMonitor[n] = null;
        this.lineBuildout[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.soakTime[n] = -1;
        this.mediaType[n] = null;
        this.alsMode[n] = null;
        this.reach[n] = null;
        this.wavelength[n] = null;
        this.termmode[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected boolean mediaChanged() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.isDirty[i][3] || !this.isDirty[i][18] || !AdminState.warnOnMediaChange(this.getAdminStateFor(i))) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws InvalidLoopbackProvision, InvalidSoakTime, InService, NoSuchInterface, WrongInterfaceType, SyncProvBusy, UnsupportedOperation, ConfigError, SyncProvError, AnnotatedException, LoopbackActive, InvalidState, InvalidQuality, RollsOnPort, ProvisionError, DetailedConfigError {
        boolean bl = false;
        for (int i = 0; i < this.numLines; ++i) {
            Attribute attribute;
            eWavelength eWavelength2;
            Attribute attribute2;
            eReach eReach2;
            Object object;
            int n;
            if (this.isDirty(i, 1)) {
                this.model[i].setAlias(this.getPortName(i));
            }
            try {
                if (this.isDirty(i, 5)) {
                    this.model[i].setSfBerLevel((short)this.getSfBerLevel(i));
                }
                if (this.isDirty(i, 6)) {
                    this.model[i].setSdBerLevel((short)this.getSdBerLevel(i));
                }
            }
            catch (ConfigError configError) {
                throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_BER_NOT_APPLICABLE_ON_PROTECT_LINE), (Exception)((Object)configError));
            }
            catch (EMCProvisionError eMCProvisionError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
            }
            if (this.isDirty(i, 14)) {
                if (db.on()) {
                    db.println("Setting STS Monitor ");
                }
                if (!this.isSonet) {
                    short s = (short)AbstractHoNum.Vc4Num2Sts((int)this.getStsMonitor(i));
                    this.model[i].setLinePointerMonitorStsNumber(s);
                } else {
                    this.model[i].setLinePointerMonitorStsNumber(this.getStsMonitor(i).shortValue());
                }
            }
            if (this.isDirty(i, 15) || this.isDirty(i, 16)) {
                int n2 = this.getLineBuildout(i).getIntValue();
                if (!this.getRxEq(i).booleanValue()) {
                    n2 = -n2;
                }
                if (db.on()) {
                    db.println("Setting line buildout for " + i + " to " + n2);
                }
                this.model[i].setLineBuildout(n2);
            }
            if (this.isDirty(i, 17)) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.getSoakTime(i));
                }
                this.model[i].setSoakTime(this.getSoakTime(i));
            }
            if (this.isDirty(i, 3)) {
                boolean bl2;
                eAdminState eAdminState2;
                block42: {
                    if (db.on()) {
                        db.fine("setting line to admin state " + this.getTerms().getTermForAdminState(this.getAdminStateFor(i).value()));
                    }
                    eAdminState2 = null;
                    n = 0;
                    bl2 = true;
                    try {
                        eAdminState2 = this.getAdminStateFor(i);
                        n = !this.model[i].getConnectionsList().isEmpty() ? 1 : 0;
                        bl2 = this.model[i].getNodeModelDelegate().getNeDefaultsModel().getForceToOosDsbldStateChange();
                        if (db.on()) {
                            db.fine("Admin=" + eAdminState2.value() + "\tHas ckt=" + (n != 0) + "\tDisableAllowed=" + bl2);
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block42;
                        db.println("Failed to getForceToOosDsbldStateChange()");
                    }
                }
                if (eAdminState2 == eAdminState.ADMIN_OOS_DSBLD && n != 0 && !bl2) {
                    object = this.getTerms().getTermForAdminState(this.getAdminStateFor(i).value());
                    ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_ADMIN_STATE_CANNOT_BE_APPLIED, "You cannot change the port state to " + (String)object + " if the NODE.general.AllowServiceAffectingPortChangeToDisabled NE default is set to FALSE and a circuit exists on the port.");
                } else {
                    this.model[i].setAdminStateNoLpbk(eAdminState2);
                }
            }
            if (this.isDirty(i, 18)) {
                try {
                    this.portIsIS(i);
                    this.portTypeSanityCheck(i);
                    if (this.getMediaType(i).getIntValue() == 0) {
                        sLineSyncConfig sLineSyncConfig2 = this.getSyncConfig(i);
                        sLineSyncConfig2.syncMessageIn = false;
                        this.model[i].setSonetConfig(sLineSyncConfig2);
                        if (this.isDirty(i, 10) || this.isDirty(i, 11) || this.isDirty(i, 12) || this.isDirty(i, 13)) {
                            this.model[i].setSonetConfig(this.getSyncConfig(i));
                            this.isDirty[i][10] = false;
                            this.isDirty[i][11] = false;
                            this.isDirty[i][12] = false;
                            this.isDirty[i][13] = false;
                        }
                    }
                    this.model[i].setLineInfoMediumType((short)this.getMediaType(i).getIntValue());
                }
                catch (Exception exception) {
                    db.println("Caught exception in applyToModel");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    n = 359;
                    try {
                        n = this.model[i].getPortModel().getModuleModel().getEqType();
                    }
                    catch (Exception exception2) {
                        SDebug.printStackTrace((Throwable)exception2);
                    }
                    String string = "This port's type cannot be changed because the SDH validation check failed.\n\nCheck to see if the port or its peer ports, if any, are:\n - In the " + AdminState.getAdminTermIS(this.getTerms()) + " or " + AdminState.getAdminTermAINS(this.getTerms()) + " states\n";
                    string = n == 121 || n == 118 || n == 120 || n == 119 ? string + " - Part of a protection group, SONET DCC, or orderwire\n" : string + " - Part of a VT, STS circuit, protection group, SONET DCC, or orderwire\n" + this.getBlsrString();
                    string = string + " - Client/trunk provisioned with an active trace\n";
                    throw new AnnotatedException(string, exception);
                }
            }
            if (this.isDirty(i, 7)) {
                boolean bl3 = this.isInOnePlusOneProtectionGroup(this.model[i]);
                if (bl3) {
                    throw new ConfigError("The BLSR extension byte cannot be edited for aport in a 1+1 protection group.");
                }
                n = this.isInBlsr(this.model[i]) ? 1 : 0;
                String string = this.getTerms().getRingTerms(1);
                if (n == 0 || CerentDialog.yesNoDialog((Component)this.getFrame(), (String)("Changing the " + string + " extension byte can impact " + string + " switching.\n" + string + " switching will not function correctly if the two endpoints\n" + "are provisioned to use different extension bytes.\n\n" + "Is OK to continue?"), (String)"Confirmation Dialog")) {
                    object = this.getBlsrExtByte(i);
                    this.model[i].setBlsrByte(eBlsrExtensionByte.from_int(((Attribute)object).getValue()));
                }
            }
            if (this.isDirty(i, 10) || this.isDirty(i, 11) || this.isDirty(i, 12) || this.isDirty(i, 13)) {
                try {
                    this.model[i].setSonetConfig(this.getSyncConfig(i));
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    throw new UnsupportedOperation("Timing parameters cannot be changed on the protect port.");
                }
            }
            if (this.isDirty(i, 20)) {
                if (this.isSplitterProtectedLine(i)) {
                    if (this.alsMode[i].getIntValue() != 0 && !this.FlgDlgAlreadyShowed) {
                        ErrorMsg.displayWarning(null, (WID)EMC.WID_ALS_WONT_ENGAGE);
                    }
                    this.FlgDlgAlreadyShowed = true;
                }
                this.model[i].setALSMode(this.getAlsMode(i).getIntValue());
            }
            if (this.isDirty(i, 22) && (eReach2 = eReach.from_int((attribute2 = this.getReach(i)).getValue())).value() != 0) {
                this.opticModels[i].setLineReach(eReach2);
            }
            if (this.isDirty(i, 23) && (eWavelength2 = eWavelength.from_int((attribute = this.getWavelength(i)).getValue())).value() != 174) {
                this.opticModels[i].setLineWavelength(eWavelength2);
            }
            if (!this.isDirty(i, 24)) continue;
            Attribute attribute3 = this.getTermMode(i);
            InterfaceModel interfaceModel = this.model[i].getHighestParent();
            ((AbstractDwdmLineModel)interfaceModel).setTermMode(attribute3.getValue());
        }
        this.resetDirtyBits();
    }

    protected String getBlsrString() {
        Version version = this.node.getVersionedFeature(Feature.BLSR_2F_VERSIONING).getVersion();
        Version version2 = this.node.getVersionedFeature(Feature.BLSR_4F_VERSIONING).getVersion();
        if (version == Version.NIL && version2 == Version.NIL) {
            return " ";
        }
        return " - The BLSR extension byte is not K3.\n";
    }

    protected boolean isSplitterProtectedLine(int n) {
        return false;
    }

    public Attribute[] getQualityAttributes() throws AbstractCmsNoSuchEntityException {
        SynchronizationModel synchronizationModel;
        this.qualityAttrs = this.sonetTiming ? ((synchronizationModel = ((NodeModelDelegate)this.node).getNcChassis().getSyncModel()).isG1SsmGeneration() ? this.getAttributeMap().getAttributeArray("timingSonetSsmQuality") : this.getAttributeMap().getAttributeArray("timingSonetG2SsmQuality")) : this.getAttributeMap().getAttributeArray("timingSdhSsmQuality");
        return this.qualityAttrs;
    }

    private boolean isSonetTiming() {
        return ((NodeModelDelegate)this.node).getNcChassis().getSyncModel().isSonetTimingStandard();
    }

    public boolean timingStandardChanged() {
        boolean bl = false;
        if (this.sonetTiming != this.isSonetTiming()) {
            this.sonetTiming = this.isSonetTiming();
            bl = true;
        } else {
            bl = false;
        }
        if (db.on()) {
            db.println("changed=" + bl + "  current sonetTiming=" + this.sonetTiming);
        }
        return bl;
    }

    public void resetSyncConfig() {
        if (db.on()) {
            db.println("resetSyncConfig");
        }
        this.syncConfig = new sLineSyncConfig[this.numLines];
    }
}

