/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TNCModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.TreeMap;

public abstract class AbstractTNCCardTabbedView
extends PluggableCardTabbedView {
    protected ArrayList ocnLinesList;
    protected ArrayList etherLinesList;
    protected ArrayList gigEs;

    public AbstractTNCCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    @Override
    protected void init() {
        super.init();
        TdmLineModel[] tdmLineModelArray = ((TNCModuleModel)this.getUiModel()).getAllTdmLines();
        this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        EtherLineModel[] etherLineModelArray = ((TNCModuleModel)this.getUiModel()).getEtherLineModels();
        this.etherLinesList = new ArrayList<EtherLineModel>(Arrays.asList(etherLineModelArray));
        this.getOM().addObservable((Observable[])etherLineModelArray);
        HdGeLineModel[] hdGeLineModelArray = ((TNCModuleModel)this.getUiModel()).getGigeLineModels();
        this.gigEs = new ArrayList<HdGeLineModel>(Arrays.asList(hdGeLineModelArray));
        this.getOM().addObservable((Observable[])hdGeLineModelArray);
        this._interfaceContainers = Collections.synchronizedMap(new TreeMap());
        this.addContainers(this.getPpmModelsArray());
    }

    protected void addContainers(IPortContainer[] iPortContainerArray) {
        for (int i = 0; i < iPortContainerArray.length; ++i) {
            IPortContainer iPortContainer = iPortContainerArray[i];
            Iterator iterator = iPortContainer.getContainedPorts().iterator();
            while (iterator.hasNext()) {
                try {
                    this.addContainer(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    db.println("Caught exception in addContainers()!");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
            }
        }
    }

    protected IPortContainer removeContainer(IInterfaceModel iInterfaceModel) {
        return (IPortContainer)this._interfaceContainers.remove(iInterfaceModel);
    }

    private void addContainer(IInterfaceModel iInterfaceModel, IPortContainer iPortContainer) {
        this._interfaceContainers.put(iInterfaceModel, iPortContainer);
    }

    protected TdmLineModel[] getOcnLinesArray() {
        return this.ocnLinesList.toArray(new TdmLineModel[this.ocnLinesList.size()]);
    }

    protected EtherLineModel[] getEtherLinesArray() {
        return this.etherLinesList.toArray(new EtherLineModel[this.etherLinesList.size()]);
    }

    protected HdGeLineModel[] getGigeLinesArray() {
        return this.gigEs.toArray(new HdGeLineModel[this.gigEs.size()]);
    }

    @Override
    protected List addModel(Observable observable) {
        List list = super.addModel(observable);
        if (observable instanceof PpmModel) {
            IPortContainer iPortContainer = (IPortContainer)((Object)observable);
            Model[] modelArray = ((TNCModuleModel)this.getUiModel()).getAllTdmLines();
            EtherLineModel[] etherLineModelArray = ((TNCModuleModel)this.getUiModel()).getEtherLineModels();
            EtherLineModel[] etherLineModelArray2 = ((TNCModuleModel)this.getUiModel()).getGigeLineModels();
            int n = modelArray.length;
            int n2 = etherLineModelArray.length;
            int n3 = etherLineModelArray2.length;
            if (n != this.ocnLinesList.size()) {
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
                this.getOM().addObservable((Observable[])modelArray);
                list.add(new OcnLineUpdate(modelArray, iPortContainer));
                db.fine("Added TDM line model...");
            } else if (n2 != this.etherLinesList.size()) {
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                this.etherLinesList = new ArrayList<EtherLineModel>(Arrays.asList(etherLineModelArray));
                this.getOM().addObservable((Observable[])etherLineModelArray);
                list.add(new EtherLineUpdate(etherLineModelArray, iPortContainer));
                db.fine("Added Ethernet line models...");
            } else if (n3 != this.gigEs.size()) {
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                this.gigEs = new ArrayList<HdGeLineModel>(Arrays.asList(etherLineModelArray2));
                this.getOM().addObservable((Observable[])etherLineModelArray2);
                list.add(new EtherLineUpdate(etherLineModelArray2, iPortContainer));
                db.fine("Added Ethernet line models...");
            }
        }
        return list;
    }

    @Override
    public void destroy() {
        this.ocnLinesList.clear();
        this.etherLinesList.clear();
        this.gigEs.clear();
        super.destroy();
    }
}

