/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.sLaserThresholds;
import cerent.cms.idl.Dwdm.sValThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.tnc.TNCThresholdsTableModel;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;

public class TNCOpticalThresholdTableModel
extends TNCThresholdsTableModel
implements ResettablePmThresholdsTableModel {
    private static final int POWER_OFFSET = 400;
    private static final int POWER_OFFSET_TNC_RX = 500;
    public static final String UNAVAILABLE = "N/A";
    public static final float[] scaleFactor = new float[]{1.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
    private static final int[] LOWER_BOUND = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] UPPER_BOUND = new int[]{0, 1000, 700, 700, 700, 700};
    public static final String[] columnNames = new String[]{"Port", "Laser Bias High (%)", "RX Power High (dBm)", "RX Power Low (dBm)", "TX Power High (dBm)", "TX Power Low (dBm)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int LBIAS_HIGH_INDEX = 1;
    public static final int RXP_HIGH_INDEX = 2;
    public static final int RXP_LOW_INDEX = 3;
    public static final int TXP_HIGH_INDEX = 4;
    public static final int TXP_LOW_INDEX = 5;
    protected int thresholdLayer;
    protected sLaserThresholds[] thresholdsVal;
    protected boolean[] rowDirty = null;
    private static final SDebug db = new SDebug("TNCOpticalThresholdTableModel");

    public TNCOpticalThresholdTableModel(InterfaceModel[] interfaceModelArray, int n) {
        super(db, interfaceModelArray);
        this.thresholdLayer = n;
        this.refreshMyLines(interfaceModelArray);
    }

    @Override
    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    @Override
    public boolean resetToDefaultByLine() {
        return true;
    }

    @Override
    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        sLaserThresholds sLaserThresholds2 = null;
        InterfaceModel interfaceModel = this.model[n];
        eIntervalType eIntervalType2 = null;
        switch (this.thresholdLayer) {
            case 0: {
                eIntervalType2 = eIntervalType.INTERVAL_15_MIN;
                break;
            }
            case 1: {
                eIntervalType2 = eIntervalType.INTERVAL_DAY;
                break;
            }
            case 2: {
                eIntervalType2 = eIntervalType.INTERVAL_VARIABLE;
                break;
            }
            default: {
                throw new Exception("TNCOpticalThresholdTableModel.getThresholdNeDefault: Bad thresholdLayer = " + this.thresholdLayer);
            }
        }
        sLaserThresholds2 = interfaceModel.getDefaultOpticsThresholdsForTNC(eIntervalType2, neDefaultsModel);
        return sLaserThresholds2;
    }

    @Override
    public void setThresholdValue(int n, Object object) {
        if (object instanceof sLaserThresholds) {
            this.thresholdsVal[n] = (sLaserThresholds)object;
        }
    }

    @Override
    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        super.refreshMyLines(interfaceModelArray);
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sLaserThresholds[this.numLines];
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Float.class;
            }
        }
        return Object.class;
    }

    public boolean supportLaserBias(int n, int n2) {
        return true;
    }

    public boolean supportTxPower(int n, int n2) {
        return true;
    }

    public boolean supportOpticsMon(int n, int n2) {
        return true;
    }

    @Override
    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        return super.getPortDescriptionFor(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule() && this.supportLaserBias(n, n2) && this.supportTxPower(n, n2) && this.supportOpticsMon(n, n2)) {
                    return n2 > 0;
                }
                return false;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("no such entity in isCellEditable");
                }
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            int n3 = 0;
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    n3 = this.getThreshold((int)n).laserBias.high;
                    break;
                }
                case 2: {
                    n3 = this.getThreshold((int)n).rxPower.high - 500;
                    break;
                }
                case 3: {
                    n3 = this.getThreshold((int)n).rxPower.low - 500;
                    break;
                }
                case 4: {
                    n3 = this.getThreshold((int)n).txPower.high - 400;
                    break;
                }
                case 5: {
                    n3 = this.getThreshold((int)n).txPower.low - 400;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new Float((float)n3 / scaleFactor[n2]);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            return UNAVAILABLE;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OpticalThresholdTableModel: error in getValueAt" + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = true;
        sValThresholds sValThresholds2 = null;
        int n3 = 0;
        try {
            switch (n2) {
                case 1: {
                    bl = false;
                    sValThresholds2 = this.getThreshold((int)n).laserBias;
                    break;
                }
                case 2: {
                    bl = false;
                }
                case 3: {
                    n3 = 500;
                    sValThresholds2 = this.getThreshold((int)n).rxPower;
                    break;
                }
                case 4: {
                    bl = false;
                }
                case 5: {
                    n3 = 400;
                    sValThresholds2 = this.getThreshold((int)n).txPower;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)noSuchInterface));
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
            return;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)wrongInterfaceType));
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            return;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            if (db.on()) {
                db.println("Fail to getThreshold" + (Object)((Object)unsupportedOperation));
                KDebug.printStackTrace((Throwable)unsupportedOperation);
            }
            return;
        }
        int n4 = sValThresholds2.low;
        int n5 = sValThresholds2.high;
        if (bl) {
            n4 = LOWER_BOUND[n2];
        } else {
            n5 = UPPER_BOUND[n2];
            if (n2 == 2) {
                n5 += 100;
            }
        }
        ProvisionError provisionError = new ProvisionError("value " + object + " out of range [" + (float)(n4 - n3) / scaleFactor[n2] + ".." + (float)(n5 - n3) / scaleFactor[n2] + "]");
        try {
            if (!(object instanceof Float)) {
                db.info("Value is not type of Float");
                return;
            }
            Float f = (Float)object;
            int n6 = Math.round(f.floatValue() * scaleFactor[n2]) + n3;
            if (n6 < n4 || n6 > n5) {
                throw provisionError;
            }
            if (bl) {
                if (sValThresholds2.low == n6) {
                    return;
                }
                sValThresholds2.low = n6;
            } else {
                if (sValThresholds2.high == n6) {
                    return;
                }
                sValThresholds2.high = n6;
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError2) {
            this.presentProvisionError(this.getColumnName(n2), provisionError2);
        }
        catch (NumberFormatException numberFormatException) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNames[i] = null;
            this.thresholdsVal[i] = null;
            this.rowDirty[i] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        if (db.on()) {
            db.println("applyToModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (!this.rowDirty[i]) continue;
                switch (this.thresholdLayer) {
                    case 0: {
                        this.model[i].setOpticsTCAThresholdsForTNC(this.getThreshold(i), eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.model[i].setOpticsTCAThresholdsForTNC(this.getThreshold(i), eIntervalType.INTERVAL_DAY);
                        break;
                    }
                    case 2: {
                        this.model[i].setOpticsAlmThresholdsForTNC(this.getThreshold(i));
                    }
                }
                this.rowDirty[i] = false;
                continue;
            }
            catch (ConfigError configError) {
                this.rowDirty[i] = false;
                this.thresholdsVal[i] = null;
                this.fireTableRowsUpdated(i, i);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)configError);
                }
                ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_VALUE_OUT_OF_RANGE, "");
                continue;
            }
            catch (Exception exception) {
                this.rowDirty[i] = false;
                this.thresholdsVal[i] = null;
                this.fireTableRowsUpdated(i, i);
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public sLaserThresholds getThreshold(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.thresholdsVal[n] == null) {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholdsForTNC(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholdsForTNC(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.thresholdsVal[n] = this.model[n].getOpticsAlmThresholdsForTNC();
                }
            }
        }
        return this.thresholdsVal[n];
    }
}

