/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.SonetMedia.eBlsrExtensionByte;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InService;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.InvalidSoakTime;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.AbstractHoNum;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SoakTimePropertyEditor;
import java.awt.Component;

public class TNCOscOcLineTableModel
extends TdmTableModel {
    static final Attribute[] sdhSonetAttrs = new Attribute[]{new Attribute("SONET", 1), new Attribute("SDH", 0)};
    static final Attribute[] sonetAttrs = new Attribute[]{new Attribute("SONET", 1)};
    static final Attribute[] blsrAttrs = new Attribute[]{new Attribute("K3", 0), new Attribute("Z2", 1), new Attribute("E2", 2), new Attribute("F1", 3)};
    public String[] columnNames;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] blsrExtByte;
    private sLineSyncConfig[] syncConfig;
    private Integer[] stsMonitor;
    private Attribute[] lineBuildout;
    private Boolean[] receiveEqualization;
    private int[] soakTime;
    private boolean[][] isDirty;
    private String sdString;
    private String sfString;
    private Attribute[] mediaType;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int SFBERLEVEL_INDEX = 2;
    public static final int SDBERLEVEL_INDEX = 3;
    public static final int BLSREXT_INDEX = 4;
    public static final int USEDFORSYNC_INDEX = 5;
    public static final int PROVIDESSYNC_INDEX = 6;
    public static final int SYNCMESSAGEIN_INDEX = 7;
    public static final int SENDDONOTUSE_INDEX = 8;
    public static final int STSMONITOR_INDEX = 9;
    public static final int LINEBUILDOUT_INDEX = 10;
    public static final int RXEQ_INDEX = 11;
    public static final int SOAK_TIME_INDEX = 12;
    public static final int SDH_INDEX = 13;
    private String[] portNames;
    private static final SDebug db = new SDebug("TNCOscOcLineTableModel");

    public TNCOscOcLineTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        String[] stringArray = new String[]{"Port", "Port Name", "SF BER", "SD BER", "BLSR Ext. Byte", "UsedForSync", "ProvidesSync", "SyncMsgIn", "Send DoNotUse", "PJ" + this.getTerms().getGeneralTerms(0) + "Mon#", "Line Buildout", "Rx Equalization", "AINS Soak", "Type"};
        this.columnNames = stringArray;
        if (tdmLineModelArray == null) {
            if (db.on()) {
                db.println("Model is null");
            }
            this.numLines = 0;
        } else {
            this.numLines = tdmLineModelArray.length;
        }
        this.portNames = new String[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.blsrExtByte = new Attribute[this.numLines];
        this.syncConfig = new sLineSyncConfig[this.numLines];
        this.stsMonitor = new Integer[this.numLines];
        this.lineBuildout = new Attribute[this.numLines];
        this.receiveEqualization = new Boolean[this.numLines];
        this.soakTime = new int[this.numLines];
        this.mediaType = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
        }
        this.resetDirtyBits();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    private sLineSyncConfig getSyncConfig(int n) throws NoSuchInterface, UnsupportedOperation {
        if (this.syncConfig[n] == null) {
            this.syncConfig[n] = this.model[n].getSonetConfig();
        }
        return this.syncConfig[n];
    }

    private Boolean getProvidesSyncFromCard(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).providesSyncFromCard);
    }

    private Boolean getSyncMessageIn(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).syncMessageIn);
    }

    private Attribute getLineBuildout(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineBuildout[n] == null) {
            int n2 = this.getRangeFor(Math.abs(this.model[n].getLineBuildout()));
            this.lineBuildout[n] = this.getLineBuildoutAttributeFor(n2);
        }
        return this.lineBuildout[n];
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.getTdmProtocolType(), this.getTerms());
    }

    private Attribute getLineBuildoutAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("EC1.SonetLineBuildout", n);
    }

    protected int getRangeFor(int n) {
        if (Ds123LineTableModel.between(225, 450, n)) {
            return 450;
        }
        return 225;
    }

    private Boolean getSendDoNotUse(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUse);
    }

    private Integer getStsMonitor(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.stsMonitor[n] == null) {
            if (this.getTdmProtocolTypeObj().isSdh()) {
                short s = this.model[n].getPointerMonitorStsNumber();
                this.stsMonitor[n] = new Integer(AbstractHoNum.StsNum2Vc4((int)s));
            } else {
                this.stsMonitor[n] = new Integer(this.unsignedShortToInt(this.model[n].getPointerMonitorStsNumber()));
            }
        }
        return this.stsMonitor[n];
    }

    private int getSfBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSfBerLevelIndex(n).getIntValue();
    }

    private int getSdBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSdBerLevelIndex(n).getIntValue();
    }

    private int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 9 || n2 == 12 || n2 == 13 && ((NodeModelDelegate)this.node).getPlatform().is455()) {
            return false;
        }
        if (this.model != null && this.numLines > 0) {
            try {
                InterfaceModel interfaceModel;
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !(interfaceModel = this.model[n].getHighestParent()).getModuleModel().isProtectModule()) {
                    return n2 > 0 && n2 != 6;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getSfBerLevelIndex(n);
                }
                case 3: {
                    return this.getSdBerLevelIndex(n);
                }
                case 4: {
                    return this.getBlsrExtByte(n);
                }
                case 6: {
                    return this.getProvidesSyncFromCard(n);
                }
                case 7: {
                    return this.getSyncMessageIn(n);
                }
                case 8: {
                    return this.getSendDoNotUse(n);
                }
                case 9: {
                    return this.getStsMonitor(n);
                }
                case 10: {
                    return this.getLineBuildout(n);
                }
                case 11: {
                    return this.getRxEq(n);
                }
                case 12: {
                    return this.getSoakTimeString(n);
                }
                case 13: {
                    return this.getMediaType(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught exception in getValueAt");
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    private Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, this.model[n].getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    private Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, this.model[n].getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    public Boolean getRxEq(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.receiveEqualization[n] == null) {
            int n2 = this.model[n].getLineBuildout();
            if (db.on()) {
                db.println("model[" + n + "].lineBuildout = " + n2);
            }
            this.receiveEqualization[n] = new Boolean(n2 >= 0);
        }
        return this.receiveEqualization[n];
    }

    private String getSoakTimeFromModel(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    private String getSoakTimeString(int n) throws NoSuchInterface {
        return "00:00 (H:M)";
    }

    public Attribute getMediaType(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.mediaType[n] == null) {
            int n2 = this.model[n].getLineInfoMediumType();
            this.mediaType[n] = this.getTdmProtocolTypeObj().isSdh() ? sdhSonetAttrs[1] : (sdhSonetAttrs[0].getIntValue() == n2 ? sdhSonetAttrs[0] : sdhSonetAttrs[1]);
        }
        return this.mediaType[n];
    }

    public Attribute getBlsrExtByte(int n) {
        if (this.blsrExtByte[n] == null) {
            try {
                int n2 = this.model[n].getBlsrByte();
                this.blsrExtByte[n] = blsrAttrs[n2];
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        return this.blsrExtByte[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = this.getTdmProtocolTypeObj().isSonet();
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                case 2: {
                    this.sfBerLevel[n] = (Attribute)object;
                    break;
                }
                case 3: {
                    this.sdBerLevel[n] = (Attribute)object;
                    break;
                }
                case 4: {
                    if (!this.blsrTypeSanityCheck(n, (Attribute)object)) {
                        return;
                    }
                    this.blsrExtByte[n] = (Attribute)object;
                    break;
                }
                case 11: {
                    Boolean bl2 = (Boolean)object;
                    if (bl2.equals(this.receiveEqualization[n])) {
                        return;
                    }
                    if (db.on()) {
                        db.println("setting RxEq to " + bl2);
                    }
                    this.receiveEqualization[n] = bl2;
                    break;
                }
                case 12: {
                    int n3 = this.soakTime[n];
                    try {
                        n3 = SoakTimePropertyEditor.toIntValue((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        db.fine("Number Format Exception on " + (String)object);
                    }
                    if (this.soakTime[n] == n3) {
                        return;
                    }
                    this.soakTime[n] = n3;
                    break;
                }
                case 13: {
                    Attribute attribute = (Attribute)object;
                    if (attribute.equals(this.mediaType[n])) {
                        return;
                    }
                    if (!this.portTypeSanityCheck(n)) {
                        return;
                    }
                    this.mediaType[n] = attribute;
                    break;
                }
                case 7: {
                    Boolean bl3 = (Boolean)object;
                    if (bl3 == this.syncConfig[n].syncMessageIn) {
                        return;
                    }
                    if (!this.syncMsgInSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].syncMessageIn = bl3;
                    break;
                }
                case 8: {
                    Boolean bl4 = (Boolean)object;
                    if (bl4 == this.syncConfig[n].sendDoNotUse) {
                        return;
                    }
                    if (!this.sendDoNotUseSanityCheck(n)) {
                        return;
                    }
                    this.syncConfig[n].sendDoNotUse = bl4;
                    break;
                }
                case 9: {
                    this.stsMonitor[n] = (Integer)object;
                    break;
                }
                case 10: {
                    this.lineBuildout[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in setValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private boolean sendDoNotUseSanityCheck(int n) {
        InterfaceModel interfaceModel;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer();
        bl = this.isSdh(n);
        if (bl && ((NodeModelDelegate)this.node).getPlatform().is454()) {
            stringBuffer.append("- The port type is SDH.\n");
        }
        if (!((interfaceModel = this.model[n].getHighestParent()) instanceof AbstractDwdmLineModel)) {
            bl2 = this.model[n].isProtectLine();
            if (bl2) {
                stringBuffer.append("- The port is the protect port in a 1+1 protection group.\n");
            }
            if (bl3 = this.model[n].isBlsrProtectLine()) {
                stringBuffer.append("- The port is the protect port of a four-fiber BLSR.");
            }
            bl4 = (!bl || !((NodeModelDelegate)this.node).getPlatform().is454()) && !bl2 && !bl3;
        } else {
            AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
            boolean bl5 = bl4 = !abstractDwdmLineModel.isProtectLine();
        }
        if (!bl4) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_SEND_DO_NOT_USE_REQ, stringBuffer.toString());
        }
        return bl4;
    }

    private boolean syncMsgInSanityCheck(int n) {
        InterfaceModel interfaceModel;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer();
        bl = this.isSdh(n);
        if (bl && ((NodeModelDelegate)this.node).getPlatform().is454()) {
            stringBuffer.append("- The port type is SDH.\n");
        }
        if (!((interfaceModel = this.model[n].getHighestParent()) instanceof AbstractDwdmLineModel)) {
            bl2 = this.model[n].isProtectLine();
            if (bl2) {
                stringBuffer.append("- The port is the protect port in a 1+1 protection group.\n");
            }
            if (bl3 = this.model[n].isBlsrProtectLine()) {
                stringBuffer.append("- The port is the protect port of a four-fiber BLSR.");
            }
            bl4 = (!bl || !((NodeModelDelegate)this.node).getPlatform().is454()) && !bl2 && !bl3;
        } else {
            AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
            boolean bl5 = bl4 = !abstractDwdmLineModel.isProtectLine();
        }
        if (!bl4) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_ENABLE_SYNC_MSG_REQ, stringBuffer.toString());
        }
        return bl4;
    }

    private boolean portTypeSanityCheck(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        StringBuffer stringBuffer = new StringBuffer();
        bl = this.isCircuitPresent(this.model[n]);
        bl2 = this.isOhCircuitPresent(this.model[n]);
        bl3 = this.isInOnePlusOneProtectionGroup(this.model[n]);
        bl4 = this.isInBlsr(this.model[n]);
        bl7 = !this.isSdh(n) && this.isSdccPresent(this.model[n]);
        try {
            bl6 = !this.isSdh(n) && this.getSendDoNotUse(n) != false;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
        }
        if (bl) {
            stringBuffer.append("  - There are circuits using this port.\n");
        }
        if (bl2) {
            stringBuffer.append("  - There are overhead circuits on this port.\n");
        }
        if (bl3) {
            stringBuffer.append("- The port is part of a 1+1 protection group.\n");
        }
        if (bl4) {
            stringBuffer.append("- The port is part of a " + this.getTerms().getRingTerms(1) + ".\n");
        }
        if (bl7) {
            stringBuffer.append("- A(n) " + this.getTerms().getGeneralTerms(8) + " termination exists on this port.\n");
        }
        if (bl6) {
            stringBuffer.append("- \"Send DoNotUse\" is checked.\n");
        }
        boolean bl9 = bl8 = !bl2 && !bl3 && !bl4 && !bl6 && !bl;
        if (!bl8) {
            ErrorMsg.displayDetailed((Component)this.getFrame(), EMC.EID_FAIL_PORT_TYPE_CHANGE_REQ, stringBuffer.toString());
        }
        return bl8;
    }

    private boolean blsrTypeSanityCheck(int n, Attribute attribute) {
        boolean bl = false;
        int n2 = attribute.getValue();
        OhChannelType ohChannelType = OhChannelType.getOhChannelTypeForBlsrExtByte((int)n2);
        if (ohChannelType == null) {
            bl = true;
        } else if (this.isOhCircuitPresent(this.model[n], ohChannelType)) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_UNABLE_TO_BYTE_SWITCH);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isCircuitPresent(TdmLineModel tdmLineModel) {
        return !tdmLineModel.getConnectionsList().isEmpty();
    }

    private boolean isOhCircuitPresent(TdmLineModel tdmLineModel) {
        return tdmLineModel.getOhConnectionsList().size() > 0;
    }

    private boolean isOhCircuitPresent(TdmLineModel tdmLineModel, OhChannelType ohChannelType) {
        return tdmLineModel.isOhCircuitPresent(ohChannelType);
    }

    private boolean isSdccPresent(TdmLineModel tdmLineModel) {
        boolean bl = false;
        try {
            bl = ((TdmPortModel)tdmLineModel.getPortModel()).isSonetDccTermination();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return bl;
    }

    private boolean isInBlsr(TdmLineModel tdmLineModel) {
        boolean bl;
        block2: {
            bl = false;
            try {
                ElementModel elementModel = tdmLineModel.getElementModel();
                bl = elementModel instanceof BlsrModel;
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return bl;
    }

    private boolean isInOnePlusOneProtectionGroup(TdmLineModel tdmLineModel) {
        ElementModel elementModel;
        boolean bl = tdmLineModel.isProtectLine();
        try {
            elementModel = tdmLineModel.getElementModel();
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return false;
        }
        boolean bl2 = false;
        bl2 = elementModel instanceof OnePlusOneModel;
        return bl || bl2;
    }

    private boolean isSdh(int n) {
        boolean bl = false;
        try {
            bl = this.getTdmProtocolTypeObj().isSdh() && this.getMediaType(n) == sdhSonetAttrs[1];
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return bl;
    }

    private Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal(string, n);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        this.blsrExtByte[n] = null;
        this.syncConfig[n] = null;
        this.receiveEqualization[n] = null;
        this.stsMonitor[n] = null;
        this.lineBuildout[n] = null;
        this.soakTime[n] = -1;
        this.mediaType[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    protected boolean mediaChanged() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][13] || !AdminState.warnOnMediaChange(this.getAdminStateFor(i))) continue;
            return true;
        }
        return false;
    }

    protected eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    private AdminState getAdminState(int n) throws NoSuchInterface {
        eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
        AdminState adminState = AdminState.enumToAdminState(eAdminState2);
        return adminState;
    }

    protected boolean needRemoveLoopback() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            int n = 0;
            try {
                n = this.model[i].getLoopbackAsInt();
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                throw new NoSuchInterface(exception.getMessage());
            }
            if (n == 0 || AdminState.admitsLoopback(this.getAdminStateFor(i))) continue;
            return true;
        }
        return false;
    }

    boolean adminStateChangedToFormOfOOS() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            if (!AdminState.isTransitionToOOS(this.getAdminStateFor(i), this.model[i].getAdminStateEnum())) continue;
            return true;
        }
        return false;
    }

    public void applyToModel() throws InvalidLoopbackProvision, InvalidSoakTime, InService, NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError, SyncProvError, AnnotatedException, SyncProvBusy, InvalidQuality, EMCProvisionError {
        boolean bl = false;
        for (int i = 0; i < this.numLines; ++i) {
            int n;
            if (this.isDirty(i, 1)) {
                this.model[i].setAlias(this.getPortName(i));
            }
            if (this.isDirty(i, 2)) {
                this.model[i].setSfBerLevel((short)this.getSfBerLevel(i));
            }
            if (this.isDirty(i, 3)) {
                this.model[i].setSdBerLevel((short)this.getSdBerLevel(i));
            }
            if (this.isDirty(i, 4)) {
                n = this.isInBlsr(this.model[i]);
                String string = this.getTerms().getRingTerms(1);
                if (n == 0 || CerentDialog.yesNoDialog((Component)this.getFrame(), (String)("Changing the " + string + " extension byte will prevent\n" + string + " switching until both ends of the line have\n" + "been provisioned to use the same byte.\n\n" + "Is it OK to continue?"), (String)"Confirmation Dialog")) {
                    Attribute attribute = this.getBlsrExtByte(i);
                    this.model[i].setBlsrByte(eBlsrExtensionByte.from_int(attribute.getValue()));
                }
            }
            if (this.isDirty(i, 9)) {
                if (db.on()) {
                    db.println("Setting STS Monitor ");
                }
                if ((n = this.getTdmProtocolTypeObj().isSdh()) != 0) {
                    short s = (short)AbstractHoNum.Vc4Num2Sts((int)this.getStsMonitor(i));
                    this.model[i].setLinePointerMonitorStsNumber(s);
                } else {
                    this.model[i].setLinePointerMonitorStsNumber(this.getStsMonitor(i).shortValue());
                }
            }
            if (this.isDirty(i, 10) || this.isDirty(i, 11)) {
                n = this.getLineBuildout(i).getIntValue();
                if (!this.getRxEq(i).booleanValue()) {
                    n = -n;
                }
                if (db.on()) {
                    db.println("Setting line buildout for " + i + " to " + n);
                }
                this.model[i].setLineBuildout(n);
            }
            if (this.isDirty(i, 12)) {
                if (db.on()) {
                    db.println("setting line soakTime " + this.getSoakTime(i));
                }
                this.model[i].setSoakTime(this.getSoakTime(i));
            }
            if (this.isDirty(i, 13)) {
                try {
                    if (this.getMediaType(i).getIntValue() == 0) {
                        sLineSyncConfig sLineSyncConfig2 = this.getSyncConfig(i);
                        sLineSyncConfig2.syncMessageIn = false;
                        this.model[i].setSonetConfig(sLineSyncConfig2);
                        if (this.isDirty(i, 7) || this.isDirty(i, 8)) {
                            this.model[i].setSonetConfig(this.getSyncConfig(i));
                            this.isDirty[i][7] = false;
                            this.isDirty[i][8] = false;
                        }
                    }
                    this.model[i].setLineInfoMediumType((short)this.getMediaType(i).getIntValue());
                }
                catch (EMCProvisionError eMCProvisionError) {
                    ErrorMsg.displayError((Component)this.getFrame(), (EID)eMCProvisionError.getEID());
                    this.refreshFromModel();
                }
                catch (Exception exception) {
                    db.println("Caught exception in applyToModel");
                    SDebug.printStackTrace((Throwable)exception);
                    throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_PORT_CANNOT_BE_CHANGE), exception);
                }
            }
            if (!this.isDirty(i, 7) && !this.isDirty(i, 8)) continue;
            try {
                this.model[i].setSonetConfig(this.getSyncConfig(i));
                continue;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                throw new UnsupportedOperation(ErrorMsg.getString((EID)EMC.EID_CANNOT_CHANGE_TIMIMG));
            }
        }
        this.resetDirtyBits();
    }
}

