/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.tnc;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.OrderwireModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.tnc.AbstractTNCCardTabbedView;
import cerent.cms.ui.tnc.TNCMaintenancePane;
import cerent.cms.ui.tnc.TNCPerfPane;
import cerent.cms.ui.tnc.TNCProvPane;
import java.util.List;
import java.util.Observable;

public class TncCardTabbedView
extends AbstractTNCCardTabbedView
implements ITabName {
    public TncCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        moduleModel.addObserver(this);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public Pane getMaintenanceTab() {
        return new TNCMaintenancePane("Maintenance", this);
    }

    @Override
    public Pane getPerformanceTab() {
        return new TNCPerfPane("Performance", this);
    }

    @Override
    public Pane getCircuitTab() {
        return null;
    }

    @Override
    public Pane getProvTab() {
        return new TNCProvPane("Provisioning", this);
    }

    protected EnvAlarmModel[] getAlarmInput() {
        List list = ((EntityModel)this.uiModel).getDescendantsOfType(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[0]);
    }

    protected EnvControlModel[] getControlOutput() {
        List list = ((EntityModel)this.uiModel).getDescendantsOfType(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[0]);
    }

    protected OrderwireModel[] getOrderwire() {
        List list = ((EntityModel)this.uiModel).getDescendantsOfType(eEqType.ORDER_WIRE);
        return list.toArray(new OrderwireModel[0]);
    }

    @Override
    protected List removeModel(Observable observable) {
        List list = super.removeModel(observable);
        if (observable instanceof IInterfaceModel) {
            IPortContainer iPortContainer = this.removeContainer((IInterfaceModel)observable);
            this.getOM().removeObservable(observable);
            if (iPortContainer == null) {
                db.println("Could not get parent for removed model!");
            }
            if (observable instanceof TdmLineModel) {
                if (this.ocnLinesList.remove(observable)) {
                    list.add(new OcnLineUpdate(this.getOcnLinesArray(), iPortContainer));
                }
            } else if (observable instanceof HdGeLineModel) {
                if (this.gigEs.remove(observable)) {
                    list.add(new EtherLineUpdate(this.getGigeLinesArray(), iPortContainer));
                }
            } else if (observable instanceof EtherLineModel && this.etherLinesList.remove(observable)) {
                list.add(new EtherLineUpdate(this.getEtherLinesArray(), iPortContainer));
            }
        }
        return list.size() > 0 ? list : super.removeModel(observable);
    }
}

