/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.trace;

import cerent.cms.IPlatform;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class GenericTraceProvPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private static final SDebug db = new SDebug("GenericTraceProvPane");
    private int maxStringLength;
    private static final int LENGTH_16 = 15;
    private int LENGTH_64;
    private int expMaxStringLength;
    private static final int LENGTH_1 = 1;
    public static final int CONVERT_TO_TEXT = 0;
    public static final int CONVERT_TO_HEX = 1;
    private static final String HEXMODE = "Hex Mode";
    private static final String ASCIIMODE = "ASCII Mode";
    protected static final String Q_DISABLE_AIS = "Disable AIS on TIM-P?";
    protected static final String Q_DISABLE_AIS_RDI = "Disable AIS/RDI on TIM-S?";
    protected static final String Q_DISABLE_FDI_OTN = "Disable FDI on TTIM?";
    protected static final String TRACE_OFF = "Off/None";
    protected static final String TRACE_AUTO = "Auto";
    protected static final String TRACE_MANUAL = "Manual";
    protected static final String[] modeChoices = new String[]{"Off/None", "Auto", "Manual"};
    protected static final String[] manualModeChoices = new String[]{"Off/None", "Manual"};
    protected static final String[] levelChoices = new String[]{"Section", "Path"};
    protected static final String[] otuLevelChoices = new String[]{"Section"};
    protected static final String DISABLE_AIS = "DISABLE AIS";
    protected static final String LEVEL_CHANGE = "LEVEL_CHANGE";
    protected static final String INTERFACE_CHANGE = "INTERFACE_CHANGE";
    protected static final String TRACEMODE_COMMAND = "TRACEMODE_SWITCH";
    protected static final String FACTORY_DEFAULT = "FACTORY_DEFAULT";
    protected static final String TRANSMIT_SWITCH = "TRANSMIT_SWITCH";
    protected static final String EXPECTED_SWITCH = "EXPECTED_SWITCH";
    protected static final String RECEIVED_SWITCH = "RECEIVED_SWITCH";
    protected static final String RECEIVED_C2 = "Received C2: ";
    protected static final String J0_STRINGSIZE = "Transmit Section Trace String Size";
    protected static final String J1_STRINGSIZE = "Transmit Path Trace String Size";
    protected static final String TTI_STRINGSIZE = "Trail Trace String Size";
    protected static final String TRACE_STRINGSIZE_1 = "1 byte";
    protected static final String TRACE_STRINGSIZE_16 = "16 byte";
    protected static final String TRACE_STRINGSIZE_64 = "64 byte";
    protected static final String TRANSMIT_LABEL = "    New Transmit String: ";
    protected static final String HEX = "Hex (1 byte)";
    protected static final String ASCII = "ASCII";
    protected boolean dispTransmitAsString;
    protected boolean dispExpectedAsString;
    protected boolean dispReceivedAsString;
    protected char[] transmitBytes;
    protected char[] expectedBytes;
    protected char[] receivedBytes;
    protected int traceFormat;
    private int oldState;
    private boolean modeChanged;
    private boolean disableAis;
    private boolean resetToDefaults;
    private boolean remainDirty;
    private int effectivePort;
    protected IGenericTraceLine[] models;
    protected TraceMode paneMode;
    protected int enabledFormats;
    private JRadioButton trace16ByteRB;
    private JRadioButton trace64ByteRB;
    private JRadioButton trace1ByteRB;
    private JRadioButton transAsciiRB;
    private JRadioButton transHexRB;
    private JRadioButton expAsciiRB;
    private JRadioButton expHexRB;
    private JComboBox traceModeBox;
    private JComboBox ifCB;
    private JComboBox lvlCB;
    private JCheckBox disableAisBox;
    private JTextArea transmitArea;
    private JTextArea expectedArea;
    private JTextArea receivedArea;
    private TraceTextField transmitField;
    private TraceTextField expectedField;
    private JButton transmitButton;
    private JButton expectedButton;
    private JButton receivedButton;
    private JButton factoryDefaultButton;
    private JLabel expectedFieldLabel;
    private JLabel receivedC2Label;
    private JLabel transmitLabel;
    private JScrollPane jsp1;
    private JScrollPane jsp2;
    private JScrollPane jsp3;
    private boolean supportC2Label;
    private static final int MARGIN = 10;
    private static final String SND_RETRIEVE_FAILURE = "<comm error>";
    private static final String EXP_RETRIEVE_FAILURE = "<comm error>";
    private static final String REC_RETRIEVE_FAILURE = "<comm error>";
    private static final String REC_RETRIEVE_NOT_ATTEMPTED = "<not available for current card state>";
    private static final String REC_RETRIEVE_NOT_ATTEMPTED_OFF = "<not available for current trace mode>";
    private static final String EMPTY_TRACE = "";
    private JButton refreshPB;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
    private JLabel refreshTimeLabel;
    private static final String REFRESH = "Refresh";
    private static final String AUTO_REFRESH_CMD = "AUTO_REFRESH";
    private static final int autoRefreshRate = 5000;
    private JCheckBox autoRefreshCB;
    private Timer refreshTimer;
    private static final String autoRefreshPrefPath = "ctc";
    private static final String autoRefSecPrefKey = "SectionTrc-refresh-rate";
    private static final String autoRefTTIPrefKey = "TTITrc-refresh-rate";

    protected void refreshReceivedTrace() {
        db.fine("Refreshing receive trace");
        try {
            int n = this.getEffectivePort();
            this.receivedBytes = this.getReceivedTrace(n);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.updateDisplay(RECEIVED_SWITCH, false);
    }

    private void saveAutoRefreshPref() {
        if (null != this.autoRefreshCB) {
            String string = this.paneMode == TraceMode.SECTION ? autoRefSecPrefKey : autoRefTTIPrefKey;
            boolean bl = this.autoRefreshCB.isSelected();
            Preferences.instance().setBoolean(autoRefreshPrefPath, string, bl);
        }
    }

    public static String charFromByte(char c, boolean bl) {
        int n = c & 0xFF;
        if (bl) {
            return " " + (char)n + " ";
        }
        return String.valueOf((char)n);
    }

    public static String hexFromByte(char c) {
        int n = c & 0xFF;
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string + " ";
    }

    public void printBytes(char[] cArray) {
        db.print(" Bytes length=" + cArray.length + " [");
        for (int i = 0; i < cArray.length; ++i) {
            String string = GenericTraceProvPane.charFromByte(cArray[i], false);
            db.print(string);
        }
        db.println("]");
    }

    public static String bytesToString(char[] cArray, int n) {
        String string = new String(cArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        if (n == 0) {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c < ' ' || c >= '\u0080') continue;
                stringBuffer.append(GenericTraceProvPane.charFromByte(c, false));
            }
        } else {
            for (int i = 0; i < n2; i += 16) {
                char c;
                int n3;
                int n4 = Math.min(i + 16, n2);
                stringBuffer.append(GenericTraceProvPane.hexFromByte((char)i));
                stringBuffer.append(": ");
                for (n3 = i; n3 < n4; ++n3) {
                    c = string.charAt(n3);
                    if (c > ' ' && c < '\u0080') {
                        stringBuffer.append(GenericTraceProvPane.charFromByte(c, true));
                        continue;
                    }
                    stringBuffer.append(GenericTraceProvPane.charFromByte(' ', true));
                }
                stringBuffer.append('\n');
                stringBuffer.append("     ");
                for (n3 = i; n3 < n4; ++n3) {
                    c = string.charAt(n3);
                    stringBuffer.append(GenericTraceProvPane.hexFromByte(c));
                }
                if (i + 16 >= n2) continue;
                stringBuffer.append('\n');
            }
        }
        return stringBuffer.toString();
    }

    private boolean isFormatEnabled(int n) {
        return (this.enabledFormats & 1 << n) != 0;
    }

    private boolean isFormatSelectable() {
        int n = 0;
        if (this.isFormatEnabled(2)) {
            ++n;
        }
        if (this.isFormatEnabled(1)) {
            ++n;
        }
        if (this.isFormatEnabled(0)) {
            ++n;
        }
        return n > 1;
    }

    public GenericTraceProvPane(String string, TabbedView tabbedView, TraceMode traceMode, IGenericTraceLine[] iGenericTraceLineArray, int n) {
        super(string, tabbedView);
        this.expMaxStringLength = this.LENGTH_64 = 62;
        this.dispTransmitAsString = true;
        this.dispExpectedAsString = true;
        this.dispReceivedAsString = true;
        this.traceFormat = 1;
        this.oldState = 0;
        this.modeChanged = false;
        this.disableAis = false;
        this.resetToDefaults = false;
        this.remainDirty = false;
        this.transmitField = null;
        this.expectedField = null;
        this.refreshTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericTraceProvPane.this.refreshReceivedTrace();
            }
        });
        this.paneMode = traceMode;
        this.enabledFormats = n;
        if (traceMode == TraceMode.TTI) {
            this.expMaxStringLength = this.LENGTH_64 = 64;
        }
        this.factoryDefaultButton = new JButton("Default");
        this.factoryDefaultButton.addActionListener(this);
        this.factoryDefaultButton.setActionCommand(FACTORY_DEFAULT);
        this.addButton(this.factoryDefaultButton);
        this.enableComponent(this.factoryDefaultButton);
        this.refreshMyLines(iGenericTraceLineArray);
        if (this.isFormatEnabled(0)) {
            this.maxStringLength = this.LENGTH_64;
            this.traceFormat = 0;
        } else if (this.isFormatEnabled(1)) {
            this.maxStringLength = 15;
            this.traceFormat = 1;
        } else {
            this.maxStringLength = 1;
            this.traceFormat = 2;
        }
        this.initContentPane();
        this.registerForLineUpdates();
    }

    public void changeFormat(int n) {
        this.nullify(this.transmitField);
        this.traceFormat = n;
        if (this.traceFormat == 1) {
            this.maxStringLength = 15;
            this.transHexRB.setEnabled(false);
            if (this.transHexRB.isSelected()) {
                this.transAsciiRB.doClick();
            }
        } else if (this.traceFormat == 0) {
            this.maxStringLength = this.LENGTH_64;
            this.transHexRB.setEnabled(false);
            if (this.transHexRB.isSelected()) {
                this.transAsciiRB.doClick();
            }
        } else {
            this.transHexRB.setEnabled(true);
            this.maxStringLength = this.transAsciiRB.isSelected() ? 1 : 2;
        }
        if (this.transmitField != null) {
            this.transmitField.setMaxLength(this.maxStringLength);
        }
        this.transmitArea.setText(EMPTY_TRACE);
    }

    public void changeTransStringType(int n) {
        if (n == 1) {
            if (this.transmitField != null) {
                this.transmitField.setType(1);
                this.transmitField.setMaxLength(2);
                this.maxStringLength = 2;
            }
        } else if (this.transmitField != null) {
            this.transmitField.setType(0);
            if (this.traceFormat == 2) {
                this.transmitField.setMaxLength(1);
                this.maxStringLength = 1;
            }
        }
    }

    public void changeExpStringType(int n) {
        if (n == 1) {
            if (this.expectedField != null) {
                this.expectedField.setType(1);
                this.expectedField.setMaxLength(2);
                this.expMaxStringLength = 2;
            }
        } else if (this.expectedField != null) {
            this.expectedField.setType(0);
            this.expectedField.setMaxLength(this.LENGTH_64);
            this.expMaxStringLength = this.LENGTH_64;
        }
    }

    public boolean allowTransmit() {
        return true;
    }

    public boolean allowExpect() {
        return true;
    }

    public boolean allowReceived() {
        return true;
    }

    public boolean allowLevelChange() {
        return this.lvlCB != null && this.lvlCB.getSelectedIndex() != -1;
    }

    protected JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 12));
        jTextArea.setColumns(60);
        jTextArea.setRows(4);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(Color.lightGray);
        return jTextArea;
    }

    private Component createTraceModePanel() {
        String[] stringArray;
        String[] stringArray2;
        JPanel jPanel;
        block12: {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            db.fine("adding interface call back");
            jPanel.add(new JLabel("Port: "));
            stringArray2 = this.getPortNames();
            this.ifCB = new JComboBox<String>(stringArray2);
            this.ifCB.addActionListener(this);
            this.ifCB.setActionCommand(INTERFACE_CHANGE);
            jPanel.add(this.ifCB);
            jPanel.add(Box.createHorizontalStrut(10));
            if (this.paneMode == TraceMode.TTI) {
                db.fine("adding level call back for TTI");
                jPanel.add(new JLabel("Level: "));
                this.lvlCB = ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() ? new JComboBox<String>(levelChoices) : (((EntityModel)this.getUiModel()).getEqType() == 300 || ((EntityModel)this.getUiModel()).getEqType() == 358 || ((EntityModel)this.getUiModel()).getEqType() == 301 || ((EntityModel)this.getUiModel()).getEqType() == 356 ? new JComboBox<String>(levelChoices) : new JComboBox<String>(otuLevelChoices));
                this.lvlCB.addActionListener(this);
                this.lvlCB.setActionCommand(LEVEL_CHANGE);
                jPanel.add(this.lvlCB);
                jPanel.add(Box.createHorizontalStrut(10));
            }
            if (this.paneMode == TraceMode.SECTION) {
                this.disableAisBox = new JCheckBox(Q_DISABLE_AIS_RDI);
            } else if (this.paneMode == TraceMode.PATH) {
                this.disableAisBox = new JCheckBox(Q_DISABLE_AIS);
            } else if (this.paneMode == TraceMode.TTI) {
                this.disableAisBox = new JCheckBox(Q_DISABLE_FDI_OTN);
            } else {
                db.severe("!ERROR! disableAisBox is null!");
            }
            jPanel.add(new JLabel("Received Trace Mode: "));
            stringArray = modeChoices;
            try {
                if (this.getUiModel() instanceof ModuleModel && !((ModuleModel)this.getUiModel()).supportsAutoTrace()) {
                    stringArray = manualModeChoices;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught CmsNoSuchEntity in createTraceModePanel");
                if (!GenericTraceProvPane.db.on) break block12;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (stringArray2.length == 0) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
        }
        this.traceModeBox = new JComboBox<String>(stringArray);
        this.traceModeBox.addActionListener(this);
        this.traceModeBox.setActionCommand(TRACEMODE_COMMAND);
        jPanel.add(this.traceModeBox);
        jPanel.add(Box.createHorizontalStrut(10));
        this.enableComponent(this.traceModeBox);
        this.disableAisBox.addActionListener(this);
        this.disableAisBox.setActionCommand(DISABLE_AIS);
        jPanel.add(this.disableAisBox);
        this.enableComponent(this.disableAisBox);
        jPanel.add(Box.createHorizontalStrut(10));
        boolean bl = this.supportC2Label = this.paneMode == TraceMode.PATH && ((IModuleModel)this.getUiModel()).getEqType() != 293 && !((DwdmModuleModel)this.getUiModel()).isPolluceCard();
        if (this.supportC2Label) {
            this.receivedC2Label = new JLabel("Received C2:   ");
            jPanel.add(this.receivedC2Label);
        }
        return jPanel;
    }

    private JRadioButton makeButton(JPanel jPanel, ButtonGroup buttonGroup, String string) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        this.enableComponent(jRadioButton);
        return jRadioButton;
    }

    private Component createFormatPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        if (this.paneMode == TraceMode.SECTION) {
            jPanel.setBorder(BorderFactory.createTitledBorder(J0_STRINGSIZE));
        } else if (this.paneMode == TraceMode.PATH) {
            jPanel.setBorder(BorderFactory.createTitledBorder(J1_STRINGSIZE));
        } else if (this.paneMode == TraceMode.TTI) {
            jPanel.setBorder(BorderFactory.createTitledBorder(TTI_STRINGSIZE));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.isFormatEnabled(2)) {
            this.trace1ByteRB = this.makeButton(jPanel, buttonGroup, TRACE_STRINGSIZE_1);
        }
        if (this.isFormatEnabled(1)) {
            this.trace16ByteRB = this.makeButton(jPanel, buttonGroup, TRACE_STRINGSIZE_16);
        }
        if (this.isFormatEnabled(0)) {
            this.trace64ByteRB = this.makeButton(jPanel, buttonGroup, TRACE_STRINGSIZE_64);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private Component createTransmitPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Transmit"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Current Transmit String:"));
        this.transmitArea = this.createTextArea();
        this.jsp1 = new UScrollPane((Component)this.transmitArea, 20, 31);
        jPanel2.add(this.jsp1);
        this.transmitButton = new JButton(HEXMODE);
        this.transmitButton.addActionListener(this);
        this.transmitButton.setActionCommand(TRANSMIT_SWITCH);
        jPanel2.add(this.transmitButton);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("Transmit String Type:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.transAsciiRB = this.makeButton(jPanel3, buttonGroup, ASCII);
        jPanel3.add(this.transAsciiRB);
        this.transHexRB = this.makeButton(jPanel3, buttonGroup, HEX);
        this.transAsciiRB.setSelected(true);
        jPanel3.add(this.transHexRB);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.transmitLabel = new JLabel(TRANSMIT_LABEL);
        jPanel4.add(this.transmitLabel);
        this.enableComponent(this.transmitLabel);
        this.transmitField = new TraceTextField(this.maxStringLength);
        this.transmitField.getDocument().addDocumentListener(this);
        jPanel4.add(this.transmitField);
        this.enableComponent(this.transmitField);
        jPanel.add(jPanel4);
        return jPanel;
    }

    public Component createExpectedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Expected"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JLabel("Current Expected String:"));
        this.expectedArea = this.createTextArea();
        this.jsp2 = new UScrollPane((Component)this.expectedArea, 20, 31);
        jPanel2.add(this.jsp2);
        this.expectedButton = new JButton(HEXMODE);
        this.expectedButton.addActionListener(this);
        this.expectedButton.setActionCommand(EXPECTED_SWITCH);
        jPanel2.add(this.expectedButton);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("Expected String Type:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.expAsciiRB = this.makeButton(jPanel3, buttonGroup, ASCII);
        jPanel3.add(this.expAsciiRB);
        this.expHexRB = this.makeButton(jPanel3, buttonGroup, HEX);
        this.expAsciiRB.setSelected(true);
        jPanel3.add(this.expHexRB);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.expectedFieldLabel = new JLabel("     New Expected String: ");
        jPanel4.add(this.expectedFieldLabel);
        this.enableComponent(this.expectedFieldLabel);
        this.expectedField = new TraceTextField(this.LENGTH_64);
        this.expectedField.getDocument().addDocumentListener(this);
        jPanel4.add(this.expectedField);
        this.enableComponent(this.expectedField);
        jPanel.add(jPanel4);
        return jPanel;
    }

    public Component createReceivedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Received"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.refreshPB = new JButton(REFRESH);
        this.refreshPB.addActionListener(this);
        this.refreshPB.setActionCommand(REFRESH);
        this.refreshPB.setAlignmentY(0.5f);
        jPanel2.add(Box.createHorizontalStrut(4));
        jPanel2.add(this.refreshPB);
        this.autoRefreshCB = new JCheckBox("Auto-refresh (every 5 sec)", false);
        this.autoRefreshCB.setActionCommand(AUTO_REFRESH_CMD);
        this.autoRefreshCB.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(4));
        jPanel2.add(this.autoRefreshCB);
        jPanel2.add(Box.createGlue());
        this.refreshTimeLabel = new JLabel(EMPTY_TRACE);
        jPanel2.add(this.refreshTimeLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel("Current Received String:"));
        this.receivedArea = this.createTextArea();
        this.jsp3 = new UScrollPane((Component)this.receivedArea, 20, 31);
        jPanel3.add(this.jsp3);
        this.receivedButton = new JButton(HEXMODE);
        this.receivedButton.addActionListener(this);
        this.receivedButton.setActionCommand(RECEIVED_SWITCH);
        jPanel3.add(this.receivedButton);
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void initContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createTraceModePanel());
        if (this.isFormatSelectable()) {
            jPanel.add(this.createFormatPanel());
        }
        if (this.allowTransmit()) {
            jPanel.add(this.createTransmitPanel());
        }
        if (this.allowExpect()) {
            jPanel.add(this.createExpectedPanel());
        }
        if (this.allowReceived()) {
            jPanel.add(this.createReceivedPanel());
        }
        this.add((Component)new UScrollPane((Component)jPanel));
    }

    protected void nullify(JTextField jTextField) {
        if (jTextField != null) {
            jTextField.setText(new String(this.nullByteArray()));
        }
    }

    protected byte[] nullByteArray() {
        byte[] byArray = new byte[this.maxStringLength];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private void updateRefreshTime() {
        String string = "Refreshed at " + dateFormat.format(new Date());
        this.refreshTimeLabel.setText(string);
    }

    public void updateDisplay(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = null;
        JTextArea jTextArea = null;
        JScrollPane jScrollPane = null;
        JButton jButton = null;
        char[] cArray = null;
        db.info("Calling updateDisplay: command=" + string + " sw=" + bl);
        if (string.equals(TRANSMIT_SWITCH)) {
            bl2 = this.dispTransmitAsString;
            jTextArea = this.transmitArea;
            cArray = this.transmitBytes;
            jButton = this.transmitButton;
            jScrollPane = this.jsp1;
            String string3 = new String(this.transmitBytes);
            if (string3.equals("<comm error>")) {
                bl2 = true;
                bl = false;
                this.transmitButton.setEnabled(false);
            } else {
                this.transmitButton.setEnabled(true);
            }
        } else if (string.equals(EXPECTED_SWITCH)) {
            bl2 = this.dispExpectedAsString;
            jTextArea = this.expectedArea;
            cArray = this.expectedBytes;
            jButton = this.expectedButton;
            jScrollPane = this.jsp2;
            String string4 = new String(this.expectedBytes);
            if (string4.equals("<comm error>")) {
                bl2 = true;
                bl = false;
                this.expectedButton.setEnabled(false);
            } else {
                this.expectedButton.setEnabled(true);
            }
        } else if (string.equals(RECEIVED_SWITCH)) {
            this.updateRefreshTime();
            bl2 = this.dispReceivedAsString;
            jTextArea = this.receivedArea;
            cArray = this.receivedBytes;
            jButton = this.receivedButton;
            jScrollPane = this.jsp3;
            String string5 = new String(this.receivedBytes);
            if (string5.equals(REC_RETRIEVE_NOT_ATTEMPTED) || string5.equals("<comm error>") || string5.equals(REC_RETRIEVE_NOT_ATTEMPTED_OFF)) {
                string2 = string5;
                bl2 = true;
                bl = false;
                this.receivedButton.setEnabled(false);
            } else {
                this.receivedButton.setEnabled(true);
            }
        }
        if (jScrollPane == null) {
            return;
        }
        if (jTextArea != null && cArray != null) {
            db.info("Setting TextArea: byteArr.length=" + cArray.length);
            if (string2 != null) {
                jTextArea.setText(string2);
            } else if (!bl2 && bl || bl2 && !bl) {
                jTextArea.setText(GenericTraceProvPane.bytesToString(cArray, 0));
                if (jButton != null) {
                    jButton.setText(HEXMODE);
                }
            } else {
                jTextArea.setText(GenericTraceProvPane.bytesToString(cArray, 1));
                if (jButton != null) {
                    jButton.setText(ASCIIMODE);
                }
                if (jScrollPane != null) {
                    jScrollPane.getViewport().setViewPosition(new Point(0, 0));
                }
            }
            if (bl) {
                if (string.equals(TRANSMIT_SWITCH)) {
                    this.dispTransmitAsString = !bl2;
                } else if (string.equals(EXPECTED_SWITCH)) {
                    this.dispExpectedAsString = !bl2;
                } else if (string.equals(RECEIVED_SWITCH)) {
                    this.dispReceivedAsString = !bl2;
                }
            }
        }
    }

    protected void setExpected(boolean bl) {
        if (this.expectedFieldLabel != null && this.expectedField != null) {
            this.expectedFieldLabel.setEnabled(bl &= this.isUserAuthorized());
            this.expectedField.setEnabled(bl);
            if (!bl) {
                this.expectedField.setText(null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        db.info("actionPerformed " + actionEvent);
        boolean bl = true;
        String string = actionEvent.getActionCommand();
        if (string.equals(TRACEMODE_COMMAND)) {
            this.modeChanged = true;
            int n = this.getTraceModeFromComboBox();
            if (this.oldState == n) {
                db.info("No Changes in TraceMode, set dirty to false!");
                bl = false;
            }
            this.setTraceModeComboBox(n, false);
        } else if (string.equals(DISABLE_AIS) && this.disableAisBox != null) {
            this.modeChanged = true;
            this.disableAis = this.disableAisBox.isSelected();
        } else {
            if (string.equals(TRANSMIT_SWITCH)) {
                this.updateDisplay(TRANSMIT_SWITCH, true);
                return;
            }
            if (string.equals(EXPECTED_SWITCH)) {
                this.updateDisplay(EXPECTED_SWITCH, true);
                return;
            }
            if (string.equals(RECEIVED_SWITCH)) {
                this.updateDisplay(RECEIVED_SWITCH, true);
                return;
            }
            if (string.equals(FACTORY_DEFAULT)) {
                this.nullify(this.transmitField);
                this.nullify(this.expectedField);
                this.traceModeBox.setSelectedItem(TRACE_OFF);
                if (this.disableAisBox != null) {
                    this.disableAisBox.setSelected(false);
                    this.disableAisBox.setEnabled(false);
                }
                this.resetToDefaults = true;
            } else if (string.equals(TRACE_STRINGSIZE_1)) {
                this.changeFormat(2);
            } else if (string.equals(TRACE_STRINGSIZE_16)) {
                this.changeFormat(1);
            } else if (string.equals(TRACE_STRINGSIZE_64)) {
                this.changeFormat(0);
            } else if (string.equals(ASCII)) {
                bl = false;
                if (actionEvent.getSource() == this.transAsciiRB) {
                    this.changeTransStringType(0);
                } else {
                    this.changeExpStringType(0);
                }
            } else if (string.equals(HEX)) {
                bl = false;
                if (actionEvent.getSource() == this.transHexRB) {
                    this.changeTransStringType(1);
                } else {
                    this.changeExpStringType(1);
                }
            } else if (string.equals(INTERFACE_CHANGE)) {
                if (this.isProvPaneDirty()) {
                    this.askUserToApply();
                }
                this.refreshFromModel();
                bl = false;
            } else if (string.equals(LEVEL_CHANGE)) {
                if (this.isProvPaneDirty()) {
                    this.askUserToApply();
                }
                this.refreshFromModel();
                bl = false;
            } else if (string.equals(REFRESH)) {
                bl = false;
                this.refreshReceivedTrace();
            } else if (string.equals(AUTO_REFRESH_CMD)) {
                bl = false;
                if (this.autoRefreshCB.isSelected()) {
                    if (null != this.refreshTimer && !this.refreshTimer.isRunning()) {
                        if (db.on()) {
                            db.println("Starting auto-refresh timer");
                        }
                        this.refreshTimer.start();
                    }
                } else if (null != this.refreshTimer && this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer");
                    }
                    this.refreshTimer.stop();
                }
                this.saveAutoRefreshPref();
            }
        }
        if (bl) {
            db.info("calling dirty from action performed");
            this.setDirty();
        }
    }

    private void askUserToApply() {
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Is it OK to apply these changes?", (String)"Changes not applied")) {
            try {
                this.applyChangesToModel();
                this.resetDirty();
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        db.info("calling dirty from change update");
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        db.info("calling dirty from insert update");
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        db.info("calling dirty from remove update");
        this.setDirty();
    }

    private void setTraceModeComboBox(int n, boolean bl) {
        if (n == 0) {
            if (bl) {
                this.traceModeBox.setSelectedItem(TRACE_OFF);
            }
            this.setExpected(true);
        } else if (n == 1 || n == 3) {
            if (bl) {
                this.traceModeBox.setSelectedItem(TRACE_AUTO);
            }
            this.setExpected(false);
        } else {
            if (bl) {
                this.traceModeBox.setSelectedItem(TRACE_MANUAL);
            }
            this.setExpected(true);
        }
        boolean bl2 = this.getUiModel() instanceof DwdmModuleModel && ((DwdmModuleModel)this.getUiModel()).isPolluceCard();
        int n2 = this.getEffectivePort();
        IGenericTraceLine iGenericTraceLine = this.getModel(n2);
        boolean bl3 = false;
        if (iGenericTraceLine != null && iGenericTraceLine instanceof InterfaceModel) {
            try {
                IPortModel iPortModel = ((InterfaceModel)iGenericTraceLine).getPortModel();
                if (iPortModel instanceof TdmPortModel) {
                    bl3 = ((TdmPortModel)iPortModel).getTdmLineModel().isWISPort();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (n == 0 || this.getUiModel() instanceof OTU2XpModuleModel && this.paneMode == TraceMode.PATH) {
            this.disableAisBox.setSelected(false);
            this.disableAisBox.setEnabled(false);
            this.disableAis = false;
        } else if (bl2 && this.getName().equals("J1 Path Trace") && bl3) {
            this.disableAisBox.setEnabled(false);
            this.disableAisBox.setSelected(false);
            this.disableAis = false;
        } else if (n == 3 || n == 4) {
            int n3 = this.getEffectivePort();
            if (this.paneMode == TraceMode.TTI || this.isLineTerminated(n3)) {
                this.disableAisBox.setEnabled(this.isUserAuthorized());
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            } else if (this.isSectionTerminated(n3)) {
                this.disableAisBox.setEnabled(false);
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            } else {
                this.disableAisBox.setEnabled(false);
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            }
        } else {
            int n4 = this.getEffectivePort();
            if (this.paneMode == TraceMode.TTI || this.isLineTerminated(n4)) {
                this.disableAisBox.setEnabled(this.isUserAuthorized());
                this.disableAisBox.setSelected(false);
                this.disableAis = false;
            } else if (this.isSectionTerminated(n4)) {
                this.disableAisBox.setEnabled(false);
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            } else {
                this.disableAisBox.setEnabled(false);
                this.disableAisBox.setSelected(true);
                this.disableAis = true;
            }
        }
    }

    private int getTraceModeFromComboBox() {
        String string = (String)this.traceModeBox.getSelectedItem();
        int n = string.equals(TRACE_OFF) ? 0 : (string.equals(TRACE_AUTO) ? (this.disableAisBox != null && this.disableAis ? 3 : 1) : (this.disableAisBox != null && this.disableAis ? 4 : 2));
        return n;
    }

    private boolean isOTNStatusOff(int n) {
        boolean bl;
        block3: {
            bl = true;
            IGenericTraceLine iGenericTraceLine = this.getModel(n);
            if (iGenericTraceLine != null && (iGenericTraceLine instanceof DwdmTrkLineModel || iGenericTraceLine instanceof DwdmOTULineModel) && this.paneMode == TraceMode.TTI) {
                try {
                    bl = !((AbstractDwdmLineModel)iGenericTraceLine).getIOTULineModel().getOTNStatus();
                }
                catch (Exception exception) {
                    db.println("Caught Exception in isOTNStatusOff");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl;
    }

    private boolean isTransparentTermMode(int n) {
        InterfaceModel interfaceModel;
        boolean bl = false;
        if (this.paneMode == TraceMode.SECTION && this.getUiModel() instanceof DwdmModuleModel && (interfaceModel = this.get1stLowerModel(n)) != null && interfaceModel instanceof AbstractDwdmLineModel) {
            bl = ((AbstractDwdmLineModel)interfaceModel).isTransparent();
        }
        return bl;
    }

    private boolean sendTraceStringChanged() {
        return this.allowTransmit() && this.transmitField != null && this.transmitField.getText().length() > 0;
    }

    private boolean expectTraceStringChanged() {
        return this.allowExpect() && this.expectedField != null && this.expectedField.getText().length() > 0;
    }

    protected boolean isProtectLine(IGenericTraceLine iGenericTraceLine) {
        return iGenericTraceLine.isProtectLine();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        boolean bl = true;
        if (this.resetToDefaults) {
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"The trace fields have been reset to their factory defaults.\nThis might cause a loss of traffic.\n\nIs it OK to continue?", (String)"Reset to Defaults")) {
                this.remainDirty = true;
                bl = false;
            } else {
                this.resetToDefaults = false;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Setting the trace mode failed:\n");
        stringBuffer.append("Please check for the following incompatible conditions:\n");
        int n = this.getEffectivePort();
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (bl) {
            if (iGenericTraceLine == null) {
                bl = false;
            } else if (this.isProtectLine(iGenericTraceLine)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROTECT_LINE_NOT_PROV);
                this.refreshFromModel();
                bl = false;
            }
        }
        int n2 = this.getTraceModeFromComboBox();
        if (bl && this.modeChanged && n2 != this.oldState) {
            StringBuffer stringBuffer2;
            try {
                this.setTraceMode(n, n2);
                db.info("stop trace timer !");
                db.info("start trace timer !");
                db.info("Set TraceMode to: " + n2);
                this.oldState = n2;
            }
            catch (ConfigError configError) {
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append(stringBuffer);
                if (this.paneMode != TraceMode.TTI) {
                    stringBuffer2.append("1) The termination mode is transparent\n");
                } else {
                    stringBuffer2.append("1) The ITU-T G.709 flag is not enabled\n");
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)stringBuffer2.toString());
                this.remainDirty = true;
                bl = false;
            }
            catch (ProvisionError provisionError) {
                stringBuffer2 = new StringBuffer();
                stringBuffer2.append(stringBuffer);
                this.remainDirty = true;
                bl = false;
                if (this.getUiModel() instanceof ModuleModel) {
                    IPlatform iPlatform = ((ModuleModel)this.getUiModel()).getNodeModelDelegate().getPlatform();
                    if (iPlatform.is310ma() || iPlatform.is310maSDH()) {
                        stringBuffer2.append("1) Section trace can be provisioned on one port only\n");
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)stringBuffer2.toString());
                    } else if (provisionError.getEID().getId() == CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY.getId()) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY, (Object)((Object)provisionError));
                    } else {
                        ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, (Exception)((Object)provisionError));
                    }
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, (Exception)((Object)provisionError));
                }
            }
            catch (Exception exception) {
                db.severe("EXCEPTION SETTING SECTION STATE");
                SDebug.printStackTrace((Throwable)exception);
                this.remainDirty = true;
                throw new AnnotatedException("An error occurred while applying changes.", exception);
            }
        }
        if (bl) {
            char c;
            String string;
            String string2;
            boolean bl2;
            try {
                this.setTraceFormat(n, this.traceFormat);
            }
            catch (ProvisionError provisionError) {
                if (provisionError.getEID().getId() == CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY.getId()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NOT_SUPPORTED_ON_PROTECT_ENTITY, (Object)((Object)provisionError));
                } else {
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, (Exception)((Object)provisionError));
                }
                this.remainDirty = true;
                return;
            }
            catch (Exception exception) {
                db.severe("Exception on setting trace format " + this.traceFormat + " for line " + n);
                SDebug.printStackTrace((Throwable)exception);
                this.remainDirty = true;
                throw new AnnotatedException("An error occurred while setting the trace format.", exception);
            }
            boolean bl3 = this.sendTraceStringChanged();
            boolean bl4 = this.expectTraceStringChanged();
            boolean bl5 = bl3 || bl4;
            boolean bl6 = this.paneMode == TraceMode.TTI && bl5 && (this.isOTNStatusOff(n) || n2 == 0);
            boolean bl7 = bl2 = this.paneMode != TraceMode.TTI && bl5 && (this.isTransparentTermMode(n) || n2 == 0);
            if (bl6) {
                string2 = "The transmit and expected trace strings\nare ignored when the OTN status or trace mode is OFF.\n";
                IgnorableDialog.infoDialog((Component)((Object)this), (String)string2, (String)"Information", (String)"TTITraceInfoMessage", (String)"OTN TTI Trace Message");
            } else if (bl2) {
                string2 = "The transmit trace string is ignored\nwhen the termination mode is transparent or the trace mode is OFF.\nThe expected trace string is ignored when the trace mode is OFF\n";
                IgnorableDialog.infoDialog((Component)((Object)this), (String)string2, (String)"Information", (String)"SectionTraceInfoMessage", (String)"Section Trace Message");
            }
            if (bl3) {
                string2 = this.transmitField.getText();
                if (string2.length() > this.maxStringLength) {
                    string = string2.substring(0, this.maxStringLength);
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("The transmitted field is too long. Is it OK to truncate it to: " + string + "?"), (String)"Truncate String")) {
                        this.transmitField.setText(string);
                        string2 = string;
                    }
                }
                if (string2.length() <= this.maxStringLength) {
                    if (this.transHexRB.isSelected()) {
                        int n3 = Integer.parseInt(string2, 16);
                        c = (char)n3;
                        string2 = Character.toString(c);
                    }
                    if (db.on()) {
                        db.severe("Set Transmit Trace To:");
                        this.printBytes(string2.toCharArray());
                    }
                    try {
                        this.setSendTrace(n, string2);
                        this.transmitBytes = string2.toCharArray();
                    }
                    catch (Exception exception) {
                        db.severe("EXCEPTION SETTING TRANSMIT TEXT");
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)exception);
                        }
                        this.remainDirty = true;
                        throw new AnnotatedException("An error occurred while applying changes.", exception);
                    }
                }
            }
            if (bl4 && n2 != 1) {
                string2 = this.expectedField.getText();
                if (string2.length() > this.expMaxStringLength) {
                    string = string2.substring(0, this.expMaxStringLength);
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("The expected field is too long. Is it OK to truncate it to: " + string + "?"), (String)"Truncate String")) {
                        this.expectedField.setText(string);
                        string2 = string;
                    }
                }
                if (string2.length() <= this.expMaxStringLength) {
                    if (this.expHexRB.isSelected()) {
                        int n4 = Integer.parseInt(string2, 16);
                        c = (char)n4;
                        string2 = Character.toString(c);
                    }
                    if (db.on()) {
                        db.println("Set Expected Trace To:");
                        this.printBytes(string2.toCharArray());
                    }
                    try {
                        this.setExpectedTrace(n, string2);
                        this.expectedBytes = string2.toCharArray();
                    }
                    catch (Exception exception) {
                        db.severe("EXCEPTION SETTING EXPECTED TEXT");
                        SDebug.printStackTrace((Throwable)exception);
                        this.remainDirty = true;
                        throw new AnnotatedException("An error occurred while applying changes.", exception);
                    }
                }
            }
            this.remainDirty = false;
            this.modeChanged = false;
            if (this.transmitField != null) {
                this.transmitField.setText(null);
            }
            if (this.expectedField != null) {
                this.expectedField.setText(null);
            }
        }
    }

    private static void setSelected(JRadioButton jRadioButton, boolean bl) {
        if (jRadioButton != null) {
            jRadioButton.setSelected(bl);
        }
    }

    private static void setEnabled(JRadioButton jRadioButton, boolean bl) {
        if (jRadioButton != null) {
            jRadioButton.setEnabled(bl);
        }
    }

    @Override
    public void refreshFromModel() {
        int n;
        block31: {
            block30: {
                if (this.models == null || this.models.length == 0) {
                    return;
                }
                this.modeChanged = false;
                if (this.expectedField != null) {
                    this.expectedField.setText(null);
                }
                if (this.transmitField != null) {
                    this.transmitField.setText(null);
                }
                if (this.allowLevelChange()) {
                    this.setLevelValue();
                }
                this.setEffectivePort();
                n = this.getEffectivePort();
                db.info("Entering refreshFrom Model! for idx=" + n);
                if (this.supportC2Label) {
                    try {
                        byte by = this.getCurrentPayloadLabel(n);
                        this.receivedC2Label.setText("Received C2: 0x" + GenericTraceProvPane.hexFromByte((char)by));
                    }
                    catch (Exception exception) {
                        db.severe("failed to get payload code: " + exception);
                        SDebug.printStackTrace((Throwable)exception);
                    }
                } else {
                    db.info("Not supporting C2 label");
                }
                try {
                    this.changeFormat(this.getTraceFormat(n));
                    switch (this.traceFormat) {
                        case 0: {
                            GenericTraceProvPane.setSelected(this.trace64ByteRB, true);
                            break;
                        }
                        case 1: {
                            GenericTraceProvPane.setSelected(this.trace16ByteRB, true);
                            break;
                        }
                        default: {
                            GenericTraceProvPane.setSelected(this.trace1ByteRB, true);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    db.severe("failed to get trace format: " + exception);
                    if (!db.on()) break block30;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.allowTransmit()) {
                try {
                    this.transmitBytes = this.getSendTrace(n);
                }
                catch (Exception exception) {
                    db.severe("failed to get transmit section trace: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.updateDisplay(TRANSMIT_SWITCH, false);
            } else {
                db.info("Not allowing transmit");
            }
            if (this.allowExpect()) {
                try {
                    this.expectedBytes = this.getExpectedTrace(n);
                }
                catch (Exception exception) {
                    db.severe("failed to get expected section trace: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.updateDisplay(EXPECTED_SWITCH, false);
            } else {
                db.info("Not allowing expect");
            }
            try {
                this.oldState = this.getTraceMode(n);
            }
            catch (Exception exception) {
                db.severe("failed to get section trace mode: " + exception);
                if (!db.on()) break block31;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.allowReceived()) {
            try {
                this.receivedBytes = this.getReceivedTrace(n);
            }
            catch (Exception exception) {
                db.severe("failed to get received section trace: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            this.updateDisplay(RECEIVED_SWITCH, false);
        } else {
            db.info("Not allowing received");
        }
        if (db.on()) {
            db.println("GET SEND BYTES:");
            this.printBytes(this.transmitBytes);
            db.println("GET EXPECTED BYTES:");
            this.printBytes(this.expectedBytes);
        }
        db.info("TraceFormat is " + this.traceFormat + " for " + this.paneMode);
        db.info("TraceMode is " + this.oldState + " for " + this.paneMode);
        this.setTraceModeComboBox(this.oldState, true);
        this.resetDirty();
        if (this.models != null && n >= 0 && n < this.models.length) {
            this.disableProvisioning(n, this.oldState, this.models[n].isProtectLine());
        }
        db.info("Complete refreshFrom Model! idx=" + n);
    }

    @Override
    public void dispose() {
        if (db.on()) {
            db.println("called dispose");
        }
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
        }
        this.refreshTimer = null;
        this.stopObserving();
        super.dispose();
    }

    private void stopObserving() {
        if (this.models != null) {
            for (int i = 0; i < this.models.length; ++i) {
                this.models[i].deleteObserver((Observer)((Object)this));
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.refreshTimer != null && this.refreshTimer.isRunning()) {
            this.refreshTimer.stop();
        }
        if (null != this.autoRefreshCB) {
            this.saveAutoRefreshPref();
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        this.refreshFromModel();
        this.setDirty(false);
        String string = this.paneMode == TraceMode.SECTION ? autoRefSecPrefKey : autoRefTTIPrefKey;
        boolean bl = Preferences.instance().getBoolean(autoRefreshPrefPath, string, false);
        if (null != this.autoRefreshCB) {
            this.autoRefreshCB.setSelected(bl);
            if (null != this.refreshTimer) {
                if (this.autoRefreshCB.isSelected() && !this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.");
                    }
                    this.refreshTimer.start();
                } else if (this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.");
                    }
                    this.refreshTimer.stop();
                }
            }
        }
    }

    protected void disableProvisioning(int n, int n2, boolean bl) {
        boolean bl2 = !bl && this.isUserAuthorized();
        boolean bl3 = this.getUiModel() instanceof DwdmModuleModel && ((DwdmModuleModel)this.getUiModel()).isPolluceCard();
        this.traceModeBox.setEnabled(bl2);
        if (n2 != 0 && this.isLineTerminated(n) && (!(this.getUiModel() instanceof OTU2XpModuleModel) && !bl3 || this.paneMode != TraceMode.PATH)) {
            this.disableAisBox.setEnabled(bl2);
        }
        this.transmitField.setEditable(bl2);
        this.expectedField.setEditable(bl2);
        GenericTraceProvPane.setEnabled(this.trace1ByteRB, bl2);
        GenericTraceProvPane.setEnabled(this.trace16ByteRB, bl2);
        GenericTraceProvPane.setEnabled(this.trace64ByteRB, bl2);
        this.factoryDefaultButton.setEnabled(bl2);
    }

    @Override
    protected void refreshMyLines(final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (object instanceof Ec1LineUpdate) {
                    GenericTraceProvPane.this.refreshMyLines((IGenericTraceLine[])((Ec1LineUpdate)object).getModels());
                } else if (object instanceof OcnLineUpdate) {
                    GenericTraceProvPane.this.refreshMyLines((IGenericTraceLine[])((OcnLineUpdate)object).getModels());
                } else if (object instanceof DwdmLineUpdate) {
                    DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
                    if (GenericTraceProvPane.this.paneMode == TraceMode.TTI) {
                        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)GenericTraceProvPane.this.getUiModel();
                        if (dwdmModuleModel.isADMCard()) {
                            GenericTraceProvPane.this.refreshMyLines(dwdmModuleModel.removeIlkTrkLineModels(dwdmModuleModel.getAdmDwdmTrkLineModels()));
                        } else {
                            GenericTraceProvPane.this.refreshMyLines(dwdmLineUpdate.getDwdmOTNSupportLineModels());
                        }
                    } else if (dwdmLineUpdate.getTdmLineModels() != null && dwdmLineUpdate.getTdmLineModels().length > 0) {
                        if (db.on) {
                            db.println("refreshMyLines");
                        }
                        GenericTraceProvPane.this.refreshMyLines(dwdmLineUpdate.getTdmLineModels());
                    }
                }
            }
        });
    }

    public void refreshMyLines(IGenericTraceLine[] iGenericTraceLineArray) {
        this.stopObserving();
        this.models = iGenericTraceLineArray;
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i].addObserver((Observer)((Object)this));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (GenericTraceProvPane.db.on) {
                db.println("refreshMyLines isEventDispatchThread");
            }
            this.updateIfCB();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (db.on) {
                        db.println("refreshMyLines invokeLater");
                    }
                    GenericTraceProvPane.this.updateIfCB();
                }
            });
        }
    }

    private void updateIfCB() {
        if (this.ifCB != null) {
            String[] stringArray;
            if (GenericTraceProvPane.db.on) {
                db.println("updateIfCB");
            }
            this.ifCB.removeActionListener(this);
            this.ifCB.removeAllItems();
            String[] stringArray2 = this.getPortNames();
            if (stringArray2.length > 0) {
                block13: {
                    stringArray = modeChoices;
                    try {
                        if (this.getUiModel() instanceof ModuleModel && !((ModuleModel)this.getUiModel()).supportsAutoTrace()) {
                            stringArray = manualModeChoices;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        db.println("Caught CmsNoSuchEntity in createTraceModePanel");
                        if (!GenericTraceProvPane.db.on) break block13;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                this.traceModeBox.removeActionListener(this);
                this.traceModeBox.removeAllItems();
                if (GenericTraceProvPane.db.on) {
                    db.println("updateIfCB traceModeBox empty");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    this.traceModeBox.addItem(stringArray[i]);
                    if (!GenericTraceProvPane.db.on) continue;
                    db.println("updateIfCB traceModeBox added " + stringArray[i]);
                }
            } else {
                this.traceModeBox.removeActionListener(this);
                this.traceModeBox.removeAllItems();
                if (GenericTraceProvPane.db.on) {
                    db.println("updateIfCB traceModeBox empty");
                }
                stringArray = new String[1];
                this.traceModeBox.addItem(stringArray[0]);
                if (GenericTraceProvPane.db.on) {
                    db.println("updateIfCB traceModeBox added fake item");
                }
            }
            this.traceModeBox.addActionListener(this);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (GenericTraceProvPane.db.on) {
                    db.println("updateIfCB adding item " + stringArray2[i]);
                }
                this.ifCB.addItem(stringArray2[i]);
            }
            this.ifCB.addActionListener(this);
            this.refreshFromModel();
        }
    }

    private boolean isSectionTerminated(int n) {
        InterfaceModel interfaceModel;
        boolean bl = true;
        if (this.getUiModel() instanceof DwdmModuleModel && (interfaceModel = this.get1stLowerModel(n)) != null && interfaceModel instanceof AbstractDwdmLineModel) {
            bl = ((AbstractDwdmLineModel)interfaceModel).isSectionTerminated();
        }
        return bl;
    }

    private boolean isLineTerminated(int n) {
        InterfaceModel interfaceModel;
        boolean bl = true;
        if (this.getUiModel() instanceof DwdmModuleModel && (interfaceModel = this.get1stLowerModel(n)) != null && interfaceModel instanceof AbstractDwdmLineModel) {
            bl = ((AbstractDwdmLineModel)interfaceModel).isLineTerminated();
        }
        return bl;
    }

    private byte getCurrentPayloadLabel(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        byte by = 0;
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null) {
            by = iGenericTraceLine.getCurrentPayloadLabel();
        }
        return by;
    }

    public void setTraceMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError, ProvisionError {
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null) {
            iGenericTraceLine.setTraceMode(n2);
        }
    }

    public int getTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        int n2 = 0;
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null) {
            n2 = iGenericTraceLine.getTraceMode();
        }
        return n2;
    }

    private void setSendTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, ConfigError {
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null) {
            iGenericTraceLine.setSendTrace(string);
        }
    }

    private char[] getSendTrace(int n) {
        char[] cArray;
        block3: {
            cArray = "<comm error>".toCharArray();
            IGenericTraceLine iGenericTraceLine = this.getModel(n);
            try {
                if (iGenericTraceLine != null) {
                    cArray = iGenericTraceLine.getSendTraceAsTrace().getTrace();
                }
            }
            catch (Exception exception) {
                db.println("Caught Exception in getSendTrace");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    private void setExpectedTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, ConfigError {
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null) {
            iGenericTraceLine.setExpectedTrace(string);
        }
    }

    private char[] getExpectedTrace(int n) {
        char[] cArray;
        block3: {
            cArray = "<comm error>".toCharArray();
            IGenericTraceLine iGenericTraceLine = this.getModel(n);
            try {
                if (iGenericTraceLine != null) {
                    cArray = iGenericTraceLine.getExpectedTraceAsTrace().getTrace();
                }
            }
            catch (Exception exception) {
                db.println("Caught Exception in getExpectedTrace");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    private char[] getReceivedTrace(int n) {
        char[] cArray;
        block5: {
            cArray = "<comm error>".toCharArray();
            IGenericTraceLine iGenericTraceLine = this.getModel(n);
            try {
                if (iGenericTraceLine != null) {
                    cArray = iGenericTraceLine.canRequestReceivedTrace() ? (this.oldState != 0 ? iGenericTraceLine.getReceivedTraceAsTrace().getTrace() : REC_RETRIEVE_NOT_ATTEMPTED_OFF.toCharArray()) : REC_RETRIEVE_NOT_ATTEMPTED.toCharArray();
                }
            }
            catch (InternalCommError internalCommError) {
                db.println("Caught InternalCommError in getReceivedTrace");
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)internalCommError);
                }
            }
            catch (Exception exception) {
                db.println("Caught Exception in getReceivedTrace");
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return cArray;
    }

    private void setTraceFormat(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, ConfigError, Exception {
        if (this.models != null && n >= 0 && n < this.models.length) {
            int n3 = this.paneMode.modulateTraceFormat(n2);
            if (n3 == -1) {
                throw new Exception("The selected trace format is invalid.");
            }
            this.models[n].setTraceFormat(n3);
        } else {
            db.println("Could not set trace format for index " + n);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)new Exception());
            }
        }
    }

    private int getTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, Exception {
        int n2 = 0;
        if (this.models != null && n >= 0 && n < this.models.length) {
            n2 = this.models[n].getTraceFormat();
        } else {
            db.println("Could not get trace format for index " + n);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)new Exception());
            }
        }
        int n3 = this.paneMode.demodulateTraceFormat(n2);
        if (n3 == -1) {
            throw new Exception("The retrieved trace format is invalid.");
        }
        return this.paneMode.demodulateTraceFormat(n2);
    }

    private String[] getPortNames() {
        String[] stringArray = new String[this.models.length];
        for (int i = 0; i < this.models.length; ++i) {
            if (!(this.models[i] instanceof InterfaceModel)) continue;
            try {
                TdmLineModel tdmLineModel;
                IPortModel iPortModel = ((InterfaceModel)this.models[i]).getPortModel();
                stringArray[i] = PortHelper.getPortNumAndTypeString((IPortModel)iPortModel, (boolean)false, (boolean)false) + PortHelper.getFormattedPortAlias((IPortModel)iPortModel);
                if (!(iPortModel.getModuleModel() instanceof DwdmModuleModel) || !((DwdmModuleModel)iPortModel.getModuleModel()).isPolluceCard() || iPortModel.getEqType() != 61 || !(tdmLineModel = ((TdmPortModel)iPortModel).getTdmLineModel()).isWISPort()) continue;
                PortModel portModel = (PortModel)tdmLineModel.getParentForWISLineModel().getPortModel();
                stringArray[i] = PortHelper.getPortNumAndTypeString((IPortModel)portModel, (boolean)false, (boolean)false) + PortHelper.getFormattedPortAlias((IPortModel)iPortModel);
                stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1) + "-WIS)";
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                stringArray[i] = "<error>";
            }
        }
        return stringArray;
    }

    private int getEffectivePort() {
        return this.effectivePort;
    }

    private void setEffectivePort() {
        this.effectivePort = 0;
        if (this.ifCB != null && this.ifCB.getSelectedIndex() != -1) {
            this.effectivePort = this.ifCB.getSelectedIndex();
            db.fine("setEffectivePort():" + this.effectivePort);
        } else if (this.ifCB == null) {
            db.severe("null ifCB");
        } else {
            db.severe("ifCB selected index:" + this.ifCB.getSelectedIndex());
        }
    }

    private void setLevelValue() {
        for (int i = 0; i < this.models.length; ++i) {
            if (!(this.models[i] instanceof DwdmTrkLineModel) && !(this.models[i] instanceof DwdmOTULineModel)) continue;
            try {
                ((AbstractDwdmLineModel)this.models[i]).getIOTULineModel().setMonitoringLevel(this.lvlCB.getSelectedIndex());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
    }

    @Override
    public boolean queryRemainDirty() {
        return this.remainDirty;
    }

    private IGenericTraceLine getModel(int n) {
        IGenericTraceLine iGenericTraceLine = null;
        if (this.models != null && n >= 0 && n < this.models.length) {
            iGenericTraceLine = this.models[n];
        } else {
            db.println("Could not get model for index " + n);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)new Exception());
            }
        }
        return iGenericTraceLine;
    }

    private InterfaceModel get1stLowerModel(int n) {
        IGenericTraceLine iGenericTraceLine = this.getModel(n);
        if (iGenericTraceLine != null && iGenericTraceLine instanceof InterfaceModel) {
            return ((InterfaceModel)iGenericTraceLine).getFirstLowerLayerModels();
        }
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        if (this.paneMode == TraceMode.SECTION) {
            return CSHelpConst.DwdmSectionTraceProvPane;
        }
        if (this.paneMode == TraceMode.PATH) {
            return CSHelpConst.DwdmPathTraceProvPane;
        }
        return CSHelpConst.DwdmTTIProvPane;
    }

    private class TraceTextField
    extends JTextField {
        private String hexString = "0123456789abcdefABCDEF";
        public static final int ASCII = 0;
        public static final int HEX = 1;
        private int traceTextMaxLength;
        private int fieldType;

        public TraceTextField(int n) {
            this.traceTextMaxLength = n;
            this.fieldType = 0;
            this.setColumns(this.traceTextMaxLength);
            Dimension dimension = super.getPreferredSize();
            super.setMinimumSize(dimension);
            super.setMaximumSize(dimension);
        }

        public void setMaxLength(int n) {
            this.traceTextMaxLength = n;
            this.setColumns(this.traceTextMaxLength);
            this.setText(GenericTraceProvPane.EMPTY_TRACE);
        }

        public void setType(int n) {
            if (n == 0) {
                this.fieldType = 0;
            } else if (n == 1) {
                this.fieldType = 1;
            }
        }

        @Override
        protected Document createDefaultModel() {
            return new TraceDocument();
        }

        private class TraceDocument
        extends PlainDocument {
            private TraceDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                int n2;
                if (string == null) {
                    return;
                }
                if (TraceTextField.this.fieldType == 1 && !this.isValidHexString(string)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                int n3 = this.getLength();
                if (n3 + (n2 = string.length()) > TraceTextField.this.traceTextMaxLength) {
                    int n4 = TraceTextField.this.traceTextMaxLength - n3;
                    super.insertString(n, string.substring(0, n4), attributeSet);
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    super.insertString(n, string, attributeSet);
                }
            }

            private boolean isValidHexString(String string) {
                boolean bl = true;
                for (int i = 0; bl && i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (TraceTextField.this.hexString.indexOf(c) != -1) continue;
                    bl = false;
                }
                return bl;
            }
        }
    }
}

