/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.uts;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.uts.UtsFmecCardGraphic;
import cerent.util.gui.IconImpl;
import com.cisco.ctcutsX.ui.shelf.ShelfLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Uts2ShelfLayout
extends ShelfLayout {
    private static final int SHELF_SLOT_COUNT = 3;
    private static final int FAN_SLOT_NO = 20;
    private static final int POWER_SLOT_NO = 30;
    private static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    private static final Font TEXT_FONT = new Font("Arial", 0, Math.round(130.0f));
    private static final Font labelFont = new Font("Arial", 0, 10);
    protected JPanel fmecPanel;
    private static Class thisClass = Uts2ShelfLayout.class;
    private static ImageIcon usbIcon = new ImageIcon(thisClass.getResource("/images/uts2usb.gif"));
    private static ImageIcon lcdIcon = new ImageIcon(thisClass.getResource("/images/uts2lcd.gif"));
    private static ImageIcon powerIcon = new ImageIcon(thisClass.getResource("/images/uts2Power.gif"));

    public Uts2ShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        super(iChassisModel, shelfViewController);
    }

    @Override
    public int getShelfSlotCount() {
        return 3;
    }

    @Override
    protected Font getTextFont() {
        return TEXT_FONT;
    }

    @Override
    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel();
            this.labelsPanel.setLayout(new GridLayout(3, 1, 0, 0));
            this.labelsPanel.setBorder(THIN_BORDER);
            Dimension dimension = new Dimension(10, 28);
            this.labels = new JLabel[3];
            for (int i = 2; i >= 0; --i) {
                JLabel jLabel = new JLabel("" + (i + 1));
                jLabel.setFont(labelFont);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                this.labels[i] = jLabel;
                this.labelsPanel.add(jLabel);
            }
        }
    }

    @Override
    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel();
        this.slotsPanel.setLayout(new BoxLayout(this.slotsPanel, 1));
        Dimension dimension = new Dimension(390, Math.round(28.363636f));
        for (int i = this.cards.length - 1; i >= 0; --i) {
            IconImpl iconImpl = new IconImpl(dimension);
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.slotsPanel.add(this.cards[i]);
        }
        this.createFmecPanel();
    }

    protected void createFmecPanel() {
        this.fmecPanel = new JPanel();
        this.fmecPanel.setLayout(new BoxLayout(this.fmecPanel, 0));
        int n = Math.round(85.09091f);
        this.fmecPanel.setBorder(THIN_BORDER);
        Dimension dimension = new Dimension(n / 3 + 10, n * 1 / 2 - 7);
        Dimension dimension2 = new Dimension(n / 3 + 10, n * 1 / 2 + 7);
        Dimension dimension3 = new Dimension(n / 3 + 10, n);
        EntityModel entityModel = this.getModuleEntityForSlot(20);
        UtsFmecCardGraphic utsFmecCardGraphic = new UtsFmecCardGraphic(entityModel, (AbstractShelfLayout)this, dimension3);
        utsFmecCardGraphic.setDimension(dimension3);
        CardPanel cardPanel = new CardPanel(utsFmecCardGraphic, this);
        cardPanel.setLayout(new FlowLayout(1));
        cardPanel.add(new JLabel(lcdIcon));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(THIN_BORDER);
        jPanel.setPreferredSize(dimension3);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.white);
        JLabel jLabel = new JLabel(usbIcon);
        jLabel.setToolTipText("USBP A/EMS/Bits I/0");
        jPanel2.setPreferredSize(dimension2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        EntityModel entityModel2 = this.getModuleEntityForSlot(30);
        UtsFmecCardGraphic utsFmecCardGraphic2 = new UtsFmecCardGraphic(entityModel2, (AbstractShelfLayout)this, dimension);
        CardPanel cardPanel2 = new CardPanel(utsFmecCardGraphic2, this);
        cardPanel2.setLayout(new FlowLayout(1));
        cardPanel2.add(new JLabel(powerIcon));
        jPanel.add(cardPanel2);
        this.fmecPanel.add(jPanel);
        this.fmecPanel.add(cardPanel);
    }

    public EntityModel getModuleEntityForSlot(int n) {
        List list = null;
        try {
            list = ((ChassisModel)this.chassis).getEntityTableModel().getEntityModelBySlot((IChassisModel)this.chassis, n).getChildren();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
        }
        if (list != null && list.size() > 0) {
            return (EntityModel)list.get(0);
        }
        return null;
    }

    @Override
    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    @Override
    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addFmecPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
    }

    private void addFmecPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.fmecPanel, gridBagConstraints);
        this.add(this.fmecPanel);
    }
}

