/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BERTModel;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WbeModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ComboCardMaintPane;
import cerent.cms.ui.ComboCardPmPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.wbe.WbeCardBertMainPane;
import cerent.cms.ui.wbe.WbeProvPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class WbeCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList _ds3LinesList;
    private ArrayList _ec1LinesList;
    private BbeSlot _bbeSlot;
    private Ds123LineModel[] _ds1Lines;

    public WbeCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    @Override
    protected void init() {
        int n;
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = wbeModuleModel.getDs3Lines();
        this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        int n2 = ds123LineModelArray.length;
        TdmLineModel[] tdmLineModelArray = wbeModuleModel.getEc1Lines();
        this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        int n3 = tdmLineModelArray.length;
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n3 + n2));
        for (n = 0; n < n2; ++n) {
            this.addContainerMap(ds123LineModelArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.addContainerMap(tdmLineModelArray[n]);
        }
        try {
            this._bbeSlot = wbeModuleModel.getBbeSlot();
            this.getOM().addObservable((Observable)((Object)this._bbeSlot));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this._bbeSlot = null;
        }
        this._ds1Lines = wbeModuleModel.getDs1Lines();
        this.getOM().setActive(true);
        this.getOM().setPassing(true);
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this._ds3LinesList.toArray(new Ds123LineModel[this._ds3LinesList.size()]);
    }

    private TdmLineModel[] getEc1LinesArray() {
        return this._ec1LinesList.toArray(new TdmLineModel[this._ec1LinesList.size()]);
    }

    @Override
    protected List addModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList;
        block2: {
            Model[] modelArray;
            IPortContainer iPortContainer;
            block3: {
                WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
                arrayList = new ArrayList<ModuleModelUpdate>();
                if (!(observable instanceof BbeSlot)) break block2;
                iPortContainer = (IPortContainer)((Object)observable);
                Model[] modelArray2 = wbeModuleModel.getDs3Lines();
                modelArray = wbeModuleModel.getEc1Lines();
                if (modelArray2.length <= this._ds3LinesList.size()) break block3;
                this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray2));
                this.getOM().addObservable((Observable[])modelArray2);
                arrayList.add(new Ds3LineUpdate(modelArray2, iPortContainer));
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                break block2;
            }
            if (modelArray.length <= this._ec1LinesList.size()) break block2;
            this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
            this.getOM().addObservable((Observable[])modelArray);
            arrayList.add(new Ec1LineUpdate(modelArray, iPortContainer));
            Iterator iterator = iPortContainer.getContainedPorts().iterator();
            while (iterator.hasNext()) {
                this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
            }
        }
        return arrayList;
    }

    @Override
    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        if (observable instanceof IInterfaceModel) {
            this.removeContainerMap((IInterfaceModel)observable);
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof Ds123LineModel && this._ds3LinesList.remove(observable)) {
            arrayList.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
        } else if (observable instanceof TdmLineModel && this._ec1LinesList.remove(observable)) {
            arrayList.add(new Ec1LineUpdate(this.getEc1LinesArray(), iPortContainer));
        }
        return arrayList;
    }

    @Override
    public Pane getMaintenanceTab() {
        ComboCardMaintPane comboCardMaintPane = new ComboCardMaintPane("Maintenance", (CardTabbedView)this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray());
        comboCardMaintPane.setBertPane(this.getBertTab());
        return comboCardMaintPane;
    }

    private Pane getBertTab() {
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = wbeModuleModel.getDs3Lines();
        BERTModel bERTModel = new BERTModel();
        ProtCardDualPane protCardDualPane = new ProtCardDualPane(this, (WbeModuleModel)this.getUiModel(), new WbeCardBertMainPane("BERT", this, ds123LineModelArray, this._ds1Lines, bERTModel));
        return protCardDualPane;
    }

    @Override
    public Pane getProvTab() {
        return new WbeProvPane("Provisioning", this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray());
    }

    @Override
    public Pane getPerformanceTab() {
        return new ComboCardPmPane("Performance", (CardTabbedView)this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray());
    }

    @Override
    public void destroy() {
        this._ds3LinesList.clear();
        this._ec1LinesList.clear();
        this._ds1Lines = null;
        super.destroy();
    }
}

