/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.idl.Ds123Media.eBertMode;
import cerent.cms.idl.Ds123Media.eTrafficPattern;
import cerent.cms.idl.Ds123Media.portBertConfig;
import cerent.cms.model.BERTModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.wbe.WbeDs1BertTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class WbeDs1BertPane
extends NodeProvPane
implements TableModelListener {
    protected INodeModel node;
    protected Ds123LineModel[] lineModels = null;
    int numLines = 0;
    protected WbeDs1BertTableModel dataModel = null;
    BERTModel bm = null;
    ObservableManager _obsMgr;
    Observer _observer = null;
    private static final SDebug db = new SDebug("WbeDs1BertPane");

    public WbeDs1BertPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, BERTModel bERTModel) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        TableColumn tableColumn = null;
        this.lineModels = ds123LineModelArray;
        if (ds123LineModelArray == null) {
            db.severe("<constructor> Ds123 Lines are null");
            this.numLines = 0;
        } else {
            this.numLines = ds123LineModelArray.length;
        }
        this.bm = bERTModel;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        String[] stringArray = new String[]{"PRBS15", "PRBS20", "PRBS23", "QRSS", "Alt1s0s"};
        JComboBox<String> jComboBox = new JComboBox<String>();
        TableColumn tableColumn2 = this.table.getColumn(this.dataModel.getColumnName(2));
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        jComboBox.setEditable(false);
        tableColumn2.setCellEditor(new DefaultCellEditor(jComboBox));
        String[] stringArray2 = new String[]{"None", "TPGM-L", "TPGM-B"};
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        TableColumn tableColumn3 = this.table.getColumn(this.dataModel.getColumnName(1));
        for (int i = 0; i < stringArray2.length; ++i) {
            jComboBox2.addItem(stringArray2[i]);
        }
        jComboBox2.setEditable(false);
        tableColumn3.setCellEditor(new DefaultCellEditor(jComboBox2));
        this.add((Component)uScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.registerWithModel();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            db.severe("getDataModel(): Ds123 Lines are null");
            return;
        }
        int n = 0;
        int n2 = this.numLines - 1;
        if (n != -1) {
            n = tableModelEvent.getFirstRow() < 0 ? 0 : tableModelEvent.getFirstRow();
            n2 = tableModelEvent.getLastRow() > this.numLines ? this.numLines - 1 : tableModelEvent.getLastRow();
        }
        db.info("tableChanged: first/last row are " + n + "/" + n2);
        for (int i = n; i <= n2; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            db.info(" rows are dirty");
            this.setDirty();
            return;
        }
        db.info("No rows are dirty");
        this.resetDirty();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        Object object;
        int n;
        int n2 = 0;
        for (n = 0; n < this.numLines; ++n) {
            if (!this.dataModel.isRowDirty(n) || (object = this.dataModel.getModeFromRow(n)).value() == 0) continue;
            ++n2;
        }
        if (n2 > 1) {
            CerentDialog.errorDialog((Component)((Object)this), (String)ErrorMsg.getString((EID)EMC.EID_BERT_INVALID_CONF), (String)"BERT Error Dialog");
            return;
        }
        for (n = 0; n < this.numLines; ++n) {
            if (!this.dataModel.isRowDirty(n)) continue;
            object = this.lineModels[n].getBERTConfig();
            eTrafficPattern eTrafficPattern2 = ((portBertConfig)object).pattern;
            eBertMode eBertMode2 = ((portBertConfig)object).mode;
            eBertMode eBertMode3 = this.dataModel.getModeFromRow(n);
            eTrafficPattern eTrafficPattern3 = this.dataModel.getPatternFromRow(n);
            if (eBertMode2.value() == 0 && eBertMode3.value() != 0 && this.lineModels[n].hasCircuitInterfaces()) {
                CerentDialog.warningDialog((Component)((Object)this), (String)ErrorMsg.getString((EID)EMC.WID_TRAFF_LOSS), (String)"Warning");
            }
            this.lineModels[n].setBERT(eBertMode3, eTrafficPattern3);
            break;
        }
        this.resetDirty();
    }

    protected WbeDs1BertTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new WbeDs1BertTableModel(iNodeModel, this.lineModels, this.bm);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.WbeDs1BertPane;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void refreshFromModel() {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (db.on()) {
                db.info("Recieved Ds3LineUpdate");
            }
            this.lineModels = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
            this.numLines = this.lineModels.length;
            this.dataModel.refreshMyLines(this.lineModels);
        } else if (object instanceof Ec1LineUpdate && db.on()) {
            db.fine("Recieved Ec1LineUpdate");
        } else if (db.on()) {
            db.fine("Recieved " + object);
        }
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
        super.registerWithModel();
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        this.unregisterWithModel();
        super.dispose();
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                WbeDs1BertPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            db.info("Refreshing Line " + n);
            this.dataModel.refreshLineFromModel(n);
        } else {
            db.info("In Ds123LineProvPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }
}

