/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.wxc.WxcMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class WxcMaintenanceTabPane
extends AbstractPane
implements ActionListener {
    private JPanel mainPanel;
    private JTextField actualTextField;
    private JTextField powerTextField;
    private JTextField voaTextField;
    private JComboBox portComboBox;
    private JComboBox waveLengthComboBox;
    private JButton refreshButton;
    private JButton clearButton;
    private WxcMaintenancePane parent;
    private OpticsLineModel comTxModel;
    private OpticsLineModel portAddModel;
    private Attribute wave = null;
    private String powerStr = "";
    private String voaStr = "";
    private String actualStr = "";
    private int portIndex = 0;
    private boolean isChannelActive = false;
    private boolean isAuthUser = false;
    private OpticsLineModel portExpModel;
    private static String OVERLOAD_STR = "Overload";
    private static String LIMIT_OVERLOAD_STR = "100000.0";
    private static String NA_VALUE = "-100000.0";
    private static String NA_STR = "N/A";

    public WxcMaintenanceTabPane(String string, TabbedView tabbedView, WxcMaintenancePane wxcMaintenancePane, OpticsLineModel[] opticsLineModelArray) {
        super(string, tabbedView);
        this.parent = wxcMaintenancePane;
        this.isAuthUser = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        this.initComponents();
        this.init();
        this.portComboBox.setModel(this.createDefaultPort(opticsLineModelArray));
    }

    protected void init() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.retValuePanelInit();
        this.insertValuePanelInit();
        this.add(this.mainPanel);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.actualTextField = new JTextField();
        this.powerTextField = new JTextField();
        this.portComboBox = new JComboBox();
        this.voaTextField = new JTextField();
        this.refreshButton = new JButton("Refresh");
        this.clearButton = new JButton("Delete");
    }

    private JPanel getRefreshButtonPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setLayout(new GridBagLayout());
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(this);
        jPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(this);
        jPanel.add((Component)this.clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jLabel.setText("Auto-refresh:");
        return jPanel;
    }

    private void insertValuePanelInit() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jLabel.setText("Target Power (dBm)");
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 10, 10), 0, 0));
        this.powerTextField.setText("");
        this.powerTextField.addActionListener(this);
        this.powerTextField.setMaximumSize(new Dimension(100, 20));
        jPanel.add((Component)this.powerTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 10), 0, 0));
        jLabel2.setText("Input Port");
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.portComboBox.setMaximumSize(new Dimension(100, 20));
        this.portComboBox.addActionListener(this);
        jPanel.add((Component)this.portComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jPanel2.setLayout(new GridBagLayout());
        jLabel4.setText("VOA Attenuation (dB)");
        jLabel4.setHorizontalAlignment(2);
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        this.voaTextField.setMaximumSize(new Dimension(100, 20));
        this.voaTextField.addActionListener(this);
        jPanel2.add((Component)this.voaTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jLabel3.setText("Wavelength");
        jLabel3.setHorizontalAlignment(2);
        jPanel2.add((Component)jLabel3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        this.waveLengthComboBox = new JComboBox();
        this.waveLengthComboBox.setModel(new DefaultComboBoxModel<Attribute>(((OpticsModuleModel)this.getUiModel()).getSupportedWavelengths()));
        this.waveLengthComboBox.setEditable(false);
        this.waveLengthComboBox.setMaximumSize(new Dimension(100, 20));
        this.waveLengthComboBox.addActionListener(this);
        jPanel2.add((Component)this.waveLengthComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
        jPanel3.setBorder(new TitledBorder("Insert Value"));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.mainPanel.add((Component)jPanel3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 50, 0), 0, 0));
    }

    private void retValuePanelInit() {
        JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setText("Actual Power (dBm):");
        jLabel.setHorizontalAlignment(2);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 0, 10), 0, 0));
        this.actualTextField.setPreferredSize(new Dimension(100, 20));
        this.actualTextField.setEditable(false);
        jPanel2.add((Component)this.actualTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("                  ");
        jPanel2.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.setBorder(new TitledBorder("Return Value COM-TX on selected Wavelength"));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jPanel2);
        jPanel.add(this.getRefreshButtonPanel());
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 50, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.getMaintenanceChanelPower(this.comTxModel);
            this.resetModel();
            return;
        }
        if (object == this.clearButton) {
            this.disaMaintenanceChanelPower(this.comTxModel);
            this.isChannelActive = false;
            this.clearActualPwrField();
            this.updateButtons();
        }
        if (object == this.portComboBox) {
            Attribute attribute = (Attribute)this.portComboBox.getSelectedItem();
            try {
                if (attribute.getKey().contains("ADD-RX")) {
                    this.voaStr = this.portAddModel.defaultVOAAttenuationMaintenance();
                    this.voaTextField.setText(this.voaStr);
                } else {
                    this.voaStr = this.portExpModel.defaultVOAAttenuationMaintenance();
                    this.voaTextField.setText(this.voaStr);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
            }
        }
        this.parent.enableApply(this.isAuthUser);
    }

    @Override
    public void enteringPage() throws Exception {
        this.getMaintenanceChanelPower(this.comTxModel);
        this.resetModel();
    }

    @Override
    public void refresh() {
    }

    public void updateModel() {
        int n;
        int n2;
        if (this.voaTextField.getText().trim().length() == 0 || this.powerTextField.getText().trim().length() == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FIELD_IS_REQUIRED_PARAM_1, (Object)"Target Power and Voa Attenuation");
            return;
        }
        try {
            n2 = this.convertStringToPwr(this.voaTextField.getText());
            n = this.convertStringToPwr(this.powerTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_INPUT);
            return;
        }
        if (this.isChannelActive) {
            try {
                Attribute attribute = (Attribute)this.portComboBox.getSelectedItem();
                this.setMaintenanceChanelPower(attribute.getIntValue(), n, n2, (Attribute)this.waveLengthComboBox.getSelectedItem());
                this.portIndex = attribute.getIntValue();
                this.wave = (Attribute)this.waveLengthComboBox.getSelectedItem();
                this.powerStr = this.powerTextField.getText();
                this.voaStr = this.voaTextField.getText();
                this.clearActualPwrField();
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayDetailed((Component)((Object)this), provisionError.getEID(), provisionError.getEIDMsg());
                return;
            }
            catch (FeatureUnsupported featureUnsupported) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, (Exception)((Object)featureUnsupported));
                return;
            }
        }
        try {
            Attribute attribute = (Attribute)this.portComboBox.getSelectedItem();
            this.enaMaintenanceChanelPower(attribute.getIntValue(), n, n2, (Attribute)this.waveLengthComboBox.getSelectedItem());
            this.portIndex = attribute.getIntValue();
            this.wave = (Attribute)this.waveLengthComboBox.getSelectedItem();
            this.powerStr = this.powerTextField.getText();
            this.voaStr = this.voaTextField.getText();
            this.clearActualPwrField();
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayDetailed((Component)((Object)this), provisionError.getEID(), provisionError.getEIDMsg());
            return;
        }
        catch (FeatureUnsupported featureUnsupported) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, (Exception)((Object)featureUnsupported));
            return;
        }
        this.isChannelActive = true;
        this.updateButtons();
    }

    public void resetModel() {
        String string = this.voaStr;
        this.powerTextField.setText(this.powerStr);
        if (this.actualStr.equals(LIMIT_OVERLOAD_STR)) {
            this.actualTextField.setText(OVERLOAD_STR);
        } else if (this.actualStr.equals(NA_VALUE)) {
            this.actualTextField.setText(NA_STR);
        } else {
            this.actualTextField.setText(this.actualStr);
        }
        if (this.portIndex != 0) {
            this.setSelectedPort(this.portIndex);
            this.waveLengthComboBox.setSelectedItem(this.wave);
        } else {
            this.portComboBox.setSelectedIndex(0);
            this.waveLengthComboBox.setSelectedIndex(0);
        }
        this.voaTextField.setText(string);
        this.updateButtons();
    }

    private DefaultComboBoxModel createDefaultPort(OpticsLineModel[] opticsLineModelArray) {
        Vector<Attribute> vector = new Vector<Attribute>();
        try {
            int n;
            for (n = 0; n < opticsLineModelArray.length; ++n) {
                if (!this.isWxc40Port(opticsLineModelArray[n])) continue;
                this.comTxModel = opticsLineModelArray[n];
                this.powerStr = this.comTxModel.defaultPTargetMaintenance();
                break;
            }
            for (n = 0; n < opticsLineModelArray.length; ++n) {
                if (opticsLineModelArray[n].getOptPortType() == OpticalPortType.IN_EXPRESS || opticsLineModelArray[n].getOptPortType() == OpticalPortType.EAD_BIDI) {
                    vector.add(new Attribute(this.getPortNameString(opticsLineModelArray[n]), opticsLineModelArray[n].getIndex()));
                    this.voaStr = opticsLineModelArray[n].defaultVOAAttenuationMaintenance();
                    this.portExpModel = opticsLineModelArray[n];
                    continue;
                }
                if (opticsLineModelArray[n].getOptPortType() != OpticalPortType.ADD && opticsLineModelArray[n].getOptPortType() != OpticalPortType.AD_BIDI && opticsLineModelArray[n].getOptPortType() != OpticalPortType.DROP) continue;
                vector.add(new Attribute(this.getPortNameString(opticsLineModelArray[n]), opticsLineModelArray[n].getIndex()));
                this.portAddModel = opticsLineModelArray[n];
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return new DefaultComboBoxModel<Attribute>(vector.toArray(new Attribute[0]));
    }

    private boolean isWxc40Port(OpticsLineModel opticsLineModel) throws NoSuchInterface, WrongInterfaceType {
        return opticsLineModel.getOptPortType() == OpticalPortType.OUT_COM;
    }

    @Override
    public void leavingPage() throws Exception {
    }

    private void disaMaintenanceChanelPower(OpticsLineModel opticsLineModel) {
        try {
            opticsLineModel.disaMaintenanceChanelPower(this.getOutputIndex());
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
        }
    }

    private int[] getMaintenanceChanelPower(OpticsLineModel opticsLineModel) {
        int[] nArray;
        try {
            nArray = opticsLineModel.getMaintenanceChanelPower(this.getOutputIndex());
            try {
                this.portIndex = nArray[1] = Integer.parseInt(String.valueOf(nArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                this.portIndex = 0;
                return null;
            }
            boolean bl = this.isChannelActive = this.portIndex != 0;
            if (this.isChannelActive) {
                this.wave = nArray[2] == 82 ? Wavelength.getCMaintenanceWlAttribute() : Wavelength.getWlAttribute(nArray[2]);
                this.powerStr = this.convertPwrToString(nArray[3]);
                this.voaStr = this.convertPwrToString(nArray[4]);
                this.actualStr = this.convertPwrToString(nArray[5]);
            } else {
                this.wave = null;
                this.powerStr = "";
                this.voaStr = "";
                this.actualStr = "";
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            return null;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            return null;
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
            return null;
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
            return null;
        }
        return nArray;
    }

    private void enaMaintenanceChanelPower(int n, int n2, int n3, Attribute attribute) throws ProvisionError, FeatureUnsupported {
        int[] nArray = new int[]{this.getOutputIndex(), n, attribute.getIntValue(), n2, n3};
        try {
            this.comTxModel.enaMaintenanceChanelPower(nArray);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
    }

    private void setMaintenanceChanelPower(int n, int n2, int n3, Attribute attribute) throws ProvisionError, FeatureUnsupported {
        int[] nArray = new int[]{this.getOutputIndex(), n, attribute.getIntValue(), n2, n3};
        try {
            this.comTxModel.setMaintenanceChanelPower(nArray);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
    }

    public final int getOutputIndex() {
        return this.comTxModel.getIndex();
    }

    private String getPortNameString(OpticsLineModel opticsLineModel) {
        String string;
        try {
            string = PortHelper.getPortNumString((IPortModel)opticsLineModel.getPortModel());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            string = String.valueOf(1);
        }
        return string + " (" + this.getType(opticsLineModel) + ")";
    }

    private String getType(OpticsLineModel opticsLineModel) {
        try {
            return opticsLineModel.getOptPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private void setSelectedPort(int n) {
        for (int i = 0; i < this.portComboBox.getItemCount(); ++i) {
            if (((Attribute)this.portComboBox.getItemAt(i)).getIntValue() != n) continue;
            this.portComboBox.setSelectedIndex(i);
            break;
        }
    }

    private void clearActualPwrField() {
        this.actualStr = "";
        this.actualTextField.setText(this.actualStr);
    }

    private void updateButtons() {
        this.refreshButton.setEnabled(this.isChannelActive);
        this.clearButton.setEnabled(this.isChannelActive);
        this.portComboBox.setEnabled(!this.isChannelActive);
        this.waveLengthComboBox.setEnabled(!this.isChannelActive);
    }

    private String convertPwrToString(int n) {
        return String.valueOf((double)n / 10.0);
    }

    private int convertStringToPwr(String string) {
        return (int)(Double.parseDouble(string) * 10.0);
    }
}

