/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wxc;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class WxcOchParametersTableModel
extends OpticalTableModel {
    public static final int CIRCUIT_NAME_INDEX = 14;
    public static final int FROM_SIDE_INDEX = 15;
    public static final int ACTUAL_WAVEL_INDEX = 16;
    protected static final String OVERLOAD = "Overload";
    public static String[] columnNames = new String[]{"Circuit Name", "From", "Actual Wavelength"};
    private int[] actualWavelength;
    private static final SDebug db = new SDebug("WxcOchParametersTableModel");

    public WxcOchParametersTableModel(OpticsOchTermModel[] opticsOchTermModelArray, OpticsModuleModel opticsModuleModel) {
        super(db, opticsOchTermModelArray, opticsModuleModel);
    }

    @Override
    protected void init() {
        this.actualWavelength = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.actualWavelength[i] = 0;
        }
        super.init();
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getCircuitName(n);
                }
                case 15: {
                    return this.getFrom(n);
                }
                case 16: {
                    return this.getActualWavelength(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OchParametersTableModel: error in getValueAt" + exception);
            }
            KDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                default: 
            }
            super.setValueAt(object, n, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            KDebug.printStackTrace((Throwable)classCastException);
            return;
        }
    }

    protected String getActualWavelength(int n) {
        if (this.actualWavelength[n] == 0 && this.model[n] != null && this.model[n] instanceof OpticsOchTermModel) {
            OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)this.model[n];
            try {
                this.actualWavelength[n] = opticsOchTermModel.getActualWaveLength();
            }
            catch (Exception exception) {
                this.actualWavelength[n] = 0;
            }
        }
        return this.actualWavelength[n] == 0 ? "UNKNOWN" : Wavelength.getWavelengthStringFromWavelength(this.actualWavelength[n]);
    }

    private String getFrom(int n) {
        String string = null;
        if (this.model[n].isPortTypeRX()) {
            try {
                IPortModel iPortModel = ((OpticsOchTermModel)this.model[n]).getPortModel();
                string = this.fillPortValue(iPortModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        } else {
            try {
                AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)this.node.getIfModels().getInterfaceModel(((OpticsOchTermModel)this.model[n]).getOppositeOch()[0]);
                IPortModel iPortModel = abstractOpticsLineModel.getPort();
                string = this.fillPortValue(iPortModel);
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String fillPortValue(IPortModel iPortModel) {
        String string = null;
        try {
            String string2 = PortHelper.getPortNumString((IPortModel)iPortModel);
            string = string2 + " (" + ((AbstractOpticsLineModel)iPortModel.getInterfaceModel()).getPortTypeString() + ")";
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return string;
    }

    @Override
    public void refreshLineFromModel(int n) {
        if (n >= this.getRowCount() || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getActualWavelength(n);
        this.getFrom(n);
        this.getCircuitName(n);
        super.refreshLineFromModel(n);
    }

    @Override
    protected void resetLineCache(int n) {
        this.actualWavelength[n] = 0;
        super.resetLineCache(n);
    }

    private String getCircuitName(int n) {
        return ((OpticsOchTermModel)this.model[n]).getCircuitName();
    }

    void setHideAllRows() {
        this.numLines = 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return super.getColumnClass(n);
    }

    public synchronized void setOchTermModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this.model = abstractOpticsLineModelArray;
        int n = this.numLines = this.model == null ? 0 : this.model.length;
        if (this.eqpmtModel == null) {
            try {
                this.eqpmtModel = this.model[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("problems with the update of the first circuit");
                return;
            }
        }
        this.init();
        this.refreshFromModel();
        this.fireTableDataChanged();
    }
}

