/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.xpl2.XPL2MIPTableModel;
import cerent.util.CEMC;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class MIPCreateDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Create MIP";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    private static final String SLOT = "Slot:";
    private static final String PORT = "Port:";
    private static final String LEVEL = "Level:";
    private static final String VLAN_RANGE = "Vlan Range:";
    private static final String VLAN = "Vlan:";
    private static final SDebug db = new SDebug("MIPCreateDialog");
    private static String ALL = "All";
    private static final int MAX_ROW_COUNT = 25;
    private static final int MAX_CVLAN_ID = 4094;
    private ComboBoxRenderer comboRenderer = new ComboBoxRenderer();
    private JButton okButton;
    private JButton cancelButton;
    private UComboBox slotCB;
    private UComboBox portCB;
    private UComboBox levelCB;
    private JTextField vrangeTF = new JTextField();
    private sCVlanRange vr;
    private NodeModelDelegate nodeModel;
    private ModuleModel module;
    private XPL2LineModel[] lineModels;
    XPL2MIPTableModel tableModel;
    private int editDataRow = -1;

    public MIPCreateDialog(Frame frame, XPL2ModuleModel xPL2ModuleModel, XPL2MIPTableModel xPL2MIPTableModel, int n) {
        super(frame, TITLE, true);
        this.lineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MIPCreateDialog.this.dispose();
            }
        });
        this.module = xPL2ModuleModel;
        this.nodeModel = xPL2ModuleModel.getNodeModelDelegate();
        this.tableModel = xPL2MIPTableModel;
        this.editDataRow = n;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        if (n != -1) {
            this.initializeForm();
        }
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initializeForm() {
        MIPInfo mIPInfo = this.tableModel.getMIPModel(this.editDataRow);
        this.portCB.setSelectedItem((Object)mIPInfo.getLineModel());
        this.levelCB.setSelectedIndex(mIPInfo.getLevel());
        this.vrangeTF.setText(mIPInfo.getRange());
        this.portCB.setEnabled(false);
        this.vrangeTF.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        this.slotCB = this.createSlotCombo();
        this.slotCB.setRenderer((ListCellRenderer)new MIPCardRenderer());
        this.portCB = new UComboBox((Object[])this.lineModels);
        this.portCB.setRenderer((ListCellRenderer)this.comboRenderer);
        Object[] objectArray = new Integer[8];
        for (int i = 0; i < 8; ++i) {
            objectArray[i] = new Integer(i);
        }
        this.levelCB = new UComboBox(objectArray);
        this.slotCB.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JLabel(SLOT));
        jPanel2.add(new JLabel(PORT));
        jPanel2.add(new JLabel(LEVEL));
        if (this.editDataRow == -1) {
            jPanel2.add(new JLabel(VLAN_RANGE));
            this.vrangeTF.setText("0-0");
        } else {
            jPanel2.add(new JLabel(VLAN));
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.add((Component)this.slotCB);
        jPanel3.add((Component)this.portCB);
        jPanel3.add((Component)this.levelCB);
        jPanel3.add(this.vrangeTF);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    protected boolean checkCVlanRange(String string, sCVlanRange sCVlanRange2) {
        if (string.matches("[0-9]{1,4}-[0-9]{1,4}")) {
            String[] stringArray = string.split("-");
            try {
                short s = Short.valueOf(stringArray[0]);
                short s2 = Short.valueOf(stringArray[1]);
                if (this.checkCVlanValue(s) && this.checkCVlanValue(s2)) {
                    if (s <= s2) {
                        sCVlanRange2.first = s;
                        sCVlanRange2.last = s2;
                        return true;
                    }
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
                }
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
            }
            catch (NumberFormatException numberFormatException) {
                KDebug.printStackTrace((Throwable)numberFormatException);
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"VLAN");
                return false;
            }
        } else {
            try {
                short s = Short.valueOf(string);
                if (this.checkCVlanValue(s)) {
                    sCVlanRange2.first = s;
                    sCVlanRange2.last = s;
                    return true;
                }
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
            }
            catch (NumberFormatException numberFormatException) {
                KDebug.printStackTrace((Throwable)numberFormatException);
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_NUMBER_PARAM_1, (Object)"VLAN");
                return false;
            }
        }
        return false;
    }

    private boolean checkCVlanValue(short s) {
        return s > 0 && s < 4094;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private UComboBox createSlotCombo() {
        ArrayList<ModuleModel> arrayList = new ArrayList<ModuleModel>(0);
        ArrayList<String> arrayList2 = new ArrayList<String>(0);
        TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
        arrayList.add(this.module);
        arrayList2.add(this.module.getSlot() + " (" + EntityModel.eqType2Name(tDMTerminology, this.module.getEqType()) + ")");
        Object[][] objectArray = new Object[arrayList.size()][2];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i][0] = arrayList2.get(i);
            objectArray[i][1] = arrayList.get(i);
        }
        UComboBox uComboBox = new UComboBox((Object[])objectArray);
        uComboBox.setSelectedIndex(0);
        return uComboBox;
    }

    private boolean apply() {
        if (this.slotCB.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"slot");
            this.slotCB.requestFocus();
            return false;
        }
        if (this.portCB.getSelectedIndex() == -1) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
            this.portCB.requestFocus();
            return false;
        }
        this.vr = new sCVlanRange();
        if (!this.checkCVlanRange(this.vrangeTF.getText(), this.vr)) {
            this.vrangeTF.select(0, this.vrangeTF.getText().length());
            return false;
        }
        Object[] objectArray = (Object[])this.slotCB.getSelectedItem();
        ModuleModel moduleModel = (ModuleModel)objectArray[1];
        XPL2LineModel xPL2LineModel = (XPL2LineModel)this.portCB.getSelectedItem();
        MIPInfo mIPInfo = null;
        DetailedLog detailedLog = new DetailedLog(3, "The MIP was not provisioned");
        int n = 0;
        if (this.editDataRow == -1) {
            if (this.vr.first <= this.vr.last) {
                for (int i = this.vr.first; i <= this.vr.last; ++i) {
                    try {
                        mIPInfo = new MIPInfo(xPL2LineModel, (short)i, (Integer)this.levelCB.getSelectedItem());
                        xPL2LineModel.createMIP(mIPInfo);
                        continue;
                    }
                    catch (Exception exception) {
                        ++n;
                        String string = "creating";
                        String string2 = null;
                        if (exception instanceof ProvisionError && ((ProvisionError)((Object)exception)).getEID() != null) {
                            string2 = ((ProvisionError)((Object)exception)).getEID().getMessage();
                        }
                        DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while " + string + " the MIP " + mIPInfo.getFirst() + " could not be created. " + (string2 != null ? "Reason = " + string2 : ""), exception);
                        detailedLog.addChild(detailedLog2);
                        detailedLog.updateTime();
                    }
                }
                if (n > 0) {
                    IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                        public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                        }

                        public boolean isCancelSupported() {
                            return false;
                        }

                        public void cancel() {
                        }
                    };
                    DetailedProgressDialog detailedProgressDialog = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
                    detailedProgressDialog.setCompleted(true);
                    detailedProgressDialog.start();
                }
            }
        } else {
            try {
                mIPInfo = new MIPInfo(xPL2LineModel, this.vr.first, (Integer)this.levelCB.getSelectedItem());
                xPL2LineModel.modifyMIP(mIPInfo);
            }
            catch (ProvisionError provisionError) {
                EID eID;
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                if ((eID = provisionError.getEID()) != null) {
                    ErrorMsg.displayDetailed((Component)this, eID, (Exception)((Object)provisionError));
                }
                ErrorMsg.displayDetailed((Component)this, CEMC.EID_PROVISION_ERROR, (Exception)((Object)provisionError));
            }
        }
        this.tableModel.getDataSrc().refresh();
        return true;
    }

    private String getSlotPort(int n) {
        String string = "unknown";
        try {
            short s = this.nodeModel.getIfModels().getInterfaceModel(n).getSlotNum();
            int[] nArray = this.nodeModel.getIfModels().getInterfaceModel(n).getPort().getPortNum();
            if (s != -1 && nArray[0] != -1) {
                string = "s" + s + "/p" + nArray[0];
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return string;
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            block6: {
                if (object == null) {
                    this.setText("");
                    return this;
                }
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                if (object instanceof XPL2LineModel) {
                    XPL2LineModel xPL2LineModel = (XPL2LineModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    try {
                        this.setText(entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false));
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block6;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            return this;
        }
    }

    class MIPCardRenderer
    extends JLabel
    implements ListCellRenderer {
        public MIPCardRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray != null) {
                stringBuffer.append(((String)objectArray[0]).toString());
            }
            this.setText(stringBuffer.toString());
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

