/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sMEPStats;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2CCDBStatsColumnRenderer
extends AbstractColumnRenderer {
    private static final int DNAME = 0;
    private static final int SVLANID = 1;
    private static final int MPID = 2;
    private static final int CCM_TRANS = 3;
    private static final int CCM_RCVD = 4;
    private static final int CC_RCVD_SEQ_ERR = 5;
    private static final int LTR_UNEXP_RCVD = 6;
    private static final int LBR_TRANS = 7;
    private static final int LBR_RCVD_ORDR = 8;
    private static final int LBR_RCVD_SEQ_ERR = 9;
    private static final int LBR_RCVD_BAD = 10;
    private static final int COLUMN_NO = 11;
    private JLabel label = new JLabel();
    protected static final SDebug db = new SDebug("XPL2CCDBStatsColumnRenderer");

    public XPL2CCDBStatsColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        sMEPStats sMEPStats2 = (sMEPStats)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 0: {
                string = sMEPStats2.domainName;
                break;
            }
            case 1: {
                string = String.valueOf(sMEPStats2.svlanId);
                break;
            }
            case 2: {
                string = String.valueOf(sMEPStats2.mpId);
                break;
            }
            case 3: {
                string = String.valueOf(sMEPStats2.ccm_transmitted);
                break;
            }
            case 4: {
                string = String.valueOf(sMEPStats2.ccm_received);
                break;
            }
            case 5: {
                string = String.valueOf(sMEPStats2.cc_rcvd_seq_err);
                break;
            }
            case 6: {
                string = String.valueOf(sMEPStats2.ltr_unxpctd_rcvd);
                break;
            }
            case 7: {
                string = String.valueOf(sMEPStats2.lbr_transmitted);
                break;
            }
            case 8: {
                string = String.valueOf(sMEPStats2.lbr_rcvd_in_order);
                break;
            }
            case 9: {
                string = String.valueOf(sMEPStats2.lbr_rcvd_seq_error);
                break;
            }
            case 10: {
                string = String.valueOf(sMEPStats2.lbr_rcvd_bad_msdu);
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = XPL2CCDBStatsColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = XPL2CCDBStatsColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPString(XPL2LineModel xPL2LineModel) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        try {
            return entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return null;
        }
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString(entityModel, false);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        sMEPStats sMEPStats2 = (sMEPStats)object;
        sMEPStats sMEPStats3 = (sMEPStats)object2;
        switch (n) {
            case 0: {
                String string = sMEPStats2.domainName;
                String string2 = sMEPStats3.domainName;
                n2 = string.compareTo(string2);
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.svlanId, (int)sMEPStats3.svlanId);
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.ccm_transmitted, (int)sMEPStats3.ccm_transmitted);
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.ccm_received, (int)sMEPStats3.ccm_received);
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.mpId, (int)sMEPStats3.mpId);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.cc_rcvd_seq_err, (int)sMEPStats3.cc_rcvd_seq_err);
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.ltr_unxpctd_rcvd, (int)sMEPStats3.ltr_unxpctd_rcvd);
                break;
            }
            case 7: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.lbr_transmitted, (int)sMEPStats3.lbr_transmitted);
                break;
            }
            case 8: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.lbr_rcvd_in_order, (int)sMEPStats3.lbr_rcvd_in_order);
                break;
            }
            case 9: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.lbr_rcvd_seq_error, (int)sMEPStats3.lbr_rcvd_seq_error);
                break;
            }
            case 10: {
                n2 = ComparisonUtil.compare((int)sMEPStats2.lbr_rcvd_bad_msdu, (int)sMEPStats3.lbr_rcvd_bad_msdu);
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[11];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2CCDBStatsColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Domain";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Svlan ID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "MPID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "CCM Transmitted";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "CCM Received";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "CC Received Error";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 6: {
                string = "LTR UnExpected Received";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 7: {
                string = "LBR Transmitted";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 8: {
                string = "LBR Received";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 9: {
                string = "LBR Received Error";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 10: {
                string = "LBR Received Bad MSDU";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2CCDBStatsColumnRenderer(string, n3, bl, n2);
    }
}

