/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eCCTimer;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2CFMSettingsTableModel;
import cerent.util.ObservableManager;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2CFMSettingsProvPane
extends NodeProvPane
implements ITabName,
ActionListener,
TableModelListener {
    protected XPL2CFMSettingsTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = (XPL2ModuleModel)this.getUiModel();
    protected XPL2LineModel[] lineModels = this.eqpmtModel.getXPL2EtherLines();
    private ObservableManager _obsMgr;
    private JCheckBox enableCFM;
    JRadioButton ccTimer1;
    JRadioButton ccTimer2;
    JRadioButton ccTimer3;

    public XPL2CFMSettingsProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.dataModel = new XPL2CFMSettingsTableModel(this.eqpmtModel, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = XPL2CFMSettingsProvPane.createHorizontalPanel(null);
        this.enableCFM = new JCheckBox("Enable CFM", true);
        this.enableCFM.addActionListener(this);
        jPanel.add(this.enableCFM);
        this.ccTimer1 = new JRadioButton("1 sec", true);
        this.ccTimer2 = new JRadioButton("10 sec");
        this.ccTimer3 = new JRadioButton("1 min");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ccTimer1);
        buttonGroup.add(this.ccTimer2);
        buttonGroup.add(this.ccTimer3);
        this.ccTimer1.addActionListener(this);
        this.ccTimer2.addActionListener(this);
        this.ccTimer3.addActionListener(this);
        JPanel jPanel2 = XPL2CFMSettingsProvPane.createHorizontalPanel(null);
        jPanel2.add(this.ccTimer1);
        jPanel2.add(this.ccTimer2);
        jPanel2.add(this.ccTimer3);
        jPanel2.setBorder(BorderFactory.createTitledBorder("CC Timer"));
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.add((Component)uScrollPane);
        JPanel jPanel4 = XPL2CFMSettingsProvPane.createVerticalPanel(null);
        jPanel4.add(jPanel3);
        this.add(jPanel4, "South");
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(100);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.enableCFM) {
            this.setDirty();
        }
        eCCTimer eCCTimer2 = null;
        try {
            eCCTimer2 = this.eqpmtModel.getCardCCTimer();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            wrongInterfaceType.printStackTrace();
        }
        catch (NoSuchInterface noSuchInterface) {
            noSuchInterface.printStackTrace();
        }
        catch (ProvisionError provisionError) {
            provisionError.printStackTrace();
        }
        if (!(actionEvent.getSource() == this.ccTimer1 && eCCTimer2 == eCCTimer.ONE_SEC || actionEvent.getSource() == this.ccTimer2 && eCCTimer2 == eCCTimer.TEN_SEC || actionEvent.getSource() == this.ccTimer3 && eCCTimer2 == eCCTimer.ONE_MIN)) {
            this.setDirty();
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.dataModel.applyToModel(i);
        }
        this.eqpmtModel.setCardCFMStatus(this.enableCFM.isSelected());
        if (this.ccTimer1.isSelected()) {
            this.eqpmtModel.setCardCCTimer(eCCTimer.ONE_SEC);
        } else if (this.ccTimer2.isSelected()) {
            this.eqpmtModel.setCardCCTimer(eCCTimer.TEN_SEC);
        } else {
            this.eqpmtModel.setCardCCTimer(eCCTimer.ONE_MIN);
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    public boolean printCheck() {
        return true;
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.enableCFM.setSelected(this.eqpmtModel.getCardCFMStatus());
        eCCTimer eCCTimer2 = this.eqpmtModel.getCardCCTimer();
        if (eCCTimer2 == eCCTimer.ONE_SEC) {
            this.ccTimer1.setSelected(true);
        } else if (eCCTimer2 == eCCTimer.TEN_SEC) {
            this.ccTimer2.setSelected(true);
        } else if (eCCTimer2 == eCCTimer.ONE_MIN) {
            this.ccTimer3.setSelected(true);
        }
    }

    @Override
    public void refreshMyLines(Object object) {
        this.lineModels = this.eqpmtModel.getXPL2EtherLines();
        this.dataModel.refreshMyLines(this.lineModels);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2CFMSettingsProvPane;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }
}

