/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.ChGrpPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.DwdmCardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.JLabel;

public class XPL2CardView
extends DwdmCardView {
    private static final int MAX_NUM_CHGRP = 11;
    private static final SDebug db = new SDebug("XPL2CardView");

    public XPL2CardView(ModuleModel moduleModel, AbstractCardViewPanel abstractCardViewPanel) {
        super((EntityModel)moduleModel, abstractCardViewPanel);
        for (int i = 0; i < this.ppmSlotViews.length; ++i) {
            this.ppmSlotViews[i].addCardViewPaneToPort(abstractCardViewPanel);
        }
    }

    @Override
    protected void addPorts(boolean bl) {
        XPL2ModuleModel xPL2ModuleModel = (XPL2ModuleModel)this.model;
        PluggableSlotModel[] pluggableSlotModelArray = xPL2ModuleModel.getPpmSlots();
        this.ppmSlotViews = new PpmSlotView[pluggableSlotModelArray.length];
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.insets = new Insets(2, 3, 2, 2);
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        if (xPL2ModuleModel.isL2Switch()) {
            if (this.getModel().getEqType() == 272) {
                if (this.pci.positionPortsVertically()) {
                    this.gbc.gridwidth = 2;
                    this.gbc.insets = new Insets(2, 30, 2, 2);
                } else {
                    this.gbc.gridheight = 2;
                    this.gbc.insets = new Insets(20, 3, 2, 2);
                }
            }
            this.add((Component)new JLabel("PPM"), this.gbc);
            this.gbc.gridwidth = 1;
            this.gbc.gridheight = 1;
            this.gbc.insets = new Insets(2, 3, 2, 2);
        }
        for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
            this.ppmSlotViews[i] = new PpmSlotView(pluggableSlotModelArray[i]);
            if (this.pci.positionPortsVertically()) {
                if (this.getModel().getEqType() == 272) {
                    if (i < 10) {
                        this.gbc.gridx = 0;
                    } else if (i < 20) {
                        if (i == 10) {
                            this.gbc.gridy = 0;
                        }
                        this.gbc.gridx = 1;
                    } else {
                        this.gbc.gridx = 0;
                        this.gbc.gridwidth = 2;
                        this.gbc.fill = 3;
                    }
                }
                ++this.gbc.gridy;
            } else {
                if (this.getModel().getEqType() == 272) {
                    if (i < 10) {
                        this.gbc.gridy = 0;
                    } else if (i < 20) {
                        if (i == 10) {
                            this.gbc.gridx = 0;
                        }
                        this.gbc.gridy = 1;
                    } else {
                        this.gbc.gridx = 0;
                        this.gbc.gridheight = 2;
                        this.gbc.fill = 2;
                    }
                }
                ++this.gbc.gridx;
            }
            this.add((Component)this.ppmSlotViews[i], this.gbc);
        }
        if (xPL2ModuleModel.isL2Switch()) {
            this.addChannelGroups();
        }
        this.invalidate();
    }

    private void addChannelGroups() {
        XPL2ModuleModel xPL2ModuleModel = (XPL2ModuleModel)this.model;
        ChGrpPortModel[] chGrpPortModelArray = xPL2ModuleModel.getChannelGroupPorts();
        if (this.pci.positionPortsVertically()) {
            this.gbc.gridx = 2;
            this.gbc.gridy = 0;
        } else {
            this.gbc.gridx = 0;
            this.gbc.gridy = 2;
        }
        this.add((Component)new JLabel("CHGRP"), this.gbc);
        this.ports = new AbstractPortGraphic[this.numPorts + 11];
        this.gbc.fill = 0;
        for (int i = 0; i < chGrpPortModelArray.length; ++i) {
            int n = chGrpPortModelArray[i].getGraphPortPosition();
            if (this.pci.positionPortsVertically()) {
                this.gbc.gridx = 2;
                this.gbc.gridy = n;
            } else {
                this.gbc.gridx = n;
                this.gbc.gridy = 2;
            }
            this.portModels.add(chGrpPortModelArray[i]);
            this.ports[this.numPorts] = new GenericPortGraphic(this, chGrpPortModelArray[i], n);
            this.add((Component)this.ports[this.numPorts], this.gbc);
            ++this.numPorts;
        }
    }

    @Override
    protected void registerForLocalUpdates() {
        MrSlot mrSlot;
        XPL2ModuleModel xPL2ModuleModel = (XPL2ModuleModel)this.model;
        this._obsMgr.reset();
        this._obsMgr.addObservable((Observable)((Object)xPL2ModuleModel));
        if (xPL2ModuleModel.isL2Switch()) {
            this._obsMgr.addObservable((Observable[])xPL2ModuleModel.getChannelGroupPorts());
        }
        if ((mrSlot = xPL2ModuleModel.getMrSlot()) != null) {
            this._obsMgr.addObservable((Observable)((Object)mrSlot));
            this._obsMgr.addObservable((Observable[])mrSlot.getDescendantsOfClassType(7).toArray(new PortModel[0]));
        }
        this._obsMgr.setActive(true);
        this._obsMgr.setPassing(true);
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (((XPL2ModuleModel)this.model).isL2Switch() && object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            for (int i = 0; i < this.numPorts; ++i) {
                Object e = this.portModels.get(this.getPortModelIdx(i));
                if (!(e instanceof ChGrpPortModel)) continue;
                ChGrpPortModel chGrpPortModel = (ChGrpPortModel)e;
                XPL2ChannelGroupModel xPL2ChannelGroupModel = chGrpPortModel.getLineModel();
                IAlarmStatus iAlarmStatus = this.cardAlarmStore.getPortAlarmStatus(0, xPL2ChannelGroupModel.getChGroupID());
                if (iAlarmStatus != null && this.ports[i] != null) {
                    this.ports[i].setAlarmState(iAlarmStatus.getHighestSeverity());
                    if (!db.on()) continue;
                    db.println("Updated position " + i + " chGrp: " + this.model.getPort() + ", eqType " + this.model.getEqType() + ", model: " + this.ports[i].getModel().toString());
                    continue;
                }
                if (!db.on()) continue;
                db.println("null portAlarmStatus for position " + i + ", eqType " + this.model.getEqType() + ", port " + this.model.getPort());
            }
        }
    }
}

