/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherL2Media.eHashingMode;
import cerent.cms.idl.EtherL2Media.eLacpMode;
import cerent.cms.idl.EtherL2Media.eNiValue;
import cerent.cms.idl.EtherL2Media.sBasicL2Info;
import cerent.cms.idl.EtherL2Media.sChannelGroupAttributes;
import cerent.cms.idl.EtherL2Media.sChannelGroupInfo;
import cerent.cms.idl.EtherMedia.eBucketSize;
import cerent.cms.idl.EtherMedia.eEtherDuplex;
import cerent.cms.idl.EtherMedia.eEtherSpeed;
import cerent.cms.idl.EtherMedia.sL1Info;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ChannelGroupManager;
import cerent.cms.model.XPL2ChannelGroupModel;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;

public class XPL2ChannelGroupTableModel
extends AbstractTableModel {
    public static final int CH_GROUP_INDEX = 0;
    public static final int CH_GROUP_NAME_INDEX = 1;
    public static final int PORTS_INDEX = 2;
    public static final int LACP_MODE_INDEX = 3;
    public static final int HASHING_INDEX = 4;
    public static final int ADMIN_STATE_INDEX = 5;
    public static final int SERVICE_STATE_INDEX = 6;
    public static final int MTU_INDEX = 7;
    public static final int SPEED_INDEX = 8;
    public static final int EXP_SPEED_INDEX = 9;
    public static final int DUPLEX_INDEX = 10;
    public static final int COMM_INFO_RATE_INDEX = 11;
    public static final int COMM_BURST_SIZE_INDEX = 12;
    public static final int EX_BURST_SIZE_INDEX = 13;
    public static final int NIM_INDEX = 14;
    public static final int INGRESS_COS_INDEX = 15;
    public static final int ETHER_INNER_INDEX = 16;
    public static final int ETHER_OUTER_INDEX = 17;
    public static final int MAC_LEARNING_INDEX = 18;
    static final String[] columnNames = new String[]{"Channel Group", "Name", "Ports", "LACP Mode", "Hashing", "Admin State", "Service State", "MTU", "Mode", "Expected Speed", "Duplex", "Committed Info Rate", "Committed Burst Size", "Excess Burst Size", "NIM", "Ingress CoS", "Inner Ethertype (Hex)", "Outer Ethertype (Hex)", "MAC Learning"};
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2ChannelGroupModel[] channelGroupModels = null;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    private String[] chGroupIdxs;
    private String[] chGroupNames;
    private String[] portListDesc;
    private eLacpMode[] lacpModes;
    private eHashingMode[] lacpHashings;
    private eEtherSpeed[] expSpeeds;
    private sL1Info[] etherL1Info = null;
    private sBasicL2Info[] etherBasicL2Info = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    protected EntityCellRenderer portNameRenderer;
    private NodeModelDelegate nmd;
    private static final SDebug db = new SDebug("XPL2ChannelGroupTableModel");

    public XPL2ChannelGroupTableModel(XPL2ModuleModel xPL2ModuleModel, XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray) {
        if (xPL2ModuleModel == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel);
            }
            return;
        }
        this.eqpmtModel = xPL2ModuleModel;
        this.nmd = xPL2ModuleModel.getNodeModelDelegate();
        this.portNameRenderer = new EntityCellRenderer(false);
        this.refreshMyLines(xPL2ChannelGroupModelArray);
    }

    public void refreshMyLines(XPL2ChannelGroupModel[] xPL2ChannelGroupModelArray) {
        if (db.on()) {
            db.println("refreshMyLines");
        }
        this.channelGroupModels = xPL2ChannelGroupModelArray;
        this.numLines = this.channelGroupModels.length;
        this.chGroupIdxs = new String[this.numLines];
        this.chGroupNames = new String[this.numLines];
        this.portListDesc = new String[this.numLines];
        this.lacpModes = new eLacpMode[this.numLines];
        this.lacpHashings = new eHashingMode[this.numLines];
        this.expSpeeds = new eEtherSpeed[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.etherL1Info = new sL1Info[this.numLines];
        this.etherBasicL2Info = new sBasicL2Info[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.channelGroupModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.channelGroupModels[0], SecurityLevel.PROVISIONING)) {
            if (n2 == 16 && n > 0) {
                return false;
            }
            if (n2 == 8 && this.eqpmtModel.isInTxpMode()) {
                return false;
            }
            return n2 != 0 && n2 != 10 && n2 != 2 && n2 != 6;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private sBasicL2Info getEtherBasicL2InfoFromModel(int n) throws NoSuchInterface, InvalidOperation {
        sBasicL2Info sBasicL2Info2 = this.channelGroupModels[n].getEtherBasicL2Info();
        if (db.on()) {
            db.finest("sL1Info: row=" + n);
            db.finest("   niMode=" + sBasicL2Info2.niMode.value());
            db.finest("   macLearningState=" + sBasicL2Info2.macLearningState);
            db.finest("   sIngressCOS=" + sBasicL2Info2.sIngressCOS);
            db.finest("   cEtherType=" + sBasicL2Info2.cEtherType);
            db.finest("   sEtherType=" + sBasicL2Info2.sEtherType);
        }
        return sBasicL2Info2;
    }

    private sL1Info getEtherL1InfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, NotSupportedOnEquipment {
        sL1Info sL1Info2 = this.channelGroupModels[n].getEtherL1Info();
        if (db.on()) {
            db.finest("sL1Info: row=" + n);
            db.finest("   duplex=" + sL1Info2.duplex.value());
            db.finest("   speed=" + sL1Info2.speed.value());
            db.finest("   bandwidth=" + sL1Info2.ingressQos.committedInfoRate);
            db.finest("   mtu=" + sL1Info2.mtu);
        }
        return sL1Info2;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block23: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getChGroupIdx(n);
                    }
                    case 1: {
                        return this.getChGroupNameAttr(n);
                    }
                    case 2: {
                        return this.getPortListDesc(n);
                    }
                    case 3: {
                        return this.getLacpModeAttr(n);
                    }
                    case 4: {
                        return this.getLacpHashingAttr(n);
                    }
                    case 5: {
                        return this.getAdminStateAttr(n).toString(this.getTerms());
                    }
                    case 6: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                    case 7: {
                        return this.getMTU(n);
                    }
                    case 8: {
                        return this.getSpeed(n);
                    }
                    case 9: {
                        return this.getExSpeedAttr(n);
                    }
                    case 10: {
                        return this.getDuplex(n);
                    }
                    case 14: {
                        return this.getNim(n);
                    }
                    case 11: {
                        return this.getCIR(n);
                    }
                    case 12: {
                        return this.getCBS(n);
                    }
                    case 13: {
                        return this.getEBS(n);
                    }
                    case 15: {
                        return this.getIngress(n);
                    }
                    case 16: {
                        return this.getEtherIn(n);
                    }
                    case 17: {
                        return this.getEtherOut(n);
                    }
                    case 18: {
                        return this.getMacLearning(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block23;
                db.println("Error in getValueAt in ChannelGroupTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 18: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    private String getChGroupIdx(int n) {
        block2: {
            try {
                this.chGroupIdxs[n] = this.portNameRenderer.getPortString((IEntityModel)this.channelGroupModels[n].getPortModel(), false);
            }
            catch (Exception exception) {
                if (!XPL2ChannelGroupTableModel.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.chGroupIdxs[n];
    }

    private String getChGroupNameAttr(int n) throws Exception {
        if (this.chGroupNames[n] == null) {
            this.chGroupNames[n] = this.channelGroupModels[n].getAlias();
        }
        return this.chGroupNames[n];
    }

    private String getChGroupName(int n) throws Exception {
        return this.channelGroupModels[n].getAlias();
    }

    private String getPortListDesc(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        IEntityModel[] iEntityModelArray = this.getPortList(n);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.portNameRenderer.getPortString(iEntityModelArray[i], false));
        }
        this.portListDesc[n] = stringBuilder.toString();
        return this.portListDesc[n];
    }

    protected IEntityModel[] getPortList(int n) {
        TreeSet<IEntityModel> treeSet;
        block3: {
            treeSet = new TreeSet<IEntityModel>(new Comparator<IEntityModel>(){

                @Override
                public int compare(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
                    if (iEntityModel.getEntityIndex() < iEntityModel2.getEntityIndex()) {
                        return -1;
                    }
                    if (iEntityModel.getEntityIndex() > iEntityModel2.getEntityIndex()) {
                        return 1;
                    }
                    return 0;
                }
            });
            try {
                int[] nArray = this.channelGroupModels[n].getPortList();
                for (int i = 0; i < nArray.length; ++i) {
                    InterfaceModel interfaceModel = this.nmd.getIfModels().getInterfaceModel(nArray[i]);
                    treeSet.add((IEntityModel)interfaceModel.getPort());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Exception in retrieving channel group port list " + exception);
            }
        }
        return treeSet.toArray(new IEntityModel[0]);
    }

    private Attribute getLacpModeAttr(int n) {
        if (this.lacpModes[n] == null) {
            this.lacpModes[n] = this.channelGroupModels[n].getLacpMode();
        }
        return this.getAttributeFor("LacpMode", this.lacpModes[n].value());
    }

    private eLacpMode getLacpMode(int n) {
        this.lacpModes[n] = this.channelGroupModels[n].getLacpMode();
        return this.lacpModes[n];
    }

    public Attribute[] getLacpModeAttrs() {
        return this.getAttributeArray("LacpMode");
    }

    private Attribute getLacpHashingAttr(int n) {
        if (this.lacpHashings[n] == null) {
            this.lacpHashings[n] = this.channelGroupModels[n].getLacpHashing();
        }
        return this.getAttributeFor("LacpHashingMode", this.lacpHashings[n].value());
    }

    private eHashingMode getLacpHashing(int n) {
        this.lacpHashings[n] = this.channelGroupModels[n].getLacpHashing();
        return this.lacpHashings[n];
    }

    public Attribute[] getLacpHashingModeAttrs() {
        return this.getAttributeArray("LacpHashingMode");
    }

    private AdminState getAdminStateAttr(int n) throws Exception {
        if (this.adminState[n] == null) {
            this.adminState[n] = this.getAdminState(n);
        }
        return this.adminState[n];
    }

    private AdminState getAdminState(int n) throws Exception {
        eAdminState eAdminState2 = this.channelGroupModels[n].getAdminStateEnum();
        return AdminState.enumToAdminState(eAdminState2);
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        sServiceState sServiceState2 = this.channelGroupModels[n].getServiceState();
        this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        return this.serviceState[n];
    }

    private Integer getMTU(int n) {
        return new Integer(this.etherL1Info[n].mtu);
    }

    private Attribute getIngress(int n) {
        return this.getAttributeFor("IngressCos", this.etherBasicL2Info[n].sIngressCOS);
    }

    private Short getCIR(int n) {
        return new Short(this.etherL1Info[n].ingressQos.committedInfoRate);
    }

    protected Attribute getSpeed(int n) {
        if (this.etherL1Info[n].speed.value() == 4) {
            return this.getAttributeFor("EtherSpeed", this.etherL1Info[n].speed.value());
        }
        if (this.etherL1Info[n].speed.value() == 1) {
            return this.getAttributeFor("EtherFeSpeedMode", this.etherL1Info[n].speed.value());
        }
        return this.getAttributeFor("EtherGeSpeedMode", this.etherL1Info[n].speed.value());
    }

    private Attribute getExSpeedAttr(int n) {
        if (this.expSpeeds[n] == null) {
            this.expSpeeds[n] = this.channelGroupModels[n].getExpSpeed();
        }
        if (this.etherL1Info[n].speed.value() == 1) {
            return this.getAttributeFor("EtherFeSpeedMode", this.expSpeeds[n].value());
        }
        if (this.etherL1Info[n].speed.value() == 4) {
            return this.getAttributeFor("EtherSpeed", this.expSpeeds[n].value());
        }
        return this.getAttributeFor("EtherGeSpeed", this.expSpeeds[n].value());
    }

    private eEtherSpeed getExSpeed(int n) {
        this.expSpeeds[n] = this.channelGroupModels[n].getExpSpeed();
        return this.expSpeeds[n];
    }

    private Attribute getCBS(int n) {
        return this.getAttributeFor("EtherBucket", this.etherL1Info[n].ingressQos.committedBurstSize.value());
    }

    private Attribute getEBS(int n) {
        return this.getAttributeFor("EtherBucket", this.etherL1Info[n].ingressQos.excOrPeakBurstSize.value());
    }

    private Attribute getNim(int n) {
        return this.getAttributeFor("NIMode", this.etherBasicL2Info[n].niMode.value());
    }

    private String getEtherIn(int n) {
        String string = Integer.toHexString(this.etherBasicL2Info[n].cEtherType & 0xFFFF).toUpperCase();
        for (int i = string.length(); i < 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private String getEtherOut(int n) {
        String string = Integer.toHexString(this.etherBasicL2Info[n].sEtherType & 0xFFFF).toUpperCase();
        for (int i = string.length(); i < 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private Boolean getMacLearning(int n) {
        return this.etherBasicL2Info[n].macLearningState;
    }

    private Attribute getDuplex(int n) {
        return this.getAttributeFor("EtherDuplex", this.etherL1Info[n].duplex.value());
    }

    protected boolean isBundlingOneGE(int n) {
        boolean bl = false;
        IEntityModel[] iEntityModelArray = this.getPortList(n);
        if (iEntityModelArray != null && iEntityModelArray.length > 0) {
            boolean bl2 = bl = iEntityModelArray[0].getEqType() == 167;
            if (db.on()) {
                db.println("bundling " + (bl ? "ONE GE" : "Else"));
            }
        } else if (db.on()) {
            db.println("isBundlingOneGE: port list empty!!");
        }
        return bl;
    }

    protected boolean isBundlingFE(int n) {
        boolean bl = false;
        IEntityModel[] iEntityModelArray = this.getPortList(n);
        if (iEntityModelArray != null && iEntityModelArray.length > 0) {
            boolean bl2 = bl = iEntityModelArray[0].getEqType() == 316;
            if (db.on()) {
                db.println("bundling " + (bl ? "FE" : "Else"));
            }
        } else if (db.on()) {
            db.println("isBundlingFE: port list empty!!");
        }
        return bl;
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 1: {
                this.chGroupNames[n] = (String)object;
                break;
            }
            case 3: {
                this.lacpModes[n] = eLacpMode.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 4: {
                this.lacpHashings[n] = eHashingMode.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 5: {
                AdminState adminState = (AdminState)object;
                if (adminState.equals(this.adminState[n])) {
                    return;
                }
                this.adminState[n] = adminState;
                break;
            }
            case 8: {
                this.etherL1Info[n].speed = eEtherSpeed.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 9: {
                this.expSpeeds[n] = eEtherSpeed.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 14: {
                this.etherBasicL2Info[n].niMode = eNiValue.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 11: {
                try {
                    short s;
                    this.etherL1Info[n].ingressQos.committedInfoRate = s = Short.parseShort(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 12: {
                this.etherL1Info[n].ingressQos.committedBurstSize = eBucketSize.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 13: {
                this.etherL1Info[n].ingressQos.excOrPeakBurstSize = eBucketSize.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 7: {
                try {
                    int n3;
                    this.etherL1Info[n].mtu = n3 = Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 15: {
                this.etherBasicL2Info[n].sIngressCOS = (short)((Attribute)object).getIntValue();
                break;
            }
            case 16: {
                try {
                    int n4 = Integer.parseInt(object.toString(), 16);
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        this.etherBasicL2Info[i].cEtherType = (short)n4;
                        this.fireTableCellUpdated(i, n2);
                    }
                    this.isDirty[0][n2] = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 17: {
                try {
                    int n5 = Integer.parseInt(object.toString(), 16);
                    this.etherBasicL2Info[n].sEtherType = (short)n5;
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 18: {
                this.etherBasicL2Info[n].macLearningState = (Boolean)object;
                break;
            }
            default: {
                return;
            }
        }
        if (!bl) {
            this.isDirty[n][n2] = true;
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1]) {
            this.channelGroupModels[n].setAlias(this.chGroupNames[n]);
            if (db.on()) {
                db.println("Name changed");
            }
        }
        if (this.isDirty[n][5]) {
            this.channelGroupModels[n].setAdminState(this.adminState[n].getAdminStateEnum());
            if (db.on()) {
                db.println("Admin State changed");
            }
        }
        if (this.isDirty[n][14] || this.isDirty[n][15] || this.isDirty[n][17] || this.isDirty[n][18] || this.isDirty[n][16]) {
            this.channelGroupModels[n].setEtherBasicL2Info(this.etherBasicL2Info[n]);
            if (db.on()) {
                db.println("Ether L2 params changed");
            }
        }
        if (this.isDirty[n][3] || this.isDirty[n][4] || this.isDirty[n][8] || this.isDirty[n][11] || this.isDirty[n][12] || this.isDirty[n][9] || this.isDirty[n][13] || this.isDirty[n][7]) {
            sChannelGroupInfo sChannelGroupInfo2 = new sChannelGroupInfo();
            sChannelGroupInfo2.l1Info = this.etherL1Info[n];
            sChannelGroupInfo2.algoritm = this.lacpHashings[n];
            sChannelGroupInfo2.lacpMode = this.lacpModes[n];
            sChannelGroupInfo2.expectedSpeed = sChannelGroupInfo2.l1Info.speed != eEtherSpeed.ETHER_SPEED_AUTO ? sChannelGroupInfo2.l1Info.speed : this.expSpeeds[n];
            sChannelGroupInfo2.l1Info.duplex = eEtherDuplex.ETHER_DUPLEX_FULL;
            sChannelGroupInfo2.l1Info.ingressQos.colorMode = false;
            sChannelGroupInfo2.l1Info.ingressQos.couplingFlag = false;
            this.channelGroupModels[n].modifyChannelGroup(sChannelGroupInfo2);
            if (db.on()) {
                db.println("Channel Group params changed");
            }
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    private void fillL2Defaults(int[] nArray, sBasicL2Info sBasicL2Info2) {
        block11: {
            XPL2Layer2LineModel xPL2Layer2LineModel = null;
            if (nArray != null && nArray.length > 0) {
                try {
                    InterfaceModel interfaceModel = this.nmd.getIfModels().getInterfaceModel(nArray[0]);
                    if (interfaceModel instanceof XPL2Layer2LineModel) {
                        if (db.on()) {
                            db.println("fillL2Defaults: using 1st attached port L2 defaults");
                        }
                        xPL2Layer2LineModel = (XPL2Layer2LineModel)interfaceModel;
                        sBasicL2Info sBasicL2Info3 = xPL2Layer2LineModel.getEtherBasicL2Info();
                        sBasicL2Info2.cEtherType = sBasicL2Info3.cEtherType;
                        sBasicL2Info2.macLearningState = sBasicL2Info3.macLearningState;
                        sBasicL2Info2.niMode = sBasicL2Info3.niMode;
                        sBasicL2Info2.policyId = sBasicL2Info3.policyId;
                        sBasicL2Info2.sEtherType = sBasicL2Info3.sEtherType;
                        sBasicL2Info2.sIngressCOS = sBasicL2Info3.sIngressCOS;
                    } else if (db.on()) {
                        db.println("fillL2Defaults: no L2 line interface");
                    }
                    break block11;
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("fillL2Defaults: exception retrieving port interface ");
                    }
                    break block11;
                }
            }
            if (db.on()) {
                db.println("fillL2Defaults: using node L2 defaults");
            }
            NeDefaultsModel neDefaultsModel = this.nmd.getNeDefaultsModel();
            try {
                sBasicL2Info sBasicL2Info4 = neDefaultsModel.getDefXPGEL2EtherInfo(this.eqpmtModel.getEqTypeEnum(), eEqType.DWDM_CLIENT_PORT);
                sBasicL2Info2.cEtherType = sBasicL2Info4.cEtherType;
                sBasicL2Info2.macLearningState = sBasicL2Info4.macLearningState;
                sBasicL2Info2.niMode = sBasicL2Info4.niMode;
                sBasicL2Info2.policyId = sBasicL2Info4.policyId;
                sBasicL2Info2.sEtherType = sBasicL2Info4.sEtherType;
                sBasicL2Info2.sIngressCOS = sBasicL2Info4.sIngressCOS;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void fillL1Defaults(int[] nArray, sChannelGroupInfo sChannelGroupInfo2) {
        block16: {
            Object object;
            IPortModel iPortModel;
            int n;
            block15: {
                n = 122;
                iPortModel = null;
                if (nArray != null && nArray.length > 0) {
                    try {
                        object = this.nmd.getIfModels().getInterfaceModel(nArray[0]);
                        iPortModel = ((InterfaceModel)object).getPortModel();
                        InterfaceModel[] interfaceModelArray = ((InterfaceModel)object).getLowerLayerModels();
                        if (interfaceModelArray != null && interfaceModelArray.length > 0) {
                            InterfaceModel[] interfaceModelArray2 = interfaceModelArray[0].getLowerLayerModels();
                            if (interfaceModelArray2 != null && interfaceModelArray2.length > 0) {
                                n = interfaceModelArray2[0].getPort().getEqType();
                            } else if (db.on()) {
                                db.println("fillInDefaults: no L0 interface ");
                            }
                        } else if (db.on()) {
                            db.println("fillInDefaults: no L1 interface ");
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("fillInDefaults: exception retrieving port interface ");
                        }
                        break block15;
                    }
                }
                if (db.on()) {
                    db.println("fillInDefaults: changing ch group value w/o ports attached");
                }
            }
            try {
                object = this.chGrpManager().getChannelGroupDefault(n);
                if (iPortModel != null && iPortModel.getEqType() == 316) {
                    sChannelGroupInfo2.expectedSpeed = eEtherSpeed.ETHER_SPEED_100;
                    sChannelGroupInfo2.l1Info.speed = eEtherSpeed.ETHER_SPEED_100;
                } else {
                    sChannelGroupInfo2.expectedSpeed = ((sChannelGroupInfo)object).expectedSpeed;
                    sChannelGroupInfo2.l1Info.speed = ((sChannelGroupInfo)object).l1Info.speed;
                }
                sChannelGroupInfo2.l1Info.flowControl = ((sChannelGroupInfo)object).l1Info.flowControl;
                sChannelGroupInfo2.l1Info.mtu = ((sChannelGroupInfo)object).l1Info.mtu;
                sChannelGroupInfo2.l1Info.duplex = ((sChannelGroupInfo)object).l1Info.duplex;
                sChannelGroupInfo2.l1Info.etherMode = ((sChannelGroupInfo)object).l1Info.etherMode;
                sChannelGroupInfo2.l1Info.mappingMode = ((sChannelGroupInfo)object).l1Info.mappingMode;
                sChannelGroupInfo2.l1Info.ingressQos.colorMode = ((sChannelGroupInfo)object).l1Info.ingressQos.colorMode;
                sChannelGroupInfo2.l1Info.ingressQos.couplingFlag = ((sChannelGroupInfo)object).l1Info.ingressQos.couplingFlag;
                sChannelGroupInfo2.l1Info.ingressQos.committedBurstSize = ((sChannelGroupInfo)object).l1Info.ingressQos.committedBurstSize;
                sChannelGroupInfo2.l1Info.ingressQos.committedInfoRate = ((sChannelGroupInfo)object).l1Info.ingressQos.committedInfoRate;
                sChannelGroupInfo2.l1Info.ingressQos.excOrPeakBurstSize = ((sChannelGroupInfo)object).l1Info.ingressQos.excOrPeakBurstSize;
                sChannelGroupInfo2.l1Info.ingressQos.peakInfoRate = ((sChannelGroupInfo)object).l1Info.ingressQos.peakInfoRate;
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                if (!db.on()) break block16;
                db.println("fillInDefaults: ERROR retrieving defaults");
            }
        }
    }

    private XPL2ChannelGroupManager chGrpManager() {
        return this.eqpmtModel.getChGrpManager();
    }

    public void createChGroup(sChannelGroupAttributes sChannelGroupAttributes2, int[] nArray) throws EMCProvisionError, WrongInterfaceType, NoSuchInterface {
        this.fillL1Defaults(nArray, sChannelGroupAttributes2.info);
        sBasicL2Info sBasicL2Info2 = new sBasicL2Info();
        this.fillL2Defaults(nArray, sBasicL2Info2);
        this.chGrpManager().createChannelGroup(sChannelGroupAttributes2.cgId, sChannelGroupAttributes2, sBasicL2Info2, nArray);
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        try {
            this.chGroupIdxs[n] = this.getChGroupIdx(n);
            this.chGroupNames[n] = this.getChGroupName(n);
            this.portListDesc[n] = this.getPortListDesc(n);
            this.lacpModes[n] = this.getLacpMode(n);
            this.lacpHashings[n] = this.getLacpHashing(n);
            this.expSpeeds[n] = this.getExSpeed(n);
            this.adminState[n] = this.getAdminState(n);
            this.serviceState[n] = this.getServiceState(n);
            this.etherL1Info[n] = this.getEtherL1InfoFromModel(n);
            this.etherBasicL2Info[n] = this.getEtherBasicL2InfoFromModel(n);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.isDirty[n][i] = false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Attribute[] getEtherSpeedAttrs1GE() {
        return this.getAttributeArray("EtherGeSpeedMode");
    }

    public Attribute[] getEtherSpeedAttrsFE() {
        return this.getAttributeArray("EtherFeSpeedMode");
    }

    public Attribute[] getEtherExpSpeedAttrs1GE() {
        Attribute[] attributeArray = this.getAttributeArray("EtherGeSpeedMode");
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < attributeArray.length - 1; ++i) {
            arrayList.add(attributeArray[i]);
        }
        return arrayList.toArray(new Attribute[0]);
    }

    public Attribute[] getEtherExpSpeedAttrs1GEAuto() {
        Attribute[] attributeArray = this.getAttributeArray("EtherGeSpeed");
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < attributeArray.length - 1; ++i) {
            arrayList.add(attributeArray[i]);
        }
        return arrayList.toArray(new Attribute[0]);
    }

    public Attribute[] getEtherSpeedAttr10GE() {
        return this.getAttributeArray("EtherSpeed");
    }

    public Attribute[] getBucketAttrs() {
        return this.getAttributeArray("EtherBucket");
    }

    public Attribute[] getFlowAttrs() {
        return this.getAttributeArray("EtherFlowControl");
    }

    public Attribute[] getNimAttrs() {
        return this.getAttributeArray("NIMode");
    }

    public Attribute[] getIngressAttrs() {
        return this.getAttributeArray("IngressCos");
    }

    public void dispose() {
        if (db.on()) {
            db.println("Dispose");
        }
    }
}

