/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2E13LineTableModel
extends AbstractTableModel
implements Observer {
    private sConfig[] configStructures;
    private eEqType portPayloadType = eEqType.E1_PORT;
    protected Ds123LineModel[] model = null;
    protected Ds123LineModel[] allPdhLines = null;
    protected XPL2ModuleModel moduleM = null;
    protected boolean[][] isDirty = null;
    protected Attribute[] clockSource;
    protected Attribute[] lineType;
    protected Attribute[] lineCoding;
    protected Attribute[] lineLength;
    protected int numLines = 0;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int CLOCKSOURCE_INDEX = 2;
    public static final int LINETYPE_INDEX = 3;
    public static final int LINECODING_INDEX = 4;
    public static final int LINELENGTH_INDEX = 5;
    public static final int E13_LAST_COLUMN = 5;
    public static final String[] columnNames = new String[]{"Port", "Port Name", "Clock Source", "Line Type", "Line Coding", "Line Length"};
    private String[] portNames;
    protected String sdString;
    protected String sfString;
    private static final SDebug db = new SDebug("XPL2E13LineTableModel");

    public XPL2E13LineTableModel(XPL2ModuleModel xPL2ModuleModel, Ds123LineModel[] ds123LineModelArray, eEqType eEqType2) {
        this.moduleM = xPL2ModuleModel;
        this.allPdhLines = ds123LineModelArray;
        this.model = this.filterMiTopLines(this.allPdhLines);
        this.portPayloadType = eEqType2;
        this.numLines = ds123LineModelArray == null ? 0 : ds123LineModelArray.length;
        this.init();
    }

    protected void init() {
        if (this.model != null) {
            this.numLines = this.model.length;
        }
        this.portNames = new String[this.numLines];
        this.clockSource = new Attribute[this.numLines];
        this.lineType = new Attribute[this.numLines];
        this.lineCoding = new Attribute[this.numLines];
        this.lineLength = new Attribute[this.numLines];
        this.configStructures = new sConfig[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public int getNumberOfLines() {
        return this.numLines;
    }

    public int getRangeFor(int n) {
        if (XPL2E13LineTableModel.between(0, 133, n)) {
            return 133;
        }
        if (XPL2E13LineTableModel.between(133, 266, n)) {
            return 266;
        }
        if (XPL2E13LineTableModel.between(266, 399, n)) {
            return 399;
        }
        if (XPL2E13LineTableModel.between(399, 533, n)) {
            return 533;
        }
        return 655;
    }

    public Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.moduleM.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.moduleM.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    protected Attribute getLineLengthAttributeFor(int n) {
        INodeModel iNodeModel = this.moduleM.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal("MiTopLineLength", n);
    }

    private Attribute getClockSource(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.clockSource[n] == null) {
            eClockSource eClockSource2 = this.getConfigStructure((int)n).clockSource;
            this.clockSource[n] = this.getAttributeFor("TxClockSource", eClockSource2.value());
        }
        return this.clockSource[n];
    }

    private Attribute getLineType(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineType[n] == null) {
            eLineType eLineType2 = this.getConfigStructure((int)n).lineType;
            this.lineType[n] = this.portPayloadType == eEqType.E3_PORT ? this.getAttributeFor("E3FramingType", eLineType2.value()) : this.getAttributeFor("E1FramingType", eLineType2.value());
        }
        return this.lineType[n];
    }

    private Attribute getLineCoding(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineCoding[n] == null) {
            eLineCoding eLineCoding2 = this.getConfigStructure((int)n).lineCoding;
            this.lineCoding[n] = this.portPayloadType == eEqType.E3_PORT ? this.getAttributeFor("E3LineCoding", eLineCoding2.value()) : this.getAttributeFor("E1LineCoding", eLineCoding2.value());
        }
        return this.lineCoding[n];
    }

    private Attribute getLineLength(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineLength[n] == null) {
            int n2 = this.getRangeFor(this.getConfigStructure((int)n).lineLength);
            if (db.on()) {
                db.println("line Length from switch for " + n + " is : " + this.getConfigStructure((int)n).lineLength);
            }
            this.lineLength[n] = this.getLineLengthAttributeFor(n2);
        }
        return this.lineLength[n];
    }

    private sConfig getConfigStructure(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.configStructures[n] == null) {
            this.configStructures[n] = this.model[n].getConfig();
        }
        return this.configStructures[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.portNames[n] = (String)object;
                break;
            }
            case 3: {
                this.lineType[n] = (Attribute)object;
                break;
            }
            case 4: {
                this.lineCoding[n] = (Attribute)object;
                break;
            }
            case 5: {
                try {
                    this.lineLength[n] = (Attribute)object;
                }
                catch (Exception exception) {
                    db.println("Error in typecasting line length");
                    SDebug.printStackTrace((Throwable)exception);
                }
                break;
            }
            case 2: {
                this.clockSource[n] = (Attribute)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getPortNum(int n) {
        String string = "";
        try {
            string = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)false, (boolean)true);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return string;
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 1;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    public static boolean between(int n, int n2, int n3) {
        return n3 > n && n3 <= n2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 3: {
                    return this.getLineType(n);
                }
                case 4: {
                    return this.getLineCoding(n);
                }
                case 5: {
                    return this.getLineLength(n);
                }
                case 2: {
                    return this.getClockSource(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt in XPL2E13LineTableModel " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNames[i] = null;
            this.clockSource[i] = null;
            this.lineType[i] = null;
            this.lineCoding[i] = null;
            this.lineLength[i] = null;
            this.configStructures[i] = null;
            this.resetLineCache(i);
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        this.portNames[n] = null;
        this.clockSource[n] = null;
        this.lineType[n] = null;
        this.lineCoding[n] = null;
        this.lineLength[n] = null;
        this.configStructures[n] = null;
        this.resetLineCache(n);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        block4: {
            try {
                this.configStructures[n] = this.model[n].getConfig();
                this.lineLength[n] = this.getLineLength(n);
                this.clockSource[n] = this.getAttributeFor("TxClockSource", this.configStructures[n].clockSource.value());
                this.lineCoding[n] = this.getAttributeFor("E1LineCoding", this.configStructures[n].lineCoding.value());
                this.lineType[n] = this.getAttributeFor("E1FramingType", this.configStructures[n].lineType.value());
                if (this.portPayloadType == eEqType.E3_PORT) {
                    this.lineCoding[n] = this.getAttributeFor("E3LineCoding", this.configStructures[n].lineCoding.value());
                    this.lineType[n] = this.getAttributeFor("E3FramingType", this.configStructures[n].lineType.value());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public Ds123LineModel[] filterMiTopLines(Ds123LineModel[] ds123LineModelArray) {
        ArrayList<Ds123LineModel> arrayList;
        block4: {
            XPL2LineModel[] xPL2LineModelArray = this.moduleM.getXPL2EtherLines();
            arrayList = new ArrayList<Ds123LineModel>();
            try {
                for (int i = 0; i < ds123LineModelArray.length; ++i) {
                    int n = ds123LineModelArray[i].getPortModel().getPortNum()[0];
                    for (int j = 0; j < xPL2LineModelArray.length; ++j) {
                        PortModel portModel;
                        XPL2LineModel xPL2LineModel;
                        int n2 = xPL2LineModelArray[j].getPortModel().getPortNum()[0];
                        if (n2 != n || !(xPL2LineModel = (XPL2LineModel)(portModel = (PortModel)xPL2LineModelArray[j].getPortModel()).getInterfaceModel()).isMiTopLine()) continue;
                        arrayList.add(ds123LineModelArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList.toArray(new Ds123LineModel[0]);
    }

    public void refreshMyLines(Ds123LineModel[] ds123LineModelArray) {
        this.unRegisterWithLineModels();
        this.model = ds123LineModelArray;
        if (ds123LineModelArray == null) {
            this.allPdhLines = (Ds123LineModel[])this.moduleM.getXPL2PdhLines(this.portPayloadType);
            this.model = this.filterMiTopLines(this.allPdhLines);
        }
        this.numLines = this.model == null ? 0 : this.model.length;
        this.init();
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
        if (db.on()) {
            db.println("Refreshing the table lines...");
            db.println("New models = " + this.model);
        }
    }

    private void registerWithLineModels() {
        if (this.model == null) {
            return;
        }
        for (int i = 0; i < this.model.length; ++i) {
            this.model[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.model == null) {
            return;
        }
        for (int i = 0; i < this.model.length; ++i) {
            this.model[i].deleteObserver(this);
        }
    }

    public sConfig getConfig(int n) throws NoSuchInterface, WrongInterfaceType {
        eSignalMode eSignalMode2 = eSignalMode.NO_SIGNALING;
        if (this.clockSource[n] == null) {
            this.getClockSource(n);
        }
        eClockSource eClockSource2 = eClockSource.from_int(this.clockSource[n].getIntValue());
        if (this.lineType[n] == null) {
            this.getLineType(n);
        }
        eLineType eLineType2 = eLineType.from_int(this.lineType[n].getIntValue());
        if (this.lineCoding[n] == null) {
            this.getLineCoding(n);
        }
        eLineCoding eLineCoding2 = eLineCoding.from_int(this.lineCoding[n].getIntValue());
        if (this.lineLength[n] == null) {
            this.getLineLength(n);
        }
        int n2 = this.lineLength[n].getIntValue();
        if (db.on()) {
            db.println("Value for line length for row " + n + " is " + n2);
        }
        return new sConfig(eClockSource2, eLineType2, eLineCoding2, eSignalMode2, n2, 0);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                int n;
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                if ((n = Arrays.asList(this.model).indexOf(observable)) != -1) {
                    this.refreshLineFromModel(n);
                }
            } else if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                if (db.on()) {
                    db.println("Got an Update Adding New LineModel for " + observable);
                }
                this.refreshMyLines(null);
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                ArrayList<Ds123LineModel> arrayList;
                int n;
                if (db.on()) {
                    db.println("Got an Update Deleting A LineModel for " + observable);
                }
                if ((n = (arrayList = new ArrayList<Ds123LineModel>(Arrays.asList(this.model))).indexOf(observable)) != -1) {
                    arrayList.remove(n);
                    this.model = arrayList.toArray(new Ds123LineModel[0]);
                    this.refreshMyLines(this.model);
                }
            }
        }
    }

    public void destroy() {
        for (int i = 0; i < this.model.length; ++i) {
            this.clockSource[i] = null;
            this.configStructures[i] = null;
            this.lineCoding[i] = null;
            this.lineType[i] = null;
            this.lineLength[i] = null;
        }
        this.model = null;
        this.moduleM = null;
        this.isDirty = null;
    }
}

