/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2DS13LineTableModel;
import cerent.cms.ui.xpl2.XPL2E13LineTableModel;
import cerent.util.AnnotatedException;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2E3ProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected INodeModel node;
    protected XPL2E13LineTableModel dataModel = null;
    protected Ds123LineModel[] lineModels = null;
    protected XPL2LineModel[] ethLineModels = null;
    protected PortModel[] ethPortModels = null;
    protected AbstractDwdmLineModel[] dwdmLineModels = null;
    UScrollPane scrollPane = null;
    XPL2ModuleModel eqpmtModel = null;
    private ObservableManager _obsMgr;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("XPL2E3ProvPane");

    public XPL2E3ProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        this.eqpmtModel = xPL2ModuleModel;
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        this.ethLineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.dwdmLineModels = xPL2ModuleModel.getDwdmLineModels();
        this.ethPortModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.lineModels = (Ds123LineModel[])xPL2ModuleModel.getXPL2PdhLines(eEqType.E3_PORT);
        this.dataModel = this.getDataModel(this.lineModels);
        this.lineModels = this.dataModel.filterMiTopLines(this.lineModels);
        this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[2]);
        attributeArray = this.dataModel.getAttributeArray("TxClockSource");
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[3]);
        attributeArray = this.dataModel.getAttributeArray("E3FramingType");
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[4]);
        attributeArray = this.dataModel.getAttributeArray("E3LineCoding");
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(XPL2DS13LineTableModel.columnNames[5]);
        this.table.removeColumn(tableColumn);
        this.add((Component)this.scrollPane);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected XPL2E13LineTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new XPL2E13LineTableModel(this.eqpmtModel, ds123LineModelArray, eEqType.E3_PORT);
    }

    @Override
    public void dispose() {
        int n;
        if (db.on()) {
            db.println("Called dispose");
        }
        for (n = 0; n < this.ethLineModels.length; ++n) {
            this.ethLineModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.ethPortModels.length; ++n) {
            this.ethPortModels[n].deleteObserver((Observer)((Object)this));
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In XPL2E1ProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyToLine(n);
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    protected void applyToLine(int n) throws Exception {
        sConfig sConfig2 = this.dataModel.getConfig(n);
        if (db.on()) {
            this.printConfig(sConfig2);
        }
        sConfig2.lineLength = 225;
        this.lineModels[n].setConfig(sConfig2);
        this.lineModels[n].setAlias(this.dataModel.getPortName(n));
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmLineUpdate.getDwdmLineModels();
        EtherLineModel[] etherLineModelArray = dwdmLineUpdate.getEtherLineModel();
        this.ethLineModels = new XPL2LineModel[etherLineModelArray.length];
        this.dwdmLineModels = new AbstractDwdmLineModel[abstractDwdmLineModelArray.length];
        System.arraycopy(etherLineModelArray, 0, this.ethLineModels, 0, this.ethLineModels.length);
        System.arraycopy(abstractDwdmLineModelArray, 0, this.dwdmLineModels, 0, this.dwdmLineModels.length);
        this.lineModels = (Ds123LineModel[])this.eqpmtModel.getXPL2PdhLines(eEqType.E3_PORT);
        this.lineModels = this.dataModel.filterMiTopLines(this.lineModels);
        this.dataModel.refreshMyLines(this.lineModels);
        this.numLines = this.lineModels.length;
        this.getObsMgr().setObservable((Observable[])this.lineModels);
        this.getObsMgr().addObservable((Observable[])etherLineModelArray);
        this.getObsMgr().addObservable((Observable[])this.dwdmLineModels);
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.ethPortModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.ethPortModels[n]));
        }
        for (n = 0; n < this.ethLineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.ethLineModels[n]));
        }
        for (n = 0; n < this.dwdmLineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.dwdmLineModels[n]));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.ethPortModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.ethPortModels[n]));
        }
        for (n = 0; n < this.ethLineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.ethLineModels[n]));
        }
        for (n = 0; n < this.dwdmLineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.dwdmLineModels[n]));
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XPL2E3ProvPane.this.unRegisterWithModel();
                XPL2E3ProvPane.this.refreshMyLines(null);
            }
        });
    }

    @Override
    public void destroy() {
        this.unRegisterWithModel();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.dataModel.refreshMyLines(null);
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void printConfig(sConfig sConfig2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("Clock Source " + sConfig2.clockSource.value());
        }
        if (db.on()) {
            db.println("Line Type " + sConfig2.lineType.value());
        }
        if (db.on()) {
            db.println("Line Coding " + sConfig2.lineCoding.value());
        }
        if (db.on()) {
            db.println("Signal Mode " + sConfig2.signalMode.value());
        }
        if (db.on()) {
            db.println("Line Length" + sConfig2.lineLength);
        }
        if (db.on()) {
            db.println("FDL Mode Mask" + sConfig2.fdlModeMask);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2E1ProvPane;
    }
}

