/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eEfmOperMode;
import cerent.cms.idl.EtherL2Media.eEfmRfiAction;
import cerent.cms.idl.EtherL2Media.eEfmState;
import cerent.cms.idl.EtherL2Media.sEfmInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2EFMConfigurationTableModel
extends AbstractTableModel
implements Observer {
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLE_ESM_INDEX = 1;
    public static final int MODE_INDEX = 2;
    public static final int LINK_FAULT_INDEX = 3;
    public static final int SESSION_TIMER_INDEX = 4;
    static final String[] columnNames = new String[]{"Port", "EFM State", "Mode", "Link Fault", "Session Timer"};
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private sEfmInfo[] efmInfoTest = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("XPL2EFMConfigurationTableModel");

    public XPL2EFMConfigurationTableModel(XPL2ModuleModel xPL2ModuleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.eqpmtModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.refreshMyLines(xPL2LineModelArray);
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        this.unRegisterWithLineModels();
        this.lineModels = xPL2LineModelArray;
        this.numLines = this.lineModels.length;
        this.efmInfoTest = new sEfmInfo[this.numLines];
        this.numLines = this.lineModels.length;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirty();
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            return n2 != 0;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private eEfmState getEfmStateFromModel(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        eEfmState eEfmState2 = this.lineModels[n].getEfmState();
        return eEfmState2;
    }

    private sEfmInfo getEfmInfoFromModel(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        sEfmInfo sEfmInfo2 = this.lineModels[n].getEfmConfig();
        if (db.on()) {
            db.finest("sEfmInfo: row=" + n);
            db.finest("   EFM State=" + sEfmInfo2.efmState.value());
            db.finest("   Mode=" + sEfmInfo2.efmOperMode.value());
            db.finest("   Link Fault=" + sEfmInfo2.linkFault.value());
            db.finest("   Session Timer=" + sEfmInfo2.sessionTimer);
        }
        return sEfmInfo2;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    private String getLineNumber(int n) {
        try {
            IPortModel iPortModel = this.lineModels[n].getPortModel();
            return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
        }
        catch (Exception exception) {
            if (XPL2EFMConfigurationTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    private Attribute getEfmState(int n) {
        return this.getAttributeFor("EfmStates", this.efmInfoTest[n].efmState.value());
    }

    private Attribute getEfmMode(int n) {
        return this.getAttributeFor("EfmModes", this.efmInfoTest[n].efmOperMode.value());
    }

    private Attribute getEfmLinkFault(int n) {
        return this.getAttributeFor("EfmRfiActions", this.efmInfoTest[n].linkFault.value());
    }

    private String getEfmSessionTimer(int n) {
        return String.valueOf(this.efmInfoTest[n].sessionTimer);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block9: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumber(n);
                    }
                    case 1: {
                        return this.getEfmState(n);
                    }
                    case 2: {
                        return this.getEfmMode(n);
                    }
                    case 3: {
                        return this.getEfmLinkFault(n);
                    }
                    case 4: {
                        return this.getEfmSessionTimer(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("Error in getValueAt in XPL2MapEtherPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                return;
            }
            case 2: {
                this.efmInfoTest[n].efmOperMode = eEfmOperMode.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 4: {
                try {
                    short s;
                    this.efmInfoTest[n].sessionTimer = s = Short.parseShort(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
                break;
            }
            case 1: {
                this.efmInfoTest[n].efmState = eEfmState.from_int(((Attribute)object).getIntValue());
                break;
            }
            case 3: {
                this.efmInfoTest[n].linkFault = eEfmRfiAction.from_int(((Attribute)object).getIntValue());
                break;
            }
            default: {
                return;
            }
        }
        if (!bl) {
            this.isDirty[n][n2] = true;
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public Attribute getAttributeFor(String string, int n) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeForVal(string, n);
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.eqpmtModel.getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyToModel(int n) throws Exception {
        if (this.isDirty[n][1] || this.isDirty[n][2] || this.isDirty[n][3] || this.isDirty[n][4]) {
            this.lineModels[n].setEfmConfig(this.efmInfoTest[n]);
            this.refreshLineFromModel(n);
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        try {
            this.efmInfoTest[n] = null;
            this.efmInfoTest[n] = this.getEfmInfoFromModel(n);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.isDirty[n][i] = false;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Attribute[] getEfmStateAttrs() {
        return this.getAttributeArray("EfmStates");
    }

    public Attribute[] getEfmModeAttrs() {
        return this.getAttributeArray("EfmModes");
    }

    public Attribute[] getEfmRfiActionAttrs() {
        return this.getAttributeArray("EfmRfiActions");
    }

    public Attribute[] getEfmLmAttrs() {
        return this.getAttributeArray("EfmLmActions");
    }

    private void registerWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

