/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.EtherMedia.eMediaType;
import cerent.cms.idl.EtherMedia.sEthMiTopInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2EtherPdhProvTableModel
extends AbstractTableModel
implements Observer {
    private ModuleModel eqpmtModel = null;
    private int baseIndex = 0;
    private sEthMiTopInfo[] lineMiTopInfo = null;
    private Integer[] mplsInLblArr = null;
    private Integer[] mplsOutLblArr = null;
    private Integer[] jitterArr = null;
    private Integer[] txSensitivityArr = null;
    private String[] srcIpArr = null;
    private String[] peerIpArr = null;
    protected boolean[][] isDirty = null;
    protected int numLines = 0;
    public XPL2LineModel[] lineModels = null;
    public static final String[] ethPdhColumnNames = new String[]{"Port", "Port Name", "MPLS Inner Label", "MPLS Outer Label", "Jitter Buffer", "RX Sensitivity", "Source IP Address", "Peer IP Address"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int MPLS_INNER_LABEL_INDEX = 2;
    public static final int MPLS_OUTER_LABEL_INDEX = 3;
    public static final int JITTER_INDEX = 4;
    public static final int SENSITIVITY_INDEX = 5;
    public static final int SOURCE_IP_ADDR_INDEX = 6;
    public static final int PEER_IP_ADDR_INDEX = 7;
    protected static final int ETH_PDH_NUM_COLUMN = 8;
    protected String[] portNames;
    protected String[] columnNames = ethPdhColumnNames;
    private static final SDebug db = new SDebug("XPL2EtherPdhProvTableModel");

    public XPL2EtherPdhProvTableModel(ModuleModel moduleModel, XPL2LineModel[] xPL2LineModelArray) {
        this.lineModels = xPL2LineModelArray;
        this.numLines = xPL2LineModelArray == null ? 0 : xPL2LineModelArray.length;
        this.baseIndex = xPL2LineModelArray != null && xPL2LineModelArray.length > 0 ? xPL2LineModelArray[0].getIndex() : 0;
        this.eqpmtModel = moduleModel;
        this.init();
        this.refreshMyLines(xPL2LineModelArray);
    }

    protected void init() {
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.portNames = new String[this.numLines];
        this.lineMiTopInfo = new sEthMiTopInfo[this.numLines];
        this.mplsInLblArr = new Integer[this.numLines];
        this.mplsOutLblArr = new Integer[this.numLines];
        this.jitterArr = new Integer[this.numLines];
        this.txSensitivityArr = new Integer[this.numLines];
        this.srcIpArr = new String[this.numLines];
        this.peerIpArr = new String[this.numLines];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block13: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 1: {
                        return this.getPortName(n);
                    }
                    case 2: {
                        return this.getMplsInnerLabel(n);
                    }
                    case 3: {
                        return this.getMplsOuterLabel(n);
                    }
                    case 4: {
                        return this.getJitter(n);
                    }
                    case 6: {
                        return this.getSrcIpAddr(n);
                    }
                    case 7: {
                        return this.getPeerIpAddr(n);
                    }
                    case 5: {
                        int n3 = this.getSensitivity(n);
                        if (n3 == 0) {
                            return "NA";
                        }
                        return n3;
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block13;
                db.println("Error in getValueAt in HdGePortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.portNames[n] = (String)object;
            }
            case 2: {
                this.mplsInLblArr[n] = (Integer)object;
            }
            case 3: {
                this.mplsOutLblArr[n] = (Integer)object;
            }
            case 4: {
                this.jitterArr[n] = (Integer)object;
            }
            case 6: {
                this.srcIpArr[n] = (String)object;
            }
            case 7: {
                this.peerIpArr[n] = (String)object;
            }
            case 5: {
                this.txSensitivityArr[n] = (Integer)object;
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public String getLineNumberFor(int n) {
        String string = "";
        try {
            string = PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[n].getPortModel(), (boolean)false, (boolean)true);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return string;
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.lineModels[n].getAlias();
        }
        return this.portNames[n];
    }

    public Integer getMplsInnerLabel(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return new Integer(this.lineMiTopInfo[n].inMplsLabel);
    }

    public Integer getMplsOuterLabel(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return new Integer(this.lineMiTopInfo[n].outMplsLabel);
    }

    public String getSrcIpAddr(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return XPL2EtherPdhProvTableModel.asString(this.lineMiTopInfo[n].srcIpAddr);
    }

    public String getPeerIpAddr(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return XPL2EtherPdhProvTableModel.asString(this.lineMiTopInfo[n].peerIpAddr);
    }

    public Integer getJitter(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return new Integer(this.lineMiTopInfo[n].jitter);
    }

    public ArrayList getJitterRange(int n) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        eMediaType eMediaType2 = this.lineModels[n].getEthMediaType();
        if (eMediaType2 == eMediaType.DS3oETH) {
            arrayList.add(new Integer(400));
            arrayList.add(new Integer(45000));
        } else if (eMediaType2 == eMediaType.E3oETH) {
            arrayList.add(new Integer(400));
            arrayList.add(new Integer(60000));
        } else {
            arrayList.add(new Integer(1500));
            arrayList.add(new Integer(200000));
        }
        return arrayList;
    }

    public Integer getSensitivity(int n) throws NoSuchInterface {
        if (this.lineMiTopInfo[n] == null) {
            this.lineMiTopInfo[n] = this.getLineMiTopInfo(n);
        }
        return new Integer(this.lineMiTopInfo[n].sensitivity);
    }

    public sEthMiTopInfo getLineMiTopInfo(int n) {
        try {
            if (this.lineMiTopInfo[n] == null) {
                this.lineMiTopInfo[n] = this.lineModels[n].getMiTopInfo();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
        return this.lineMiTopInfo[n];
    }

    public void setLineMiTopInfo(sEthMiTopInfo sEthMiTopInfo2, int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        this.lineModels[n].setMiTopInfo(sEthMiTopInfo2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private static String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    public void refreshLineFromModel(int n) {
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) {
        block3: {
            try {
                this.lineMiTopInfo[n] = this.lineModels[n].getMiTopInfo();
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.mplsInLblArr[n] = new Integer(this.lineMiTopInfo[n].inMplsLabel);
        this.mplsOutLblArr[n] = new Integer(this.lineMiTopInfo[n].outMplsLabel);
        this.jitterArr[n] = new Integer(this.lineMiTopInfo[n].jitter);
        this.txSensitivityArr[n] = new Integer(this.lineMiTopInfo[n].sensitivity);
        this.srcIpArr[n] = XPL2EtherPdhProvTableModel.asString(this.lineMiTopInfo[n].srcIpAddr);
        this.peerIpArr[n] = XPL2EtherPdhProvTableModel.asString(this.lineMiTopInfo[n].peerIpAddr);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshMyLines(XPL2LineModel[] xPL2LineModelArray) {
        int n;
        this.unRegisterWithLineModels();
        XPL2LineModel[] xPL2LineModelArray2 = xPL2LineModelArray;
        if (xPL2LineModelArray2 == null) {
            xPL2LineModelArray2 = ((XPL2ModuleModel)this.eqpmtModel).getXPL2EtherLines();
        }
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>(Arrays.asList(xPL2LineModelArray2));
        for (n = 0; n < xPL2LineModelArray2.length; ++n) {
            if (xPL2LineModelArray2[n].isMiTopLine()) continue;
            arrayList.remove(xPL2LineModelArray2[n]);
        }
        this.lineModels = arrayList.toArray(new XPL2LineModel[arrayList.size()]);
        this.numLines = this.lineModels.length;
        this.init();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.resetLineCache(n);
        }
        this.registerWithLineModels();
        this.fireTableDataChanged();
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public void destroy() {
        int n;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.isDirty = null;
        for (n = 0; n < this.portNames.length; ++n) {
            this.portNames[n] = null;
        }
        for (n = 0; n < this.lineMiTopInfo.length; ++n) {
            this.lineMiTopInfo[n] = null;
        }
        this.lineMiTopInfo = null;
    }

    private void registerWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                int n;
                if (db.on()) {
                    db.println("Got an Update Message for " + observable);
                }
                if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                    this.refreshLineFromModel(n);
                }
            } else if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                if (db.on()) {
                    db.println("Got an Update Adding New LineModel for " + observable);
                }
                this.refreshMyLines(null);
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("Got an Update Adding New LineModel for " + observable);
                }
                this.refreshMyLines(null);
            }
        }
    }

    public String[] getRxSensitivityValues() {
        String[] stringArray = new String[]{"-12", "-43"};
        if (this.eqpmtModel.getNodeModel().getTdmProtocolType() == 0) {
            String[] stringArray2 = new String[]{"-36", "-15"};
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

