/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eCFMRemoteMEPState;
import cerent.cms.idl.EtherL2Media.sMEPCCDB;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.MacAddrFormat;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2MEPCCDBColumnRenderer
extends AbstractColumnRenderer {
    private static final int MPID = 0;
    private static final int MAC_ADDR = 1;
    private static final int DNAME = 2;
    private static final int MANAME = 3;
    private static final int SVLANID = 4;
    private static final int PORT = 5;
    private static final int LIFETIME = 6;
    private static final int LASTCC = 7;
    private static final int REMOTEMEP = 8;
    private static final int COLUMN_NO = 9;
    private JLabel label = new JLabel();
    public static final String REMOTE_MEP_STATE = "CFMRemoteMEPState";
    private static AttributeMaps attributeMap = new AttributeMaps();
    protected static final SDebug db = new SDebug("XPL2MEPCCDBColumnRenderer");

    public XPL2MEPCCDBColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        sMEPCCDB sMEPCCDB2 = (sMEPCCDB)object;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 1: {
                string = MacAddrFormat.format(sMEPCCDB2.macAddr.addr);
                break;
            }
            case 4: {
                string = String.valueOf(sMEPCCDB2.svlanId);
                break;
            }
            case 6: {
                string = String.valueOf(sMEPCCDB2.ccLifeTime);
                break;
            }
            case 5: {
                string = String.valueOf(sMEPCCDB2.incomingPort);
                break;
            }
            case 0: {
                string = String.valueOf(sMEPCCDB2.mpId);
                break;
            }
            case 7: {
                string = String.valueOf(sMEPCCDB2.ageOflastCC);
                break;
            }
            case 2: {
                string = sMEPCCDB2.maintenanceDomain.name;
                break;
            }
            case 3: {
                string = sMEPCCDB2.MAname;
                break;
            }
            case 8: {
                string = this.getRemoteMepString(sMEPCCDB2.remoteMEPSt);
            }
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getRemoteMepString(eCFMRemoteMEPState eCFMRemoteMEPState2) {
        return XPL2MEPCCDBColumnRenderer.getRmonAttributeMaps().getAttributeForVal(REMOTE_MEP_STATE, eCFMRemoteMEPState2.value()).toString();
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = XPL2MEPCCDBColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int n3 = XPL2MEPCCDBColumnRenderer.getPortInt(nodeModelDelegate, n);
        if (n2 == -1 || n3 == -1) {
            return "unknown";
        }
        return "s" + String.valueOf(n2) + "/p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPString(XPL2LineModel xPL2LineModel) {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
        try {
            return entityCellRenderer.getPortString((IEntityModel)xPL2LineModel.getPort(), false);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return null;
        }
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            EntityModel entityModel = (EntityModel)nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString(entityModel, false);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return null;
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getSlotNum();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return -1;
        }
    }

    static int getPortInt(NodeModelDelegate nodeModelDelegate, int n) {
        try {
            return nodeModelDelegate.getIfModels().getInterfaceModel(n).getPortModel().getPort();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return -1;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        sMEPCCDB sMEPCCDB2 = (sMEPCCDB)object;
        sMEPCCDB sMEPCCDB3 = (sMEPCCDB)object2;
        switch (n) {
            case 1: {
                String string = MacAddrFormat.format(sMEPCCDB2.macAddr.addr);
                String string2 = MacAddrFormat.format(sMEPCCDB3.macAddr.addr);
                n2 = string.compareTo(string2);
                break;
            }
            case 4: {
                n2 = ComparisonUtil.compare((int)sMEPCCDB2.svlanId, (int)sMEPCCDB3.svlanId);
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare((int)sMEPCCDB2.ccLifeTime, (int)sMEPCCDB3.ccLifeTime);
                break;
            }
            case 5: {
                n2 = ComparisonUtil.compare((int)sMEPCCDB2.incomingPort, (int)sMEPCCDB3.incomingPort);
                break;
            }
            case 0: {
                n2 = ComparisonUtil.compare((int)sMEPCCDB2.mpId, (int)sMEPCCDB3.mpId);
                break;
            }
            case 7: {
                n2 = ComparisonUtil.compare((int)sMEPCCDB2.ageOflastCC, (int)sMEPCCDB3.ageOflastCC);
                break;
            }
            case 2: {
                n2 = sMEPCCDB2.maintenanceDomain.name.compareTo(sMEPCCDB3.maintenanceDomain.name);
                break;
            }
            case 3: {
                n2 = sMEPCCDB2.MAname.compareTo(sMEPCCDB3.MAname);
                break;
            }
            case 8: {
                n2 = this.getRemoteMepString(sMEPCCDB2.remoteMEPSt).compareTo(this.getRemoteMepString(sMEPCCDB3.remoteMEPSt));
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[9];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2MEPCCDBColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 1: {
                string = "Mac Address";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Svlan ID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 6: {
                string = "CC LifeTime";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Port";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 0: {
                string = "MPID";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 7: {
                string = "Last CC Age";
                n3 = 70;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Domain";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "MA Name";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 8: {
                string = "Remote MEP State";
                n3 = 130;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2MEPCCDBColumnRenderer(string, n3, bl, n2);
    }

    public static AttributeMaps getRmonAttributeMaps() {
        if (attributeMap.size() > 0) {
            return attributeMap;
        }
        String string = REMOTE_MEP_STATE;
        TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(8), new Attribute("Admin Down", 8));
        treeMap.put(new Integer(5), new Attribute("Dormant", 5));
        treeMap.put(new Integer(2), new Attribute("Down", 2));
        treeMap.put(new Integer(0), new Attribute("Invalid", 0));
        treeMap.put(new Integer(10), new Attribute("Local Excess Error", 10));
        treeMap.put(new Integer(7), new Attribute("Lower Layer Down", 7));
        treeMap.put(new Integer(6), new Attribute("Not Present", 6));
        treeMap.put(new Integer(9), new Attribute("Remote Excess Error", 9));
        treeMap.put(new Integer(3), new Attribute("Test", 3));
        treeMap.put(new Integer(4), new Attribute("Unknown", 4));
        treeMap.put(new Integer(1), new Attribute("Up", 1));
        attributeMap.put(string, treeMap);
        return attributeMap;
    }
}

