/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.MIPInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.xpl2.XPL2MIPTableModel;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class XPL2MIPDataSource
extends AbstractRowDataSource
implements Observer {
    private ArrayList mipList = new ArrayList();
    XPL2ModuleModel moduleM = null;
    private static final SDebug db = new SDebug("XPL2MIPDataSource");

    public XPL2MIPDataSource(ModuleModel moduleModel) {
        this.moduleM = (XPL2ModuleModel)moduleModel;
    }

    public void getMIPList() {
        MIPInfo[] mIPInfoArray = null;
        try {
            mIPInfoArray = this.moduleM.getMIPS();
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        this.mipList = new ArrayList();
        for (int i = 0; i < mIPInfoArray.length; ++i) {
            this.mipList.add(mIPInfoArray[i]);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Integer n = (Integer)object;
        if (object.equals(ModelUpdateType.CHANGED)) {
            if (XPL2MIPDataSource.db.on) {
                db.println("Receiving ModelUpdateType.CHANGE");
            }
        } else if (object.equals(ModelUpdateType.ADDED)) {
            if (XPL2MIPDataSource.db.on) {
                db.println("Receiving ModelUpdateType.ADDED");
            }
        } else if (object.equals(ModelUpdateType.DELETED) && XPL2MIPDataSource.db.on) {
            db.println("Receiving ModelUpdateType.DELETED");
        }
        this.getMIPList();
        this.fireDataSourceChanged();
    }

    public void refresh() {
        this.getMIPList();
        this.fireDataSourceChanged();
    }

    public int getRowCount() {
        return this.mipList.size();
    }

    public Object getObjectAtRow(int n) {
        return this.mipList.get(n);
    }

    public Collection getAllObjects() {
        return this.mipList;
    }

    public void dispose() {
        if (XPL2MIPDataSource.db.on) {
            db.println("Disposing XPL2MIPDataSrc");
        }
        try {
            for (int i = 0; i < this.mipList.size(); ++i) {
                MIPInfo mIPInfo = (MIPInfo)this.mipList.get(i);
                mIPInfo.getLineModel().deleteObserver(this);
            }
        }
        catch (Exception exception) {
            db.finest("Exception in dispose() " + exception);
        }
    }

    public void deleteMIP(XPL2MIPTableModel xPL2MIPTableModel, int[] nArray) throws EMCProvisionError {
        for (int i = 0; i < nArray.length; ++i) {
            MIPInfo mIPInfo = (MIPInfo)xPL2MIPTableModel.getValueAt(nArray[i], 0);
            XPL2LineModel xPL2LineModel = mIPInfo.getLineModel();
            xPL2LineModel.removeMIP(mIPInfo);
        }
        this.refresh();
    }
}

