/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.IMAProfileInfo;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.xpl2.XPL2CFMMappingPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XPL2MappingDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final SDebug db = new SDebug("XPL2MappingDialog");
    private static final String LONGEST_PORT_NAME = "slot 14 (ASAP_4), port 4-4-1 (OC48)";
    private JButton okButton;
    private JButton cancelButton;
    private static final String TITLE = "Link MA Profiles";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    protected SortableEntityListModel availListModel;
    protected SortableEntityListModel mainListModel;
    private JList availList;
    protected JList mainList;
    private JButton toMainPB;
    private JButton fromMainPB;
    JLabel protLB;
    JPanel availPanel;
    JPanel mainPanel;
    private ModuleModel module;
    private ArrayList tempMain = new ArrayList();
    private ArrayList tempFinal = new ArrayList();
    private ArrayList<IMAProfileInfo> listOfDomain = new ArrayList();
    XPL2CFMMappingPane dataPane;
    private MappingCellRenderer mapRenderer = new MappingCellRenderer();
    private int maxMainEntities;

    public XPL2MappingDialog(Frame frame, ArrayList<IMAProfileInfo> arrayList, XPL2CFMMappingPane xPL2CFMMappingPane) {
        super(frame, TITLE, true);
        this.dataPane = xPL2CFMMappingPane;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XPL2MappingDialog.this.dispose();
            }
        });
        this.module = this.module;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttrsPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.mainListModel.removeAllElements();
        this.availListModel.removeAllElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.availListModel.addElement(arrayList.get(i));
        }
        this.setListsEnabled(true);
        this.enableToFromButtons();
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    protected void setListsEnabled(boolean bl) {
        if (db.on()) {
            db.println("setListsEnabled " + bl);
        }
        this.availList.setEnabled(bl);
        this.mainList.setEnabled(bl);
        this.enableToFromButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.dispose();
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.toMainPB) {
            if (db.on()) {
                db.println("actionPerformed: toMainPB");
            }
            this.moveMainEntities(this.availList, this.mainList);
            this.toMainPB.setEnabled(false);
        } else if (object == this.fromMainPB) {
            if (db.on()) {
                db.println("actionPerformed: fromMainPB");
            }
            this.moveMainEntities(this.mainList, this.availList);
            this.fromMainPB.setEnabled(false);
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.availList) {
                if (db.on()) {
                    db.println("valueChanged: availList selection set");
                }
                this.toMainPB.setEnabled(!this.availList.getSelectionModel().isSelectionEmpty());
            } else if (listSelectionEvent.getSource() == this.mainList) {
                if (db.on()) {
                    db.println("valueChanged: mainList selection set");
                }
                this.fromMainPB.setEnabled(!this.mainList.getSelectionModel().isSelectionEmpty());
            }
        } else if (db.on()) {
            db.println("valueChanged: value is adjusting");
        }
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 5, 5));
        Dimension dimension = new Dimension(100, 20);
        JPanel jPanel4 = XPL2MappingDialog.createHorizontalPanel(null);
        JLabel jLabel = new JLabel("Select MA Profiles");
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        jPanel4.add(jLabel);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel4);
        jPanel2.add((Component)jPanel3, "North");
        jPanel4 = XPL2MappingDialog.createHorizontalPanel(null);
        this.availPanel = jPanel = XPL2MappingDialog.createVerticalPanel("Available Profiles");
        this.availListModel = new SortableEntityListModel();
        this.availList = new JList(this.availListModel);
        this.availList.setName("Available Entities");
        jPanel.add((Component)new UScrollPane((Component)this.availList));
        this.availList.setCellRenderer(this.mapRenderer);
        this.availList.setFixedCellHeight(20);
        this.availList.setFixedCellWidth(350);
        this.availList.setVisibleRowCount(10);
        this.availList.addListSelectionListener(this);
        this.availList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XPL2MappingDialog.this.moveMainEntities(XPL2MappingDialog.this.availList, XPL2MappingDialog.this.mainList);
                    XPL2MappingDialog.this.toMainPB.setEnabled(false);
                }
            }
        });
        jPanel4.add(jPanel);
        jPanel = XPL2MappingDialog.createVerticalPanel(null);
        jPanel.add(Box.createVerticalGlue());
        this.toMainPB = new JButton(">>");
        jPanel.add(this.toMainPB);
        this.toMainPB.addActionListener(this);
        jPanel.add(Box.createVerticalGlue());
        this.fromMainPB = new JButton("<<");
        jPanel.add(this.fromMainPB);
        this.fromMainPB.addActionListener(this);
        jPanel.add(Box.createVerticalGlue());
        jPanel4.add(jPanel);
        this.mainPanel = jPanel = XPL2MappingDialog.createVerticalPanel("Linked Profiles");
        this.mainListModel = new SortableEntityListModel();
        this.mainList = new JList(this.mainListModel);
        this.mainList.setName("Working Entities");
        jPanel.add((Component)new UScrollPane((Component)this.mainList));
        this.mainList.setFixedCellHeight(20);
        this.mainList.setFixedCellWidth(350);
        this.mainList.setCellRenderer(this.mapRenderer);
        this.mainList.setVisibleRowCount(10);
        this.mainList.addListSelectionListener(this);
        this.mainList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XPL2MappingDialog.this.moveMainEntities(XPL2MappingDialog.this.mainList, XPL2MappingDialog.this.availList);
                    XPL2MappingDialog.this.fromMainPB.setEnabled(false);
                }
            }
        });
        jPanel4.add(jPanel);
        jPanel2.add((Component)jPanel4, "Center");
        this.enableToFromButtons();
        return jPanel2;
    }

    private void moveMainEntities(JList jList, JList jList2) {
        SortableEntityListModel sortableEntityListModel = (SortableEntityListModel)jList.getModel();
        SortableEntityListModel sortableEntityListModel2 = (SortableEntityListModel)jList2.getModel();
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        while (n <= listSelectionModel.getMaxSelectionIndex()) {
            if (listSelectionModel.isSelectedIndex(n)) {
                if (jList2 == this.mainList && this.mainListModel.getSize() >= 10) {
                    if (!db.on()) break;
                    db.println("already >= 10 main entities");
                    break;
                }
                sortableEntityListModel2.addElement(sortableEntityListModel.getElementAt(n));
                sortableEntityListModel.removeElementAt(n);
                continue;
            }
            ++n;
        }
        listSelectionModel.clearSelection();
    }

    protected void enableToFromButtons() {
        boolean bl = this.availList != null && this.availList.getModel() != null && this.availList.isEnabled() && this.availList.getModel().getSize() > 0 && !this.availList.isSelectionEmpty();
        boolean bl2 = this.mainList != null && this.mainList.getModel() != null && this.mainList.isEnabled() && this.mainList.getModel().getSize() > 0 && !this.mainList.isSelectionEmpty();
        this.toMainPB.setEnabled(bl);
        this.fromMainPB.setEnabled(bl2);
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    public static JPanel createHorizontalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean apply() throws NoSuchInterface {
        Object[] objectArray = new IMAProfileInfo[this.mainList.getModel().getSize()];
        if (this.mainList.getModel().getSize() > 0) {
            this.mainListModel.copyInto(objectArray);
        }
        this.dataPane.linkProfiles((IMAProfileInfo[])objectArray);
        return true;
    }

    public class MappingCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MappingCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof IMAProfileInfo) {
                this.setText(((IMAProfileInfo)object).getMAName() + " / " + String.valueOf(((IMAProfileInfo)object).getVlanId()));
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    public class SortableEntityListModel
    extends AbstractListModel {
        ArrayList theList = new ArrayList();

        @Override
        public Object getElementAt(int n) {
            return this.theList.get(n);
        }

        @Override
        public int getSize() {
            return this.theList.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(Object object) {
            int n = 0;
            IMAProfileInfo iMAProfileInfo = (IMAProfileInfo)object;
            if (iMAProfileInfo != null) {
                ArrayList arrayList = this.theList;
                synchronized (arrayList) {
                    IMAProfileInfo iMAProfileInfo2;
                    for (int i = 0; i < this.theList.size() && iMAProfileInfo.compareTo((Object)(iMAProfileInfo2 = (IMAProfileInfo)this.theList.get(i))) >= 0; ++i) {
                        if (iMAProfileInfo.compareTo((Object)iMAProfileInfo2) == 0) {
                            return;
                        }
                        ++n;
                    }
                    this.add(n, object);
                }
            }
        }

        public boolean contains(Object object) {
            return this.theList.contains(object);
        }

        private void add(int n, Object object) {
            this.theList.add(n, object);
            this.fireIntervalAdded(this, n, n);
        }

        public void remove(Object object) {
            int n = this.theList.indexOf(object);
            this.theList.remove(object);
            if (n >= 0) {
                this.fireIntervalRemoved(this, n, n);
            }
        }

        public void removeElementAt(int n) {
            this.theList.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void removeAllElements() {
            int n = this.theList.size() - 1;
            this.theList.clear();
            if (n >= 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyInto(Object[] objectArray) {
            ArrayList arrayList = this.theList;
            synchronized (arrayList) {
                for (int i = 0; i < this.theList.size(); ++i) {
                    objectArray[i] = this.theList.get(i);
                }
            }
        }
    }
}

