/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eCRCThreshold;
import cerent.cms.idl.EtherL2Media.eCardFrpHoldOffTime;
import cerent.cms.idl.EtherL2Media.eCardFrpRole;
import cerent.cms.idl.EtherL2Media.eCardFrpState;
import cerent.cms.idl.EtherL2Media.eProtectionInterOPMode;
import cerent.cms.idl.EtherL2Media.sCrcInfo;
import cerent.cms.idl.EtherL2Media.sFrpInfo;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2ProtectionTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2ProtectionProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener,
ActionListener {
    private static final String PROTECTION_DISABLED = "Disabled";
    private static final String PROTECTION_FORCED = "Forced";
    private static final String PROTECTION_ENABLED = "Enabled";
    private static final String MASTER_MODE = "Master";
    protected XPL2ProtectionTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    private JCheckBox masterCheck;
    private JComboBox holdOffCombo;
    private JComboBox protectionCombo;
    private JButton refreshBtn = new JButton("Refresh");
    private JComboBox protectionModeCombo;
    private JCheckBox switchWithCRCAlarm;
    private JComboBox crcThrCombo;
    private JComboBox soakCount;
    private JComboBox pollInterval;
    private boolean neSupportsCrcConfig;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2ProtectionProvPane");

    public XPL2ProtectionProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.lineModels = this.eqpmtModel.getXPL2NNITrunkLines();
        this.neSupportsCrcConfig = false;
        String string2 = this.eqpmtModel.getNodeModelDelegate().getSwVersion();
        if (string2.compareTo("09.21") > 0) {
            this.neSupportsCrcConfig = true;
        }
        this.dataModel = new XPL2ProtectionTableModel(this.eqpmtModel, this.lineModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add(this.makeControlPanel(), "South");
        this.add((Component)uScrollPane);
        this.registerWithModel();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.masterCheck.setEnabled(AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING));
        this.protectionCombo.setEnabled(AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING));
        this.holdOffCombo.setEnabled(AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING));
        this.lineModels = this.eqpmtModel.getXPL2NNITrunkLines();
        this.dataModel.refreshMyLines(this.lineModels);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        objectArray = this.dataModel.getBridgePortStateValues();
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
        tableColumn.setPreferredWidth(105);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(180);
        if (!this.neSupportsCrcConfig) {
            this.table.removeColumn(tableColumn);
        }
        this.table.sizeColumnsToFit(-1);
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2ProtectionProvPane.createHorizontalPanel(null);
        jPanel2.add(new JLabel(MASTER_MODE));
        this.masterCheck = new JCheckBox("", false);
        Object[] objectArray = new Object[]{PROTECTION_DISABLED, PROTECTION_ENABLED, PROTECTION_FORCED};
        this.protectionCombo = new JComboBox<Object>(objectArray);
        this.masterCheck.addActionListener(this);
        this.protectionCombo.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.masterCheck);
        jPanel2.add(Box.createHorizontalStrut(15));
        jPanel2.add(new JLabel("Protection: "));
        jPanel2.add(this.protectionCombo);
        Object[] objectArray2 = new Object[]{HOLD_OFF_TIME.DISABLED, HOLD_OFF_TIME._50MSEC, HOLD_OFF_TIME._100MSEC, HOLD_OFF_TIME._200MSEC, HOLD_OFF_TIME._500MSEC, HOLD_OFF_TIME._1SEC, HOLD_OFF_TIME._2SEC, HOLD_OFF_TIME._5SEC};
        this.holdOffCombo = new JComboBox<Object>(objectArray2);
        this.holdOffCombo.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(15));
        jPanel2.add(new JLabel("Hold Off Time: "));
        jPanel2.add(this.holdOffCombo);
        jPanel2.add(Box.createHorizontalStrut(30));
        this.refreshBtn.addActionListener(this);
        jPanel2.add(this.refreshBtn);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        if (this.neSupportsCrcConfig) {
            jPanel.add((Component)this.makeCrcControlPanel(), "South");
        }
        return jPanel;
    }

    private JPanel makeCrcControlPanel() {
        int n;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2ProtectionProvPane.createHorizontalPanel(null);
        Object[] objectArray = new Object[]{PROT_INTEROP_MODE.INDEPENDENT, PROT_INTEROP_MODE.HANDSHAKE};
        this.protectionModeCombo = new JComboBox<Object>(objectArray);
        jPanel2.add(new JLabel("Switch With CRC Alarm: "));
        this.switchWithCRCAlarm = new JCheckBox("", true);
        this.switchWithCRCAlarm.addActionListener(this);
        jPanel2.add(this.switchWithCRCAlarm);
        jPanel2.add(Box.createHorizontalStrut(5));
        Object[] objectArray2 = new Object[]{CRC_THREHOLD.THR_10_E_2, CRC_THREHOLD.THR_10_E_3, CRC_THREHOLD.THR_10_E_4};
        this.crcThrCombo = new JComboBox<Object>(objectArray2);
        this.crcThrCombo.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(15));
        jPanel2.add(new JLabel("CRC Threshold:"));
        jPanel2.add(this.crcThrCombo);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.soakCount = new JComboBox();
        for (n = 3; n <= 10; ++n) {
            this.soakCount.addItem(new Integer(n));
        }
        this.soakCount.addActionListener(this);
        jPanel2.add(new JLabel("CRC Soak Count:"));
        jPanel2.add(this.soakCount);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.pollInterval = new JComboBox();
        for (n = 10; n <= 60; ++n) {
            this.pollInterval.addItem(new Integer(n));
        }
        this.pollInterval.addActionListener(this);
        jPanel2.add(new JLabel("CRC Poll Interval:"));
        jPanel2.add(this.pollInterval);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.isProvPaneDirty() || this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public void refreshMyLines(Object object) {
        this.lineModels = this.eqpmtModel.getXPL2NNITrunkLines();
        this.dataModel.refreshMyLines(this.lineModels);
    }

    @Override
    public void applyChangesToModel() throws Exception {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.dataModel.applyToModel(i);
        }
        this.resetDirty();
        sFrpInfo sFrpInfo2 = new sFrpInfo();
        sFrpInfo2.frpRole = this.masterCheck.isSelected() ? eCardFrpRole.FRP_MASTER_CARD : eCardFrpRole.FRP_SLAVE_CARD;
        sFrpInfo2.frpState = eCardFrpState.from_int(this.protectionCombo.getSelectedIndex());
        sFrpInfo2.frpHoldOffTime = ((HOLD_OFF_TIME)((Object)this.holdOffCombo.getSelectedItem())).getEnum();
        if (null != this.protectionModeCombo) {
            eProtectionInterOPMode eProtectionInterOPMode2 = ((PROT_INTEROP_MODE)((Object)this.protectionModeCombo.getSelectedItem())).getEnum();
        }
        sCrcInfo sCrcInfo2 = new sCrcInfo();
        sCrcInfo2.switchWithCRCAlarm = false;
        if (null != this.switchWithCRCAlarm) {
            if (this.switchWithCRCAlarm.isSelected()) {
                sCrcInfo2.switchWithCRCAlarm = true;
            }
            sCrcInfo2.thresholdCRC = ((CRC_THREHOLD)((Object)this.crcThrCombo.getSelectedItem())).getEnum();
            sCrcInfo2.soakCountCRC = ((Integer)this.soakCount.getSelectedItem()).shortValue();
            sCrcInfo2.pollIntervalCRC = ((Integer)this.pollInterval.getSelectedItem()).shortValue();
        }
        try {
            this.setCursor(3);
            this.eqpmtModel.setFrpInfo(sFrpInfo2);
            this.eqpmtModel.setCrcInfo(sCrcInfo2);
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)provisionError.getEID());
        }
        catch (Exception exception) {
            throw new ConfigError(exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
        super.refresh();
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        sFrpInfo sFrpInfo2 = this.eqpmtModel.getFrpInfo();
        sCrcInfo sCrcInfo2 = this.eqpmtModel.getCrcInfo();
        this.masterCheck.setSelected(sFrpInfo2.frpRole == eCardFrpRole.FRP_MASTER_CARD);
        this.protectionCombo.setSelectedIndex(sFrpInfo2.frpState.value());
        this.holdOffCombo.setSelectedIndex(sFrpInfo2.frpHoldOffTime.value());
        if (this.neSupportsCrcConfig) {
            this.switchWithCRCAlarm.setSelected(sCrcInfo2.switchWithCRCAlarm);
            this.crcThrCombo.setSelectedIndex(sCrcInfo2.thresholdCRC.value() - 1);
            this.soakCount.setSelectedItem(sCrcInfo2.soakCountCRC);
            this.pollInterval.setSelectedItem(sCrcInfo2.pollIntervalCRC);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshBtn) {
            try {
                this.dataModel.refreshActualBridgePortState();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else if (actionEvent.getSource() == this.protectionCombo || actionEvent.getSource() == this.masterCheck) {
            sFrpInfo sFrpInfo2 = this.eqpmtModel.getFrpInfo();
            if ((sFrpInfo2.frpRole != eCardFrpRole.FRP_MASTER_CARD || !this.masterCheck.isSelected()) && (sFrpInfo2.frpRole != eCardFrpRole.FRP_SLAVE_CARD || this.masterCheck.isSelected()) || sFrpInfo2.frpState.value() != this.protectionCombo.getSelectedIndex()) {
                this.setDirty();
            }
        } else if (actionEvent.getSource() == this.holdOffCombo) {
            sFrpInfo sFrpInfo3 = this.eqpmtModel.getFrpInfo();
            if (sFrpInfo3.frpHoldOffTime != ((HOLD_OFF_TIME)((Object)this.holdOffCombo.getSelectedItem())).getEnum()) {
                this.setDirty();
            }
        } else if (actionEvent.getSource() == this.protectionModeCombo) {
            eProtectionInterOPMode eProtectionInterOPMode2 = this.eqpmtModel.getProtOpMode();
            if (eProtectionInterOPMode2 != ((PROT_INTEROP_MODE)((Object)this.protectionModeCombo.getSelectedItem())).getEnum()) {
                this.setDirty();
            }
        } else if (actionEvent.getSource() == this.switchWithCRCAlarm || actionEvent.getSource() == this.crcThrCombo || actionEvent.getSource() == this.soakCount || actionEvent.getSource() == this.pollInterval) {
            this.setDirty();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2ProtectionProvPane;
    }

    private static enum CRC_THREHOLD {
        DISABLED("Disabled", eCRCThreshold.CRC_THR_UNKNOWN),
        THR_10_E_2("10(-e)2", eCRCThreshold.CRC_THR_10_E_2),
        THR_10_E_3("10(-e)3", eCRCThreshold.CRC_THR_10_E_3),
        THR_10_E_4("10(-e)4", eCRCThreshold.CRC_THR_10_E_4);

        private eCRCThreshold value;
        private String label;

        private CRC_THREHOLD(String string2, eCRCThreshold eCRCThreshold2) {
            this.value = eCRCThreshold2;
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }

        public eCRCThreshold getEnum() {
            return this.value;
        }
    }

    private static enum HOLD_OFF_TIME {
        DISABLED("Disabled", eCardFrpHoldOffTime.FRP_HOLD_OFF_DISABLED),
        _50MSEC("50 msec", eCardFrpHoldOffTime.FRP_HOLD_OFF_50_MSEC),
        _100MSEC("100 msec", eCardFrpHoldOffTime.FRP_HOLD_OFF_100_MSEC),
        _200MSEC("200 msec", eCardFrpHoldOffTime.FRP_HOLD_OFF_200_MSEC),
        _500MSEC("500 msec", eCardFrpHoldOffTime.FRP_HOLD_OFF_500_MSEC),
        _1SEC("1 sec", eCardFrpHoldOffTime.FRP_HOLD_OFF_1_SEC),
        _2SEC("2 sec", eCardFrpHoldOffTime.FRP_HOLD_OFF_2_SEC),
        _5SEC("5 sec", eCardFrpHoldOffTime.FRP_HOLD_OFF_5_SEC);

        private eCardFrpHoldOffTime value;
        private String label;

        private HOLD_OFF_TIME(String string2, eCardFrpHoldOffTime eCardFrpHoldOffTime2) {
            this.value = eCardFrpHoldOffTime2;
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }

        public eCardFrpHoldOffTime getEnum() {
            return this.value;
        }
    }

    private static enum PROT_INTEROP_MODE {
        UNKNOWN("Unknown", eProtectionInterOPMode.PROT_OP_UNKNOWN),
        INDEPENDENT("Disabled", eProtectionInterOPMode.PROT_OP_INDEPENDENT),
        HANDSHAKE("Handshake", eProtectionInterOPMode.PROT_OP_HANDSHAKE);

        private eProtectionInterOPMode value;
        private String label;

        private PROT_INTEROP_MODE(String string2, eProtectionInterOPMode eProtectionInterOPMode2) {
            this.value = eProtectionInterOPMode2;
            this.label = string2;
        }

        public String toString() {
            return this.label;
        }

        public eProtectionInterOPMode getEnum() {
            return this.value;
        }
    }
}

