/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eRepPortType;
import cerent.cms.idl.EtherL2Media.eRepVlbOperation;
import cerent.cms.idl.EtherL2Media.sRepSegmentAttributes;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PortModel;
import cerent.cms.model.QinQSettings;
import cerent.cms.model.RepSegmentAttribute;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.REPCreationDialog;
import cerent.cms.ui.xpl2.XPL2REPSegmentTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.WindowHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2REPProvPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    private INodeModel nm;
    protected PortModel[] portModels = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] linesModels = null;
    protected XPL2Layer2LineModel[] layer2Models = null;
    protected RepSegmentAttribute[] repSegmentList = null;
    protected RepSegmentAttribute repSegment = null;
    protected sRepSegmentAttributes test;
    private JLabel portLabel;
    private UComboBox segmentCB;
    private JButton activateVLDBButton;
    private JButton deactivateVLDBButton;
    private JButton deleteButton;
    private JButton resetButton;
    private CSHelpButton helpButton;
    private boolean actVlbButtonDirty = false;
    private boolean deactVlbButtonDirty = false;
    private boolean deleteButtonDirty = false;
    private JButton createRepButton;
    private JButton editRepButton;
    protected XPL2REPSegmentTableModel dataSegmentModel = null;
    private JPanel segmentPane = null;
    private boolean dialogDisplayed;
    private boolean applyChanges = false;
    private ObservableManager _obsMgr;
    private static final SDebug db = new SDebug("XPL2REPProvPane");

    public XPL2REPProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel, short s, short s2, QinQSettings qinQSettings) {
        super(string, (IModel)xPL2ModuleModel.getNodeModel(), tabbedView);
        this.nm = xPL2ModuleModel.getNodeModel();
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.linesModels = xPL2ModuleModel.getXPL2EtherLines();
        this.layer2Models = xPL2ModuleModel.getXPL2Layer2EtherLines();
        this.repSegmentList = xPL2ModuleModel.getRepSegmentAttributesList();
        if (xPL2ModuleModel == null || this.portModels == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + this.portModels);
            }
            return;
        }
        this.init();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        tableColumn = this.table.getColumn(this.table.getColumnName(0));
        tableColumn.setMinWidth(150);
        tableColumn = this.table.getColumn(this.table.getColumnName(1));
        tableColumn.setMinWidth(175);
        tableColumn = this.table.getColumn(this.table.getColumnName(2));
        tableColumn.setMinWidth(100);
        tableColumn = this.table.getColumn(this.table.getColumnName(8));
        tableColumn.setMinWidth(100);
        tableColumn = this.table.getColumn(this.table.getColumnName(9));
        tableColumn.setMinWidth(200);
        tableColumn = this.table.getColumn(this.table.getColumnName(10));
        tableColumn.setMinWidth(150);
        tableColumn = this.table.getColumn(this.table.getColumnName(3));
        tableColumn.setMinWidth(100);
        tableColumn = this.table.getColumn(this.table.getColumnName(4));
        tableColumn.setMinWidth(150);
        tableColumn = this.table.getColumn(this.table.getColumnName(5));
        tableColumn.setMinWidth(150);
    }

    @Override
    protected void addButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = this.getButtonPanel();
            this.add(this.buttonPanel, "East");
        }
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        JPanel jPanel = XPL2REPProvPane.createVerticalPanel(null);
        this.resetButton = new JButton("Reset");
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(this);
        jPanel.add(this.resetButton);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    XPL2REPProvPane.this.helpButton.launchHelp(XPL2REPProvPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(Box.createVerticalStrut(this.resetButton.getPreferredSize().height / 3));
            jPanel.add(this.helpButton);
        }
        return jPanel;
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable[])this.portModels);
        this.getObsMgr().addObservable((Observable[])this.linesModels);
        this.getObsMgr().addObservable((Observable[])this.layer2Models);
    }

    protected void unRegisterWithModel() {
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable[])this.portModels);
        this.getObsMgr().removeObservable((Observable[])this.linesModels);
        this.getObsMgr().removeObservable((Observable[])this.layer2Models);
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    private void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = XPL2REPProvPane.createVerticalPanel(null);
        jPanel.add(this.selectSegment());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.createSegmentTablePane());
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.createSegmentConfigPane());
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
    }

    private JPanel selectSegment() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.portLabel = new JLabel("Segment#: ");
        jPanel.add(this.portLabel);
        this.segmentCB = new UComboBox((Object[])this.repSegmentList);
        jPanel.add((Component)this.segmentCB);
        return jPanel;
    }

    private JPanel createSegmentConfigPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        this.createRepButton = this.makeActionButton("Create");
        jPanel.add(this.createRepButton);
        this.editRepButton = this.makeActionButton("Edit");
        jPanel.add(this.editRepButton);
        this.editRepButton.setEnabled(false);
        return jPanel;
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setFocusPainted(false);
        this.enableComponent(jButton);
        return jButton;
    }

    private JPanel createSegmentTablePane() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        double[] dArray = new double[]{11.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        double[] dArray2 = new double[]{1.0, 0.0, 0.0, 1.0E-4};
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = dArray;
        gridBagLayout.rowWeights = dArray2;
        this.segmentPane = new JPanel(gridBagLayout);
        this.segmentPane.setPreferredSize(new Dimension(380, 160));
        this.segmentPane.setBorder(BorderFactory.createTitledBorder("Selected Segment"));
        this.dataSegmentModel = new XPL2REPSegmentTableModel((Container)((Object)this), this.eqpmtModel);
        this.table = new UTable((TableModel)this.dataSegmentModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.segmentPane.add((Component)uScrollPane, new GridBagConstraints(0, 0, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.enableComponent(this.deleteButton, (IModel)this.nm);
        this.deleteButton.setEnabled(false);
        this.activateVLDBButton = new JButton("Activate VLB");
        this.activateVLDBButton.addActionListener(this);
        this.enableComponent(this.activateVLDBButton, (IModel)this.nm);
        this.activateVLDBButton.setEnabled(false);
        this.deactivateVLDBButton = new JButton("Deactivate VLB");
        this.deactivateVLDBButton.addActionListener(this);
        this.enableComponent(this.deactivateVLDBButton, (IModel)this.nm);
        this.deactivateVLDBButton.setEnabled(false);
        this.segmentPane.add((Component)this.activateVLDBButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.segmentPane.add((Component)this.deactivateVLDBButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.segmentPane.add((Component)this.deleteButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, 0, 0, 5), 0, 0));
        return this.segmentPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        IVlanInfo[] iVlanInfoArray = this.eqpmtModel.getVlanDb();
        this.actVlbButtonDirty = false;
        this.deactVlbButtonDirty = false;
        this.deleteButtonDirty = false;
        if (object == this.createRepButton) {
            REPCreationDialog rEPCreationDialog = new REPCreationDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Create Segment", this.eqpmtModel, this);
            rEPCreationDialog.show();
        } else if (object == this.editRepButton) {
            REPCreationDialog rEPCreationDialog = new REPCreationDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Edit Segment", this.eqpmtModel, this.repSegment, this);
            rEPCreationDialog.show();
        } else if (object == this.resetButton) {
            this.reset();
        } else if (object == this.activateVLDBButton) {
            this.setDirty();
            this.actVlbButtonDirty = true;
            this.apply();
        } else if (object == this.deactivateVLDBButton) {
            this.setDirty();
            this.deactVlbButtonDirty = true;
            this.apply();
        } else if (object == this.deleteButton) {
            this.setDirty();
            this.deleteButtonDirty = true;
            this.apply();
        }
    }

    private void trigerVLDB(int n, boolean bl) throws Exception {
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < this.layer2Models.length; ++i) {
            if (this.layer2Models[i].getIndex() != n) continue;
            xPL2Layer2LineModel = this.layer2Models[i];
            if (bl) {
                xPL2Layer2LineModel.triggerVLB(eRepVlbOperation.ACTIVATE_VLB);
                CerentDialog.infoDialog((Component)((Object)this), (String)"VLB Activation Succeeded", (String)"");
                continue;
            }
            xPL2Layer2LineModel.triggerVLB(eRepVlbOperation.DEACTIVATE_VLB);
            CerentDialog.infoDialog((Component)((Object)this), (String)"VLB De-Activation Succeeded", (String)"");
        }
    }

    private void removeRepPortConfig(int n) throws Exception {
        XPL2Layer2LineModel xPL2Layer2LineModel = null;
        for (int i = 0; i < this.layer2Models.length; ++i) {
            if (this.layer2Models[i].getIndex() != n) continue;
            xPL2Layer2LineModel = this.layer2Models[i];
            xPL2Layer2LineModel.removeRepPortConfig();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void setUpArrayAndComboBoxes() {
        XPL2REPProvPane xPL2REPProvPane = this;
        SegmentIdComboBoxModel segmentIdComboBoxModel = new SegmentIdComboBoxModel(this.repSegmentList);
        this.segmentCB.setModel((ComboBoxModel)segmentIdComboBoxModel);
        if (this.portModels.length == 0) {
            this.segmentCB.setEnabled(false);
            this.editRepButton.setEnabled(false);
        } else {
            this.segmentCB.setEnabled(true);
            this.editRepButton.setEnabled(true);
        }
        RepSegmentAttribute repSegmentAttribute = (RepSegmentAttribute)this.segmentCB.getSelectedItem();
        this.dataSegmentModel.updateModel(repSegmentAttribute);
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    @Override
    public void destroy() {
        if (this.dataSegmentModel != null) {
            this.dataSegmentModel.dispose();
        }
        super.destroy();
    }

    @Override
    public void applyChangesToModel() throws Exception {
        try {
            if (this.actVlbButtonDirty) {
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    this.trigerVLDB(this.repSegment.getPortInfo()[nArray[i]].portIndex, true);
                }
                this.resetDirty();
            } else if (this.deactVlbButtonDirty) {
                int[] nArray = this.table.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    this.trigerVLDB(this.repSegment.getPortInfo()[nArray[i]].portIndex, false);
                }
                this.resetDirty();
            } else if (this.deleteButtonDirty) {
                int[] nArray = this.table.getSelectedRows();
                int n = this.repSegment.getPortInfo().length;
                String string = "";
                string = n == 1 || nArray.length > 1 ? "Do you really want to delete the Segment#" + this.repSegment + "?" : "Do you really want to delete the selected Port from the Segment#" + this.repSegment + "?";
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)"Conform Delete")) {
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    this.removeRepPortConfig(this.repSegment.getPortInfo()[nArray[i]].portIndex);
                }
                this.resetDirty();
            }
        }
        catch (Exception exception) {
            this.refresh();
            throw exception;
        }
    }

    public void resetTable() {
        this.reset();
    }

    private void reset() {
        block2: {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("Exception caught in reset() " + exception);
            }
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.portModels = this.eqpmtModel.getPortModels();
        this.linesModels = this.eqpmtModel.getXPL2EtherLines();
        this.layer2Models = this.eqpmtModel.getXPL2Layer2EtherLines();
        this.repSegmentList = this.eqpmtModel.getRepSegmentAttributesList();
        int n = this.segmentCB.getSelectedIndex();
        int n2 = this.segmentCB.getSelectedIndex();
        if (!this.isProvPaneDirty()) {
            this.setUpArrayAndComboBoxes();
        }
        if (n != -1 && this.segmentCB.getModel().getSize() > n) {
            this.segmentCB.setSelectedIndex(n2);
        }
        if (this.repSegmentList.length == 0) {
            this.editRepButton.setEnabled(false);
        } else if (this.repSegmentList.length == 3) {
            this.createRepButton.setEnabled(false);
        } else if (this.repSegmentList.length < 3) {
            this.createRepButton.setEnabled(true);
        }
        this.refreshFromModelSelectItem();
    }

    public void refreshFromModelSelectItem() throws Exception {
        if (this.portModels.length != 0) {
            RepSegmentAttribute repSegmentAttribute = (RepSegmentAttribute)this.segmentCB.getSelectedItem();
            this.dataSegmentModel.updateModel(repSegmentAttribute);
            this.repSegment = repSegmentAttribute;
        }
    }

    public void refreshFromModelSelectItemNet() throws Exception {
        if (this.portModels.length != 0) {
            // empty if block
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2REPProvPane;
    }

    @Override
    public void update(Observable observable, Object object) {
        if ((observable instanceof PortModel || observable instanceof XPL2LineModel || observable instanceof XPL2Layer2LineModel || observable instanceof XPL2ModuleModel) && object instanceof Integer && object.equals(ModelUpdateType.CHANGED)) {
            this.reset();
            this.resetDirty();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.disableAllButtons();
        } else {
            int n = this.table.getSelectedRow();
            if (n == listSelectionEvent.getFirstIndex()) {
                if (this.repSegment.getPortInfo()[n].portType != eRepPortType.REGULAR_PORT) {
                    this.setVLBActivateEnabled(true);
                }
                this.enableDelete();
            }
        }
    }

    public void setVLBActivateEnabled(boolean bl) {
        WindowHelper.setEnabled((JComponent)this.activateVLDBButton, (boolean)bl);
        WindowHelper.setEnabled((JComponent)this.deactivateVLDBButton, (boolean)bl);
    }

    public void disableAllButtons() {
        WindowHelper.setEnabled((JComponent)this.activateVLDBButton, (boolean)false);
        WindowHelper.setEnabled((JComponent)this.deactivateVLDBButton, (boolean)false);
        WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
    }

    public void enableDelete() {
        WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)true);
    }

    class SegmentChangeEvent
    extends ChangeEvent {
        private Object newValue;

        public SegmentChangeEvent(Object object, Object object2) {
            super(object);
            this.newValue = object2;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    static interface SegmentComboBoxSelectionListener
    extends EventListener {
        public boolean selectionChanged(SegmentChangeEvent var1);
    }

    class SegmentIdComboBoxModel
    extends DefaultComboBoxModel {
        private ArrayList<SegmentComboBoxSelectionListener> selectionListeners;

        public SegmentIdComboBoxModel() {
            this.selectionListeners = new ArrayList();
        }

        public SegmentIdComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.selectionListeners = new ArrayList();
        }

        public void addVetoableSelectionListener(SegmentComboBoxSelectionListener segmentComboBoxSelectionListener) {
            this.selectionListeners.add(segmentComboBoxSelectionListener);
        }

        public void removeVetoableSelectionListener(SegmentComboBoxSelectionListener segmentComboBoxSelectionListener) {
            this.selectionListeners.remove(segmentComboBoxSelectionListener);
        }

        @Override
        public void setSelectedItem(Object object) {
            block2: {
                super.setSelectedItem(object);
                try {
                    XPL2REPProvPane.this.refreshFromModelSelectItem();
                }
                catch (Exception exception) {
                    if (!db.on()) break block2;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }
}

