/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.IStringTag;
import cerent.cms.model.StringTag;
import cerent.cms.xml.AbstractMetaData;
import cerent.cms.xml.AbstractSimpleMetaData;
import cerent.cms.xml.AttributeCmdClassification;
import cerent.cms.xml.IMethodMetaData;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.TypeInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.StringIndex;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodTypeInfo
extends AbstractSimpleMetaData
implements IMethodMetaData {
    static final MethodInfo VoidType = new MethodInfo("void", null, null);
    static final String problemIndicator = "ERROR";
    static final int UNIT_INDENT = 2;
    static final String METHOD_TAG = "method";
    static final String RETURN_TAG = "return";
    static final String PARM_TAG = "parameter";
    static final String COMMENT_TAG = "comment";
    static final String PROPERTY_TAG = "property";
    static final String TYPE_TAG = "type";
    static final String ITEM_TYPE_TAG = "itemtype";
    static final String VALUE_TYPE_TAG = "valuetype";
    static final String HELPER_TAG = "helper";
    static final String ACTION_TAG = "action";
    static final String EXCLUDED_PRODUCTS_TAG = "ExcludedProducts".toLowerCase();
    static final String VOID = "void";
    static final String NS_ATTR = "xmlns";
    static final String NAME_ATTR = "name";
    static final String NAME_ASSIGN = "name=\"";
    static final String ASSOCIATION_NAME = "association-name";
    private static final StringIndex[] StringIndexArrayTemplate = new StringIndex[0];
    private static final MethodInfo[] TypeInfoArrayTemplate = new MethodInfo[0];
    private static OutputFormat defaultOutputFormat = MethodTypeInfo.getOutputFormat();
    public static boolean doEmitComments = true;
    protected String fullyQualifiedClass;
    protected String fullyQualifiedMethod;
    protected MethodInfo returnType;
    protected Map nameToParmType;
    protected String[] argNames;
    protected MethodInfo[] argTypes;
    protected String[] typeNamesInOrder;
    protected boolean isIncludedInObjState;
    protected String comment;
    protected boolean isVoidReturnType;
    protected boolean added;
    protected Properties props;
    static SDebug db = new SDebug("MethodTypeInfo");

    static String getLastSegment(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return n < 0 ? string : string.substring(n + 1);
    }

    public static String getLastSegment(String string) {
        return MethodTypeInfo.getLastSegment(string, ".");
    }

    static String getAllButLastSegment(String string) {
        int n = string.lastIndexOf(".");
        return n < 0 ? string : string.substring(0, n);
    }

    static String createFullyQualifiedClassName(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        return string + "." + string2;
    }

    static String createFullyQualifiedMethodName(String string, String string2, String string3) {
        String string4 = MethodTypeInfo.createFullyQualifiedClassName(string, string2);
        return MethodTypeInfo.createFullyQualifiedMethodName(string4, string3);
    }

    public static String createFullyQualifiedMethodName(String string, String string2) {
        String string3 = string == null || string.length() == 0 ? string2 : string + "." + string2;
        return string3;
    }

    public MethodTypeInfo(String string, MethodInfo methodInfo, MethodInfo[] methodInfoArray, boolean bl, String string2, String[] stringArray) {
        this.init(string, methodInfo, methodInfoArray, bl, string2, stringArray);
    }

    public MethodTypeInfo(String string, MethodTypeInfo methodTypeInfo) {
        this(string, methodTypeInfo, false);
    }

    public MethodTypeInfo(String string, MethodTypeInfo methodTypeInfo, boolean bl) {
        String string2 = null;
        String string3 = null;
        String string4 = methodTypeInfo.fullyQualifiedMethod;
        String string5 = MethodTypeInfo.getLastSegment(string4);
        String string6 = MethodTypeInfo.createFullyQualifiedMethodName(string, string5);
        MethodInfo methodInfo = new MethodInfo(methodTypeInfo.returnType);
        MethodInfo[] methodInfoArray = MethodTypeInfo.copyTypesInfos(methodTypeInfo.argTypes);
        boolean bl2 = methodTypeInfo.isIncludedInObjState;
        String string7 = "";
        this.init(string2, string3, string6, methodInfo, methodInfoArray, bl2, string7, methodTypeInfo.excludedProducts);
        this.mergeProperties(methodTypeInfo.props);
        this.added = bl;
    }

    protected static MethodInfo[] copyTypesInfos(MethodInfo[] methodInfoArray) {
        MethodInfo[] methodInfoArray2 = new MethodInfo[methodInfoArray.length];
        System.arraycopy(methodInfoArray, 0, methodInfoArray2, 0, methodInfoArray.length);
        return methodInfoArray2;
    }

    protected void init(String string, String string2, String string3, MethodInfo methodInfo, MethodInfo[] methodInfoArray, boolean bl, String string4, String[] stringArray) {
        this.fullyQualifiedClass = MethodTypeInfo.createFullyQualifiedClassName(string, string2);
        this.fullyQualifiedMethod = MethodTypeInfo.createFullyQualifiedMethodName(string, string2, string3);
        this.init(this.fullyQualifiedMethod, methodInfo, methodInfoArray, bl, string4, stringArray);
    }

    protected void init(String string, MethodInfo methodInfo, MethodInfo[] methodInfoArray, boolean bl, String string2, String[] stringArray) {
        int n = string.lastIndexOf(".");
        this.fullyQualifiedClass = string.substring(0, n);
        this._init(string, methodInfo, methodInfoArray, bl, string2, stringArray);
    }

    protected void _init(String string, MethodInfo methodInfo, MethodInfo[] methodInfoArray, boolean bl, String string2, String[] stringArray) {
        this.fullyQualifiedMethod = string;
        this.returnType = methodInfo;
        this.isIncludedInObjState = bl;
        String string3 = methodInfo.getType();
        this.isVoidReturnType = string3.equals(VOID);
        if (this.isVoidReturnType || methodInfoArray.length > 0) {
            this.isIncludedInObjState = false;
        }
        this.comment = string2;
        this.excludedProducts = stringArray;
        this.init(methodInfoArray);
    }

    protected void init(MethodInfo[] methodInfoArray) {
        this.argTypes = methodInfoArray;
        this.nameToParmType = new HashMap();
        int n = methodInfoArray == null ? 0 : methodInfoArray.length;
        this.typeNamesInOrder = new String[n];
        this.argNames = new String[n];
        String string = this.fullyQualifiedMethod;
        for (int i = 0; i < n; ++i) {
            String string2;
            MethodInfo methodInfo = methodInfoArray[i];
            this.argNames[i] = string2 = methodInfo.getArgName();
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException(string + " - " + "argNames " + i + " must be each non-empty");
            }
            String string3 = methodInfo.getType();
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException(string + " - " + "argTypes  " + i + " must be each non-empty");
            }
            if (this.nameToParmType.get(string2) != null) {
                throw new IllegalArgumentException(string + " - " + "argNames must be unique");
            }
            this.nameToParmType.put(string2, new StringIndex(string3, i));
            this.typeNamesInOrder[i] = methodInfo.getItemType() != null && methodInfo.getItemType().length() > 0 ? methodInfo.getItemType() : methodInfo.getType();
        }
    }

    public MethodTypeInfo(String string, String string2, Element element) {
        if (!element.getNodeName().equals(METHOD_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: method");
        }
        String string3 = element.getAttribute(NAME_ATTR);
        String string4 = MethodTypeInfo.createFullyQualifiedMethodName(string, string2, string3);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList arrayList = new ArrayList();
        MethodInfo methodInfo = null;
        boolean bl = true;
        String string5 = "";
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string6 = node.getNodeName();
            Element element2 = (Element)node;
            if (string6.equals(PARM_TAG)) {
                this.decodeParmNode(arrayList, element2);
                continue;
            }
            if (string6.equals(RETURN_TAG)) {
                methodInfo = this.decodeReturnNode(element2);
                continue;
            }
            if (string6.equals(COMMENT_TAG)) {
                string5 = MethodTypeInfo.decodeCommentNode(element2);
                continue;
            }
            if (string6.equals(PROPERTY_TAG)) {
                IStringTag iStringTag = this.decodePropertyNode(element2);
                this.mergeProperty(iStringTag);
                continue;
            }
            if (string6.equals(ACTION_TAG)) {
                bl = !this.decodeActionNode(element2);
                continue;
            }
            if (string6.equals(EXCLUDED_PRODUCTS_TAG)) {
                this.excludedProducts = MethodTypeInfo.decodeExcludedProductsNode(element2);
                continue;
            }
            if (!db.on()) continue;
            db.println("method " + string4 + " - unknown tag: " + string6);
        }
        if (methodInfo == null) {
            methodInfo = VoidType;
        }
        MethodInfo[] methodInfoArray = arrayList.toArray(TypeInfoArrayTemplate);
        this.init(string, string2, string3, methodInfo, methodInfoArray, bl, string5, this.excludedProducts);
    }

    protected boolean decodeActionNode(Element element) {
        boolean bl = false;
        String string = MethodTypeInfo.getTextChild(element);
        if (string != null) {
            bl = (string = string.toLowerCase().trim()).equals("true") || string.equals("1") || string.equals("yes");
        }
        return bl;
    }

    static String[] decodeExcludedProductsNode(Element element) {
        String string = MethodTypeInfo.getTextChild(element);
        String[] stringArray = AbstractMetaData.getMetaDataDef(string);
        if (stringArray == null) {
            stringArray = StringArrayTemplate;
        }
        return stringArray;
    }

    protected static String decodeCommentNode(Element element) {
        String string = MethodTypeInfo.getTextChild(element);
        return string;
    }

    protected IStringTag decodePropertyNode(Element element) {
        String string = element.getAttribute(NAME_ATTR);
        String string2 = MethodTypeInfo.getTextChild(element);
        return new StringTag(string, string2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getTextChild(Element element) {
        String string = null;
        StringWriter stringWriter = new StringWriter();
        try {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            StringBuffer stringBuffer = stringWriter.getBuffer();
            BaseMarkupSerializer baseMarkupSerializer = MethodTypeInfo.getSerializer(stringWriter);
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                short s = node.getNodeType();
                if (s == 3) {
                    stringBuffer.append(((CharacterData)node).getData());
                    continue;
                }
                if (s != 1) continue;
                baseMarkupSerializer.serialize((Element)node);
            }
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    protected static BaseMarkupSerializer getSerializer(StringWriter stringWriter) {
        XMLSerializer xMLSerializer = new XMLSerializer();
        xMLSerializer.setOutputCharStream((Writer)stringWriter);
        xMLSerializer.setOutputFormat(defaultOutputFormat);
        return xMLSerializer;
    }

    protected MethodInfo decodeReturnNode(Element element) {
        if (!element.getNodeName().equals(RETURN_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: return");
        }
        return new MethodInfo().decodeTypeChildrenNodes(element);
    }

    protected void decodeParmNode(List list, Element element) {
        if (!element.getNodeName().equals(PARM_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: parameter");
        }
        String string = element.getAttribute(NAME_ATTR);
        MethodInfo methodInfo = new MethodInfo().decodeTypeChildrenNodes(element);
        methodInfo.setArgName(string);
        list.add(methodInfo);
    }

    static String namespaceToPkg(String string) {
        return string == null ? null : string.replace('/', '.');
    }

    static String getFullyQualifiedType(Element element) {
        String string = element.getAttribute(NS_ATTR);
        String string2 = element.getAttribute(NAME_ATTR);
        String string3 = string != null && string.length() > 0 ? MethodTypeInfo.namespaceToPkg(string) + "." + string2 : string2;
        return string3;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void mergeProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        if (this.props == null) {
            this.props = new Properties(properties);
        } else {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this.props.put(string, string2);
            }
        }
    }

    public void mergeProperty(IStringTag iStringTag) {
        if (iStringTag == null) {
            return;
        }
        String string = iStringTag.getFirst();
        String string2 = iStringTag.getSecond();
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(string, string2);
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethod;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClass.equals("com.cisco.ctcutsx.model.PlatformNodeModel")) {
            this.fullyQualifiedClass = "com.cisco.ctcutsX.model.PlatformNodeModel";
        } else if (this.fullyQualifiedClass.equals("com.cisco.ctcutsxsdh.model.PlatformNodeModel")) {
            this.fullyQualifiedClass = "com.cisco.ctcutsXsdh.model.PlatformNodeModel";
        }
        return this.fullyQualifiedClass;
    }

    public String getMethodName() {
        return this.fullyQualifiedMethod.substring(this.fullyQualifiedClass.length() + 1);
    }

    @Override
    public String getReturnType() {
        return this.returnType.getItemType() != null && this.returnType.getItemType().length() > 0 ? this.returnType.getItemType() : this.returnType.getType();
    }

    @Override
    public String getMapValueType() {
        return this.returnType.getMapValueType();
    }

    @Override
    public String getMapKeyType() {
        return this.returnType.getMapKeyType();
    }

    @Override
    public String[] getProductExclusions() {
        return this.excludedProducts;
    }

    public boolean hasVoidReturnType() {
        return this.getReturnType().equals(VOID);
    }

    public boolean hasProblemReturnType() {
        return this.getReturnType().startsWith(problemIndicator);
    }

    @Override
    public String getRealReturnType() {
        return this.returnType.getType();
    }

    @Override
    public String getReturnHelper() {
        return this.returnType.getHelper();
    }

    public int getNumParms() {
        return this.argTypes.length;
    }

    public MethodInfo[] getTypes() {
        return this.argTypes;
    }

    @Override
    public String[] getArgNames() {
        return this.argNames;
    }

    @Override
    public String[] getArgTypes() {
        return this.typeNamesInOrder;
    }

    public boolean hasProblemArgType() {
        boolean bl = false;
        String[] stringArray = this.getArgTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(problemIndicator)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public String[] getRealArgTypes() {
        String[] stringArray = new String[this.argTypes.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.argTypes[i].getType();
        }
        return stringArray;
    }

    @Override
    public String[] getArgHelpers() {
        String[] stringArray = new String[this.argTypes.length];
        for (int i = 0; i < this.argTypes.length; ++i) {
            stringArray[i] = this.argTypes[i].getHelper();
        }
        return stringArray;
    }

    public boolean getIsIncludedInObjState() {
        return this.isIncludedInObjState;
    }

    @Override
    public boolean getIsAction() {
        return !this.getIsIncludedInObjState();
    }

    public boolean isAdded() {
        return this.added;
    }

    public StringIndex lookupArgType(String string) {
        return (StringIndex)this.nameToParmType.get(string);
    }

    public boolean doesMatchByMethodName(String string) {
        return this.fullyQualifiedMethod.equals(string);
    }

    @Override
    public boolean doesMatchByArgNames(String[] stringArray, StringIndex[] stringIndexArray) {
        return this.doesMatchByArgNames(stringArray, stringIndexArray, false);
    }

    public boolean doesMatchByArgNames(String[] stringArray, StringIndex[] stringIndexArray, boolean bl) {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (bl) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
            if (hashSet.size() != n) {
                throw new IllegalArgumentException("names are not unique");
            }
        }
        boolean bl2 = n == this.getNumParms();
        for (int i = 0; bl2 && i < n; ++i) {
            String string = stringArray[i];
            StringIndex stringIndex = this.lookupArgType(string);
            if (stringIndex == null) {
                bl2 = false;
                continue;
            }
            if (stringIndexArray == null) continue;
            stringIndexArray[i] = stringIndex;
        }
        return bl2;
    }

    public boolean doesMatchByArgNames(String[] stringArray) {
        return this.doesMatchByArgNames(stringArray, null);
    }

    public boolean doesMatchByArgNames(MethodTypeInfo methodTypeInfo) {
        boolean bl = this.fullyQualifiedMethod.equals(methodTypeInfo.fullyQualifiedMethod) && this.doesMatchByArgNames(methodTypeInfo.getArgNames());
        return bl;
    }

    public StringIndex[] getTypes(String[] stringArray) {
        StringIndex[] stringIndexArray = new StringIndex[stringArray.length];
        if (!this.doesMatchByArgNames(stringArray, stringIndexArray)) {
            stringIndexArray = null;
        }
        return stringIndexArray;
    }

    public boolean doesMatchByArgTypes(String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = stringArray.length == this.getNumParms();
        if (bl) {
            String string = this.getFullyQualifiedMethodName();
            for (int i = 0; bl && i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = ReflectionUtil.fromJvmClassname((String)string2);
                String string4 = this.argTypes[i].getType();
                bl = string3.equals(string4);
            }
        }
        return bl;
    }

    @Override
    public Method getMatchingMethod(String string, String string2) throws ClassNotFoundException {
        return this.getMatchingMethod(string, string2, true);
    }

    public Method getMatchingMethod(String string, String string2, boolean bl) throws ClassNotFoundException {
        Method method = null;
        String[] stringArray = this.getRealArgTypes();
        Class clazz = ReflectionUtil.forName(string);
        method = ReflectionUtil.getMethodWithSignature((Class)clazz, (String)string2, (String[])stringArray);
        if (method == null && bl) {
            this.logMatchingProblem();
        }
        return method;
    }

    public Method getMatchingMethod(boolean bl) throws ClassNotFoundException {
        String string = this.getFullyQualifiedMethodName();
        String string2 = this.getFullyQualifiedClassName();
        String string3 = this.getMethodName();
        Method method = this.getMatchingMethod(string2, string3, bl);
        return method;
    }

    public boolean hasFixMe() {
        boolean bl = false;
        if (this.returnType.hasFixMe()) {
            bl = true;
        } else {
            for (int i = 0; i < this.argTypes.length; ++i) {
                if (!this.argTypes[i].hasFixMe()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected void logMatchingProblem() {
        this.logMatchingProblem(false);
    }

    protected void logMatchingProblem(boolean bl) {
        if (bl || db.on()) {
            SDebug sDebug = bl ? null : db;
            String string = this.signatureString();
            MethodTypeInfo.print(sDebug, "error: couldn't find actual method matching: " + string + ".");
            MethodTypeInfo.print(sDebug, " Perhaps the CTCTypeInfo.xml file is out of sync with the actual CTC code. Perhaps TypeInfoDoclet should be re-run.");
            MethodTypeInfo.print(sDebug, " Another possibility is that the class is for whatever reason not loadable.");
            MethodTypeInfo.print(sDebug, " Yet another possibility is that this method wasn't ported during a prev. sync.");
            MethodTypeInfo.println(sDebug, "");
            MethodTypeInfo.println(sDebug, "");
        }
    }

    public boolean doesMatch(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String string = clazz.getName() + "." + method.getName();
        boolean bl = this.doesMatchByMethodName(string);
        if (bl) {
            Class<?>[] classArray = method.getParameterTypes();
            String[] stringArray = new String[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                stringArray[i] = classArray[i].getName();
            }
            bl = this.doesMatchByArgTypes(stringArray);
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof MethodTypeInfo) {
            MethodTypeInfo methodTypeInfo = (MethodTypeInfo)object;
            bl = this.doesMatchByMethodName(methodTypeInfo.fullyQualifiedMethod) && this.doesMatchByArgTypes(methodTypeInfo.getArgTypes());
        }
        return bl;
    }

    public int hashCode() {
        long l = this.fullyQualifiedMethod.hashCode();
        int n = this.argTypes.length;
        for (int i = 0; i < n; ++i) {
            l += (long)this.argTypes[i].getType().hashCode();
        }
        return (int)l;
    }

    public String signatureString(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(this.returnType.getType());
            stringBuilder.append(" ");
        }
        if (bl2) {
            stringBuilder.append(this.fullyQualifiedMethod);
        } else {
            stringBuilder.append(MethodTypeInfo.getLastSegment(this.fullyQualifiedMethod));
        }
        stringBuilder.append("(");
        for (int i = 0; i < this.argTypes.length; ++i) {
            MethodInfo methodInfo = this.argTypes[i];
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(methodInfo.getType());
            stringBuilder.append(" ");
            stringBuilder.append(methodInfo.getArgName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String signatureString() {
        return this.signatureString(true, true);
    }

    public String toString() {
        return this.signatureString();
    }

    public void mergeInto(MethodTypeInfo methodTypeInfo, boolean bl) {
        this.returnType.mergeInto(methodTypeInfo.returnType);
        int n = Math.min(this.argTypes.length, methodTypeInfo.argTypes.length);
        for (int i = 0; i < n; ++i) {
            MethodInfo methodInfo = this.argTypes[i];
            MethodInfo methodInfo2 = methodTypeInfo.argTypes[i];
            methodInfo.mergeInto(methodInfo2);
        }
        if ((methodTypeInfo.comment == null || methodTypeInfo.comment.length() == 0) && this.comment != null && this.comment.length() > 0) {
            System.out.println("adding comment '" + this.comment + "' to " + this.getFullyQualifiedMethodName());
            methodTypeInfo.comment = this.comment;
        }
        methodTypeInfo.mergeProperties(this.props);
    }

    public AttributeCmdClassification createClassification() {
        return this.createClassification(false);
    }

    public AttributeCmdClassification createClassification(boolean bl) {
        AttributeCmdClassification attributeCmdClassification = new AttributeCmdClassification();
        String string = this.getFullyQualifiedClassName();
        if (string.equals("com.cisco.ctcutsx.model.PlatformNodeModel")) {
            string = "com.cisco.ctcutsX.model.PlatformNodeModel";
        }
        Method method = null;
        int n = 2;
        try {
            method = this.getMatchingMethod(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SDebug.printStackTrace((Throwable)classNotFoundException);
        }
        if (method == null) {
            this.logMatchingProblem(bl);
            n = -1;
            attributeCmdClassification.setCmdClassification(n);
            return attributeCmdClassification;
        }
        String string2 = method.getName();
        attributeCmdClassification.setCmdName(string2);
        String string3 = string2;
        attributeCmdClassification.setParameterNames(this.getArgNames());
        String[] stringArray = this.getProductExclusions();
        attributeCmdClassification.setExcludedProducts(stringArray);
        attributeCmdClassification.setAction(this.getIsAction());
        try {
            attributeCmdClassification.setParameterTypes(ReflectionUtil.forName(this.getRealArgTypes()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl2 = ReflectionUtil.isBeanAccessor((Method)method);
        boolean bl3 = ReflectionUtil.isBeanMutator((Method)method);
        if (bl2) {
            n = 0;
        } else if (bl3) {
            n = 1;
        }
        attributeCmdClassification.setCmdClassification(n);
        if (bl2) {
            if (string3.startsWith("get")) {
                string3 = string3.substring(3);
            } else if (this.getRealReturnType().equals("boolean") && string3.startsWith("is")) {
                string3 = string3.substring(2);
            }
        } else if (bl3 && string3.startsWith("set")) {
            string3 = string3.substring(3);
        }
        attributeCmdClassification.setAttributeName(string3);
        string = MethodTypeInfo.getLastSegment(string);
        attributeCmdClassification.setModelName(string);
        attributeCmdClassification.setDoesCorrespondToPublicMethodAccess(true);
        return attributeCmdClassification;
    }

    static void println(KDebug kDebug, String string) {
        if (kDebug != null) {
            kDebug.println(string);
        } else {
            System.out.println(string);
        }
    }

    static void println(KDebug kDebug, int n, String string) {
        MethodTypeInfo.indent(kDebug, n);
        if (kDebug != null) {
            kDebug.println(string);
        } else {
            System.out.println(string);
        }
    }

    static void print(KDebug kDebug, String string) {
        if (kDebug != null) {
            kDebug.print(string);
        } else {
            System.out.print(string);
        }
    }

    static void print(KDebug kDebug, int n, String string) {
        MethodTypeInfo.indent(kDebug, n);
        if (kDebug != null) {
            kDebug.print(string);
        } else {
            System.out.print(string);
        }
    }

    public void print(KDebug kDebug, int n) {
        this.print(kDebug, n, true);
    }

    public void print(KDebug kDebug, int n, boolean bl) {
        int n2;
        int n3 = this.fullyQualifiedMethod.lastIndexOf(".");
        String string = this.fullyQualifiedMethod.substring(n3 + 1, this.fullyQualifiedMethod.length());
        MethodTypeInfo.printOpenTag(kDebug, n, METHOD_TAG, NAME_ASSIGN + string + "\"");
        int n4 = n + 2;
        this.printProperties(kDebug, n4);
        this.printReturn(kDebug, n4);
        int n5 = this.getNumParms();
        for (n2 = 0; n2 < n5; ++n2) {
            this.printParameter(kDebug, n4, n2);
        }
        int n6 = n2 = this.returnType.getType() != null && this.returnType.getType().equals(VOID) ? 1 : 0;
        if (n2 == 0 && !this.isIncludedInObjState) {
            this.printTextNode(kDebug, n4, ACTION_TAG, "" + !this.isIncludedInObjState);
        }
        if (this.comment != null && this.comment.length() > 0 && doEmitComments && bl) {
            this.printTextNode(kDebug, n4, COMMENT_TAG, this.comment);
        }
        if (this.excludedProducts != null && this.excludedProducts.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.excludedProducts.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.excludedProducts[i]);
            }
            this.printTextNode(kDebug, n4, EXCLUDED_PRODUCTS_TAG, stringBuilder.toString());
        }
        MethodTypeInfo.printCloseTag(kDebug, n, METHOD_TAG);
    }

    protected void printTextNode(KDebug kDebug, int n, String string, String string2) {
        MethodTypeInfo.printOpenTag(kDebug, n, string);
        MethodTypeInfo.indent(kDebug, n + 2);
        MethodTypeInfo.println(kDebug, string2);
        MethodTypeInfo.printCloseTag(kDebug, n, string);
    }

    @Override
    public void print(KDebug kDebug) {
        this.print(kDebug, 0);
    }

    void printProperties(KDebug kDebug, int n) {
        if (this.props == null) {
            return;
        }
        int n2 = n + 2;
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string);
            MethodTypeInfo.printOpenTag(kDebug, n, PROPERTY_TAG, NAME_ASSIGN + string + "\"", false);
            MethodTypeInfo.print(kDebug, string2);
            MethodTypeInfo.printCloseTag(kDebug, 0, PROPERTY_TAG);
        }
    }

    void printReturn(KDebug kDebug, int n) {
        int n2 = n + 2;
        MethodTypeInfo.printOpenTag(kDebug, n, RETURN_TAG);
        MethodTypeInfo.printArgType(kDebug, n2, this.returnType);
        MethodTypeInfo.printCloseTag(kDebug, n, RETURN_TAG);
    }

    static void printArgType(KDebug kDebug, int n, MethodInfo methodInfo) {
        methodInfo.printType(kDebug, n);
    }

    void printParameter(KDebug kDebug, int n, int n2) {
        int n3 = n + 2;
        MethodInfo methodInfo = this.argTypes[n2];
        String string = methodInfo.getArgName();
        MethodTypeInfo.printOpenTag(kDebug, n, PARM_TAG, NAME_ASSIGN + string + "\"");
        String string2 = methodInfo.getComment();
        if (string2 != null && string2.length() > 0) {
            this.printTextNode(kDebug, n3, COMMENT_TAG, string2);
        }
        MethodTypeInfo.printArgType(kDebug, n3, methodInfo);
        MethodTypeInfo.printCloseTag(kDebug, n, PARM_TAG);
    }

    static void printOpenTag(KDebug kDebug, int n, String string, String string2) {
        MethodTypeInfo.printOpenTag(kDebug, n, string, string2, true);
    }

    static void printOpenTag(KDebug kDebug, int n, String string, String string2, boolean bl) {
        MethodTypeInfo.indent(kDebug, n);
        String string3 = " ";
        if (string2 == null) {
            string2 = "";
            string3 = "";
        }
        if (bl) {
            MethodTypeInfo.println(kDebug, "<" + string + string3 + string2 + ">");
        } else {
            MethodTypeInfo.print(kDebug, "<" + string + string3 + string2 + ">");
        }
    }

    protected static void indent(KDebug kDebug, int n) {
        for (int i = 0; i < n; ++i) {
            MethodTypeInfo.print(kDebug, " ");
        }
    }

    static void printOpenTag(KDebug kDebug, int n, String string) {
        MethodTypeInfo.printOpenTag(kDebug, n, string, null);
    }

    static void printOpenCloseTag(KDebug kDebug, int n, String string, String string2) {
        MethodTypeInfo.indent(kDebug, n);
        String string3 = " ";
        if (string2 == null) {
            string2 = "";
            string3 = "";
        }
        MethodTypeInfo.println(kDebug, "<" + string + string3 + string2 + "/>");
    }

    static void printOpenCloseTag(KDebug kDebug, int n, String string) {
        MethodTypeInfo.printOpenCloseTag(kDebug, n, string, null);
    }

    static void printCloseTag(KDebug kDebug, int n, String string) {
        MethodTypeInfo.indent(kDebug, n);
        MethodTypeInfo.println(kDebug, "</" + string + ">");
    }

    static OutputFormat getOutputFormat() {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setOmitXMLDeclaration(true);
        return outputFormat;
    }

    public static class MethodInfo
    extends TypeInfo {
        public MethodInfo() {
        }

        public MethodInfo(String string, String string2, String string3) {
            this(null, string, string2, string3);
        }

        public MethodInfo(String string, String string2, String string3, String string4) {
            this(string, string2, string3, null, string4);
        }

        public MethodInfo(String string, String string2, String string3, String string4, String string5) {
            super(string, string2, string3, string4, string5);
        }

        public MethodInfo(MethodInfo methodInfo) {
            super(methodInfo.getArgName(), methodInfo.getType(), methodInfo.getItemType(), methodInfo.getMapValueType(), methodInfo.getHelper());
        }

        @Override
        protected void setMapState() {
            try {
                this.isMap = this.type != null && ReflectionUtil.doesImplement((Class)ReflectionUtil.forName(this.type), Map.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                SDebug.printStackTrace((Throwable)classNotFoundException);
            }
        }

        public void mergeInto(MethodInfo methodInfo) {
            methodInfo.setArgName(MethodInfo.getBestHelper(methodInfo.getArgName(), this.getArgName()));
            methodInfo.setHelper(MethodInfo.getBestHelper(methodInfo.getHelper(), this.getHelper()));
            methodInfo.setType(MethodInfo.getBestType(methodInfo.getType(), this.getType()));
            methodInfo.setItemType(MethodInfo.getBestType(methodInfo.getItemType(), this.getItemType()));
            methodInfo.setMapValueType(MethodInfo.getBestType(methodInfo.getMapValueType(), this.getMapValueType()));
        }

        static String getBestArg(String string, String string2) {
            String string3 = string;
            if (string == null || string.length() == 0) {
                string3 = string2;
            }
            return string3;
        }

        static String getBestHelper(String string, String string2) {
            String string3 = string;
            if (string == null || string.length() == 0) {
                string3 = string2;
            }
            return string3;
        }

        static String getBestType(String string, String string2) {
            String string3 = string;
            if (string == null || string.length() == 0 || string.startsWith(MethodTypeInfo.problemIndicator)) {
                string3 = string2;
            }
            return string3;
        }

        protected MethodInfo decodeTypeChildrenNodes(Element element) {
            NodeList nodeList = element.getChildNodes();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string6 = node.getNodeName();
                if (string6.equals(MethodTypeInfo.TYPE_TAG)) {
                    string = MethodTypeInfo.getFullyQualifiedType((Element)node);
                    continue;
                }
                if (string6.equals(MethodTypeInfo.ITEM_TYPE_TAG)) {
                    string2 = MethodTypeInfo.getFullyQualifiedType((Element)node);
                    continue;
                }
                if (string6.equals(MethodTypeInfo.VALUE_TYPE_TAG)) {
                    string4 = MethodTypeInfo.getFullyQualifiedType((Element)node);
                    continue;
                }
                if (string6.equals(MethodTypeInfo.HELPER_TAG)) {
                    string3 = MethodTypeInfo.getFullyQualifiedType((Element)node);
                    continue;
                }
                if (!string6.equals(MethodTypeInfo.COMMENT_TAG)) continue;
                string5 = MethodTypeInfo.decodeCommentNode((Element)node);
            }
            this.setType(string);
            this.setMapValueType(string4);
            this.setItemType(string2);
            this.setHelper(string3);
            this.setComment(string5);
            return this;
        }

        public void printType(KDebug kDebug, int n) {
            String string;
            MethodTypeInfo.printOpenCloseTag(kDebug, n, MethodTypeInfo.TYPE_TAG, MethodTypeInfo.NAME_ASSIGN + this.getType() + "\"");
            String string2 = this.getItemType();
            if (string2 != null && string2.length() > 0) {
                MethodTypeInfo.printOpenCloseTag(kDebug, n, MethodTypeInfo.ITEM_TYPE_TAG, MethodTypeInfo.NAME_ASSIGN + this.getItemType() + "\"");
            }
            if ((string = super.getMapValueType()) != null && string.length() > 0) {
                MethodTypeInfo.printOpenCloseTag(kDebug, n, MethodTypeInfo.VALUE_TYPE_TAG, MethodTypeInfo.NAME_ASSIGN + string + "\"");
            }
            if (this.getHelper() != null && !this.getType().equals(MethodTypeInfo.VOID)) {
                MethodTypeInfo.printOpenCloseTag(kDebug, n, MethodTypeInfo.HELPER_TAG, MethodTypeInfo.NAME_ASSIGN + this.getHelper() + "\"");
            }
        }
    }
}

