/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class ObservableManager
implements IObservableManager,
Observer {
    protected ArrayList observables = new ArrayList();
    protected WeakReference<Observer> observer;
    protected boolean active;
    protected boolean passing = false;
    protected int bmcState = -1;
    protected BlockingModeController bmc = null;

    public ObservableManager(Observer observer, boolean bl, Observable[] observableArray) {
        this.setObserver(observer);
        this.active = bl;
        this.setObservable(observableArray);
    }

    public void setObserver(Observer observer) {
        this.observer = new WeakReference<Observer>(observer);
    }

    public ObservableManager(Observer observer, boolean bl) {
        this(observer, bl, null);
    }

    public void setObservable(Observable[] observableArray) {
        if (this.active) {
            this.setActive(false);
            this.observables.clear();
            this.setActive(true);
        } else {
            this.observables.clear();
        }
        this.addObservable(observableArray);
    }

    public void addObservable(Observable[] observableArray) {
        if (observableArray != null) {
            for (int i = 0; i < observableArray.length; ++i) {
                this.addObservable(observableArray[i]);
            }
        }
    }

    public void addObservable(Observable observable) {
        if (observable != null && this.indexOf(observable) < 0) {
            this.observables.add(observable);
            if (this.active) {
                observable.addObserver(this);
            }
        }
    }

    protected int indexOf(Observable observable) {
        int n = this.observables.indexOf(observable);
        return n;
    }

    public void removeObservable(Observable observable) {
        int n = this.indexOf(observable);
        if (n >= 0) {
            if (this.active) {
                observable.deleteObserver(this);
            }
            this.observables.remove(n);
        }
    }

    public void removeObservable(Observable[] observableArray) {
        if (observableArray != null) {
            for (int i = 0; i < observableArray.length; ++i) {
                this.removeObservable(observableArray[i]);
            }
        }
    }

    public void setActive(boolean bl) {
        block4: {
            if (bl == this.active) break block4;
            this.active = bl;
            if (this.active) {
                for (int i = 0; i < this.observables.size(); ++i) {
                    ((Observable)this.observables.get(i)).addObserver(this);
                }
            } else {
                for (int i = 0; i < this.observables.size(); ++i) {
                    ((Observable)this.observables.get(i)).deleteObserver(this);
                }
            }
        }
    }

    public void reset() {
        this.setActive(false);
        this.observables.clear();
    }

    public void setBlockingModeController(BlockingModeController blockingModeController) {
        this.bmc = blockingModeController;
        if (this.bmcState != -1) {
            this.bmcState = 0;
        }
        this.passing = false;
    }

    public boolean isPassing() {
        return this.passing;
    }

    public void setPassing(boolean bl) {
        if (this.passing != bl) {
            this.passing = bl;
            if (!this.passing) {
                this.bmcState = 0;
            }
        }
    }

    public int getBlockingModeControllerState() {
        return this.bmcState;
    }

    public String toString() {
        return "active: " + this.active + ", passing: " + this.passing + ", bmcState: " + this.bmcState + ", observer: " + this.observer;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.passing) {
            Observer observer;
            if (this.observer != null && (observer = (Observer)this.observer.get()) != null) {
                observer.update(observable, object);
            }
        } else if (this.bmc != null) {
            this.bmcState = this.bmc.processBlockedEvent(observable, object, this.bmcState);
        } else if (this.bmcState != -1) {
            ++this.bmcState;
        }
    }
}

