/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class IpAddrDocument
extends PlainDocument {
    public static String INIT_STRING = "XX.XX.XXX.XXX";
    private static int SEP1 = 2;
    private static int SEP2 = 5;
    private static int SEP3 = 9;
    private static String HEX_STRING = "abcdefABCDEF0123456789";
    public static String IP_STRING = "IP";
    public static String NEW_STRING = "NEW";
    private JTextComponent textComponent;
    private int newOffset;

    public IpAddrDocument(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (attributeSet != null && attributeSet.containsAttribute(IP_STRING, NEW_STRING)) {
            this.clearText();
            super.insertString(this.newOffset, string, attributeSet);
            return;
        }
        if (string.equals(INIT_STRING)) {
            super.insertString(n, string, attributeSet);
            return;
        }
        this.newOffset = n;
        if (this.atSeparator(n)) {
            ++this.newOffset;
            this.textComponent.setCaretPosition(this.newOffset);
        }
        super.remove(this.newOffset, 1);
        super.insertString(this.newOffset, string, attributeSet);
    }

    public void clearText() throws BadLocationException {
        this.newOffset = 0;
        super.remove(0, this.getLength());
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (this.atSeparator(n)) {
            this.textComponent.setCaretPosition(n - 1);
        } else {
            this.textComponent.setCaretPosition(n);
        }
    }

    private boolean atSeparator(int n) {
        return n == SEP1 || n == SEP2 || n == SEP3;
    }
}

