/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

public class CdrWriter {
    private static final int _block = 256;
    private boolean _littleEndian;
    private byte[] _buffer;
    private int _offset;
    private int _max;

    public CdrWriter(boolean bl) {
        this._littleEndian = bl;
        this._buffer = new byte[256];
        this._offset = 0;
        this._max = 256;
        this.putBoolean(this._littleEndian);
    }

    public boolean endian() {
        return this._littleEndian;
    }

    public void endian(boolean bl) {
        this._littleEndian = bl;
    }

    private void resize(int n) {
        if (this._offset + n >= this._max) {
            int n2 = (this._max + n) / 256 * 256;
            if ((this._max + n) % 256 != 0) {
                n2 += 256;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this._buffer, 0, byArray, 0, this._max);
            this._buffer = byArray;
        }
    }

    public void putByte(long l) {
        this.resize(1);
        this._buffer[this._offset++] = (byte)l;
    }

    public void putBytes(byte[] byArray) {
        this.putInt(byArray.length);
        this.resize(byArray.length);
        System.arraycopy(byArray, 0, this._buffer, this._offset, byArray.length);
        this._offset += byArray.length;
    }

    public void putShort(int n) {
        this.align(2);
        if (this._littleEndian) {
            this.putByte(n & 0xFF);
            this.putByte(n >> 8 & 0xFF);
        } else {
            this.putByte(n >> 8 & 0xFF);
            this.putByte(n & 0xFF);
        }
    }

    public void putInt(int n) {
        this.align(4);
        if (this._littleEndian) {
            this.putByte(n & 0xFF);
            this.putByte(n >> 8 & 0xFF);
            this.putByte(n >> 16 & 0xFF);
            this.putByte(n >> 24 & 0xFF);
        } else {
            this.putByte(n >> 24 & 0xFF);
            this.putByte(n >> 16 & 0xFF);
            this.putByte(n >> 8 & 0xFF);
            this.putByte(n & 0xFF);
        }
    }

    public void putLong(long l) {
        this.align(8);
        if (this._littleEndian) {
            this.putByte(l & 0xFFL);
            this.putByte(l >> 8 & 0xFFL);
            this.putByte(l >> 16 & 0xFFL);
            this.putByte(l >> 24 & 0xFFL);
            this.putByte(l >> 32 & 0xFFL);
            this.putByte(l >> 40 & 0xFFL);
            this.putByte(l >> 48 & 0xFFL);
            this.putByte(l >> 56 & 0xFFL);
        } else {
            this.putByte(l >> 56 & 0xFFL);
            this.putByte(l >> 48 & 0xFFL);
            this.putByte(l >> 40 & 0xFFL);
            this.putByte(l >> 32 & 0xFFL);
            this.putByte(l >> 24 & 0xFFL);
            this.putByte(l >> 16 & 0xFFL);
            this.putByte(l >> 8 & 0xFFL);
            this.putByte(l & 0xFFL);
        }
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public void putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
    }

    public void putBoolean(boolean bl) {
        this.putByte(bl ? 1L : 0L);
    }

    public void putString(String string) {
        this.putInt(string.length() + 1);
        for (int i = 0; i < string.length(); ++i) {
            this.putByte(string.charAt(i));
        }
        this.putByte(0L);
    }

    public void align(int n) {
        while (this._offset % n != 0) {
            this.putByte(0L);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this._offset];
        System.arraycopy(this._buffer, 0, byArray, 0, this._offset);
        return byArray;
    }
}

