/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import cerent.util.tty.CLISetConnectionIdAction;
import cerent.util.tty.CLIWavelengthAction;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.CircuitFactoryModel;
import com.cisco.crs.model.CrsOchTrailAdit;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimPortModel;
import java.util.Comparator;
import java.util.List;

public class OchTrailAditModel
extends AbstractModel
implements Comparator,
IOchTrailAditModel {
    private CrsOchTrailAdit aditRef;
    private int entityIndex = -1;
    private IPortModel port;
    private String connectionName = "";
    private int cachedAdminState = 0;
    private int cachedServiceState = 0;

    @Override
    public void destroy() {
        if (this.db.on()) {
            this.db.println("OchTrailAditModel::destroy()");
        }
        super.destroy();
        this.aditRef = null;
        this.connectionName = null;
    }

    @Override
    public void dispose() {
        this.aditRef = null;
        this.connectionName = null;
        if (this.db.on()) {
            this.db.println("OchTrailAditModel::dispose()");
        }
        super.dispose();
    }

    public OchTrailAditModel(PlatformNodeModel platformNodeModel, CrsOchTrailAdit crsOchTrailAdit) {
        super(platformNodeModel, platformNodeModel.getChildDebug(CircuitFactoryModel.class));
        this.aditRef = crsOchTrailAdit;
        this.entityIndex = crsOchTrailAdit.getIpath()[0].getPortEntityIdx();
    }

    public int compare(Object object, Object object2) {
        if (object instanceof OchTrailAditModel && object2 instanceof OchTrailAditModel) {
            OchTrailAditModel ochTrailAditModel = (OchTrailAditModel)object;
            OchTrailAditModel ochTrailAditModel2 = (OchTrailAditModel)object2;
            if (ochTrailAditModel.equals(ochTrailAditModel2)) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OchTrailAditModel) {
            OchTrailAditModel ochTrailAditModel = (OchTrailAditModel)object;
            if (this.getCircuitId() == null) {
                if (this.db.on()) {
                    this.db.println("Comparing already disposed adit, return false");
                }
                return false;
            }
            if (ochTrailAditModel.getNodeModel() == null || ochTrailAditModel.getCircuitId() == null) {
                if (this.db.on()) {
                    this.db.println("Comparing with disposed adit, simplified compare");
                }
                return ochTrailAditModel.getObjectType() == this.getObjectType() && ochTrailAditModel.getObjIndex() == this.getObjIndex();
            }
            if (this.db.on()) {
                this.db.println("Comparing, return:" + (ochTrailAditModel.getObjectType() == this.getObjectType() && ochTrailAditModel.getObjIndex() == this.getObjIndex() && ochTrailAditModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId() && ochTrailAditModel.getCircuitId().getUniquePart().getUniqueId() == this.getCircuitId().getUniquePart().getUniqueId()));
            }
            return ochTrailAditModel.getObjectType() == this.getObjectType() && ochTrailAditModel.getObjIndex() == this.getObjIndex() && ochTrailAditModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId() && ochTrailAditModel.getCircuitId().getUniquePart().getUniqueId() == this.getCircuitId().getUniquePart().getUniqueId();
        }
        this.db.println("Comparing, return false");
        return false;
    }

    public void checkForStateUpdate() {
        boolean bl = false;
        int n = this.getAdminState();
        int n2 = this.getServiceState();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectOchTrailAdit;
    }

    public ICircuitId getCircuitId() {
        if (this.aditRef != null) {
            return this.aditRef.getIcktId();
        }
        return null;
    }

    public int getConnectionType() {
        return 0;
    }

    public int getObjIndex() {
        return this.getEntityIndex();
    }

    public int getOptChannel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    public IOchncPathDefModel[] getPaths() {
        if (this.aditRef != null) {
            return this.aditRef.getIpath();
        }
        return new IOchncPathDefModel[0];
    }

    public IPortModel getPortModel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        if (this.port == null && iOchncPathDefModelArray.length != 0) {
            try {
                IEntityTableModel iEntityTableModel = iOchncPathDefModelArray[0].getNodeModel().getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(iOchncPathDefModelArray[0].getPortEntityIdx());
                if (iEntityModel instanceof IPortModel) {
                    this.port = (IPortModel)iEntityModel;
                } else {
                    this.db.warning("Port Model for OchTrailAdit is not instance of IPortModel: " + iEntityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.warning("Cannot get OchTrailAdit port model: " + abstractCmsNoSuchEntityException.getMessage());
            }
        }
        return this.port;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }

    public boolean inUse() {
        return false;
    }

    public void localDestroy() throws Busy {
        if (this.db.on()) {
            this.db.println("OchTrailAditModel::localDestroy");
        }
        CLISetConnectionIdAction cLISetConnectionIdAction = new CLISetConnectionIdAction(this.node.getHostName());
        String string = "";
        boolean bl = false;
        try {
            bl = cLISetConnectionIdAction.resetConnectionId(((PlimPortModel)this.port).getInternalId());
            if (bl) {
                this.db.println("OchTrailAditModel::localDestroy - Node ConnectionId reset unsuccessful.");
                throw new Busy("OchTrailAditModel::localDestroy - Node ConnectionId reset unsuccessful.");
            }
            ((PlimPortModel)this.port).requireLock();
            ((IPlimTrkLineModel)this.port.getInterfaceModel()).setConnectionId(null);
        }
        catch (NoSuchInterface noSuchInterface) {
            this.db.println("OchTrailAditModel::localDestroy - Node ConnectionId not reset, Cannot retrieve previous ConnectionId.");
            SDebug.printStackTrace((Throwable)noSuchInterface);
            throw new Busy("OchTrailAditModel::localDestroy - Node ConnectionId not reset, Cannot retrieve previous ConnectionId.");
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            this.db.println("OchTrailAditModel::localDestroy - Node ConnectionId not reset, Cannot retrieve previous ConnectionId.");
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            throw new Busy("OchTrailAditModel::localDestroy - Node ConnectionId not reset, Cannot retrieve previous ConnectionId.");
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
    }

    public IConnectionConversionModel createConnectionConversionModel(List list, int n, ICircuitId iCircuitId, List list2, int n2, IConnCreateAttrs iConnCreateAttrs, int n3, boolean bl, boolean bl2) throws NoSuchConnection, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, PathInUse {
        return null;
    }

    public int getAdminState() throws AbstractCmsIOException {
        int n;
        PlimPortModel plimPortModel = (PlimPortModel)this.getPortModel();
        boolean bl = false;
        if (plimPortModel == null) {
            this.db.warning("getAdminState invoked on an adit with a null PlimPortModel.");
            return 2;
        }
        try {
            n = plimPortModel.getAdminState();
        }
        catch (NoSuchInterface noSuchInterface) {
            return 2;
        }
        int n2 = n == 0 || n == 3 ? 3 : 2;
        if (this.cachedAdminState == 0) {
            this.cachedAdminState = n2;
        } else if (this.cachedAdminState != n2) {
            this.cachedAdminState = n2;
            bl = true;
        }
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        return n2;
    }

    public IConnectionConversionModel getConnectionConversionModel() {
        return null;
    }

    public String getConnectionName() {
        if (this.aditRef != null) {
            return this.aditRef.getConnectionName();
        }
        return "";
    }

    public int getServiceState() throws AbstractCmsIOException {
        int n;
        PlimPortModel plimPortModel = (PlimPortModel)this.getPortModel();
        boolean bl = false;
        if (plimPortModel == null) {
            this.db.warning("getServiceSate invoked on an adit with a null PlimPortModel.");
            return 2;
        }
        try {
            n = plimPortModel.getServiceStateType();
        }
        catch (NoSuchInterface noSuchInterface) {
            return 2;
        }
        int n2 = n == 102 || n == 0 ? 0 : 2;
        if (this.cachedServiceState == 0) {
            this.cachedServiceState = n2;
        } else if (this.cachedServiceState != n2) {
            this.cachedServiceState = n2;
            bl = true;
        }
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        return n2;
    }

    public boolean hasLoopback() {
        return false;
    }

    public boolean hasTestAccess() {
        return false;
    }

    public boolean hasXcLoopback() throws AbstractCmsNoSuchEntityException, InvalidPath {
        return false;
    }

    public boolean inConnectionConversion() {
        return false;
    }

    public boolean inRoll() {
        return false;
    }

    public boolean isBlsrDri() {
        return false;
    }

    public void setAdminState(int n) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        block4: {
            CLIWavelengthAction cLIWavelengthAction = new CLIWavelengthAction(this.node.getHostName());
            String string = ((PlimPortModel)this.getPortModel()).getInternalId();
            if (n == 0 || n == 3) {
                cLIWavelengthAction.setShutdown(string, false);
            } else {
                cLIWavelengthAction.setShutdown(string, true);
            }
            try {
                this.port.setAdminState(n);
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
        this.aditRef.setConnectionName(string);
    }

    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return true;
    }
}

