/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.parser;

import cerent.util.SDebug;
import com.cisco.crs.model.CrsAlarm;
import com.cisco.crs.model.EntityTableModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.ICLIParser;
import com.cisco.crs.model.core.LmpIdStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AlarmParser
implements ICLIParser {
    private EntityTableModel entityTable;
    private SDebug db;

    public AlarmParser(EntityTableModel entityTableModel, SDebug sDebug) {
        this.entityTable = entityTableModel;
        this.db = sDebug;
    }

    @Override
    public CLIResponse parseResponse(String string) {
        Object object;
        Document document;
        block30: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = null;
            try {
                object = documentBuilderFactory.newDocumentBuilder();
                document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(string.getBytes()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (this.db.on) {
                    this.db.println("Error while parsing XML alarms");
                }
            }
            catch (SAXException sAXException) {
                if (this.db.on) {
                    this.db.println("Error while parsing XML alarms");
                }
            }
            catch (IOException iOException) {
                if (!this.db.on) break block30;
                this.db.println("Error while parsing XML alarms");
            }
        }
        if (document == null) {
            return null;
        }
        object = document.getDocumentElement();
        NodeList nodeList = object.getElementsByTagName("AlarmTable");
        if (nodeList != null) {
            nodeList = ((Element)nodeList.item(0)).getElementsByTagName("Alarm");
        }
        TreeSet<CrsAlarm> treeSet = new TreeSet<CrsAlarm>();
        if (nodeList != null && nodeList.getLength() > 0) {
            Integer[] integerArray = this.entityTable.getElementIndices();
            String string2 = this.entityTable.getNMD().getHostName();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                CrsAlarm crsAlarm = new CrsAlarm();
                NodeList nodeList2 = element.getChildNodes();
                boolean bl = false;
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Object object2;
                        Element element2 = (Element)nodeList2.item(j);
                        String string3 = element2.getNodeName();
                        if (string3.equals("Naming")) {
                            object2 = (Element)element2.getElementsByTagName("EventID").item(0);
                            crsAlarm.setEventId(Integer.parseInt(object2.getTextContent()));
                        } else if (string3.equals("SourceID")) {
                            crsAlarm.setSourceId(element2.getTextContent());
                        } else if (string3.equals("Timestamp")) {
                            crsAlarm.setTimeStamp(Long.parseLong(element2.getTextContent()));
                        } else if (string3.equals("Category")) {
                            crsAlarm.setCategory(element2.getTextContent());
                        } else if (string3.equals("Group")) {
                            crsAlarm.setGroup(element2.getTextContent());
                        } else if (string3.equals("Code")) {
                            crsAlarm.setCode(element2.getTextContent());
                        } else if (string3.equals("Severity")) {
                            crsAlarm.setSeverity(element2.getTextContent());
                        } else if (string3.equals("IsAdmin")) {
                            crsAlarm.setAdmin(Boolean.parseBoolean(element2.getTextContent()));
                        } else if (string3.equals("AdditionalText")) {
                            object2 = element2.getTextContent();
                            for (Integer n : integerArray) {
                                String string4 = new PlimPortId(n.intValue()).toString();
                                if (((String)object2).indexOf(string4) == -1 || LmpIdStore.getInstance().getLmpId(string2, n) == -1) continue;
                                bl = true;
                                crsAlarm.setAdditionalText((String)object2);
                                break;
                            }
                        }
                        if (bl) break;
                    }
                }
                if (!bl) continue;
                treeSet.add(crsAlarm);
            }
        }
        this.entityTable.getNMD().getAlarmStore().updateAlarms(treeSet);
        return null;
    }
}

