/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310ma.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc310ma.ui.shelf.CardPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.List;

public class CTXMACard
extends CardGraphic {
    private PpmSlot[] ppmSlots = null;

    public CTXMACard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "CTXCard"));
        this.createChildren();
    }

    private void createChildren() {
        List list = this.entityM.getDescendantsOfEqType(149);
        this.ppmSlots = new PpmSlot[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)list.get(i);
            this.ppmSlots[i] = new PpmSlot(pluggableSlotModel, this.parent, this.db, this.getPpmBounds(i));
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        int n3 = CardPainter.OPTICON_X_OFFSET;
        int n4 = CardPainter.OPTICON_Y_OFFSET;
        CardPainter.paintRJ45(graphics2D, "CRAFT", n3, n4);
        CardPainter.paintRJ45(graphics2D, "LAN", n3, n4 += CardPainter.PORT_WIDTH + CardPainter.RJ45_Y_SPACING);
        if (this.ppmSlots != null) {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (this.ppmSlots[i] == null) continue;
                this.ppmSlots[i].draw(graphics2D);
                Rectangle rectangle = this.getPpmBounds(i);
                float f = (float)(rectangle.getX() + rectangle.getWidth() / 2.0);
                float f2 = (float)(rectangle.getY() + rectangle.getHeight() + 8.0);
                this.drawLabel(graphics2D, String.valueOf(i + 1), f, f2);
            }
        }
        graphics2D.setColor(color);
    }

    protected Rectangle getPpmBounds(int n) {
        int n2 = CardPainter.OPTICON_X_OFFSET;
        int n3 = CardPainter.CONTROLLER_OPTICON_Y_OFFSET + n * (CardPainter.PORT_HEIGHT + CardPainter.CONTROLLER_OPTICON_Y_SPACING);
        return new Rectangle(n2, n3, CardPainter.PORT_WIDTH, CardPainter.PORT_HEIGHT);
    }

    @Override
    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (!this.ppmSlots[i].contains(mouseEvent.getPoint())) continue;
                return this.ppmSlots[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, float f, float f2) {
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(7.0f);
        graphics2D.setFont(font2);
        graphics2D.drawString(string, f, f2);
        graphics2D.setFont(font);
    }
}

