/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    public static final float CARD_H_TO_CARD_W_RATIO = 8.461538f;
    private static final float PORT_H_TO_PORT_W_RATIO = 1.8f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.3846154f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    private static final float FONT_TO_CARD_W_RATIO = 0.30769232f;
    public static final int CARD_WIDTH = 26;
    public int CARD_HEIGHT = Math.round((float)this.getCardWidth() * 8.461538f);
    private final int PORT_WIDTH = Math.round((float)this.getCardWidth() * 0.3846154f);
    private final int PORT_HEIGHT = Math.round((float)this.PORT_WIDTH * 1.8f);
    private final int SMALL_PORT_HEIGHT = this.PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private final int PORT_CONN1_X;
    private final int PORT_CONN2_X = this.PORT_CONN1_X = this.PORT_WIDTH / 2;
    private final int PORT_CONN1_Y = this.PORT_HEIGHT / 3;
    private final int PORT_CONN2_Y = this.PORT_CONN1_Y * 2;
    private final int SMALL_PORT_CONN1_Y = this.SMALL_PORT_HEIGHT / 3;
    private final int SMALL_PORT_CONN2_Y = this.SMALL_PORT_CONN1_Y * 2;
    private final int OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int MULTIPORT_OPTICON_X_OFFSET = (this.getCardWidth() - this.PORT_WIDTH) / 2;
    private final int OPTICON_Y_OFFSET = Math.round((float)this.CARD_HEIGHT * 0.27272728f);
    private static final int OPTICON_X_SPACING = 0;
    private final int OPTICON_Y_SPACING = Math.round((float)this.CARD_HEIGHT * 0.11363637f);
    private final int SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)this.CARD_HEIGHT * 0.11363637f) * 0.75));
    private final int MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int MINI_PORT_HEIGHT = Math.round((float)this.PORT_HEIGHT * 0.6f);
    private final int MINI_MULTIPORT_OPTICON_X_OFFSET = Math.round((float)(this.getCardWidth() - this.MINI_PORT_WIDTH) / 2.0f);
    private final int MINI_OPTICON_Y_OFFSET = this.OPTICON_Y_OFFSET - 4;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private final int MINI_OPTICON_Y_SPACING = this.MINI_PORT_HEIGHT + 1;
    private final int SMALL_MINI_PORT_WIDTH = this.PORT_WIDTH;
    private final int SMALL_MINI_PORT_HEIGHT = Math.round((float)this.PORT_HEIGHT * 0.47f);
    private final int SMALL_MINI_OPTICON_Y_SPACING = this.SMALL_MINI_PORT_HEIGHT + 2;
    private final int SMALL_MINI_OPTICON_Y_OFFSET = this.OPTICON_Y_OFFSET - 6;
    private final int SMALLER_PORT_CONN1_Y = this.SMALL_MINI_PORT_HEIGHT / 3;
    private final int SMALLER_PORT_CONN2_Y = this.SMALLER_PORT_CONN1_Y * 2 + 1;
    public static final double FACTOR_454 = 1.0;
    public static final double FACTOR_454SDH = 0.86;
    public static final double SCALE_FACTOR = 0.86;
    public int WIDTH;
    public static int HEIGHT;
    public final int SLOT_WIDTH = this.getCardWidth();
    public static final int SLOT_HEIGHT;
    private static final int SM_WIDTH = 13;
    private static final int SM_HEIGHT;
    public Dimension SLOT_DIM;
    public static Dimension SMALL_SLOT_DIM;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.23076923f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    public static int RECT_HEIGHT;
    public static int RECT_OFFSET;
    public static int TOP_RECT_OFFSET;
    public static int TOP_RECT_HEIGHT;
    public static int BOTTOM_RECT_OFFSET;
    public static int BOTTOM_RECT_HEIGHT;
    public static final int EXTRACTOR_HEIGHT = 18;
    public static final int EXTRACTOR_WIDTH = 10;
    public static final int TAB_MARGIN = 2;
    public final int TAB_RADIUS = (int)((double)((this.getCardWidth() - 10 - 2) / 2) * 0.86);
    public final int TAB_DIAMETER = this.TAB_RADIUS * 2;
    public final int TAB_ARC_WIDTH = this.getCardWidth() - 10 - this.TAB_RADIUS - 2;
    public final int TAB_ARC_HEIGHT = 18 - this.TAB_DIAMETER;
    public static final int BOTTOM_EXTRACTOR_OFFSET;
    public static int BOTTOM_EXTRACTOR_HEIGHT;
    public static final int TOP_EXTRACTOR_OFFSET = 0;
    public static int TOP_EXTRACTOR_HEIGHT;
    public static final int NAME_X_OFFSET = 2;
    public static int NAME_Y_OFFSET;
    public final int ACTIVE_LIGHT_Y_OFFSET = (int)(Math.round((double)((float)this.CARD_HEIGHT * 0.27272728f) * 0.86) - 4L);
    public final int ACTIVE_LIGHT_WIDTH = Math.round((float)this.getCardWidth() * 0.23076923f) - 1;
    public final int ACTIVE_LIGHT_HEIGHT = (int)Math.round((double)((float)this.CARD_HEIGHT * 0.018181818f) * 0.86 + 2.0);
    protected Rectangle mainRectangle;
    private static final float[] dash1;
    private static final Rectangle topExtractorRectangle;
    private static final Rectangle bottomExtractorRectangle;
    private final Arc2D.Double topExtractorMain = new Arc2D.Double(10.0, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
    private final Arc2D.Double topExtractorSmall = new Arc2D.Double(12.0, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
    private final Line2D.Double topExtractorLine = new Line2D.Double(0.0, 18.0, 10 + this.TAB_ARC_WIDTH, 18.0);
    private final Arc2D.Double bottomExtractorMain = new Arc2D.Double(10.0, BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
    private final Arc2D.Double bottomExtractorSmall = new Arc2D.Double(12.0, BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
    private final Line2D.Double bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, 10 + this.TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
    private static Rectangle topRectangle;
    private static Rectangle bottomRectangle;
    protected CardGraphic cg;
    private Rectangle topBackgroundRectangle;
    private Rectangle bottomBackgroundRectangle;
    protected OpticsModuleModel model;
    protected OpticsLineModel[] linemodels;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] BandWavelengthStrings;

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * 26;
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
        int n = 26;
        this.topBackgroundRectangle = new Rectangle(0, 0, n, TOP_EXTRACTOR_HEIGHT);
        this.bottomBackgroundRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, n, HEIGHT);
        this.updateWidth();
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
            this.linemodels = opticsModuleModel.getOpticsLineModels();
        }
    }

    @Override
    public void updateWidth() {
        this.WIDTH = this.cg.getSlotsOccupied() * this.getCardWidth();
        this.SLOT_DIM = new Dimension(this.WIDTH, HEIGHT);
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
    }

    protected int getRectHeight() {
        return RECT_HEIGHT;
    }

    protected int getRectOffset() {
        return RECT_OFFSET;
    }

    protected int getExtractorHeight() {
        return 18;
    }

    protected int getExtractorWidth() {
        return 10;
    }

    protected int getTabMargin() {
        return 2;
    }

    protected int getExtractorOffset() {
        return 0;
    }

    protected int getNameXOffset() {
        return 2;
    }

    protected int getNameYOffset() {
        return NAME_Y_OFFSET;
    }

    @Override
    public int getOpticonXOffset() {
        return this.OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonYOffset() {
        return this.OPTICON_Y_OFFSET;
    }

    @Override
    public int getMultiPortOpticonXOffset() {
        return this.MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getOpticonYSpacing() {
        return this.OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniMultiPortOticonXOffset() {
        return this.MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    @Override
    public int getCardWidth() {
        return 26;
    }

    @Override
    public int getCardHeight() {
        return this.CARD_HEIGHT;
    }

    @Override
    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    @Override
    public int getPortWidth() {
        return this.PORT_WIDTH;
    }

    @Override
    public int getPortHeight() {
        return this.PORT_HEIGHT;
    }

    @Override
    public int getMiniPortWidth() {
        return this.MINI_PORT_WIDTH;
    }

    @Override
    public int getMiniPortHeight() {
        return this.MINI_PORT_HEIGHT;
    }

    @Override
    public int getMiniOpticonXSpacing() {
        return 0;
    }

    @Override
    public int getMiniOpticonYSpacing() {
        return this.MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getMiniOpticonYOffset() {
        return this.MINI_OPTICON_Y_OFFSET;
    }

    @Override
    public int getPortX(int n, int n2) {
        return this.MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    @Override
    public int getPortY(int n, int n2) {
        if (n == 0) {
            return this.OPTICON_Y_OFFSET + this.OPTICON_Y_SPACING * n2;
        }
        return this.OPTICON_Y_OFFSET + this.SMALL_OPTICON_Y_SPACING * n2;
    }

    @Override
    public int getSmallPortWidth() {
        return this.PORT_WIDTH;
    }

    @Override
    public int getSmallPortHeight() {
        return this.SMALL_PORT_HEIGHT;
    }

    @Override
    public int getPortConn1X() {
        return this.PORT_CONN1_X;
    }

    @Override
    public int getPortConn2X() {
        return this.PORT_CONN2_X;
    }

    @Override
    public int getPortConn1Y() {
        return this.PORT_CONN1_Y;
    }

    @Override
    public int getPortConn2Y() {
        return this.PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1Y() {
        return this.SMALL_PORT_CONN1_Y;
    }

    @Override
    public int getSmallPortConn2Y() {
        return this.SMALL_PORT_CONN2_Y;
    }

    @Override
    public int getSmallPortConn1X() {
        return 0;
    }

    @Override
    public int getSmallPortConn2X() {
        return 0;
    }

    @Override
    public int getSmallMiniPortWidth() {
        return this.getMiniPortWidth();
    }

    @Override
    public int getSmallMiniPortHeight() {
        return this.SMALL_MINI_PORT_HEIGHT;
    }

    @Override
    public int getSmallMiniOpticonYSpacing() {
        return this.SMALL_MINI_OPTICON_Y_SPACING;
    }

    @Override
    public int getSmallMiniOpticonYOffset() {
        return this.SMALL_MINI_OPTICON_Y_OFFSET;
    }

    @Override
    public int getSmallerPortConn1Y() {
        return this.SMALLER_PORT_CONN1_Y;
    }

    @Override
    public int getSmallerPortConn2Y() {
        return this.SMALLER_PORT_CONN2_Y;
    }

    @Override
    public int getPortLoopbackDist() {
        return 3;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        this.paintActual(graphics2D);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(topExtractorRectangle);
        graphics2D.draw(bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.topExtractorMain);
        graphics2D.draw(this.topExtractorSmall);
        graphics2D.draw(this.topExtractorLine);
        graphics2D.draw(this.bottomExtractorMain);
        graphics2D.draw(this.bottomExtractorSmall);
        graphics2D.draw(this.bottomExtractorLine);
        int n3 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n3) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, this.ACTIVE_LIGHT_Y_OFFSET + this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.getCardWidth() - this.ACTIVE_LIGHT_WIDTH - 2, this.ACTIVE_LIGHT_Y_OFFSET, this.ACTIVE_LIGHT_WIDTH, this.ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(topRectangle);
        graphics2D.draw(bottomRectangle);
        graphics2D.setColor(Color.black);
        int n4 = 174;
        String string2 = this.cg.getEqLabel();
        Font font2 = graphics.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font2);
        int n5 = fontMetrics.getAscent() - 1;
        int n6 = 0;
        int n7 = 9;
        if (string2.startsWith("STM64XFP")) {
            String string3 = string2.substring(0, 3);
            String string4 = string2.substring(3, 5);
            String string5 = string2.substring(5, string2.length());
            int n8 = n2 + NAME_Y_OFFSET - 1;
            int n9 = fontMetrics.stringWidth(string3);
            graphics2D.drawString(string3, (n + this.getCardWidth() - n9) / 2, n8);
            n9 = fontMetrics.stringWidth(string4);
            graphics2D.drawString(string4, (n + this.getCardWidth() - n9) / 2, n8 += n5);
            n9 = fontMetrics.stringWidth(string5);
            graphics2D.drawString(string5, (n + this.getCardWidth() - n9) / 2, n8 += n5);
        } else if (string2.startsWith("STM") || string2.startsWith("E1_") || string2.startsWith("ML100") || string2.startsWith("DS3") && string2.length() > 3 || string2.startsWith("ETH") && string2.length() > 3) {
            int n10 = 3;
            if (string2.startsWith("ML100")) {
                n10 = 2;
            }
            String string6 = string2.substring(0, n10);
            String string7 = string2.substring(n10);
            if (string2.startsWith("ML100X")) {
                string7 = string7.replaceFirst("-8", "");
            }
            graphics2D.drawString(string6, n + 2, n2 + NAME_Y_OFFSET - n6);
            int n11 = string7.length() == 1 ? n + 2 + 7 : (string7.length() == 2 ? n + 2 + 4 : n + 2);
            graphics2D.drawString(string7, n11, n2 + NAME_Y_OFFSET + n7);
        } else if (string2.startsWith("MS-I")) {
            String string8 = string2.substring(0, 3);
            String string9 = string2.substring(3, 5);
            String string10 = string2.substring(5, string2.length());
            int n12 = n2 + NAME_Y_OFFSET - 1;
            int n13 = fontMetrics.stringWidth(string8);
            graphics2D.drawString(string8, (n + this.getCardWidth() - n13) / 2, n12);
            n13 = fontMetrics.stringWidth(string9);
            graphics2D.drawString(string9, (n + this.getCardWidth() - n13) / 2, n12 += n5);
            n13 = fontMetrics.stringWidth(string10);
            graphics2D.drawString(string10, (n + this.getCardWidth() - n13) / 2, n12 += n5);
        } else if (string2.startsWith("XC")) {
            String string11 = string2.substring(0, 2);
            String string12 = string2.substring(2);
            if (string12.length() > 3) {
                string12 = string12.substring(0, string12.indexOf(32));
            }
            graphics2D.drawString(string11, n + 2, n2 + NAME_Y_OFFSET - n6);
            graphics2D.drawString(string12, n + 2 + 2, n2 + NAME_Y_OFFSET + n7);
        } else if (string2.startsWith("UNK")) {
            String string13 = string2.substring(0, 4);
            graphics2D.drawString(string13, n + 2 - 1, n2 + NAME_Y_OFFSET - n6);
        } else if (string2.startsWith("TXP") || string2.startsWith("MXP")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            String string14 = "";
            String string15 = "";
            String string16 = "";
            String string17 = null;
            int n14 = n2 + NAME_Y_OFFSET - 1;
            try {
                string14 = stringTokenizer.nextToken();
                string15 = stringTokenizer.nextToken();
                string16 = stringTokenizer.nextToken();
                string17 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (string17 != null) {
                int n15 = fontMetrics.getAscent() / 2;
                int n16 = (BOTTOM_EXTRACTOR_OFFSET - (BOTTOM_RECT_OFFSET + BOTTOM_RECT_HEIGHT)) / 2;
                int n17 = (n + this.getCardWidth() - fontMetrics.stringWidth(string17)) / 2;
                int n18 = n2 + BOTTOM_RECT_OFFSET + BOTTOM_RECT_HEIGHT + n16 + n15;
                graphics2D.drawString(string17, n17, n18);
            }
            graphics2D.drawString(string14, n + 2, n14);
            graphics2D.drawString(string15, n + 2, n14 += n5);
            int n19 = string16.length() - 4;
            if (n19 > 0) {
                graphics2D.setFont(new Font(font2.getFontName(), font2.getStyle(), font2.getSize() - (n19 == 1 ? 1 : 2)));
            }
            graphics2D.drawString(string16, n + 2, n14 += n5);
        } else if (string2.startsWith("AD-1B")) {
            String string18 = "AD1B";
            String string19 = "x.x";
            n4 = this.getBandWave();
            if (n4 != 0) {
                string19 = BandWavelengthStrings[n4].substring(2, 6);
            }
            int n20 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string18, n + 2, n20);
            graphics2D.drawString(string19, n + 2, n20 += n5);
        } else if (string2.startsWith("AD-4B")) {
            String string20 = "AD4B";
            String string21 = "x.x";
            n4 = this.getBandWave();
            if (n4 != 0) {
                string21 = BandWavelengthStrings[n4].substring(2, 6);
            }
            int n21 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string20, n + 2, n21);
            graphics2D.drawString(string21, n + 2, n21 += n5);
        } else if (string2.startsWith("AD-1C")) {
            String string22 = "AD1C";
            String string23 = "x.x";
            n4 = this.getWave();
            if (n4 != 0 && n4 != 174) {
                string23 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
            }
            int n22 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string22, n + 2, n22);
            graphics2D.drawString(string23, n + 2, n22 += n5);
        } else if (string2.startsWith("AD-2C")) {
            String string24 = "AD2C";
            String string25 = "x.x";
            n4 = this.getWave();
            if (n4 != 0 && n4 != 174) {
                string25 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
            }
            int n23 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string24, n + 2, n23);
            graphics2D.drawString(string25, n + 2, n23 += n5);
        } else if (string2.startsWith("AD-4C")) {
            String string26 = "AD4C";
            String string27 = "x.x";
            n4 = this.getWave();
            if (n4 != 0 && n4 != 174) {
                string27 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
            }
            int n24 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string26, n + 2, n24);
            graphics2D.drawString(string27, n + 2, n24 += n5);
        } else if (string2.startsWith("OPT-BST E")) {
            String string28 = "OPT";
            String string29 = "BST";
            String string30 = "E";
            int n25 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string28, n + 2, n25);
            graphics2D.drawString(string29, n + 2, n25 += n5);
            graphics2D.drawString(string30, n + 2, n25 += n5);
        } else if (string2.startsWith("OPT-RAMP ")) {
            String string31 = "OPT";
            String string32 = "RAMP";
            String string33 = this.cg.getEqType() == 287 ? "C" : "CE";
            int n26 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string31, n + 2, n26);
            graphics2D.drawString(string32, n + 2, n26 += n5);
            graphics2D.drawString(string33, n + 2, n26 += n5);
        } else if (string2.equals("OPT-BST L")) {
            String string34 = "OPT";
            String string35 = "BST";
            String string36 = "L";
            int n27 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string34, n + 2, n27);
            graphics2D.drawString(string35, n + 2, n27 += n5);
            graphics2D.drawString(string36, n + 2, n27 += n5);
        } else if (string2.equals("OPT-BST")) {
            String string37 = "OPT";
            String string38 = "BST";
            int n28 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string37, n + 2, n28);
            graphics2D.drawString(string38, n + 2, n28 += n5);
        } else if (string2.startsWith("OPT-PRE")) {
            String string39 = "OPT";
            String string40 = "PRE";
            int n29 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string39, n + 2, n29);
            graphics2D.drawString(string40, n + 2, n29 += n5);
        } else if (string2.startsWith("Optical amplifier L")) {
            String string41 = "OPT";
            String string42 = "AMP";
            String string43 = "L";
            int n30 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string41, n + 2, n30);
            graphics2D.drawString(string42, n + 2, n30 += n5);
            graphics2D.drawString(string43, n + 2, n30 += n5);
        } else if (string2.startsWith("OPT-AMP 17")) {
            String string44 = "OPT";
            String string45 = "AMP";
            String string46 = "17";
            int n31 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string44, n + 2, n31);
            graphics2D.drawString(string45, n + 2, n31 += n5);
            graphics2D.drawString(string46, n + 2, n31 += n5);
        } else if (string2.startsWith("OPT-AMP 23")) {
            String string47 = "OPT";
            String string48 = "AMP";
            String string49 = "23";
            int n32 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string47, n + 2, n32);
            graphics2D.drawString(string48, n + 2, n32 += n5);
            graphics2D.drawString(string49, n + 2, n32 += n5);
        } else if (string2.startsWith("OPT-AMP C")) {
            String string50 = "OPT";
            String string51 = "AMP";
            String string52 = "C";
            int n33 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string50, n + 2, n33);
            graphics2D.drawString(string51, n + 2, n33 += n5);
            graphics2D.drawString(string52, n + 2, n33 += n5);
        } else if (string2.startsWith("OSC M")) {
            String string53 = "OSCM";
            String string54 = "";
            int n34 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string53, n + 2, n34);
            graphics2D.drawString(string54, n + 2, n34 += n5);
        } else if (string2.startsWith("OSC-CSM")) {
            String string55 = "OSC";
            String string56 = "CSM";
            int n35 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string55, n + 2, n35);
            graphics2D.drawString(string56, n + 2, n35 += n5);
        } else if (string2.startsWith("CE-100T")) {
            String string57 = "CE";
            String string58 = "100T";
            int n36 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string57, n + 2, n36);
            graphics2D.drawString(string58, n + 2, n36 += n5);
        } else if (string2.startsWith("CE-1000")) {
            String string59 = "CE";
            String string60 = "1000";
            int n37 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string59, n + 2, n37);
            graphics2D.drawString(string60, n + 2, n37 += n5);
        } else if (string2.startsWith("32 WSS L")) {
            String string61 = "  32 WSS L";
            String string62 = "";
            int n38 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string61, n + 2, n38);
            graphics2D.drawString(string62, n + 2, n38 += n5);
        } else if (string2.equals("32 DMX L")) {
            String string63 = "32";
            String string64 = "DMX";
            String string65 = "L";
            int n39 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string63, n + 2, n39);
            graphics2D.drawString(string64, n + 2, n39 += n5);
            graphics2D.drawString(string65, n + 2, n39 += n5);
        } else if (string2.startsWith("32 WSS")) {
            String string66 = "       32 WSS";
            String string67 = "";
            int n40 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string66, n + 2, n40);
            graphics2D.drawString(string67, n + 2, n40 += n5);
        } else if (string2.equals("40 WXC")) {
            String string68 = "  40 WXC";
            String string69 = "";
            int n41 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string68, n + 2, n41);
            graphics2D.drawString(string69, n + 2, n41 += n5);
        } else if (string2.equals("40 WXC L")) {
            String string70 = "    40 WXC L";
            String string71 = "";
            int n42 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string70, n + 2, n42);
            graphics2D.drawString(string71, n + 2, n42 += n5);
        } else if (string2.equals("80 WXC C")) {
            String string72 = " 80 WXC C";
            String string73 = "";
            int n43 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string72, n + 2, n43);
            graphics2D.drawString(string73, n + 2, n43 += n5);
        } else if (string2.equals("40 DMX L")) {
            String string74 = "40";
            String string75 = "DMX";
            String string76 = "L";
            int n44 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string74, n + 2, n44);
            graphics2D.drawString(string75, n + 2, n44 += n5);
            graphics2D.drawString(string76, n + 2, n44 += n5);
        } else if (string2.equals("40 DMX CE")) {
            String string77 = "40";
            String string78 = "DMX";
            String string79 = "";
            string79 = n3 == 6 ? "C" : "CE";
            int n45 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string77, n + 2, n45);
            graphics2D.drawString(string78, n + 2, n45 += n5);
            graphics2D.drawString(string79, n + 2, n45 += n5);
        } else if (string2.equals("40 DMX CO")) {
            String string80 = "40";
            String string81 = "DMX";
            String string82 = "";
            string82 = n3 == 6 ? "C" : "CO";
            int n46 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string80, n + 2, n46);
            graphics2D.drawString(string81, n + 2, n46 += n5);
            graphics2D.drawString(string82, n + 2, n46 += n5);
        } else if (string2.equals("40 WSS CE")) {
            String string83 = "";
            String string84 = "";
            string83 = n3 == 6 ? "40 WSS C" : "40 WSS CE";
            int n47 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string83, n + 2, n47);
            graphics2D.drawString(string84, n + 2, n47 += n5);
        } else if (string2.equals("40 WSS CO")) {
            String string85 = "";
            String string86 = "";
            string85 = n3 == 6 ? "40 WSS C" : "40 WSS CO";
            int n48 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string85, n + 2, n48);
            graphics2D.drawString(string86, n + 2, n48 += n5);
        } else if (string2.equals("40 MUX")) {
            String string87 = "40";
            String string88 = "MUX";
            int n49 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string87, n + 2, n49);
            graphics2D.drawString(string88, n + 2, n49 += n5);
        } else if (string2.equals("40 MUX L")) {
            String string89 = "40";
            String string90 = "MUX";
            String string91 = "L";
            int n50 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string89, n + 2, n50);
            graphics2D.drawString(string90, n + 2, n50 += n5);
            graphics2D.drawString(string91, n + 2, n50 += n5);
        } else if (string2.equals("32 DMX")) {
            String string92 = "32";
            String string93 = "DMX";
            int n51 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string92, n + 2, n51);
            graphics2D.drawString(string93, n + 2, n51 += n5);
        } else if (string2.startsWith("4MD")) {
            String string94 = "4MD";
            String string95 = "x.xx";
            n4 = this.getWave();
            if (n4 != 0 && n4 != 174) {
                string95 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
            }
            int n52 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string94, n + 2, n52);
            graphics2D.drawString(string95, n + 2, n52 += n5);
        } else if (string2.startsWith("32 MUXO")) {
            String string96 = "   32 MUXO";
            String string97 = "";
            int n53 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string96, n + 2, n53);
            graphics2D.drawString(string97, n + 2, n53 += n5);
        } else if (string2.equals("32 DMXO")) {
            String string98 = "   32 DMXO";
            String string99 = "";
            int n54 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string98, n + 2, n54);
            graphics2D.drawString(string99, n + 2, n54 += n5);
        } else if (string2.startsWith("FC-MR") || string2.startsWith("CE-MR") || string2.startsWith("ML-MR")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
            String string100 = "";
            String string101 = "";
            try {
                string100 = stringTokenizer.nextToken();
                string101 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            int n55 = fontMetrics.stringWidth(string100);
            int n56 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string100, (n + this.getCardWidth() - n55) / 2, n56);
            n55 = fontMetrics.stringWidth(string101);
            graphics2D.drawString(string101, (n + this.getCardWidth() - n55) / 2, n56 += n5);
        } else if (string2.startsWith("TCC2P")) {
            String string102 = "";
            String string103 = "";
            int n57 = n2 + NAME_Y_OFFSET - 1;
            string102 = string2.substring(0, 4);
            string103 = string2.substring(4, string2.length());
            int n58 = fontMetrics.stringWidth(string102);
            graphics2D.drawString(string102, (n + 26 - n58) / 2, n57);
            graphics2D.drawString(string103, (n + this.getCardWidth() - n58) / 2, n57 += n5);
        } else if (string2.startsWith("RAN_SVC")) {
            int n59 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString("RAN", n + 2, n59);
            graphics2D.drawString("SVC", n + 2, n59 += n5);
        } else if (string2.startsWith("MRC25G_12")) {
            String string104 = string2.substring(0, 3);
            String string105 = string2.substring(3, 6);
            String string106 = string2.substring(7, string2.length());
            int n60 = n2 + NAME_Y_OFFSET - 1;
            int n61 = fontMetrics.stringWidth(string104);
            graphics2D.drawString(string104, (n + this.getCardWidth() - n61) / 2, n60);
            n61 = fontMetrics.stringWidth(string105);
            graphics2D.drawString(string105, (n + this.getCardWidth() - n61) / 2, n60 += n5);
            n61 = fontMetrics.stringWidth(string106);
            graphics2D.drawString(string106, (n + this.getCardWidth() - n61) / 2, n60 += n5);
        } else if (string2.startsWith("MRC")) {
            String string107 = string2.substring(0, 3);
            String string108 = string2.substring(4, string2.length());
            int n62 = n2 + NAME_Y_OFFSET - 1;
            int n63 = fontMetrics.stringWidth(string107);
            graphics2D.drawString(string107, (n + this.getCardWidth() - n63) / 2, n62);
            n63 = fontMetrics.stringWidth(string108);
            graphics2D.drawString(string108, (n + this.getCardWidth() - n63) / 2, n62 += n5);
        } else if (string2.startsWith("OTU2")) {
            String string109 = "OTU2";
            String string110 = "XP";
            int n64 = n2 + NAME_Y_OFFSET - 1;
            int n65 = fontMetrics.stringWidth(string109);
            graphics2D.drawString(string109, (n + this.getCardWidth() - n65) / 2, n64);
            n65 = fontMetrics.stringWidth(string110);
            graphics2D.drawString(string110, (n + this.getCardWidth() - n65) / 2, n64 += n5);
        } else if (string2.endsWith("XP") || string2.endsWith("XPE")) {
            String string111 = string2.substring(0, string2.indexOf("_"));
            String string112 = string2.substring(string2.indexOf("_") + 1, string2.length());
            int n66 = n2 + NAME_Y_OFFSET - 1;
            int n67 = fontMetrics.stringWidth(string111);
            graphics2D.drawString(string111, (n + this.getCardWidth() - n67) / 2, n66);
            n67 = fontMetrics.stringWidth(string112);
            graphics2D.drawString(string112, (n + this.getCardWidth() - n67) / 2, n66 += n5);
        } else if (string2.startsWith("PSM")) {
            String string113 = "PSM";
            String string114 = "";
            n4 = this.getPSMWavelength();
            if (n4 != 0 && n4 != 174) {
                string114 = Wavelength.getWavelengthStringFromWavelength(n4).substring(2, 6);
            }
            int n68 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string113, n + 2, n68);
            graphics2D.drawString(string114, n + 2, n68 += n5);
        } else if (string2.startsWith("40G-TXP-C")) {
            String string115 = "       40G";
            String string116 = "      TXP C";
            int n69 = n2 + NAME_Y_OFFSET - 1;
            int n70 = fontMetrics.stringWidth(string115);
            graphics2D.drawString(string115, (n + this.getCardWidth() - n70) / 2, n69);
            n70 = fontMetrics.stringWidth(string116);
            graphics2D.drawString(string116, (n + this.getCardWidth() - n70) / 2, n69 += n5);
        } else if (string2.startsWith("40E-TXP-C")) {
            String string117 = "       40E";
            String string118 = "      TXP C";
            int n71 = n2 + NAME_Y_OFFSET - 1;
            int n72 = fontMetrics.stringWidth(string117);
            graphics2D.drawString(string117, (n + this.getCardWidth() - n72) / 2, n71);
            n72 = fontMetrics.stringWidth(string118);
            graphics2D.drawString(string118, (n + this.getCardWidth() - n72) / 2, n71 += n5);
            String string119 = this.cg.getMfgProductId();
            String string120 = "";
            if (string119.startsWith("15454-40E-TXP-C")) {
                string120 = "       (EP)";
            }
            if (string119.startsWith("15454-40ME-TXP-C")) {
                string120 = "       (ME)";
            }
            if (!string120.equals("")) {
                n72 = fontMetrics.stringWidth(string120);
                graphics2D.drawString(string120, (n + this.getCardWidth() - n72) / 2, n71 += n5);
            }
        } else if (string2.equals("40G-MXP-C")) {
            String string121 = "       40G";
            String string122 = "      MXP C";
            int n73 = n2 + NAME_Y_OFFSET - 1;
            int n74 = fontMetrics.stringWidth(string121);
            graphics2D.drawString(string121, (n + this.getCardWidth() - n74) / 2, n73);
            n74 = fontMetrics.stringWidth(string122);
            graphics2D.drawString(string122, (n + this.getCardWidth() - n74) / 2, n73 += n5);
        } else if (string2.equals("40E-MXP-C")) {
            String string123 = "        40E";
            String string124 = "        MXP C";
            int n75 = n2 + NAME_Y_OFFSET - 1;
            int n76 = fontMetrics.stringWidth(string123);
            graphics2D.drawString(string123, (n + this.getCardWidth() - n76) / 2, n75);
            n76 = fontMetrics.stringWidth(string124);
            graphics2D.drawString(string124, (n + this.getCardWidth() - n76) / 2, n75 += n5);
            String string125 = this.cg.getMfgProductId();
            String string126 = "";
            if (string125.startsWith("15454-40E-MXP-C")) {
                string126 = "       (EP)";
            }
            if (string125.startsWith("15454-40ME-MXP-C")) {
                string126 = "       (ME)";
            }
            if (!string126.equals("")) {
                n76 = fontMetrics.stringWidth(string126);
                graphics2D.drawString(string126, (n + this.getCardWidth() - n76) / 2, n75 += n5);
            }
        } else if (string2.startsWith("F TDCU")) {
            String string127 = "F";
            String string128 = "TDCU";
            int n77 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string127, n + 2, n77);
            graphics2D.drawString(string128, n + 2, n77 += n5);
        } else if (string2.startsWith("C TDCU")) {
            String string129 = "C";
            String string130 = "TDCU";
            int n78 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string129, n + 2, n78);
            graphics2D.drawString(string130, n + 2, n78 += n5);
        } else if (string2.startsWith("40 SMR1 C")) {
            String string131 = " 40";
            String string132 = "SMR1";
            String string133 = " C";
            int n79 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string131, n + 2, n79);
            graphics2D.drawString(string132, n + 2, n79 += n5);
            graphics2D.drawString(string133, n + 2, n79 += n5);
        } else if (string2.startsWith("40 SMR2 C")) {
            String string134 = " 40";
            String string135 = "SMR2";
            String string136 = " C";
            int n80 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string134, n + 2, n80);
            graphics2D.drawString(string135, n + 2, n80 += n5);
            graphics2D.drawString(string136, n + 2, n80 += n5);
        } else if (string2.startsWith("80 SMR1 C")) {
            String string137 = " 80";
            String string138 = "SMR1";
            String string139 = " C";
            int n81 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string137, n + 2, n81);
            graphics2D.drawString(string138, n + 2, n81 += n5);
            graphics2D.drawString(string139, n + 2, n81 += n5);
        } else {
            if (string2.startsWith("G1000")) {
                graphics2D.setFont(new Font(font2.getFontName(), font2.getStyle(), font2.getSize() - 1));
            }
            graphics2D.drawString(string2, n + 2, n2 + NAME_Y_OFFSET);
            if (string2.endsWith("(TXP)")) {
                graphics2D.drawString("(TXP)", n + 2, n2 + n5 + NAME_Y_OFFSET);
            }
            graphics2D.setFont(font2);
        }
        graphics2D.setStroke(stroke);
    }

    public void paintActual(Graphics2D graphics2D) {
        int n = this.cg.getState();
        int n2 = this.cg.getSlot();
        int n3 = this.cg.getSlotsOccupied();
        String string = null;
        int n4 = 26;
        boolean bl = false;
        ArrayList arrayList = null;
        try {
            arrayList = ((EntityModel)this.cg.getModel()).getNodeModelDelegate().getMfgData(this.cg.getModel().getShelfId());
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        for (int i = 0; i < n3; ++i) {
            block9: {
                block8: {
                    block7: {
                        bl = false;
                        if (arrayList != null && arrayList.size() < n2 + i - 1) {
                            string = (String)arrayList.get(n2 + i - 1);
                        }
                        this.topBackgroundRectangle = new Rectangle(i * n4, 0, n4, TOP_EXTRACTOR_HEIGHT);
                        this.bottomBackgroundRectangle = new Rectangle(i * n4, BOTTOM_RECT_OFFSET, n4, HEIGHT);
                        if (i != 0) break block7;
                        if (this.cg.getState() == 1 && this.cg.hasProvisionedCard()) break block8;
                    }
                    if (i <= 0 || string == null || string.equals("")) break block9;
                }
                graphics2D.setColor(this.cg.getCurrentColor());
                graphics2D.fill(this.topBackgroundRectangle);
                graphics2D.fill(this.bottomBackgroundRectangle);
                bl = true;
            }
            if (!bl || i <= 0) continue;
            Rectangle rectangle = new Rectangle(i * n4 + 2, 2, 6, TOP_EXTRACTOR_HEIGHT - 4);
            Rectangle rectangle2 = new Rectangle(i * n4 + 2, BOTTOM_EXTRACTOR_OFFSET + 2, 6, BOTTOM_EXTRACTOR_HEIGHT - 4);
            Arc2D.Double double_ = new Arc2D.Double(i * n4 + 10, 0 - this.TAB_ARC_HEIGHT, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, 90.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(i * n4 + 10, 0 + this.TAB_ARC_HEIGHT, this.TAB_DIAMETER, this.TAB_DIAMETER, 90.0, -180.0, 0);
            Line2D.Double double_3 = new Line2D.Double(i * n4, 18.0, 10 + this.TAB_ARC_WIDTH + i * n4, 18.0);
            Arc2D.Double double_4 = new Arc2D.Double(i * n4 + 10, BOTTOM_EXTRACTOR_OFFSET + this.TAB_DIAMETER, 2 * this.TAB_ARC_WIDTH, 2 * this.TAB_ARC_HEIGHT, 180.0, -90.0, 0);
            Arc2D.Double double_5 = new Arc2D.Double(i * n4 + 10, BOTTOM_EXTRACTOR_OFFSET, this.TAB_DIAMETER, this.TAB_DIAMETER, -90.0, 180.0, 0);
            Line2D.Double double_6 = new Line2D.Double(i * n4, BOTTOM_EXTRACTOR_OFFSET, 10 + this.TAB_ARC_WIDTH + i * n4, BOTTOM_EXTRACTOR_OFFSET);
            Line2D.Double double_7 = new Line2D.Double(i * n4, 0.0, i * n4, 18.0);
            Line2D.Double double_8 = new Line2D.Double(i * (n4 * 2), 0.0, i * (n4 * 2), 18.0);
            Line2D.Double double_9 = new Line2D.Double(i * n4, BOTTOM_RECT_OFFSET, i * n4, BOTTOM_EXTRACTOR_OFFSET + 18);
            Line2D.Double double_10 = new Line2D.Double(i * (n4 * 2), BOTTOM_RECT_OFFSET, i * (n4 * 2), BOTTOM_EXTRACTOR_OFFSET + 18);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(this.mainRectangle);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.gray);
            graphics2D.draw(rectangle);
            graphics2D.draw(rectangle2);
            graphics2D.setColor(Color.black);
            graphics2D.draw(double_);
            graphics2D.draw(double_2);
            graphics2D.draw(double_3);
            graphics2D.draw(double_4);
            graphics2D.draw(double_5);
            graphics2D.draw(double_6);
            graphics2D.draw(double_8);
            graphics2D.draw(double_7);
            graphics2D.draw(double_10);
            graphics2D.draw(double_9);
        }
    }

    public int getWave() {
        int n;
        try {
            n = this.models[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 174;
        }
        return n;
    }

    public int getPSMWavelength() {
        int n;
        try {
            n = this.linemodels[0].getExpectedWaveLength();
        }
        catch (Exception exception) {
            return 174;
        }
        return n;
    }

    public int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    static {
        SLOT_HEIGHT = HEIGHT = 189;
        SM_HEIGHT = HEIGHT / 2;
        SMALL_SLOT_DIM = new Dimension(13, SM_HEIGHT);
        RECT_HEIGHT = 3;
        RECT_OFFSET = 42;
        TOP_RECT_OFFSET = 40;
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = 153;
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_EXTRACTOR_OFFSET = HEIGHT - 18 - 1;
        BOTTOM_EXTRACTOR_HEIGHT = 18;
        TOP_EXTRACTOR_HEIGHT = 18;
        NAME_Y_OFFSET = 27;
        dash1 = new float[]{1.5f};
        topExtractorRectangle = new Rectangle(2, 2, 6, TOP_EXTRACTOR_HEIGHT - 4);
        bottomExtractorRectangle = new Rectangle(2, BOTTOM_EXTRACTOR_OFFSET + 2, 6, BOTTOM_EXTRACTOR_HEIGHT - 4);
        BandWavelengthStrings = new String[]{"UNKNOWN", "1530.33", "1534.25", "1538.19", "1542.14", "1546.12", "1550.12", "1554.13", "1558.17"};
    }
}

