/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc455.ui.stm1e.STM1E12RSPmThresholdsTableModel;
import com.cisco.ctc455.ui.stm1e.STM1ECardTabbedView;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;

public class STM1E12RSPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected STM1E12RSPmThresholdsTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected TdmLineModel[] thresholdLineModels = null;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected int numLines = 0;
    protected int numThresholdLines = 0;
    private static final SDebug db = new SDebug("STM1E12RSPmThresholdsPane");

    public STM1E12RSPmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.lineModels = tdmLineModelArray;
        this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
        this.initializeThresholdLines();
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(225);
        this.table.setAutoCreateColumnsFromModel(false);
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected STM1E12RSPmThresholdsTableModel getDataModel() {
        return new STM1E12RSPmThresholdsTableModel(this.getUiModel().getNodeModel(), this.thresholdLineModels, this.intervalType, this.nearEnd);
    }

    private synchronized void initializeThresholdLines() {
        this.thresholdLineModels = this.getThresholdLineModels(this.lineModels);
        this.numThresholdLines = this.thresholdLineModels == null ? 0 : this.thresholdLineModels.length;
    }

    protected TdmLineModel[] getThresholdLineModels(TdmLineModel[] tdmLineModelArray) {
        return ((STM1ECardTabbedView)this.getParentView()).getStmModeModels();
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                STM1E12RSPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.initializeThresholdLines();
            this.dataModel.setModel(this.thresholdLineModels);
        } else if (db.on()) {
            db.println("In SonetPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numThresholdLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.lineModels[n].setSectionPmThresholds(this.intervalType, this.nearEnd, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numThresholdLines - 1 ? this.numThresholdLines - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    private void printThresholds(sSectionThresholds sSectionThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("ES " + sSectionThresholds2.es);
            db.println("SES " + sSectionThresholds2.ses);
            db.println("BBE " + sSectionThresholds2.bbe);
            db.println("UAS " + sSectionThresholds2.sefs);
            db.println("EB " + sSectionThresholds2.cv);
            db.println("===============================================");
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12RSPmThresholdsPane;
    }
}

