/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;
import org.omg.CORBA.UNKNOWN;

public class STM1EC2TableModel
extends AbstractTableModel {
    protected TdmHoModel[] stsModels = null;
    protected INodeModel node = null;
    private int numLines = 0;
    private boolean dirty = false;
    private boolean[][] isDirty;
    final String[] columnNames = new String[]{"Port", "C2 Expect", "C2 Receive"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int C2EXPE_INDEX = 1;
    public static final int C2RECV_INDEX = 2;
    private Attribute[] c2Expe;
    private Attribute[] c2Recv;
    private static final SDebug db = new SDebug("STM1EC2TableModel");

    public STM1EC2TableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray) {
        this.stsModels = tdmHoModelArray;
        this.node = iNodeModel;
        this.numLines = this.stsModels != null ? this.stsModels.length : 0;
        this.c2Expe = new Attribute[this.numLines];
        this.c2Recv = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                try {
                    return new Integer(this.stsModels[n].getInfo().portNumber);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            case 1: {
                if (this.stsModels != null) {
                    return this.getC2ExpeIndex(n);
                }
                return "TUG";
            }
            case 2: {
                if (this.stsModels != null) {
                    return this.getC2RecvIndex(n);
                }
                return "TUG";
            }
        }
        return "TUG";
    }

    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.stsModels != null && this.numLines > 0) {
            boolean bl = AbstractPane.isUserAuthorized(this.stsModels[0], SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.stsModels[0].getModuleModel().isProtectModule()) {
                    return n2 >= 1 && n2 != 2;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    this.c2Expe[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.dirty = true;
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private Attribute getC2RecvIndex(int n) throws AbstractCmsIOException {
        if (this.c2Recv[n] == null) {
            try {
                Byte by = new Byte(this.stsModels[n].getHoPathTraceModel().getCurrentPayloadLabel());
                this.c2Recv[n] = this.validateC2(by) ? ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal("STM1E_C2", by.intValue()) : new Attribute("Unknown" + this.toHex(by.intValue() & 0xFF), by.intValue());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Error in getC2RecvIndex " + (Object)((Object)noSuchInterface));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Error in getC2RecvIndex " + (Object)((Object)wrongInterfaceType));
            }
            catch (InternalCommError internalCommError) {
                db.println("Error in getC2RecvIndex " + (Object)((Object)internalCommError));
            }
            catch (UNKNOWN uNKNOWN) {
                db.println("Error in getC2RecvIndex " + (Object)((Object)uNKNOWN));
            }
        }
        return this.c2Recv[n];
    }

    private String toHex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            string = "0" + string;
        }
        string = " (0x" + string + ")";
        return string;
    }

    private Attribute getC2ExpeIndex(int n) throws AbstractCmsIOException {
        if (this.c2Expe[n] == null) {
            try {
                Byte by = new Byte(this.stsModels[n].getHoPathTraceModel().getExpectedPayloadCode());
                this.c2Expe[n] = this.validateC2(by) ? ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal("STM1E_C2", by.intValue()) : new Attribute("Unknown", by.intValue());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("Error in getC2ExpeIndex " + (Object)((Object)noSuchInterface));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Error in getC2ExpeIndex " + (Object)((Object)wrongInterfaceType));
            }
        }
        return this.c2Expe[n];
    }

    private boolean validateC2(Byte by) {
        switch (by.intValue()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 254: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    public void applyChanges() throws Exception {
        try {
            for (int i = 0; i < this.numLines; ++i) {
                if (!this.isDirty(i, 1)) continue;
                this.stsModels[i].getHoPathTraceModel().setExpectedPayloadCode(this.getC2Expe(i));
            }
            this.dirty = false;
            this.resetDirtyBits();
        }
        catch (Exception exception) {
            db.println("Error in applyChanges " + exception);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void resetLineCache(int n) {
        this.c2Expe[n] = null;
        this.c2Recv[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private byte getC2Expe(int n) throws AbstractCmsIOException {
        return (byte)this.c2Expe[n].getIntValue();
    }

    public synchronized void setStsModel(TdmHoModel[] tdmHoModelArray) {
        this.stsModels = tdmHoModelArray;
        this.numLines = this.stsModels == null ? 0 : this.stsModels.length;
        this.c2Expe = new Attribute[this.numLines];
        this.c2Recv = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.refreshFromModel();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }
}

