/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.model.AdminState;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmLineProvPane;
import cerent.cms.ui.sonet.TdmLineTableModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc455.ui.stm1e.STM1ECardTabbedView;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;

public class STM1ELineProvPane
extends TdmLineProvPane {
    private static final SDebug db = new SDebug("STM1ELineProvPane");

    public STM1ELineProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, TdmLineTableModel tdmLineTableModel) {
        super(string, tabbedView, tdmLineModelArray, tdmLineTableModel);
    }

    @Override
    protected void prepareColumns() {
        this.removeColumn(7);
        this.removeColumn(20);
        this.removeColumn(16);
        this.removeColumn(15);
        this.removeColumn(2);
        this.removeColumn(18);
        Object var1_1 = null;
        Object var2_2 = null;
        this.setAttrCellEditor(5, "declareSfBerLevel");
        this.setAttrCellEditor(6, "declareSdBerLevel");
        this.setAttrCellEditor(11, "timingSdhSsmQuality");
    }

    @Override
    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.getCurrentModeModels())) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.getCurrentModeModels())) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            boolean bl3 = true;
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.getCurrentModeModels(), bl);
                bl3 = false;
                stringBuffer.append(string).append("\n");
            }
            if (AdminState.adminStateChangedToFormOfOOSWhilePeerIsIS(this.dataModel, this.getCurrentModeModels())) {
                stringBuffer.append(this.getSplitterString());
            }
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (n < 8) {
                this.dataModel.refreshLineFromModel(n);
            } else {
                this.dataModel.refreshMyLines(this.getCurrentModeModels());
            }
        } else if (db.on()) {
            db.println("In STM1ELineProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected TdmLineModel[] getCurrentModeModels() {
        return ((STM1ECardTabbedView)this.getParentView()).getStmModeModels();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12LineProvPane;
    }
}

