/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600;

import cerent.cms.IPlatform;
import cerent.cms.ReferencePlatform;
import cerent.cms.idl.Common.sClassBSubnetAddr;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.IpSubnet;
import cerent.util.SDebug;
import com.cisco.ctc600.model.AlarmDecoderDefs;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.model.nedefaults.NodeDefaults;
import com.cisco.ctc600.model.vf.Blsr2FiberVersionedFeature;
import com.cisco.ctc600.model.vf.Blsr4FiberVersionedFeature;
import com.cisco.ctc600.ui.CardViewPanel;
import com.cisco.ctc600.ui.PlatformCardTabbedViewFactory;
import com.cisco.ctc600.ui.network.IconStore;
import com.cisco.ctc600.ui.shelf.CardBehavior600;
import com.cisco.ctc600.ui.shelf.CardFactory;
import com.cisco.ctc600.ui.shelf.CardPainter;
import com.cisco.ctc600.ui.shelf.InternalSubnetPane;
import com.cisco.ctc600.ui.shelf.ShelfLayout;
import com.cisco.ctc600.ui.shelf.ShelfMaintenancePane;
import com.cisco.ctc600.ui.shelf.ShelfProvPane;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Platform
extends ReferencePlatform {
    private static final Boolean ds3FarEnd = new Boolean(false);
    private static final int[] supported600XcCardEqTypes = new int[]{91, 59};
    private static final LANAccessMode[] LAN_ACCESS_MODE = new LANAccessMode[]{LANAccessMode.DCC_ONLY, LANAccessMode.FRONT_ONLY, LANAccessMode.BACKPLANE_ONLY, LANAccessMode.FRONT_BACKPLANE};
    private static final HashMap versionedFeatureMap = new HashMap();
    private static final Map opticalLoopback600Map;
    private static final Map timingMode600Map;
    private static final String[] pm600ColumnNames;
    static final int[] vw600Masks;
    static final int XCON_A_SLOT = 6;
    static final int XCON_B_SLOT = 8;
    static final int XCON_A_SLOT_INDEX = 786432;
    static final int XCON_B_SLOT_INDEX = 0x100000;
    public static final int XCON_A_INDEX = 786433;
    public static final int XCON_B_INDEX = 0x100001;
    private static Platform instance;

    public static IPlatform instance() {
        return instance;
    }

    private Platform() {
    }

    @Override
    public boolean is600() {
        return true;
    }

    @Override
    public Image[] getIcons(NodeModelDelegate nodeModelDelegate) {
        return IconStore.getIcons(nodeModelDelegate);
    }

    @Override
    public CardTabbedViewFactory getCardTabbedViewFactory() {
        return PlatformCardTabbedViewFactory.instance();
    }

    @Override
    public AbstractCardViewPanel getCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        return new CardViewPanel(moduleModel, cardViewController);
    }

    @Override
    public CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        return CardFactory.createCard(entityModel, abstractShelfLayout);
    }

    @Override
    public ICardPainter getCardPainter(CardGraphic cardGraphic) {
        return new CardPainter(cardGraphic);
    }

    @Override
    public CardBehavior getCardBehavior(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        return new CardBehavior600(sDebug, nodeModelDelegate);
    }

    @Override
    public AbstractShelfLayout getShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        return new ShelfLayout(iChassisModel, shelfViewController);
    }

    @Override
    public AbstractShelfProvPane getShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        return new ShelfProvPane(string, tabbedView, iGuestPaneFactory);
    }

    @Override
    public AbstractShelfMaintenancePane getShelfMaintenancePane(String string, TabbedView tabbedView) {
        return new ShelfMaintenancePane(string, tabbedView);
    }

    @Override
    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        return (AbstractVersionedFeature)versionedFeatureMap.get(feature);
    }

    @Override
    public Pane getInternalSubnetPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory, NodeModelDelegate nodeModelDelegate) {
        return new InternalSubnetPane(string, tabbedView, iGuestPaneFactory, (PlatformNodeModel)nodeModelDelegate);
    }

    @Override
    public IpSubnet[] getInternalSubnets(NodeModelDelegate nodeModelDelegate) {
        try {
            sClassBSubnetAddr[] sClassBSubnetAddrArray = ((PlatformNodeModel)nodeModelDelegate).getInternalSubnetModel().getInternalSubnet();
            return new IpSubnet[]{new IpSubnet(sClassBSubnetAddrArray[0].addr[0], sClassBSubnetAddrArray[0].addr[1], 0, 0, 16), new IpSubnet(sClassBSubnetAddrArray[1].addr[0], sClassBSubnetAddrArray[1].addr[1], 0, 0, 16), DEFAULT_INTERNAL_NETWORK};
        }
        catch (Exception exception) {
            if (exception instanceof AbstractCmsIOException) {
                throw (AbstractCmsIOException)((Object)exception);
            }
            throw new CmsCommFailException(exception.getMessage());
        }
    }

    @Override
    public int[] getOsiModes() {
        int[] nArray = new int[]{1, 2};
        return nArray;
    }

    @Override
    public String[] getSonetMonTypeNames() {
        return AlarmDecoderDefs.getSonetMonTypeNames();
    }

    @Override
    public String[] getSdhMonTypeNames() {
        return AlarmDecoderDefs.getSdhMonTypeNames();
    }

    @Override
    public Map[] getEqTypeNameMapsForDefaults() {
        return NodeDefaults.getEqTypeNameMaps();
    }

    @Override
    public Object[][] getDefaultsList(String string) {
        return NodeDefaults.getDefaultsList(string);
    }

    @Override
    public Object[] getListOfDefaultsLists() {
        return NodeDefaults.getListOfDefaultsLists();
    }

    @Override
    public int[] getSupportedXcCardEqTypes() {
        return supported600XcCardEqTypes;
    }

    @Override
    public LANAccessMode[] getSupportedLanAccessModes() {
        return LAN_ACCESS_MODE;
    }

    @Override
    public boolean isConfigurableSDPSupported() {
        return false;
    }

    @Override
    public boolean supportsXCSwitchOperations() {
        return false;
    }

    @Override
    public boolean supportsPPC() {
        return false;
    }

    @Override
    public int dayPmTableColumns() {
        return 31;
    }

    @Override
    public String[] getPmColumnNames() {
        return pm600ColumnNames;
    }

    @Override
    public boolean hasInventoryUserCode() {
        return true;
    }

    @Override
    public boolean isRIPPaneSupported() {
        return false;
    }

    @Override
    public int getMaxCmsAuditEvents() {
        return 1200;
    }

    @Override
    public boolean showPjMon() {
        return false;
    }

    @Override
    public boolean showSSM() {
        return true;
    }

    @Override
    public boolean showAdminSSM() {
        return false;
    }

    @Override
    public boolean supportsTdmInfo() {
        return false;
    }

    @Override
    public boolean supportsTdmTransceiver(int n) {
        return true;
    }

    @Override
    public boolean isSnmpProxyCapable() {
        return true;
    }

    @Override
    public boolean isFanTrayAlarmable() {
        return true;
    }

    @Override
    public boolean isBlsrProtectionSupport() {
        return true;
    }

    @Override
    public Map getTimingModeAttributeMap() {
        return timingMode600Map;
    }

    @Override
    public Map getLoopbackAttributeMap() {
        return opticalLoopback600Map;
    }

    @Override
    public String getControlCardName() {
        return "TSC";
    }

    @Override
    public int getFanCount() {
        return 3;
    }

    @Override
    public boolean hasDccTunneling() {
        return false;
    }

    @Override
    public int getNumberOfTimingOutRef() {
        return 3;
    }

    @Override
    public boolean isAISThresholdProvisionable() {
        return true;
    }

    @Override
    public boolean isBitsOutStateProvisionable() {
        return true;
    }

    @Override
    public boolean isPotentiallyLcdIpCapable() {
        return false;
    }

    @Override
    public boolean isRetrieveDiagnosticsImplemented() {
        return true;
    }

    @Override
    public int getBiggestStitchedEtherPath() {
        return -1;
    }

    @Override
    public boolean Oc3SupportsLDC() {
        return true;
    }

    @Override
    public boolean isBridgeAndRollCapable() {
        return true;
    }

    @Override
    public boolean suppressMonitorCkt() {
        return true;
    }

    @Override
    public boolean isMaxMultiCastDropsCapable() {
        return true;
    }

    @Override
    public boolean isCAPCapable() {
        return true;
    }

    @Override
    public boolean isBackupRestoreWithOptions() {
        return true;
    }

    @Override
    public boolean isPortOOSserviceAfecting() {
        return false;
    }

    @Override
    public boolean suppressDsIface() {
        return true;
    }

    @Override
    public boolean suppressVtIface() {
        return true;
    }

    @Override
    protected int[] eqTypesWithoutUniqueNames() {
        int[] nArray = new int[]{89};
        return nArray;
    }

    @Override
    public int[] getVwMasks() {
        return vw600Masks;
    }

    @Override
    public int getXconASlot() {
        return 6;
    }

    @Override
    public int getXconBSlot() {
        return 8;
    }

    @Override
    public int getXconASlotIndex() {
        return 786432;
    }

    @Override
    public int getXconBSlotIndex() {
        return 0x100000;
    }

    @Override
    public int getXconAIndex() {
        return 786433;
    }

    @Override
    public int getXconBIndex() {
        return 0x100001;
    }

    @Override
    public boolean isESMCapable() {
        return true;
    }

    @Override
    public boolean isUcpUnicCapable() {
        return false;
    }

    @Override
    public boolean isEnhancedCircuitRepairCapable() {
        return false;
    }

    @Override
    public boolean isSpanUpgradeCapable() {
        return false;
    }

    @Override
    public boolean allowsManualXcSwitching() {
        return false;
    }

    @Override
    public boolean isScreenEntitiesCapable() {
        return false;
    }

    @Override
    public boolean isISTUCapable() {
        return false;
    }

    @Override
    public boolean isVCATCapable() {
        return false;
    }

    @Override
    public boolean isLCASCapable() {
        return false;
    }

    @Override
    public String getPlatformName() {
        return "15600";
    }

    @Override
    public Boolean ds3HasFarEnd() {
        return ds3FarEnd;
    }

    @Override
    public boolean isSecureModeSupported() {
        return false;
    }

    @Override
    public boolean canSendPdip() {
        return false;
    }

    @Override
    public boolean supportsDetailedSwUpgradeInfo() {
        return true;
    }

    @Override
    public boolean supportsServerTrail() {
        return true;
    }

    public boolean supportsRpr() {
        return false;
    }

    static {
        versionedFeatureMap.put(Feature.BLSR_2F_VERSIONING, new Blsr2FiberVersionedFeature());
        versionedFeatureMap.put(Feature.BLSR_4F_VERSIONING, new Blsr4FiberVersionedFeature());
        opticalLoopback600Map = new TreeMap();
        timingMode600Map = new TreeMap();
        Platform.putAttribute(opticalLoopback600Map, 0, "None");
        Platform.putAttribute(opticalLoopback600Map, 1, "Terminal (Inward)");
        Platform.putAttribute(opticalLoopback600Map, 2, "Facility (Line)");
        Platform.putAttribute(opticalLoopback600Map, 3, "Payload");
        Platform.putAttribute(timingMode600Map, 0, "External");
        Platform.putAttribute(timingMode600Map, 1, "Line");
        Platform.putAttribute(timingMode600Map, 2, "Mixed");
        pm600ColumnNames = new String[]{"Param", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31", "Prev-32"};
        vw600Masks = new int[]{8, 4, 2, 1, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
        instance = new Platform();
    }
}

